/*
 The MIT License (MIT)

 Copyright (c) 2017 Juan Cazala - https://caza.la

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE



 ********************************************************************************************
                                   SYNAPTIC (v1.1.4)
 ********************************************************************************************

 Synaptic is a javascript neural network library for node.js and the browser, its generalized
 algorithm is architecture-free, so you can build and train basically any type of first order
 or even second order neural network architectures.

 http://en.wikipedia.org/wiki/Recurrent_neural_network#Second_Order_Recurrent_Neural_Network

 The library includes a few built-in architectures like multilayer perceptrons, multilayer
 long-short term memory networks (LSTM) or liquid state machines, and a trainer capable of
 training any given network, and includes built-in training tasks/tests like solving an XOR,
 passing a Distracted Sequence Recall test or an Embeded Reber Grammar test.

 The algorithm implemented by this library has been taken from Derek D. Monner's paper:


 A generalized LSTM-like training algorithm for second-order recurrent neural networks
 http://www.overcomplete.net/papers/nn2012.pdf

 There are references to the equations in that paper commented through the source code.

*/
(function(v,u){typeof exports==="object"&&typeof module==="object"?module.exports=u():typeof define==="function"&&define.amd?define([],u):typeof exports==="object"?exports.synaptic=u():v.synaptic=u()})(this,function(){return function(v){function u(w){if(r[w])return r[w].exports;var n=r[w]={i:w,l:!1,exports:{}};v[w].call(n.exports,n,n.exports,u);n.l=!0;return n.exports}var r={};u.m=v;u.c=r;u.d=function(w,n,k){u.o(w,n)||Object.defineProperty(w,n,{configurable:!1,enumerable:!0,get:k})};u.n=function(w){var n=
w&&w.__esModule?function(){return w["default"]}:function(){return w};u.d(n,"a",n);return n};u.o=function(w,n){return Object.prototype.hasOwnProperty.call(w,n)};u.p="";return u(u.s=4)}([function(v,u,r){function w(b){return b&&b.__esModule?b:{default:b}}Object.defineProperty(u,"__esModule",{value:!0});var n=function(){function b(d,a){for(var c=0;c<a.length;c++){var e=a[c];e.enumerable=e.enumerable||!1;e.configurable=!0;"value"in e&&(e.writable=!0);Object.defineProperty(d,e.key,e)}}return function(d,
a,c){a&&b(d.prototype,a);c&&b(d,c);return d}}();v=r(6);var k=w(v);v=r(2);var g=w(v);r=r(1);var h=w(r);r=function(){function b(d){if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");this.size=d|0;this.list=[];for(this.connectedTo=[];d--;){var a=new g.default;this.list.push(a)}}n(b,[{key:"activate",value:function(d){var a=[];if(typeof d!="undefined"){if(d.length!=this.size)throw Error("INPUT size and LAYER size must be the same to activate!");for(var c in this.list){var e=
this.list[c];e=e.activate(d[c]);a.push(e)}}else for(c in this.list)e=this.list[c],e=e.activate(),a.push(e);return a}},{key:"propagate",value:function(d,a){if(typeof a!="undefined"){if(a.length!=this.size)throw Error("TARGET size and LAYER size must be the same to propagate!");for(var c=this.list.length-1;c>=0;c--){var e=this.list[c];e.propagate(d,a[c])}}else for(c=this.list.length-1;c>=0;c--)e=this.list[c],e.propagate(d)}},{key:"project",value:function(d,a,c){d instanceof h.default&&(d=d.layers.input);
if(d instanceof b){if(!this.connected(d))return new k.default(this,d,a,c)}else throw Error("Invalid argument, you can only project connections to LAYERS and NETWORKS!");}},{key:"gate",value:function(d,a){if(a==b.gateType.INPUT){if(d.to.size!=this.size)throw Error("GATER layer and CONNECTION.TO layer must be the same size in order to gate!");for(var c in d.to.list){var e=d.to.list[c],f=this.list[c],l;for(l in e.connections.inputs){var m=e.connections.inputs[l];m.ID in d.connections&&f.gate(m)}}}else if(a==
b.gateType.OUTPUT){if(d.from.size!=this.size)throw Error("GATER layer and CONNECTION.FROM layer must be the same size in order to gate!");for(c in d.from.list){e=d.from.list[c];f=this.list[c];for(var p in e.connections.projected)m=e.connections.projected[p],m.ID in d.connections&&f.gate(m)}}else if(a==b.gateType.ONE_TO_ONE){if(d.size!=this.size)throw Error("The number of GATER UNITS must be the same as the number of CONNECTIONS to gate!");for(c in d.list)f=this.list[c],m=d.list[c],f.gate(m)}d.gatedfrom.push({layer:this,
type:a})}},{key:"selfconnected",value:function(){for(var d in this.list)if(!this.list[d].selfconnected())return!1;return!0}},{key:"connected",value:function(d){var a=0,c;for(c in this.list)for(var e in d.list){var f=this.list[c],l=d.list[e];f=f.connected(l);f.type=="projected"&&a++}if(a==this.size*d.size)return b.connectionType.ALL_TO_ALL;a=0;for(var m in this.list)f=this.list[m],l=d.list[m],f=f.connected(l),f.type=="projected"&&a++;if(a==this.size)return b.connectionType.ONE_TO_ONE}},{key:"clear",
value:function(){for(var d in this.list)this.list[d].clear()}},{key:"reset",value:function(){for(var d in this.list)this.list[d].reset()}},{key:"neurons",value:function(){return this.list}},{key:"add",value:function(d){d=d||new g.default;this.list.push(d);this.size++}},{key:"set",value:function(d){d=d||{};for(var a in this.list){var c=this.list[a];d.label&&(c.label=d.label+"_"+c.ID);d.squash&&(c.squash=d.squash);d.bias&&(c.bias=d.bias)}return this}}]);return b}();r.connectionType={ALL_TO_ALL:"ALL TO ALL",
ONE_TO_ONE:"ONE TO ONE",ALL_TO_ELSE:"ALL TO ELSE"};r.gateType={INPUT:"INPUT",OUTPUT:"OUTPUT",ONE_TO_ONE:"ONE TO ONE"};u.default=r},function(v,u,r){function w(d){return d&&d.__esModule?d:{default:d}}Object.defineProperty(u,"__esModule",{value:!0});var n=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(d){return typeof d}:function(d){return d&&typeof Symbol==="function"&&d.constructor===Symbol&&d!==Symbol.prototype?"symbol":typeof d},k=function(){function d(a,c){for(var e=0;e<
c.length;e++){var f=c[e];f.enumerable=f.enumerable||!1;f.configurable=!0;"value"in f&&(f.writable=!0);Object.defineProperty(a,f.key,f)}}return function(a,c,e){c&&d(a.prototype,c);e&&d(a,e);return a}}();v=r(2);var g=w(v);v=r(0);var h=w(v);r=r(3);var b=w(r);r=function(){function d(a){if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");typeof a!="undefined"&&(this.layers={input:a.input||null,hidden:a.hidden||[],output:a.output||null},this.optimized=null)}k(d,[{key:"activate",
value:function(a){if(this.optimized===!1){this.layers.input.activate(a);for(a=0;a<this.layers.hidden.length;a++)this.layers.hidden[a].activate();return this.layers.output.activate()}this.optimized==null&&this.optimize();return this.optimized.activate(a)}},{key:"propagate",value:function(a,c){if(this.optimized===!1)for(this.layers.output.propagate(a,c),c=this.layers.hidden.length-1;c>=0;c--)this.layers.hidden[c].propagate(a);else this.optimized==null&&this.optimize(),this.optimized.propagate(a,c)}},
{key:"project",value:function(a,c,e){this.optimized&&this.optimized.reset();if(a instanceof d)return this.layers.output.project(a.layers.input,c,e);if(a instanceof h.default)return this.layers.output.project(a,c,e);throw Error("Invalid argument, you can only project connections to LAYERS and NETWORKS!");}},{key:"gate",value:function(a,c){this.optimized&&this.optimized.reset();this.layers.output.gate(a,c)}},{key:"clear",value:function(){this.restore();var a=this.layers.output;this.layers.input.clear();
for(var c=0;c<this.layers.hidden.length;c++)this.layers.hidden[c].clear();a.clear();this.optimized&&this.optimized.reset()}},{key:"reset",value:function(){this.restore();var a=this.layers.output;this.layers.input.reset();for(var c=0;c<this.layers.hidden.length;c++)this.layers.hidden[c].reset();a.reset();this.optimized&&this.optimized.reset()}},{key:"optimize",value:function(){for(var a=this,c={},e=this.neurons(),f=0;f<e.length;f++){for(var l=e[f].neuron,m=e[f].layer;l.neuron;)l=l.neuron;c=l.optimize(c,
m)}for(f=0;f<c.propagation_sentences.length;f++)c.propagation_sentences[f].reverse();c.propagation_sentences.reverse();e="var F = Float64Array ? new Float64Array("+c.memory+") : []; ";for(f in c.variables)e+="F["+c.variables[f].id+"] = "+(c.variables[f].value||0)+"; ";e+="var activate = function(input){\n";for(f=0;f<c.inputs.length;f++)e+="F["+c.inputs[f]+"] = input["+f+"]; ";for(f=0;f<c.activation_sentences.length;f++)if(c.activation_sentences[f].length>0)for(l=0;l<c.activation_sentences[f].length;l++)e+=
c.activation_sentences[f][l].join(" "),e+=c.trace_sentences[f][l].join(" ");e+=" var output = []; ";for(f=0;f<c.outputs.length;f++)e+="output["+f+"] = F["+c.outputs[f]+"]; ";e=e+"return output; }; var propagate = function(rate, target){\nF["+(c.variables.rate.id+"] = rate; ");for(f=0;f<c.targets.length;f++)e+="F["+c.targets[f]+"] = target["+f+"]; ";for(f=0;f<c.propagation_sentences.length;f++)for(l=0;l<c.propagation_sentences[f].length;l++)e+=c.propagation_sentences[f][l].join(" ")+" ";e=(e+" };\nvar ownership = function(memoryBuffer){\nF = memoryBuffer;\nthis.memory = F;\n};\nreturn {\nmemory: F,\nactivate: activate,\npropagate: propagate,\nownership: ownership\n};").split(";").join(";\n");
var p=(new Function(e))();p.data={variables:c.variables,activate:c.activation_sentences,propagate:c.propagation_sentences,trace:c.trace_sentences,inputs:c.inputs,outputs:c.outputs,check_activation:this.activate,check_propagation:this.propagate};p.reset=function(){a.optimized&&(a.optimized=null,a.activate=p.data.check_activation,a.propagate=p.data.check_propagation)};this.optimized=p;this.activate=p.activate;this.propagate=p.propagate}},{key:"restore",value:function(){if(this.optimized){var a=this.optimized,
c=function(){var x=Array.prototype.slice.call(arguments),B=x.shift(),J=x.pop()+"_",H;for(H in x)J+=x[H]+"_";J+=B.ID;x=a.memory;B=a.data.variables;return J in B?x[B[J].id]:0},e=this.neurons(),f=0;for(;f<e.length;f++){for(var l=e[f].neuron;l.neuron;)l=l.neuron;l.state=c(l,"state");l.old=c(l,"old");l.activation=c(l,"activation");l.bias=c(l,"bias");for(var m in l.trace.elegibility)l.trace.elegibility[m]=c(l,"trace","elegibility",m);for(var p in l.trace.extended)for(m in l.trace.extended[p])l.trace.extended[p][m]=
c(l,"trace","extended",p,m);for(var y in l.connections.projected){var D=l.connections.projected[y];D.weight=c(D,"weight");D.gain=c(D,"gain")}}}}},{key:"neurons",value:function(){for(var a=[],c=this.layers.input.neurons(),e=this.layers.output.neurons(),f=0;f<c.length;f++)a.push({neuron:c[f],layer:"input"});for(f=0;f<this.layers.hidden.length;f++){c=this.layers.hidden[f].neurons();for(var l=0;l<c.length;l++)a.push({neuron:c[l],layer:f})}for(f=0;f<e.length;f++)a.push({neuron:e[f],layer:"output"});return a}},
{key:"inputs",value:function(){return this.layers.input.size}},{key:"outputs",value:function(){return this.layers.output.size}},{key:"set",value:function(a){this.layers={input:a.input||null,hidden:a.hidden||[],output:a.output||null};this.optimized&&this.optimized.reset()}},{key:"setOptimize",value:function(a){this.restore();this.optimized&&this.optimized.reset();this.optimized=a?null:!1}},{key:"toJSON",value:function(a){this.restore();a=this.neurons();for(var c=[],e=[],f={},l=0;l<a.length;l++){for(var m=
a[l].neuron;m.neuron;)m=m.neuron;f[m.ID]=l;var p={trace:{elegibility:{},extended:{}},state:m.state,old:m.old,activation:m.activation,bias:m.bias,layer:a[l].layer};p.squash=m.squash==g.default.squash.LOGISTIC?"LOGISTIC":m.squash==g.default.squash.TANH?"TANH":m.squash==g.default.squash.IDENTITY?"IDENTITY":m.squash==g.default.squash.HLIM?"HLIM":m.squash==g.default.squash.RELU?"RELU":null;c.push(p)}for(l=0;l<a.length;l++){for(m=a[l].neuron;m.neuron;)m=m.neuron;for(var y in m.connections.projected)p=m.connections.projected[y],
e.push({from:f[p.from.ID],to:f[p.to.ID],weight:p.weight,gater:p.gater?f[p.gater.ID]:null});m.selfconnected()&&e.push({from:f[m.ID],to:f[m.ID],weight:m.selfconnection.weight,gater:m.selfconnection.gater?f[m.selfconnection.gater.ID]:null})}return{neurons:c,connections:e}}},{key:"toDot",value:function(a){typeof a==="undefined"||n(a)||(a=!1);for(var c="digraph nn {\n    rankdir = BT\n",e=[this.layers.input].concat(this.layers.hidden,this.layers.output),f=0;f<e.length;f++)for(var l=0;l<e[f].connectedTo.length;l++){var m=
e[f].connectedTo[l],p=m.to,y=m.size,D=e.indexOf(e[f]);p=e.indexOf(p);if(a){if(m.gatedfrom.length){var x="fake"+D+"_"+p;c+="    "+x+' [label = "", shape = point, width = 0.01, height = 0.01]\n';c+="    "+D+" -> "+x+" [label = "+y+", arrowhead = none]\n";c+="    "+x+" -> "+p+"\n"}else c+="    "+D+" -> "+p+" [label = "+y+"]\n";for(var B in m.gatedfrom)y=m.gatedfrom[B].layer,y=e.indexOf(y),c+="    "+y+" -> "+x+" [color = blue]\n"}else for(B in c+="    "+D+" -> "+p+" [label = "+y+"]\n",m.gatedfrom)y=m.gatedfrom[B].layer,
y=e.indexOf(y),c+="    "+y+" -> "+p+" [color = blue]\n"}c+="}\n";return{code:c,link:"https://chart.googleapis.com/chart?chl="+escape(c.replace("/ /g","+"))+"&cht=gv"}}},{key:"standalone",value:function(){this.optimized||this.optimize();for(var a=this.optimized.data,c="function (input) {\n",e=0;e<a.inputs.length;e++)c+="F["+a.inputs[e]+"] = input["+e+"];\n";for(e=0;e<a.activate.length;e++)for(var f=0;f<a.activate[e].length;f++)c+=a.activate[e][f].join("")+"\n";c+="var output = [];\n";for(e=0;e<a.outputs.length;e++)c+=
"output["+e+"] = F["+a.outputs[e]+"];\n";c+="return output;\n}";a=c.match(/F\[(\d+)\]/g);f=0;var l={};for(e=0;e<a.length;e++){var m=a[e].match(/\d+/)[0];m in l||(l[m]=f++)}a="F = {\n";for(e in l)a+=l[e]+": "+this.optimized.memory[e]+",\n";a=a.substring(0,a.length-2)+"\n};\n";a="var run = "+c.replace(/F\[(\d+)]/g,function(p){return"F["+l[p.match(/\d+/)[0]]+"]"}).replace("{\n","{\n"+a)+";\n";return(new Function(a+"return run"))()}},{key:"worker",value:function(a,c,e){a={};e&&(a=e);a.rate=a.rate||.2;
a.iterations=a.iterations||1E5;a.error=a.error||.005;a.cost=a.cost||null;a.crossValidate=a.crossValidate||null;var f="// REPLACED BY WORKER\nvar cost = "+(e&&e.cost||this.cost||b.default.cost.MSE)+";\n";e=d.getWorkerSharedFunctions();e=e.replace(/var cost = options && options\.cost \|\| this\.cost \|\| Trainer\.cost\.MSE;/g,f);e=e.replace("return results;",'postMessage({action: "done", message: results, memoryBuffer: F}, [F.buffer]);');e=e.replace("console.log('iterations', iterations, 'error', error, 'rate', currentRate)",
"postMessage({action: 'log', message: {\niterations: iterations,\nerror: error,\nrate: currentRate\n}\n})");e=e.replace("abort = this.schedule.do({ error: error, iterations: iterations, rate: currentRate })","postMessage({action: 'schedule', message: {\niterations: iterations,\nerror: error,\nrate: currentRate\n}\n})");this.optimized||this.optimize();f="var inputs = "+this.optimized.data.inputs.length+";\n";f+="var outputs = "+this.optimized.data.outputs.length+";\n";f+="var F =  new Float64Array(["+
this.optimized.memory.toString()+"]);\n";f+="var activate = "+this.optimized.activate.toString()+";\n";f+="var propagate = "+this.optimized.propagate.toString()+";\n";f+="onmessage = function(e) {\nif (e.data.action == 'startTraining') {\ntrain("+JSON.stringify(c)+","+JSON.stringify(a)+");\n}\n}";c=new Blob([e+"\n"+f]);c=window.URL.createObjectURL(c);return new Worker(c)}},{key:"clone",value:function(){return d.fromJSON(this.toJSON())}}],[{key:"getWorkerSharedFunctions",value:function(){if(typeof d._SHARED_WORKER_FUNCTIONS!==
"undefined")return d._SHARED_WORKER_FUNCTIONS;var a=b.default.prototype.train.toString();a=a.replace(/this._trainSet/g,"_trainSet");a=a.replace(/this.test/g,"test");a=a.replace(/this.crossValidate/g,"crossValidate");a=a.replace("crossValidate = true","// REMOVED BY WORKER");var c=b.default.prototype._trainSet.toString().replace(/this.network./g,""),e=b.default.prototype.test.toString().replace(/this.network./g,"");return d._SHARED_WORKER_FUNCTIONS=a+"\n"+c+"\n"+e}},{key:"fromJSON",value:function(a){for(var c=
[],e={input:new h.default,hidden:[],output:new h.default},f=0;f<a.neurons.length;f++){var l=a.neurons[f],m=new g.default;m.trace.elegibility={};m.trace.extended={};m.state=l.state;m.old=l.old;m.activation=l.activation;m.bias=l.bias;m.squash=l.squash in g.default.squash?g.default.squash[l.squash]:g.default.squash.LOGISTIC;c.push(m);l.layer=="input"?e.input.add(m):l.layer=="output"?e.output.add(m):(typeof e.hidden[l.layer]=="undefined"&&(e.hidden[l.layer]=new h.default),e.hidden[l.layer].add(m))}for(f=
0;f<a.connections.length;f++)l=a.connections[f],m=c[l.gater],l=c[l.from].project(c[l.to],l.weight),m&&m.gate(l);return new d(e)}}]);return d}();u.default=r},function(v,u,r){Object.defineProperty(u,"__esModule",{value:!0});var w=function(){function h(b,d){for(var a=0;a<d.length;a++){var c=d[a];c.enumerable=c.enumerable||!1;c.configurable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(b,c.key,c)}}return function(b,d,a){d&&h(b.prototype,d);a&&h(b,a);return b}}(),n=r(5),k=n&&n.__esModule?n:{default:n},
g=0;v=function(){function h(){if(!(this instanceof h))throw new TypeError("Cannot call a class as a function");this.ID=h.uid();this.connections={inputs:{},projected:{},gated:{}};this.error={responsibility:0,projected:0,gated:0};this.trace={elegibility:{},extended:{},influences:{}};this.activation=this.old=this.state=0;this.selfconnection=new k.default(this,this,0);this.squash=h.squash.LOGISTIC;this.neighboors={};this.bias=Math.random()*.2-.1}w(h,[{key:"activate",value:function(b){if(typeof b!="undefined")return this.activation=
b,this.bias=this.derivative=0,this.activation;this.old=this.state;this.state=this.selfconnection.gain*this.selfconnection.weight*this.state+this.bias;for(var d in this.connections.inputs)b=this.connections.inputs[d],this.state+=b.from.activation*b.weight*b.gain;this.activation=this.squash(this.state);this.derivative=this.squash(this.state,!0);var a=[],c;for(c in this.trace.extended){var e=this.neighboors[c],f=e.selfconnection.gater==this?e.old:0;for(l in this.trace.influences[e.ID])f+=this.trace.influences[e.ID][l].weight*
this.trace.influences[e.ID][l].from.activation;a[e.ID]=f}for(d in this.connections.inputs)for(c in b=this.connections.inputs[d],this.trace.elegibility[b.ID]=this.selfconnection.gain*this.selfconnection.weight*this.trace.elegibility[b.ID]+b.gain*b.from.activation,this.trace.extended){var l=this.trace.extended[c];e=this.neighboors[c];f=a[e.ID];l[b.ID]=e.selfconnection.gain*e.selfconnection.weight*l[b.ID]+this.derivative*this.trace.elegibility[b.ID]*f}for(var m in this.connections.gated)this.connections.gated[m].gain=
this.activation;return this.activation}},{key:"propagate",value:function(b,d){var a=0;if(typeof d!="undefined")this.error.responsibility=this.error.projected=d-this.activation;else{for(var c in this.connections.projected){var e=this.connections.projected[c];d=e.to;a+=d.error.responsibility*e.gain*e.weight}this.error.projected=this.derivative*a;a=0;for(c in this.trace.extended){d=this.neighboors[c];e=d.selfconnection.gater==this?d.old:0;for(var f in this.trace.influences[c])e+=this.trace.influences[c][f].weight*
this.trace.influences[d.ID][f].from.activation;a+=d.error.responsibility*e}this.error.gated=this.derivative*a;this.error.responsibility=this.error.projected+this.error.gated}b=b||.1;for(c in this.connections.inputs){f=this.connections.inputs[c];a=this.error.projected*this.trace.elegibility[f.ID];for(c in this.trace.extended)d=this.neighboors[c],a+=d.error.responsibility*this.trace.extended[d.ID][f.ID];f.weight+=b*a}this.bias+=b*this.error.responsibility}},{key:"project",value:function(b,d){if(b==
this)return this.selfconnection.weight=1,this.selfconnection;var a=this.connected(b);if(a&&a.type=="projected")return typeof d!="undefined"&&(a.connection.weight=d),a.connection;d=new k.default(this,b,d);this.connections.projected[d.ID]=d;this.neighboors[b.ID]=b;b.connections.inputs[d.ID]=d;b.trace.elegibility[d.ID]=0;for(var c in b.trace.extended)b.trace.extended[c][d.ID]=0;return d}},{key:"gate",value:function(b){this.connections.gated[b.ID]=b;var d=b.to;if(!(d.ID in this.trace.extended)){this.neighboors[d.ID]=
d;var a=this.trace.extended[d.ID]={},c;for(c in this.connections.inputs)a[this.connections.inputs[c].ID]=0}d.ID in this.trace.influences?this.trace.influences[d.ID].push(b):this.trace.influences[d.ID]=[b];b.gater=this}},{key:"selfconnected",value:function(){return this.selfconnection.weight!==0}},{key:"connected",value:function(b){var d={type:null,connection:!1};if(this==b)return this.selfconnected()?(d.type="selfconnection",d.connection=this.selfconnection,d):!1;for(var a in this.connections)for(var c in this.connections[a])if(c=
this.connections[a][c],c.to==b||c.from==b)return d.type=a,d.connection=c,d;return!1}},{key:"clear",value:function(){for(var b in this.trace.elegibility)this.trace.elegibility[b]=0;for(b in this.trace.extended)for(var d in this.trace.extended[b])this.trace.extended[b][d]=0;this.error.responsibility=this.error.projected=this.error.gated=0}},{key:"reset",value:function(){this.clear();for(var b in this.connections)for(var d in this.connections[b])this.connections[b][d].weight=Math.random()*.2-.1;this.bias=
Math.random()*.2-.1;this.old=this.state=this.activation=0}},{key:"optimize",value:function(b,d){b=b||{};var a=[],c=[],e=[],f=b.memory||0,l=b.neurons||1,m=b.inputs||[],p=b.targets||[],y=b.outputs||[],D=b.variables||{},x=b.activation_sentences||[],B=b.trace_sentences||[],J=b.propagation_sentences||[],H=b.layers||{__count:0,__neuron:0};b=function(O){d in H&&O[H.__count]||(H.__count=O.push([])-1,H[d]=H.__count)};b(x);b(B);b(J);var q=H.__count;b=function(){var O=Array.prototype.slice.call(arguments);if(O.length==
1){if(O[0]=="target"){var S="target_"+p.length;p.push(f)}else S=O[0];return S in D?D[S]:D[S]={value:0,id:f++}}if(S=O.length>2)var W=O.pop();var V=O.shift(),Y=O.pop();S||(W=V[Y]);S=Y+"_";for(Y=0;Y<O.length;Y++)S+=O[Y]+"_";S+=V.ID;return S in D?D[S]:D[S]={value:W,id:f++}};var t=function(){for(var O=Array.prototype.slice.call(arguments),S=O.pop(),W="",V=0;V<O.length;V++)W=typeof O[V]=="string"?W+O[V]:W+("F["+O[V].id+"]");S.push(W+";")},M=function(O){for(var S in O)if(O.hasOwnProperty(S))return!1;return!0},
C=M(this.connections.projected),z=M(this.connections.gated),P=d=="input"?!0:M(this.connections.inputs),Q=d=="output"?!0:C&&z;M=b("rate");var G=b(this,"activation");if(P)m.push(G.id);else{x[q].push(a);B[q].push(c);J[q].push(e);var I=b(this,"old");q=b(this,"state");var R=b(this,"bias");if(this.selfconnection.gater)var U=b(this.selfconnection,"gain");if(this.selfconnected())var T=b(this.selfconnection,"weight");t(I," = ",q,a);this.selfconnected()?this.selfconnection.gater?t(q," = ",U," * ",T," * ",q,
" + ",R,a):t(q," = ",T," * ",q," + ",R,a):t(q," = ",R,a);for(var X in this.connections.inputs){var A=this.connections.inputs[X],E=b(A.from,"activation");I=b(A,"weight");if(A.gater)var Z=b(A,"gain");this.connections.inputs[X].gater?t(q," += ",E," * ",I," * ",Z,a):t(q," += ",E," * ",I,a)}I=b(this,"derivative");switch(this.squash){case h.squash.LOGISTIC:t(G," = (1 / (1 + Math.exp(-",q,")))",a);t(I," = ",G," * (1 - ",G,")",a);break;case h.squash.TANH:E=b("aux");var N=b("aux_2");t(E," = Math.exp(",q,")",
a);t(N," = 1 / ",E,a);t(G," = (",E," - ",N,") / (",E," + ",N,")",a);t(I," = 1 - (",G," * ",G,")",a);break;case h.squash.IDENTITY:t(G," = ",q,a);t(I," = 1",a);break;case h.squash.HLIM:t(G," = +(",q," > 0)",a);t(I," = 1",a);break;case h.squash.RELU:t(G," = ",q," > 0 ? ",q," : 0",a),t(I," = ",q," > 0 ? 1 : 0",a)}for(var K in this.trace.extended){q=this.neighboors[K];E=b("influences["+q.ID+"]");N=b(q,"old");var aa=!1;q.selfconnection.gater==this&&(t(E," = ",N,c),aa=!0);for(var L in this.trace.influences[q.ID]){N=
b(this.trace.influences[q.ID][L],"weight");var ba=b(this.trace.influences[q.ID][L].from,"activation");aa?t(E," += ",N," * ",ba,c):(t(E," = ",N," * ",ba,c),aa=!0)}}for(X in this.connections.inputs)for(K in A=this.connections.inputs[X],A.gater&&(Z=b(A,"gain")),E=b(A.from,"activation"),L=b(this,"trace","elegibility",A.ID,this.trace.elegibility[A.ID]),this.selfconnected()?this.selfconnection.gater?A.gater?t(L," = ",U," * ",T," * ",L," + ",Z," * ",E,c):t(L," = ",U," * ",T," * ",L," + ",E,c):A.gater?t(L,
" = ",T," * ",L," + ",Z," * ",E,c):t(L," = ",T," * ",L," + ",E,c):A.gater?t(L," = ",Z," * ",E,c):t(L," = ",E,c),this.trace.extended){q=this.neighboors[K];E=b("influences["+q.ID+"]");L=b(this,"trace","elegibility",A.ID,this.trace.elegibility[A.ID]);N=b(this,"trace","extended",q.ID,A.ID,this.trace.extended[q.ID][A.ID]);if(q.selfconnected())var ca=b(q.selfconnection,"weight");if(q.selfconnection.gater)var da=b(q.selfconnection,"gain");q.selfconnected()?q.selfconnection.gater?t(N," = ",da," * ",ca," * ",
N," + ",I," * ",L," * ",E,c):t(N," = ",ca," * ",N," + ",I," * ",L," * ",E,c):t(N," = ",I," * ",L," * ",E,c)}for(var F in this.connections.gated)c=b(this.connections.gated[F],"gain"),t(c," = ",G,a)}if(!P){a=b(this,"error","responsibility",this.error.responsibility);if(Q){A=b("target");t(a," = ",A," - ",G,e);for(K in this.connections.inputs)A=this.connections.inputs[K],L=b(this,"trace","elegibility",A.ID,this.trace.elegibility[A.ID]),I=b(A,"weight"),t(I," += ",M," * (",a," * ",L,")",e);y.push(G.id)}else if(!C&&
!z){C=b("aux");for(K in this.connections.projected)F=this.connections.projected[K],q=F.to,G=b(F,"weight"),z=b(q,"error","responsibility",q.error.responsibility),F.gater?(F=b(F,"gain"),t(C," += ",z," * ",F," * ",G,e)):t(C," += ",z," * ",G,e);c=b(this,"error","projected",this.error.projected);t(c," = ",I," * ",C,e);t(C," = 0",e);for(K in this.trace.extended){q=this.neighboors[K];E=b("aux_2");N=b(q,"old");q.selfconnection.gater==this?t(E," = ",N,e):t(E," = 0",e);for(A in this.trace.influences[q.ID])F=
this.trace.influences[q.ID][A],G=b(F,"weight"),F=b(F.from,"activation"),t(E," += ",G," * ",F,e);z=b(q,"error","responsibility",q.error.responsibility);t(C," += ",z," * ",E,e)}A=b(this,"error","gated",this.error.gated);t(A," = ",I," * ",C,e);t(a," = ",c," + ",A,e);for(K in this.connections.inputs){A=this.connections.inputs[K];F=b("aux");L=b(this,"trace","elegibility",A.ID,this.trace.elegibility[A.ID]);t(F," = ",c," * ",L,e);for(K in this.trace.extended)q=this.neighboors[K],z=b(q,"error","responsibility",
q.error.responsibility),N=b(this,"trace","extended",q.ID,A.ID,this.trace.extended[q.ID][A.ID]),t(F," += ",z," * ",N,e);I=b(A,"weight");t(I," += ",M," * ",F,e)}}else if(z){t(a," = 0",e);for(K in this.connections.projected)F=this.connections.projected[K],q=F.to,G=b(F,"weight"),z=b(q,"error","responsibility",q.error.responsibility),F.gater?(F=b(F,"gain"),t(a," += ",z," * ",F," * ",G,e)):t(a," += ",z," * ",G,e);t(a," *= ",I,e);for(K in this.connections.inputs)A=this.connections.inputs[K],L=b(this,"trace",
"elegibility",A.ID,this.trace.elegibility[A.ID]),I=b(A,"weight"),t(I," += ",M," * (",a," * ",L,")",e)}else if(C){t(a," = 0",e);for(K in this.trace.extended){q=this.neighboors[K];E=b("aux");N=b(q,"old");q.selfconnection.gater==this?t(E," = ",N,e):t(E," = 0",e);for(A in this.trace.influences[q.ID])F=this.trace.influences[q.ID][A],G=b(F,"weight"),F=b(F.from,"activation"),t(E," += ",G," * ",F,e);z=b(q,"error","responsibility",q.error.responsibility);t(a," += ",z," * ",E,e)}t(a," *= ",I,e);for(K in this.connections.inputs){A=
this.connections.inputs[K];F=b("aux");t(F," = 0",e);for(K in this.trace.extended)q=this.neighboors[K],z=b(q,"error","responsibility",q.error.responsibility),N=b(this,"trace","extended",q.ID,A.ID,this.trace.extended[q.ID][A.ID]),t(F," += ",z," * ",N,e);I=b(A,"weight");t(I," += ",M," * ",F,e)}}t(R," += ",M," * ",a,e)}return{memory:f,neurons:l+1,inputs:m,outputs:y,targets:p,variables:D,activation_sentences:x,trace_sentences:B,propagation_sentences:J,layers:H}}}],[{key:"uid",value:function(){return g++}},
{key:"quantity",value:function(){return{neurons:g,connections:n.connections}}}]);return h}();v.squash={LOGISTIC:function(h,b){h=1/(1+Math.exp(-h));return b?h*(1-h):h},TANH:function(h,b){return b?1-Math.pow(Math.tanh(h),2):Math.tanh(h)},IDENTITY:function(h,b){return b?1:h},HLIM:function(h,b){return b?1:h>0?1:0},RELU:function(h,b){return b?h>0?1:0:h>0?h:0}};u.default=v},function(v,u,r){Object.defineProperty(u,"__esModule",{value:!0});var w=function(){function n(k,g){for(var h=0;h<g.length;h++){var b=
g[h];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(k,b.key,b)}}return function(k,g,h){g&&n(k.prototype,g);h&&n(k,h);return k}}();v=function(){function n(k,g){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");g=g||{};this.network=k;this.rate=g.rate||.2;this.iterations=g.iterations||1E5;this.error=g.error||.005;this.cost=g.cost||null;this.crossValidate=g.crossValidate||null}w(n,[{key:"train",value:function(k,g){var h=
1,b=l=0,d=!1,a=g&&g.cost||this.cost||n.cost.MSE,c=!1,e=Date.now();g&&(g.iterations&&(this.iterations=g.iterations),g.error&&(this.error=g.error),g.rate&&(this.rate=g.rate),g.cost&&(this.cost=g.cost),g.schedule&&(this.schedule=g.schedule),g.customLog&&(console.log("Deprecated: use schedule instead of customLog"),this.schedule=g.customLog),this.crossValidate||g.crossValidate)&&(this.crossValidate||(this.crossValidate={}),c=!0,g.crossValidate.testSize&&(this.crossValidate.testSize=g.crossValidate.testSize),
g.crossValidate.testError&&(this.crossValidate.testError=g.crossValidate.testError));var f=this.rate;if(Array.isArray(this.rate))var l=Math.floor(this.iterations/this.rate.length);if(c){var m=Math.ceil((1-this.crossValidate.testSize)*k.length);var p=k.slice(0,m);m=k.slice(m)}for(var y=0;!d&&b<this.iterations&&h>this.error&&!(c&&h<=this.crossValidate.testError);)if(h=0,b++,l>0&&(f=this.rate[Math.floor(b/l)]||f),typeof this.rate==="function"&&(f=this.rate(b,y)),c?(this._trainSet(p,f,a),h+=this.test(m).error,
y=1):(h+=this._trainSet(k,f,a),y=k.length),y=h/=y,g&&(this.schedule&&this.schedule.every&&b%this.schedule.every==0?d=this.schedule.do({error:h,iterations:b,rate:f}):g.log&&b%g.log==0&&console.log("iterations",b,"error",h,"rate",f),g.shuffle))for(var D=void 0,x=void 0,B=k,J=B.length;J;x=Math.floor(Math.random()*J),D=B[--J],B[J]=B[x],B[x]=D);return{error:h,iterations:b,time:Date.now()-e}}},{key:"trainAsync",value:function(k,g){var h=this.workerTrain.bind(this);return new Promise(function(b,d){try{h(k,
b,g,!0)}catch(a){d(a)}})}},{key:"_trainSet",value:function(k,g,h){for(var b=0,d=0;d<k.length;d++){var a=k[d].output,c=this.network.activate(k[d].input);this.network.propagate(g,a);b+=h(a,c)}return b}},{key:"test",value:function(k,g){for(var h=0,b,d=g&&g.cost||this.cost||n.cost.MSE,a=Date.now(),c=0;c<k.length;c++)b=k[c].input,g=k[c].output,b=this.network.activate(b),h+=d(g,b);h/=k.length;return{error:h,time:Date.now()-a}}},{key:"workerTrain",value:function(k,g,h,b){b||console.warn("Deprecated: do not use `workerTrain`, use `trainAsync` instead.");
var d=this;this.network.optimized||this.network.optimize();var a=this.network.worker(this.network.optimized.memory,k,h);a.onmessage=function(c){switch(c.data.action){case "done":var e=c.data.message.iterations,f=c.data.message.error,l=c.data.message.time;d.network.optimized.ownership(c.data.memoryBuffer);g({error:f,iterations:e,time:l});a.terminate();break;case "log":console.log(c.data.message);case "schedule":h&&h.schedule&&typeof h.schedule.do==="function"&&(e=h.schedule.do,e(c.data.message))}};
a.postMessage({action:"startTraining"})}},{key:"XOR",value:function(k){if(this.network.inputs()!=2||this.network.outputs()!=1)throw Error("Incompatible network (2 inputs, 1 output)");var g={iterations:1E5,log:!1,shuffle:!0,cost:n.cost.MSE};if(k)for(var h in k)g[h]=k[h];return this.train([{input:[0,0],output:[0]},{input:[1,0],output:[1]},{input:[0,1],output:[1]},{input:[1,1],output:[0]}],g)}},{key:"DSR",value:function(k){k=k||{};var g=k.targets||[2,4,7,8],h=k.distractors||[3,5,6,9],b=k.prompts||[0,
1],d=k.length||24,a=k.success||.95,c=k.iterations||1E5,e=k.rate||.1,f=k.log||0,l=k.schedule||{};k=k.cost||this.cost||n.cost.CROSS_ENTROPY;var m,p,y,D;var x=m=p=y=D=0;for(var B=1,J=g.length+h.length+b.length,H=function T(R,U){var X=Math.random()*R|0,A=!1,E;for(E in U)X==U[E]&&(A=!0);return A?T(R,U):X},q=function(R,U){for(var T in R)if(Math.round(R[T])!=U[T])return!1;return!0},t=Date.now();x<c&&(D<a||x%1E3!=0);){D=[];var M=d-b.length;for(p=0;p<M;p++)D.push(h[Math.random()*h.length|0]);var C=[];B=[];
for(p=0;p<b.length;p++)C.push(Math.random()*g.length|0),B.push(H(M,B));B=B.sort();for(p=0;p<b.length;p++)D[B[p]]=g[C[p]],D.push(b[p]);var z,P=z=0;for(p=B=0;p<d;p++){var Q=[];for(y=0;y<J;y++)Q[y]=0;Q[D[p]]=1;var G=[];for(y=0;y<g.length;y++)G[y]=0;p>=M&&(G[C[p-M]]=1);y=this.network.activate(Q);q(y,G)?p<M?z++:P++:this.network.propagate(e,G);B+=k(G,y);z+P==d&&m++}x%1E3==0&&(m=0);x++;p=x%1E3;p=p==0?1E3:p;D=m/p;B/=d;f&&x%f==0&&console.log("iterations:",x," success:",D," correct:",m," time:",Date.now()-
t," error:",B);l.do&&l.every&&x%l.every==0&&l.do({iterations:x,success:D,error:B,time:Date.now()-t,correct:m})}return{iterations:x,success:D,error:B,time:Date.now()-t}}},{key:"ERG",value:function(k){k=k||{};var g=k.iterations||15E4,h=k.error||.05,b=k.rate||.1,d=k.log||500;k=k.cost||this.cost||n.cost.CROSS_ENTROPY;var a=function(){this.paths=[]};a.prototype={connect:function(C,z){this.paths.push({node:C,value:z});return this},any:function(){return this.paths.length==0?!1:this.paths[Math.random()*this.paths.length|
0]},test:function(C){for(var z in this.paths)if(this.paths[z].value==C)return this.paths[z];return!1}};for(var c=function(){var C=new a,z=(new a).connect(C,"E"),P=(new a).connect(z,"S"),Q=(new a).connect(z,"V").connect(P,"P");z=(new a).connect(P,"X");z.connect(z,"S");Q=(new a).connect(Q,"V");Q.connect(Q,"T");P.connect(Q,"X");P=(new a).connect(z,"T").connect(Q,"P");return{input:(new a).connect(P,"B"),output:C}},e=function(){var C=c(),z=c(),P=new a,Q=(new a).connect(P,"E");C.output.connect(Q,"T");z.output.connect(Q,
"P");C=(new a).connect(C.input,"P").connect(z.input,"T");return{input:(new a).connect(C,"B"),output:P}},f=function(){for(var C=e().input.any(),z="";C;)z+=C.value,C=C.node.any();return z},l=function(C,z){var P=0,Q=-1,G=0,I=-1,R;for(R in C)C[R]>P&&(P=C[R],Q=R),z[R]>G&&(G=z[R],I=R);return Q!=I},m=0,p=1,y={B:0,P:1,T:2,X:3,S:4,E:5},D=Date.now();m<g&&p>h;){var x=0;p=0;for(var B=f(),J=B.charAt(x),H=B.charAt(x+1);x<B.length-1;){for(var q=[],t=[],M=0;M<6;M++)q[M]=0,t[M]=0;q[y[J]]=1;t[y[H]]=1;q=this.network.activate(q);
l(q,t)&&this.network.propagate(b,t);J=B.charAt(++x);H=B.charAt(x+1);p+=k(t,q)}p/=B.length;m++;m%d==0&&console.log("iterations:",m," time:",Date.now()-D," error:",p)}return{iterations:m,error:p,time:Date.now()-D,test:function(C){for(var z=e().input,P=0,Q=C.charAt(P);P<C.length;){z=z.test(Q);if(!z)return!1;z=z.node;Q=C.charAt(++P)}return!0},generate:f}}},{key:"timingTask",value:function(k){if(this.network.inputs()!=2||this.network.outputs()!=1)throw Error("Invalid Network: must have 2 inputs and one output");
typeof k=="undefined"&&(k={});var g=k.iterations||200,h=k.error||.005,b=k.rate||[.03,.02],d=k.log===!1?!1:k.log||10,a=k.cost||this.cost||n.cost.MSE,c=k.trainSamples||7E3;k=c+(k.trainSamples||1E3);for(var e=0,f=[],l=0;l<k;l++)f.push({input:[0,0],output:[0]});for(;e<k-20;){l=Math.round(Math.random()*20);f[e].input[0]=1;for(var m=e;m<=e+l;m++)f[m].input[1]=l/20,f[m].output[0]=.5;e+=l;l=Math.round(Math.random()*20);for(m=e+1;m<=e+l&&m<k;m++)f[m].input[1]=f[e].input[1];e+=l}e=[];l=[];for(m=0;m<k;m++)(m<
c?e:l).push(f[m]);return{train:this.train(e,{rate:b,log:d,iterations:g,error:h,cost:a}),test:this.test(l)}}}]);return n}();v.cost={CROSS_ENTROPY:function(n,k){var g=0,h;for(h in k)g-=n[h]*Math.log(k[h]+1E-15)+(1-n[h])*Math.log(1+1E-15-k[h]);return g},MSE:function(n,k){for(var g=0,h=0;h<k.length;h++)g+=Math.pow(n[h]-k[h],2);return g/k.length},BINARY:function(n,k){for(var g=0,h=0;h<k.length;h++)g+=Math.round(n[h]*2)!=Math.round(k[h]*2);return g}};u.default=v},function(v,u,r){function w(b){return b&&
b.__esModule?b:{default:b}}Object.defineProperty(u,"__esModule",{value:!0});u.Architect=u.Network=u.Trainer=u.Layer=u.Neuron=void 0;var n=r(2);Object.defineProperty(u,"Neuron",{enumerable:!0,get:function(){return w(n).default}});var k=r(0);Object.defineProperty(u,"Layer",{enumerable:!0,get:function(){return w(k).default}});var g=r(3);Object.defineProperty(u,"Trainer",{enumerable:!0,get:function(){return w(g).default}});var h=r(1);Object.defineProperty(u,"Network",{enumerable:!0,get:function(){return w(h).default}});
v=function(b){if(b&&b.__esModule)return b;var d={};if(b!=null)for(var a in b)Object.prototype.hasOwnProperty.call(b,a)&&(d[a]=b[a]);d.default=b;return d}(r(7));u.Architect=v},function(v,u,r){Object.defineProperty(u,"__esModule",{value:!0});var w=function(){function k(g,h){for(var b=0;b<h.length;b++){var d=h[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(g,d.key,d)}}return function(g,h,b){h&&k(g.prototype,h);b&&k(g,b);return g}}(),n=u.connections=
0;v=function(){function k(g,h,b){if(!(this instanceof k))throw new TypeError("Cannot call a class as a function");if(!g||!h)throw Error("Connection Error: Invalid neurons");this.ID=k.uid();this.from=g;this.to=h;this.weight=typeof b=="undefined"?Math.random()*.2-.1:b;this.gain=1;this.gater=null}w(k,null,[{key:"uid",value:function(){return u.connections=n+=1,n-1}}]);return k}();u.default=v},function(v,u,r){Object.defineProperty(u,"__esModule",{value:!0});u.connections=void 0;var w=function(){function g(h,
b){for(var d=0;d<b.length;d++){var a=b[d];a.enumerable=a.enumerable||!1;a.configurable=!0;"value"in a&&(a.writable=!0);Object.defineProperty(h,a.key,a)}}return function(h,b,d){b&&g(h.prototype,b);d&&g(h,d);return h}}(),n=(v=r(0))&&v.__esModule?v:{default:v},k=u.connections=0;v=function(){function g(h,b,d,a){if(!(this instanceof g))throw new TypeError("Cannot call a class as a function");this.ID=g.uid();this.from=h;this.to=b;this.selfconnection=b==h;this.type=d;this.connections={};this.list=[];this.size=
0;this.gatedfrom=[];typeof this.type=="undefined"&&(this.type=h==b?n.default.connectionType.ONE_TO_ONE:n.default.connectionType.ALL_TO_ALL);if(this.type==n.default.connectionType.ALL_TO_ALL||this.type==n.default.connectionType.ALL_TO_ELSE)for(var c in this.from.list)for(var e in this.to.list){if(b=this.from.list[c],d=this.to.list[e],this.type!=n.default.connectionType.ALL_TO_ELSE||b!=d)b=b.project(d,a),this.connections[b.ID]=b,this.size=this.list.push(b)}else if(this.type==n.default.connectionType.ONE_TO_ONE)for(var f in this.from.list)b=
this.from.list[f],d=this.to.list[f],b=b.project(d,a),this.connections[b.ID]=b,this.size=this.list.push(b);h.connectedTo.push(this)}w(g,null,[{key:"uid",value:function(){return u.connections=k+=1,k-1}}]);return g}();u.default=v},function(v,u,r){function w(b){return b&&b.__esModule?b:{default:b}}Object.defineProperty(u,"__esModule",{value:!0});var n=r(8);Object.defineProperty(u,"Perceptron",{enumerable:!0,get:function(){return w(n).default}});var k=r(9);Object.defineProperty(u,"LSTM",{enumerable:!0,
get:function(){return w(k).default}});var g=r(10);Object.defineProperty(u,"Liquid",{enumerable:!0,get:function(){return w(g).default}});var h=r(11);Object.defineProperty(u,"Hopfield",{enumerable:!0,get:function(){return w(h).default}})},function(v,u,r){function w(k,g){if(typeof g!=="function"&&g!==null)throw new TypeError("Super expression must either be null or a function, not "+typeof g);k.prototype=Object.create(g&&g.prototype,{constructor:{value:k,enumerable:!1,writable:!0,configurable:!0}});
g&&(Object.setPrototypeOf?Object.setPrototypeOf(k,g):k.__proto__=g)}Object.defineProperty(u,"__esModule",{value:!0});v=(v=r(1))&&v.__esModule?v:{default:v};var n=(r=r(0))&&r.__esModule?r:{default:r};r=function(k){function g(){if(!(this instanceof g))throw new TypeError("Cannot call a class as a function");var h=(g.__proto__||Object.getPrototypeOf(g)).call(this);if(!this)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");h=!h||typeof h!=="object"&&typeof h!=="function"?
this:h;var b=Array.prototype.slice.call(arguments);if(b.length<3)throw Error("not enough layers (minimum 3) !!");var d=b.shift(),a=b.pop();d=new n.default(d);var c=[];a=new n.default(a);for(var e=d,f=0;f<b.length;f++){var l=new n.default(b[f]);c.push(l);e.project(l);e=l}e.project(a);h.set({input:d,hidden:c,output:a});return h}w(g,k);return g}(v.default);u.default=r},function(v,u,r){function w(k,g){if(typeof g!=="function"&&g!==null)throw new TypeError("Super expression must either be null or a function, not "+
typeof g);k.prototype=Object.create(g&&g.prototype,{constructor:{value:k,enumerable:!1,writable:!0,configurable:!0}});g&&(Object.setPrototypeOf?Object.setPrototypeOf(k,g):k.__proto__=g)}Object.defineProperty(u,"__esModule",{value:!0});v=(v=r(1))&&v.__esModule?v:{default:v};var n=(r=r(0))&&r.__esModule?r:{default:r};r=function(k){function g(){if(!(this instanceof g))throw new TypeError("Cannot call a class as a function");var h=(g.__proto__||Object.getPrototypeOf(g)).call(this);if(!this)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
h=!h||typeof h!=="object"&&typeof h!=="function"?this:h;var b=Array.prototype.slice.call(arguments);if(b.length<3)throw Error("not enough layers (minimum 3) !!");var d=b.pop(),a=n.default.connectionType.ALL_TO_ALL,c=!1,e=!1,f=!1,l=!0;if(typeof d!="number"){var m=b.pop();d.hasOwnProperty("peepholes")&&(a=d.peepholes);d.hasOwnProperty("hiddenToHidden")&&(c=d.hiddenToHidden);d.hasOwnProperty("outputToHidden")&&(e=d.outputToHidden);d.hasOwnProperty("outputToGates")&&(f=d.outputToGates);d.hasOwnProperty("inputToOutput")&&
(l=d.inputToOutput)}else m=d;d=b.shift();d=new n.default(d);var p=[];m=new n.default(m);for(var y=null,D=0;D<b.length;D++){var x=b[D],B=(new n.default(x)).set({bias:1}),J=(new n.default(x)).set({bias:1}),H=new n.default(x);x=(new n.default(x)).set({bias:1});p.push(B);p.push(J);p.push(H);p.push(x);var q=d.project(H);d.project(B);d.project(J);d.project(x);if(y!=null){var t=y.project(H);y.project(B);y.project(J);y.project(x)}var M=H.project(m),C=H.project(H);c&&H.project(H,n.default.connectionType.ALL_TO_ELSE);
e&&m.project(H);f&&(m.project(B),m.project(x),m.project(J));H.project(B,a);H.project(J,a);H.project(x,a);B.gate(q,n.default.gateType.INPUT);J.gate(C,n.default.gateType.ONE_TO_ONE);x.gate(M,n.default.gateType.OUTPUT);y!=null&&B.gate(t,n.default.gateType.INPUT);y=H}l&&d.project(m);h.set({input:d,hidden:p,output:m});return h}w(g,k);return g}(v.default);u.default=r},function(v,u,r){function w(k,g){if(typeof g!=="function"&&g!==null)throw new TypeError("Super expression must either be null or a function, not "+
typeof g);k.prototype=Object.create(g&&g.prototype,{constructor:{value:k,enumerable:!1,writable:!0,configurable:!0}});g&&(Object.setPrototypeOf?Object.setPrototypeOf(k,g):k.__proto__=g)}Object.defineProperty(u,"__esModule",{value:!0});v=(v=r(1))&&v.__esModule?v:{default:v};var n=(r=r(0))&&r.__esModule?r:{default:r};r=function(k){function g(h,b,d,a,c){if(!(this instanceof g))throw new TypeError("Cannot call a class as a function");var e=(g.__proto__||Object.getPrototypeOf(g)).call(this);if(!this)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
e=!e||typeof e!=="object"&&typeof e!=="function"?this:e;h=new n.default(h);b=new n.default(b);d=new n.default(d);for(var f=b.neurons(),l=[],m=0;m<a;m++){var p=f[Math.random()*f.length|0].project(f[Math.random()*f.length|0]);l.push(p)}for(a=0;a<c;a++)m=Math.random()*f.length|0,p=Math.random()*l.length|0,f[m].gate(l[p]);h.project(b);b.project(d);e.set({input:h,hidden:[b],output:d});return e}w(g,k);return g}(v.default);u.default=r},function(v,u,r){function w(d){return d&&d.__esModule?d:{default:d}}function n(d,
a){if(typeof a!=="function"&&a!==null)throw new TypeError("Super expression must either be null or a function, not "+typeof a);d.prototype=Object.create(a&&a.prototype,{constructor:{value:d,enumerable:!1,writable:!0,configurable:!0}});a&&(Object.setPrototypeOf?Object.setPrototypeOf(d,a):d.__proto__=a)}Object.defineProperty(u,"__esModule",{value:!0});var k=function(){function d(a,c){for(var e=0;e<c.length;e++){var f=c[e];f.enumerable=f.enumerable||!1;f.configurable=!0;"value"in f&&(f.writable=!0);
Object.defineProperty(a,f.key,f)}}return function(a,c,e){c&&d(a.prototype,c);e&&d(a,e);return a}}();v=r(1);v=w(v);var g=r(3),h=w(g);r=r(0);var b=w(r);r=function(d){function a(c){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");var e=(a.__proto__||Object.getPrototypeOf(a)).call(this);if(!this)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");e=!e||typeof e!=="object"&&typeof e!=="function"?this:e;var f=new b.default(c);c=new b.default(c);
f.project(c,b.default.connectionType.ALL_TO_ALL);e.set({input:f,hidden:[],output:c});e.trainer=new h.default(e);return e}n(a,d);k(a,[{key:"learn",value:function(c){var e=[],f;for(f in c)e.push({input:c[f],output:c[f]});return this.trainer.train(e,{iterations:5E5,error:5E-5,rate:1})}},{key:"feed",value:function(c){var e=this.activate(c);c=[];for(var f in e)c[f]=e[f]>.5?1:0;return c}}]);return a}(v.default);u.default=r}])});
