var verbs={info:{help:"Provides information about the current package.",optionshelp:["If no option is provided will look for the package in the current directory.","If an URL is provided will look for the package in the repository.","Else it will try to access the directory specified."]},search:{help:"Searches for a keyword on the repository.",optionshelp:["Searches the keyword passed as an option."]},install:{help:"Install a package",optionshelp:"Provide the path or URL to the package directory or opack file.;'-d'       : Installation directory for package.;'-force'   : Force installation;'-repo'    : Use an alternatively repository for dependencies;'-deps'    : Automatically try to install dependencies;'-useunzip': Alternatively use unzip to save memory;'-noverify': Don't run hash verification on the end;'-cred'    : Provide authentication credentials (e.g. user:pass);'-arg'     : Pass an argument to the pre/post install scripts".split(";")},
erase:{help:"Deletes a package",optionshelp:["Deletes a package on the path specified","(only files declared on the package.json will be deleted)","'-force': Force operation even with package dependencies","'-arg'  : Pass an argument to the pre/post erase scripts"]},update:{help:"Updates a package",optionshelp:["The install/erase verbs options are valid also for update.","'-all'       : Tries to update all packages locally installed","'-cred'      : Provide authentication credentials (e.g. user:pass)",
"'-noerase'   : When updating don't delete the package first","'-erasefolder: Erase previous version folder while updating to a new version"]},exec:{help:"Executes code from an installed package",optionshelp:["Loads the main script of a local installed package."]},list:{help:"List installed packages",optionshelp:[]},pack:{help:"Generates a opack file from a packaging directory",optionshelp:""},genpack:{help:"Generates a package.json for packaging.",optionshelp:""},add2db:{help:"Add an already installed package to the local OpenPack database",
optionshelp:[]},remove4db:{help:"Remove a package entry from the local OpenPack database",optionshelp:["Provide the path to the entry to remove.","'-i'       : Remove package entries interactively."]},script:{help:"Creates a shell script, on the current path, to execute a opack (--script)"},daemon:{help:"Creates a shell script, on the current path, to execute an opack as a daemon (--daemon)"},ojob:{help:"Creates a shell script, on the current path, to execute an opack as a ojob (--ojob)"},add2remotedb:{},
remove2remotedb:{},help:{}};plugin("ZIP");plugin("HTTP");ow.loadFormat();ow.loadObj();var localDB,remoteDB,zipCache={},outputPath,verb,arg,__remoteUser,__remotePass,__remoteHTTP;
function showHelp(){print("Usage: opack [verb] [package/path] [options]\n");var a=0;for(var b in verbs)b.length>a&&(a=b.length);print("Verbs:\n");for(let d in verbs)if(b=verbs[d],!isUnDef(b.help)){print("   "+d+repeat(a-d.length+1," ")+" - "+b.help);for(let c in b.optionshelp)print(repeat(a," ")+"          "+b.optionshelp[c])}print("");print("(version "+af.getVersion()+", "+Packages.openaf.AFCmdBase.LICENSE+")")}
function getHTTPOPack(a){if(!isUnDef(zipCache[a]))return zipCache[a];log("Retrieving "+a);try{var b=execHTTPWithCred(a.replace(/ /g,"%20"),"GET","",{},!0),d=new ZIP(b);return zipCache[a]=d}catch(c){logErr("Can't retrieve "+a+" ("+c.message+")")}}function getRemoteDB(){return isUnDef(remoteDB)?remoteDB=getOPackRemoteDB():remoteDB}
function addRemoteDB(a,b){var d={};plugin("ZIP");var c=new ZIP;try{d=fromJsonYaml(af.fromBytes2String(c.streamGetFile(b,OPACKCENTRALJSON)))}catch(f){}delete a.__filelocation;delete a.filesHash;d[a.name]=a;try{c.streamPutFile(b,OPACKCENTRALJSON,af.fromString2Bytes(stringify(d)))}catch(f){logErr(f.message)}}
function removeRemoteDB(a,b){var d={};plugin("ZIP");var c=new ZIP;try{d=fromJsonYaml(af.fromBytes2String(c.streamGetFile(b,OPACKCENTRALJSON)))}catch(f){}delete d[a];try{c.streamPutFile(b,OPACKCENTRALJSON,af.fromString2Bytes(stringify(d)))}catch(f){logErr(f.message)}}
function addLocalDB(a,b){var d=getOpenAFPath()+"/"+PACKAGESJSON_DB,c=__gHDir()+"/"+PACKAGESJSON_USERDB,f=io.fileExists(c),g=io.fileExists(d),e=!0;try{if(g&&io.fileInfo(d).permissions.indexOf("w")<0&&(e=!1,logWarn("'"+d+"' is not accessible. Reverting to per-user oPack db.")),f&&io.fileInfo(c).permissions.indexOf("w")<0)throw c+" is not accessible. Please check permissions.";}catch(m){if(!m.message.match(/NoSuchFileException/))throw m;}try{b=String(java.io.File(b).getCanonicalPath()).replace(/\/$/,
"");var k=getOpenAFPath().replace(/\/$/,"");b.length>k.length&&b.substring(0,k.length)==k&&b[k.length]=="/"&&(b="$DIR"+b.substring(k.length))}catch(m){logErr(m.message)}g={};k=new ZIP;try{g=fromJsonYaml(af.fromBytes2String(k.streamGetFile(d,PACKAGESJSON)))}catch(m){m.message.indexOf("FileNotFoundException")<0&&m.message.indexOf("NoSuchFileException")<0&&logErr(m.message)}if(f)try{var p=fromJsonYaml(af.fromBytes2String(k.streamGetFile(c,PACKAGESJSON))),l;for(l in p)l.startsWith("$DIR")&&delete p[l];
g=merge(p,g)}catch(m){m.message.indexOf("FileNotFoundException")<0&&m.message.indexOf("NoSuchFileException")<0&&logErr(m.message)}for(l in g)g[l].name=="OpenAF"&&delete g[l];isUnDef(g)&&(g={});g[b]=a;try{if(e)k.streamPutFile(d,PACKAGESJSON,af.fromString2Bytes(stringify(g)));else{for(l in g)g[l].name=="OpenAF"&&delete g[l],l.startsWith("$DIR")&&delete g[l];k.streamPutFile(c,PACKAGESJSON,af.fromString2Bytes(stringify(g)))}}catch(m){logErr(m.message);return}a.name.toUpperCase()!="OPENAF"&&log("Package "+
a.name+" added to local OpenPack DB")}function getPackVersion(a,b){if(a.toUpperCase()=="OPENAF")return String(getVersion());if(isUnDef(b)){if(a=findLocalDBByName(a),!isUnDef(a))return String(a.version)}else return String(b.version)}function getLocalDB(a){if(a==0&&!isUnDef(localDB))return localDB;localDB=getOPackLocalDB();compare(localDB,{})&&checkOpenAFinDB();return localDB}function findLocalDBByTarget(a){return getLocalDB()[a]}
function findLocalDBByName(a){var b=getLocalDB(!0);if(!(isUnDef(a)||a.length<=0)){var d,c;for(c in b){var f=b[c];if(f.name.toUpperCase()==a.toUpperCase()||ow.format.string.separatorsToUnix(c)==ow.format.string.separatorsToUnix(a))isDef(d)?ow.format.string.separatorsToUnix(c)==ow.format.string.separatorsToUnix(a)&&(d=f):d=f,d.__target=c}return d}}
function findLocalDBTargetByName(a){var b=getLocalDB();if(!(isUnDef(a)||a.length<=0)){var d,c;for(c in b)b[c].name.toUpperCase()==a.toUpperCase()&&(d=c);return d}}
function verifyDeps(a){var b={};if(isMap(a.dependencies)){log("Checking dependencies for "+a.name+"...");for(let k in a.dependencies){var d=a.dependencies[k],c=findLocalDBByName(k);ldep=k.toLowerCase();b[ldep]=!1;if(!isUnDef(c)){d=d.split(",");var f=[],g;for(g in d){var e=String(d[g]).trim();c.version=String(c.version).trim();if(c.version.indexOf(".")>0&&e.indexOf(".")>0)try{if(e.match(/^>=/)&&ow.format.semVer(c.version).greaterEquals(e.replace(/^>=/,""))){f.push(!0);continue}if(e.match(/^<=/)&&ow.format.semVer(c.version).lowerEquals(e.replace(/<=/,
""))){f.push(!0);continue}if(e.match(/^<(?=[^=])/)&&ow.format.semVer(c.version).lower(e.replace(/^</,""))){f.push(!0);continue}if(e.match(/^>(?=[^=])/)&&ow.format.semVer(c.version).greater(e.replace(/^>/,""))){f.push(!0);continue}if(ow.format.semVer(c.version).equals(e)){f.push(!0);continue}}catch(p){}c.version==e?f.push(!0):e.match(/^>=/)&&c.version>=e.replace(/^>=/,"")?f.push(!0):e.match(/^<=/)&&c.version<=e.replace(/^<=/,"")?f.push(!0):e.match(/^<(?=[^=])/)&&c.version<e.replace(/^</,"")?f.push(!0):
e.match(/^>(?=[^=])/)&&c.version>e.replace(/^>/,"")?f.push(!0):f.push(!1)}f.indexOf(!1)<0&&(b[ldep]=!0)}}}return b}
function removeLocalDB(a,b){var d=getOpenAFPath()+"/"+PACKAGESJSON_DB,c=__gHDir()+"/"+PACKAGESJSON_USERDB,f=io.fileExists(c),g=!0;if(!isMap(a)||!isDef(a.name)||a.name!="OpenAF"){if(io.fileInfo(d).permissions.indexOf("w")<0)if(f){if(io.fileInfo(c).permissions.indexOf("w")<0)throw"Can't access '"+d+"' neither '"+c+"'.";g=!1}else throw d+" is not accessible. Please check permissions.";b=String(java.io.File(b).getCanonicalPath()).replace(/\/$/,"");var e=getOpenAFPath().replace(/\/$/,"");b.length>e.length&&
b.substring(0,e.length)==e&&(b="$DIR"+b.substring(e.length));e={};var k={},p=new ZIP;try{if(g){e=fromJsonYaml(af.fromBytes2String(p.streamGetFile(d,PACKAGESJSON)));for(var l in e)e[l].name=="OpenAF"&&delete e[l]}if(f)for(l in k=fromJsonYaml(af.fromBytes2String(p.streamGetFile(c,PACKAGESJSON))),k)k[l].name=="OpenAF"&&delete k[l],l.startsWith("$DIR")&&delete k[l]}catch(h){logErr(h.message)}if(isDef(e)||isDef(k)){var m=!1;if(g)try{if(isDef(e)){let h=isDef(e[b])?b:Object.keys(e).find(n=>n.toUpperCase()===
b.toUpperCase());isDef(h)?(delete e[h],m=!0):logWarn(`Package '${b.replace("$DIR/",getOpenAFPath())}' not found in OpenPack DB.`)}m&&p.streamPutFile(d,PACKAGESJSON,af.fromString2Bytes(stringify(e)))}catch(h){logErr(h.message);return}if(f)try{if(isDef(k)){let h=isDef(k[b])?b:Object.keys(k).find(n=>n.toUpperCase()===b.replace("$DIR/",getOpenAFPath()).toUpperCase());h&&(delete k[h],m=!0)}for(l in k)k[l].name=="OpenAF"&&delete k[l],l.startsWith("$DIR")&&delete k[l];m&&p.streamPutFile(c,PACKAGESJSON,af.fromString2Bytes(stringify(k)))}catch(h){logErr(h.message);
return}m?log("Package "+a.name+" removed from local OpenPack DB"):logWarn("Package can't be removed from oPack database.")}}}function checkOpenAFinDB(){}
function listFiles(a,b,d){var c=[];isUnDef(d)&&(d=[]);isUnDef(b)&&(b="");a=a.replace(/\\+/g,"/");b=b.replace(/\\+/g,"/");var f=io.listFiles(a+"/"+b);for(let e in f.files){var g=f.files[e];d.indexOf(g.filename)>=0||(g.isFile?c.push(b+g.filename.replace(/\\+/g,"/")):c=c.concat(listFiles(a,g.filepath.replace(/\\/g,"/").replace(new RegExp(a+"[\\\\/]*",""),"")+"/")))}return c.sort()}
function generateHash(a){var b="";if(isString(a))if(io.isBinaryFile(a)){var d=io.readFileStream(a);b=String(sha1(d));d.close()}else{d=io.readFileStream(a);var c=Packages.org.apache.commons.codec.digest.DigestUtils.getDigest(Packages.org.apache.commons.codec.digest.MessageDigestAlgorithms.SHA_1);ioStreamReadBytes(d,g=>{var e=[],k;for(k in g)g[k]!=13&&e.push(g[k]);c.update(e)});b=String(Packages.org.apache.commons.codec.binary.Hex.encodeHexString(c.digest()))}if(isByteArray(a)){if(isBinaryArray(a))return sha1(a);
b=[];for(var f in a)a[f]!=13&&b.push(a[f]);return sha1(b)}if(b=="")throw"Object type for generateHash couldn't be determined.";return b}
function listFilesWithHash(a,b){var d={};b=listFiles(a,void 0,b);var c=0,f=0,g=ow.format.string.updateLine(lognl);for(let k in b){c++;try{var e="Checking ("+ow.format.round(c*100/b.length)+"%) "+ow.format.addNumberSeparator(c)+" files";g.line(e);e.length>f&&(f=e.length);b[k].match(new RegExp(PACKAGEJSON+"$",""))||b[k].match(new RegExp(PACKAGEYAML+"$",""))||(d[b[k]]=generateHash(a+"/"+b[k]))}catch(p){}}c>0&&(g.end(),log("All files checked."));return d}
function verifyHashList(a,b){var d={},c="local",f=new ZIP;a.match(/^http/)&&(c="http");if(a.match(/\.(opack)|(jar)$/))if(c=="http"){c="opackhttp";var g=execHTTPWithCred(a.replace(/ /g,"%20"),"GET","",{},!0);f=new ZIP(g)}else c="opack",f=new ZIP;c=="http"&&(g=execHTTPWithCred(a.replace(/ /g,"%20")+"/"+file.replace(/ /g,"%20")));var e=0,k=ow.format.string.updateLine(lognl);for(let l in b){e++;k.line("Verifying ("+ow.format.round(e*100/Object.keys(b).length)+"%) "+ow.format.addNumberSeparator(e)+" files");
d[l]=!1;switch(c){case "local":var p=generateHash(a+"/"+l);break;case "http":p=generateHash(g);break;case "opack":p=c=="opack"?generateHash(f.streamGetFile(l)):generateHash(f.getFile(l));break;case "opackhttp":p=c=="opackhttp"?generateHash(f.streamGetFile(l)):generateHash(f.getFile(l))}p==b[l]&&(d[l]=!0)}k.end();f.close();return d}
function copyFile(a,b){mkdir(b.replace(/\/[^\/]+$/,"/"));try{java.nio.file.Files.copy(java.nio.file.Paths.get(a),java.nio.file.Paths.get(b),java.nio.file.StandardCopyOption.REPLACE_EXISTING)}catch(d){if(!d.message.match(/DirectoryNotEmptyException/))throw d;}}function deleteFile(a){return io.rm(a)}function mkdir(a){return io.mkdir(a)}function rmdir(a,b){if(!(b&&io.fileExists(a)&&$from(io.listFiles(a).files).equals("isFile",!0).any()))return io.rm(a)}
function sortPackagesByDeps(a,b){if(isUnDef(a)||a.length<=1)return a;var d=b?getLocalDB():getRemoteDB();if(isUnDef(d)||Object.keys(d).length==0)return a;log("Sorting packages by dependencies...");var c={},f=[],g;for(g in a){var e=findCaseInsensitive(d,a[g]);e?(c[e.name]=e,f.push(e.name)):f.push(a[g])}e=!1;for(var k in c)if(isMap(c[k].dependencies)){for(var p in c[k].dependencies)if(f.some(n=>n.toLowerCase()===p.toLowerCase())){e=!0;break}if(e)break}if(!e)return a;e={};for(k in c)e[k]=isMap(c[k].dependencies)?
c[k].dependencies:{};k=Object.keys(e);for(c=[];k.length>0;){f=!1;for(g=0;g<k.length;g++){var l=k[g];if(isUnDef(e[l])||Object.keys(e[l]).length===0){b?c.unshift(l):c.push(l);delete e[l];f=l.toLowerCase();for(var m in e)for(var h in e[m])h.toLowerCase()===f&&delete e[m][h];k.splice(g,1);f=!0;break}}if(!f){c=c.concat(b?k:k.reverse());break}}h=[];for(g in c)for(m in a)if((e=findCaseInsensitive(d,a[m]))&&e.name===c[g]){h.push(a[m]);break}for(g in a)h.includes(a[g])||(b?h.unshift(a[g]):h.push(a[g]));log("Sorted: "+
h.join(", "));return h}
function execHTTPWithCred(a,b,d,c,f,g,e){isUnDef(__remoteHTTP)&&(__remoteHTTP=new ow.obj.http);ow.loadNet();var k=ow.net.path4URL(a),p=ow.net.host4URL(a);k=k.substring(0,k.lastIndexOf("/"));try{var l=__remoteHTTP.exec(a,b,d,c,f,g,e);if(l.responseCode==401)throw"code: 401";}catch(h){if(String(h).indexOf("code: 401")>=0){try{try{$sec(__,"opack").get("opack::")}catch(n){$sec(__,"opack").set("opack::",{})}var m=$sec(__,"opack").get("opack::"+p+"::"+k)}catch(n){}isMap(m)&&(isUnDef(__remoteUser)||isUnDef(__remotePass))&&
(__remoteUser=Packages.openaf.AFCmdBase.afc.dIP(m.u),__remotePass=Packages.openaf.AFCmdBase.afc.dIP(m.p));isDef(__remoteUser)&&isDef(__remotePass)&&__remoteHTTP.login(Packages.openaf.AFCmdBase.afc.dIP(__remoteUser),Packages.openaf.AFCmdBase.afc.dIP(__remotePass),a);if(isUnDef(__remoteUser)||isUnDef(__remotePass))__remoteUser=ask("Enter authentication user: "),__remotePass=ask("Enter authentication password: ",String.fromCharCode(0));__remoteHTTP.login(Packages.openaf.AFCmdBase.afc.dIP(__remoteUser),
Packages.openaf.AFCmdBase.afc.dIP(__remotePass),a);l=__remoteHTTP.exec(a,b,d,c,f,g,e);if(l.responseCode==200)try{$sec(__,"opack").set("opack::"+p+"::"+k,{u:__remoteUser,p:__remotePass})}catch(n){}}else throw h;}return e?l:l.responseBytes}
function getOpenAFSB(){var a=String(java.lang.System.getProperty("os.name")),b=getOpenAFJar();b=a.match(/Windows/)?b.replace(/openaf\.jar/,"openaf.bat"):b.replace(/openaf\.jar/,"openaf-sb");try{io.readFileString(b)}catch(d){return logErr("Can't access "+b),null}return a.match(/Windows/)?b+" -s -i script -f ":b}
function getOpenAF(){var a=ow.format.getOS(),b=getOpenAFJar();b=a.match(/Windows/)?b.replace(/openaf\.jar/,"openaf.bat"):b.replace(/openaf\.jar/,"openaf");try{io.readFileString(b)}catch(d){return logErr("Can't access "+b),null}return a.match(/Windows/)?b+" -s -i script -f ":b}function fixSheBang(a){var b=io.readFileAsArray(a);b[0].match(/^#!/)&&(b[0]="#!/usr/bin/env "+getOpenAFSB());io.writeFileAsArray(a,b);try{af.sh("chmod u+rx "+a)}catch(d){}}
function runScript(a,b){b=_$(b).isMap().default({});b=merge({OAF_PATH:getOpenAFPath(),JAVA_HOME:ow.format.getJavaHome(),OAF_HOME:__gHDir(),OAF_VERSION:getVersion(),OAF_DIST:getDistribution(),OJOB_HOME:__flags.OJOB_LOCALPATH},b);if(isString(a))try{return newFn("args="+stringify(b,__,"")+";"+a)(),!0}catch(c){return logErr(c),!1}else if(isArray(a)){Object.keys(b).forEach(c=>b[c]=String(b[c]));var d=!1;a.forEach(c=>{d||(c=$sh(c).envs(b,!0).exec(),isArray(c)&&c.length>0&&c[0].exitcode!=0&&(d=!0))});return!d}}
function findCaseInsensitive(a,b){if(isUnDef(b))return __;for(i in a)if(a[i].name.toUpperCase()==b.toUpperCase())return a[i];return __}function fromJsonYaml(a){try{return af.fromJson(a)}catch(b){return af.fromYAML(a)}}
function getPackage(a){var b={};if(isUnDef(a))return b;if(a.match(/^http/i))if(a.match(/\.(opack)|(jar)$/i)){var d=getHTTPOPack(a);if(isUnDef(d))return;try{b=fromJsonYaml(af.fromBytes2String(d.getFile(PACKAGEJSON)).replace(/\n/g,"")+"")}catch(e){b=fromJsonYaml(af.fromBytes2String(d.getFile(PACKAGEYAML))+"")}if(isUnDef(b.files)){b.files=[];var c=d.list();for(let e in c)b.files.push(e)}b.__filelocation="opackurl"}else try{try{var f=execHTTPWithCred(a.replace(/ /g,"%20")+"/"+PACKAGEJSON,"GET","",{},
!0);var g=af.fromBytes2String(f).replace(/\n/g,"");retry=!1}catch(e){try{f=execHTTPWithCred(a.replace(/ /g,"%20")+"/"+PACKAGEYAML,"GET","",{},!0),g=af.fromBytes2String(f),retry=!1}catch(k){logErr("Error while retrieving remote package: "+String(k))}}b=fromJsonYaml(g);if(isUnDef(b))throw a+"/"+PACKAGESJSON;b.__filelocation="url"}catch(e){logErr("Didn't find a package on '"+a+"' ("+e.message+")");return}else if(a.match(/\.(opack)|(jar)$/i))try{d=new ZIP;try{b=fromJsonYaml(af.fromBytes2String(d.streamGetFile(a,
PACKAGEJSON))+"")}catch(e){b=fromJsonYaml(af.fromBytes2String(d.streamGetFile(a,PACKAGEYAML))+"")}if(isUnDef(b.files)){b.files=[];c=d.list();for(let e in c)b.files.push(e)}b.__filelocation="opacklocal"}catch(e){printErr(e.message);return}else try{try{b=io.readFileJSON(a+"/"+PACKAGEJSON)}catch(e){b=io.readFileYAML(a+"/"+PACKAGEYAML)}b.__filelocation="local";b.__target=String((new java.io.File(a)).getCanonicalPath());isUnDef(b.files)&&(b.files=listFiles(a))}catch(e){}return b}
function __opack_info(a){if(!isUnDef(a[0])&&a[0]!=""){var b=getPackage(a[0]);if(isUnDef(b)||isUnDef(b.name))if(b=findLocalDBByName(a[0]),isUnDef(b)||isUnDef(b.name)){b=getRemoteDB();var d=findCaseInsensitive(b,a[0]);if(isUnDef(d)){logErr("No entry for '"+a[0]+"' on remote OPack database(s).");logErr(`Package ${a[0]} not found.`);return}switch(d.repository.type){case "path":if(isUnDef(d.repository.path)){logErr("No repository.path defined for '"+a[0]+"' on remote OPack database(s).");return}var c=
d.repository.path;b=getPackage(c);break;default:if(isUnDef(d.repository.url)){logErr("No repository.url defined for '"+a[0]+"' on remote OPack database(s).");return}c=d.repository.url;b=getPackage(c);isUnDef(b)&&!isUnDef(d.repository.backupurl)&&(b=getPackage(d.repository.backupurl))}a[0]=c;b.__filelocation="remote"}else a[0]=findLocalDBTargetByName(a[0]),b.__filelocation="local";else b.__filelocation="local";d=b.__filelocation.match(/local$/)?!1:!0;switch(b.repository.type){case "path":c=b.repository.path;
break;default:c=b.repository.url}print(printMap({"Installed in":a[0],Name:b.name,Version:b.version,Description:b.description,Author:b.author,Repository:"["+b.repository.type+"] "+c}));var f;c=[];d||(f=verifyDeps(b));if(isMap(b.dependencies))for(var g in b.dependencies)d?c.push({package:g}):c.push({package:g,status:f[g]?"OK":"FAILED DEPENDENCY"});print(ansiColor("bold","Depends on:")+"\n");print(printTable(c));var e;f=[];d||(e=verifyHashList(a[0],b.filesHash));for(let k in b.files){g=b.files[k];c=
!0;if(g==PACKAGEJSON||g==PACKAGEYAML)c=!1;if(isUnDef(g)||g==null)c=!1;c&&(d?f.push({file:g.replace(new RegExp("^"+a[0].replace(/\./g,"\\."),"")+"/","").replace(/^\/*/,"")}):(c=isUnDef(e[g])?"not installed":e[g]?"OK":"CHANGED!",f.push({file:g.replace(new RegExp("^"+a[0].replace(/\./g,"\\."),"")+"/","").replace(/^\/*/,""),status:c})))}ansiStart();print("\n\n"+ansiColor("bold","Files:")+"\n");ansiStop();print(printTable(f))}}
function __opack_list(a){var b=getLocalDB(!0),d=__conStatus||__initializeCon(),c=[],f=$from(b).attach("iname",k=>k.name.toLowerCase()).attach("key",k=>ow.format.string.separatorsToUnix(k._key)).sort("iname").distinct("_key"),g;for(g in f){var e=f[g];e!="OpenPackDB"&&b[e].key!="OpenAF"&&(d?c.push({name:b[e].name,version:b[e].version,path:b[e].key.replace(new RegExp("^"+getOpenAFPath()),"[openaf]/")}):(ansiStart(),print(ansiColor("bold","["+b[e].name+"]")+" (version "+ansiColor("green",b[e].version)+
"): "+ansiColor("cyan",b[e].key.replace(new RegExp("^"+getOpenAFPath()),"(openaf)/"))),ansiStop()))}c.length>0?(a=processExpr(" ",__,a.join(" ")),isUnDef(a.__format)&&(a.__format="ctable"),$o(c,a)):print("No packages found.")}
function checkVersion(a,b){if(isUnDef(a))return-1;var d=getPackVersion(a.name);return!b&&isDef(d)&&(d.indexOf(".")>0&&a.version.indexOf(".")&&ow.format.semver(d).greater(a.version)||d>a.version)?(log("Installed version is newer "+d),0):!b&&isDef(d)&&(d.indexOf(".")>0&&a.version.indexOf(".")&&ow.format.semver(d).equals(a.version)||d==a.version)?(log(a.name+", version "+d+", already installed in '"+findLocalDBTargetByName(a.name)+"'."),0):isUnDef(d)?-1:1}
function install(a){if(!(isUnDef(a[0])||a[0].length<=0)){if(isUnDef(a[0])||a[0].toUpperCase()!="OPENAF"){checkOpenAFinDB();var b=!1,d=!1,c=!1,f=!1,g=!1,e=!1,k=!1,p=!1,l=!1,m=!1,h=[],n=[];for(let q in a)if(h.push(a[q]),b){var x=a[q];b=!1;m=!0}else c?(__opackCentral.indexOf(a[q])<0&&__opackCentral.unshift(a[q]),c=!1):f?(arg=a[q],f=!1):g?(g=a[q],g.indexOf(":")>0&&([__remoteUser,__remotePass]=g.split(/:/)),g=!1):a[q]=="-d"?b=!0:a[q]=="-force"?d=!0:a[q]=="-repo"?c=!0:a[q]=="-deps"?l=!0:a[q]=="-arg"?f=
!0:a[q]=="-justcopy"?e=!0:a[q]=="-noverify"?p=!0:a[q]=="-useunzip"?k=!0:a[q]=="-cred"?g=!0:(h.pop(),n.push(a[q]));var t={installed:0,updated:0,failed:0,notNeeded:0};n=sortPackagesByDeps(n);n.forEach(q=>{var r="Getting package '"+q+"'...";log(ansiColor("FAINT",repeat(r.length,"-")));log(r);r=getPackage(q);if(isUnDef(r.name)&&r.__filelocation!="opackurl"){log("Checking remote OPack database(s)...");var w=getRemoteDB();w=findCaseInsensitive(w,q);if(isUnDef(w)){logErr("No entry for '"+q+"' on remote OPack database(s).");
t.failed++;return}switch(w.repository.type){case "path":if(isUnDef(w.repository.path)){logErr("Missing repository.path for '"+q+"' on remote OPack database(s).");t.failed++;return}r=getPackage(w.repository.path);q=r.repository.path;break;default:if(isUnDef(w.repository.url)){logErr("Missing repository.url for '"+q+"' on remote OPack database(s).");t.failed++;return}r=getPackage(w.repository.url);q=r.repository.url}}var D=isUnDef(x)&&!m?io.fileInfo(getOpenAFPath()).permissions.indexOf("w")>=0?getOpenAFPath()+
r.name:__gHDir()+"/.openaf-opack-"+r.name:x;log("Install folder: "+D);if(checkVersion(r,d)||e){log((e?"COPYING":"INSTALLING")+" -- "+r.name+" version "+r.version);var E=findLocalDBByName(r.name);var y=verifyDeps(r);if(!d&&!e&&isMap(r.dependencies))for(var v in r.dependencies)if(w=r.dependencies[v],!y[v.toLowerCase()]){var B=findCaseInsensitive(getLocalDB(!0),v);if(!isDef(B)||checkVersion(B)!=0){logWarn("Failed dependency on '"+v+"', version "+w+".");if(v.toUpperCase()=="OPENAF"){logErr("Please update OpenAF (e.g. 'openaf --update')");
return}log("Checking remote OPack database(s)...");w=getRemoteDB();w=findCaseInsensitive(w,v);if(isUnDef(w)){logErr("No entry for '"+v+"' on remote OPack database(s).");return}if(!l)try{if(logFlush(),askChoose("Do you want to try to install '"+v+"': ",["yes","no"])==1)return}catch(u){return}B=clone(h);switch(w.repository.type){case "path":if(isUnDef(w.repository.path)){logErr("Missing repository.path for '"+v+"' on remote OPack database(s).");return}B.push(w.repository.path);break;default:if(isUnDef(w.repository.url)){logErr("Missing repository.url for '"+
v+"' on remote OPack database(s).");return}B.push(w.repository.url)}w=install(B);isDef(w)&&(t.installed+=w.installed,t.updated+=w.updated,t.failed+=w.failed,t.notNeeded+=w.notNeeded)}}outputPath=D;if(!isUnDef(r.scripts.preinstall)&&!e&&(v=runScript(r.scripts.preinstall,{OPACK_PATH:outputPath}),!v)){logErr("Error while executing preinstall script.");t.failed++;return}switch(r.__filelocation){case "url":log("Copying remote files...");mkdir(outputPath);v=pForEach(r.files,function(u){log("Copying "+u+
"...");try{var z=execHTTPWithCred(q.replace(/ /g,"%20")+"/"+u.replace(/ /g,"%20"),"GET","",{},!0,void 0,!0);ioStreamCopy(io.writeFileStream(outputPath+"/"+u),z)}catch(C){return logErr("Can't copy remote file '"+u+"' ("+C.message+")"),0}return 1});v.filter(u=>u==1).length==r.files.length?(log(`All files copied (#${r.files.length}).`),t.installed++):(log("Not all files were copied ("+v.length+"/"+r.files.length+")!"),t.failed++);break;case "opackurl":var F=getHTTPOPack(q);if(typeof F=="undefined"){logErr("Can't get remote OPack '"+
q+"'");t.failed++;return}var A=ow.format.string.updateLine(lognl);v=pForEach(r.files,function(u){mkdir(outputPath);A.line("Unpacking "+u+"...");try{io.writeFileBytes(outputPath+"/"+u,F.getFile(u))}catch(z){return logErr("Can't write "+outputPath+"/"+u+" ("+z.message+")"),0}return 1});A.end();v.filter(u=>u==1).length==r.files.length?(log(`All files unpacked (#${r.files.length}).`),t.installed++):(log("Not all files were unpacked ("+v.length+"/"+r.files.length+")!"),t.failed++);break;case "local":log("Copying files");
A=ow.format.string.updateLine(lognl);outputPath=outputPath.replace(/\/{2,}/g,"/");v=pForEach(r.files,function(u){try{mkdir(outputPath);var z="Copying "+u.replace(new RegExp("^"+q.replace(/\./g,"\\."),"")+"/","")+"...";A.line(z);copyFile(q+"/"+u,outputPath+"/"+u.replace(new RegExp("^"+q.replace(/\./g,"\\."),"")+"/",""))}catch(C){logErr(C)}return 1});A.end();v.filter(u=>u==1).length==r.files.length?(log(`All files copied (#${r.files.length}).`),t.installed++):(log("Not all files were copied ("+v.length+
"/"+r.files.length+")!"),t.failed++);break;case "opacklocal":log("Copying files"),A=ow.format.string.updateLine(lognl),outputPath=outputPath.replace(/\/{2,}/g,"/"),v=pForEach(r.files,function(u){mkdir(outputPath);var z="Copying "+u.replace(new RegExp("^"+q.replace(/\./g,"\\."),"")+"/","")+"...";log(z);try{if(k){if(sh("unzip -o "+q+" "+u+" -d "+outputPath),__exitcode!=0)throw"Unzip exit code "+__exitcode+" for "+u;}else{var C=new ZIP;ioStreamCopy(io.writeFileStream(outputPath+"/"+u),C.streamGetFileStream(q,
u));C.close()}}catch(G){return logErr("Can't write "+outputPath+"/"+u+" ("+G.message+")"),0}return 1}),A.end(),v.filter(u=>u==1).length==r.files.length?(log(`All files copied (#${r.files.length}).`),t.installed++):(log("Not all files were copied ("+v.length+"/"+r.files.length+")!"),t.failed++)}isDef(E)&&$from(E.files).except(r.files).select(u=>{log("Deleting "+u+"...");io.rm(outputPath+"/"+u)});if(!p){log("Verifying package files installed...");E=verifyHashList(outputPath,r.filesHash);D=v=0;for(let u in r.files)y=
r.files[u],y!=PACKAGEJSON&&y!=PACKAGEYAML&&(E[y]?v++:logErr("File '"+y+"' not equal to declared hash ('"+r.filesHash[y]+"')"),D++);log(""+v+" file(s) verified (#"+D+") (+package description file).")}if(typeof r.scripts.postinstall!=="undefined"&&!e&&(v=runScript(r.scripts.postinstall,{OPACK_PATH:outputPath}),!v)){logErr("Error while executing postinstall script.");t.failed++;return}log("Package "+r.name+" installed.");delete r.__filelocation;e||addLocalDB(r,outputPath)}else log("No need to install/update "+
q),t.notNeeded++});log(ansiColor("FAINT",repeat(4,"-")));return t}logErr("Can't install OpenAF. Please install manually or using another package manager (e.g. RPM). To update execute 'openaf --update'.")}}
function __opack_exec(a){if(isUnDef(a[0])||a[0].toUpperCase()!="OPENAF"){packag=findLocalDBByName(a[0]);if(isUnDef(packag)||isUnDef(packag.name)){packag=getPackage(a[0]);if(packag.__filelocation!="local"){packag.__filelocation=="opacklocal"?logErr("Please use 'openaf-sb "+a[0]+"' instead."):logErr(`Package '${a[0]}' not found (note: only installed or local packages can be executed)`);return}a=a[0]}else a=findLocalDBTargetByName(a[0]);isString(packag.main)&&packag.main.length>0?af.load(a+"/"+packag.main):
isDef(packag.mainJob)&&packag.mainJob.length>0?oJobRunFile(a+"/"+packag.mainJob):logErr("Can't load package "+packag.name)}else logErr("Please use 'openaf' to execute OpenAF")}
function __opack_script(a,b,d){function c(t){if(typeof shLocation==="undefined"){if(l==1)shLocation="/bin/sh",g=g.replace(/\\/g,"/"),g=g.replace(/(\w):/,"/cygdrive/$1").toLowerCase();else try{shLocation=sh("which sh","",null,!1)}catch(r){logErr("Couldn't determine path for sh, assuming /bin/sh: "+r.message),shLocation="/bin/sh"}log("sh located in "+shLocation)}var q="#!"+shLocation+"\n";q=q+'CDIR=`pwd`\ncd `dirname $0`\nDIR=`pwd`\ncd $CDIR\nstty -icanon min 1 -echo 2>/dev/null\n#if [ -z "${JAVA_HOME}" ]; then \nJAVA_HOME="'+
g+'"\n#fi\n';q=q+'OPENAF_DIR="'+e+'"\n';q=q+'\n"$JAVA_HOME"/bin/java '+m+" -Djline.terminal=jline.UnixTerminal -jar $OPENAF_DIR "+t+"\n";return q+"EXITCODE=$?\nstty icanon echo 2>/dev/null\nexit $EXITCODE\n"}function f(t){var q='@echo off\n\nset thispath=%~dp0\nset DIR=%thispath:~0,-1%\nrem if not %JAVA_HOME% == "" set JAVA_HOME="'+g+'"\n';q=q+'set JAVA_HOME="'+g+'"\n';q=q+'set OPENAF_DIR="'+e+'"\n';return q=q+"\n%JAVA_HOME%\\bin\\java "+m+" -jar %OPENAF_DIR% "+t+"\n"}if(isUnDef(a[0])||a[0].toUpperCase()!=
"OPENAF"){packag=findLocalDBByName(a[0]);if(isUnDef(packag)||isUnDef(packag.name)){packag=getPackage(a[0]);if(packag.__filelocation!="local"){packag.__filelocation=="opacklocal"?logErr("Please use 'openaf-sb "+a[0]+"' instead."):logErr(`Package '${a[0]}' not found (note: only installed or local packages can be executed)`);return}a=a[0]}else a=findLocalDBTargetByName(a[0]);var g=java.lang.System.getProperty("java.home")+"",e=getOpenAFJar(),k=java.lang.System.getProperty("os.name")+"",p=java.lang.System.getProperty("user.dir")+
"",l=k.match(/Windows/)?1:0,m="",h=splitBySeparator(__expr," ");for(x in h){var n=splitBySeparator(h[x],"=");n.length==2&&n[0]=="args"&&(m=n[1])}var x=g.replace(/\\/g,"/");x.substring(0,getOpenAFPath().lastIndexOf("/")+1)==getOpenAFPath()&&(g=(k.match(/Windows/)?"%DIR%":"$DIR")+"/"+x.substring(getOpenAFPath().lastIndexOf("/")+1));e=(k.match(/Windows/)?"%DIR%":"$DIR")+"/"+e.substring(getOpenAFJar().lastIndexOf("/")+1);loadLodash();b=b?"--daemon ":"--script ";isString(packag.main)&&packag.main.length>
0&&!d?l?(io.writeFileString(p+"/opack_"+_.camelCase(packag.name)+".bat",f(b+a+"/"+packag.main+' -e "%*"')),log("Created script in "+p+"/opack_"+_.camelCase(packag.name)+".bat")):(io.writeFileString(p+"/opack_"+_.camelCase(packag.name),c(b+a+"/"+packag.main+' -e "$*"')),sh("chmod u+x "+p+"/opack_"+_.camelCase(packag.name)),log("Created script in "+p+"/opack_"+_.camelCase(packag.name))):isDef(packag.mainJob)&&packag.mainJob.length>0?l?(io.writeFileString(p+"/opack_"+_.camelCase(packag.name)+".bat",
f('--ojob -e "'+a+"/"+packag.mainJob+' %*"')),log("Created script in "+p+"/opack_"+_.camelCase(packag.name)+".bat")):(io.writeFileString(p+"/opack_"+_.camelCase(packag.name),c('--ojob -e "'+a+"/"+packag.mainJob+' $*"')),sh("chmod u+x "+p+"/opack_"+_.camelCase(packag.name)),log("Created script in "+p+"/opack_"+_.camelCase(packag.name))):logErr("Can't generate ojob script for package "+packag.name)}else logErr("Please use 'openaf' to execute OpenAF")}
function update(a){var b=!1,d=!1,c=!1,f=!1,g=!1,e=!0,k=!0,p=[],l=[];for(let h in a)l.push(a[h]),d?(__opackCentral.indexOf(a[h])<0&&__opackCentral.unshift(a[h]),d=!1):c?(arg=a[h],c=!1):f?(f=a[h],f.indexOf(":")>0&&([__remoteUser,__remotePass]=f.split(/:/)),f=!1):a[h]=="-arg"?c=!0:a[h]=="-force"?b=!0:a[h]=="-repo"?d=!0:a[h]=="-all"?g=!0:a[h]=="-noerase"?e=!1:a[h]=="-cred"?f=!0:a[h]=="-erasefolder"?k=!1:(l.pop(),p.push(a[h]));var m={updated:0,erasedToUpdate:0,failed:0,notNeeded:0};if(g){a=getOPackLocalDB();
for(let h in a)a[h].name.toUpperCase()!="OPENAF"&&p.push(a[h].name)}p=sortPackagesByDeps(p);p.forEach(h=>{if(h.toUpperCase()=="OPENAF")logErr("Please use 'openaf --update' to update OpenAF"),m.failed++;else{var n="Getting package '"+h+"'...";log(ansiColor("FAINT",repeat(n.length,"-")));log(n);n=getPackage(h);var x=findLocalDBByName(h);if(isDef(x)&&isDef(x.__target)){var t=x.__target;log("Found existing installation at: "+t)}isUnDef(n)||typeof n.name!="undefined"&&n.__filelocation!="local"||(n=getOPackRemoteDB()[$from(Object.keys(getOPackRemoteDB())).equals(h).at(0)]);
if(isUnDef(n)||typeof n.name==="undefined")b?(h=[h],isDef(t)&&(h.push("-d"),h.push(t)),n=install(h),isDef(n)&&(m.updated+=n.installed,m.failed+=n.failed,m.notNeeded+=n.notNeeded)):(logWarn("Can't update!"),m.failed++);else if(x=checkVersion(n,b),x<0)logWarn("Can't update since package is not installed."),m.failed++;else if(x>0){if(typeof n.__filelocation!=="undefined"&&!n.__filelocation.match(/opack/))switch(n.repository.type){case "path":if(isUnDef(n.repository.path)){logErr("Missing repository.path for '"+
h+"' on remote OPack database(s).");m.failed++;return}pack=n.repository.path;break;default:if(isUnDef(n.repository.url)){logErr("Missing repository.url for '"+h+"' on remote OPack database(s).");m.failed++;return}pack=n.repository.url}log("UPDATING -- "+n.name+" version "+n.version);e&&(n=erase([h],k,!0),m.erasedToUpdate+=n.erased,m.failed+=n.failed);h=[h];isDef(t)&&(h.push("-d"),h.push(t));n=install(h);isDef(n)&&(m.updated+=n.installed,m.failed+=n.failed,m.notNeeded+=n.notNeeded)}else log("No need to update "+
n.name),m.notNeeded++}});log(ansiColor("FAINT",repeat(4,"-")));return m}
function erase(a,b,d){if(isUnDef(a[0])||a[0].toUpperCase()!="OPENAF"){checkOpenAFinDB();var c=[],f=!1,g=!1,e;for(e in a)g?(arg=a[e],g=!1):a[e]=="-arg"?g=!0:a[e]=="-force"?f=!0:c.push(a[e]);var k={erased:0,failed:0};c=sortPackagesByDeps(c,!0);c.forEach(p=>{var l="Getting package '"+p+"'...";log(ansiColor("FAINT",repeat(l.length,"-")));log(l);l=getPackage(p);if(isUnDef(l)||isUnDef(l.name)){l=findLocalDBByName(p);if(isUnDef(l)||isUnDef(l.name)){logErr(`Package '${p}' not found.`);k.failed++;return}l.__filelocation=
"local"}if(isMap(l.dependencies)&&!f&&!d){p=getLocalDB(!0);for(var m in p)if(isMap(p[m].dependencies)&&typeof p[m].dependencies[l.name]!=="undefined"&&l.name!="OpenAF"){logErr("'"+p[m].name+"' depends on '"+l.name+"'");logErr("Please remove '"+p[m].name+"' first.");k.failed++;return}}if(typeof l.scripts.preerase!=="undefined"&&(m=runScript(l.scripts.preerase,{OPACK_PATH:l.__target}),!m)){logErr("Error while executing preerase script.");k.failed++;return}switch(l.__filelocation){case "url":logErr("Can't remove non local packages");
k.failed++;break;case "opackurl":logErr("Can't remove non local packages");k.failed++;break;case "opacklocal":logErr("Please provide a local installed package location or the package name");k.failed++;break;case "local":log("Erasing files...");if(io.fileExists(l.__target)&&io.fileInfo(l.__target).permissions.indexOf("w")<0)throw k.failed++,"No write permissions over '"+l.__target+"'";m=ow.format.string.updateLine(lognl);for(var h in l.files)p="Removing "+l.files[h].replace(/^\/*/,"")+"...",m.line(p),
deleteFile(l.__target+"/"+l.files[h].replace(/^\/*/,""));m.end();m=listFilesRecursive(l.__target);for(h in m)m[h].isDirectory&&(m[h].filename==".openaf_precompiled"?rmdir(m[h].filepath):rmdir(m[h].filepath,!0));b||rmdir(l.__target,!0);io.fileExists(l.__target)&&io.listFiles(l.__target).files.length>0?(logWarn("Package "+l.name+" could not be erased."),k.failed++):(log("Package "+l.name+" erased."),k.erased++);removeLocalDB(l,l.__target)}typeof l.scripts.posterase!=="undefined"&&(m=runScript(l.scripts.posterase,
{OPACK_PATH:l.__target}),m||(logErr("Error while executing posterase script."),k.failed++))});log(ansiColor("FAINT",repeat(4,"-")));return k}logErr("Can't delete OpenAF. Please delete manually or following the uninstall instructions.")}
function removeInteractiveFromDB(a){var b=String(getOpenAFPath());b.endsWith("/")||(b+="/");a=_$(a,"db").isString().default(b+PACKAGESJSON_DB);if(io.fileExists(a)){try{var d=new ZIP,c=af.fromBytes2String(d.streamGetFile(a,PACKAGESJSON));var f=af.fromJson(c)}catch(h){logErr("Failed to read oPack database at "+a+": "+h);return}var g=[],e=(h,n)=>{if(!(isUnDef(n)||isDef(n.name)&&n.name=="OpenAF")){var x=isDef(n.name)?n.name:h;isDef(n.version)&&(x+=" ("+n.version+")");var t=isDef(n.__target)?n.__target:
h;g.push({key:h,label:x+(" | "+t),pack:n})}};(d=isArray(f))?f.forEach((h,n)=>e(n,h)):Object.keys(f).sort().forEach(h=>e(h,f[h]));if(g.length==0)log("No removable entries found in "+a);else{c=g.map(h=>h.label);__initializeCon();var k=askChooseMultiple("Select oPacks to remove",c,Math.min(10,c.length),ansiColor("FAINT,ITALIC","(use arrows to move, space to toggle, enter to confirm)"));if(isArray(k)&&k.length!=0){c=g.filter(h=>k.indexOf(h.label)>=0);c.forEach(h=>log("Marked for removal: "+h.label));
b=new Date;var p=h=>String(h).padStart(2,"0");b=b.getFullYear()+p(b.getMonth()+1)+p(b.getDate())+p(b.getHours())+p(b.getMinutes())+p(b.getSeconds());b=a+"."+b+".bak";log("Creating backup at "+b+"...");io.cp(a,b);var l=[];if(d){var m={};c.forEach(h=>m[String(h.key)]=!0);f=f.filter((h,n)=>!m[String(n)]);c.forEach(h=>l.push(isDef(h.pack.name)?h.pack.name:String(h.key)))}else c.forEach(h=>{isDef(f[h.key])&&isDef(f[h.key].name)?l.push(f[h.key].name):l.push(String(h.key));delete f[h.key]});d=new ZIP;try{d.streamPutFile(a,
PACKAGESJSON,af.fromString2Bytes(stringify(f,__,2)))}catch(h){throw logErr("Failed to write updated packages.json: "+h),log("Database left untouched. Restore from backup at "+b),h;}log("Removed "+l.length+" entr"+(l.length==1?"y":"ies")+" from "+a);l.forEach(h=>log(" - "+h))}else log("No entries selected. Nothing will be removed.")}}else logErr("oPack database not found at "+a)}
function remove(a){checkOpenAFinDB();a=isArray(a)?a:[];for(var b=!1,d,c=[],f=!1,g=0;g<a.length;g++){var e=a[g];f?(d=e,f=!1):e=="-i"?b=!0:e=="-db"?f=!0:String(e).indexOf("db=")==0?d=e.substring(3):c.push(e)}b?removeInteractiveFromDB(d):(a=findLocalDBByName(c[0]),isDef(a)&&isUnDef(a.name)?logErr(`Package '${c[0]}' not found on the local OpenPack DB.`):(c[0]=findLocalDBTargetByName(c[0]),log("Removing from the local OpenPack DB: "+a.name+"("+a.version+") ["+findLocalDBTargetByName(a.name)+"]"),removeLocalDB(a,
c[0])))}function removeCentral(a){var b=_$(a[1],"centralFile").isString().default("opack.db");removeRemoteDB(a[0],b)}function addCentral(a){var b=getPackage(a[0]),d=_$(a[1],"centralFile").isString().default("opack.db");isUnDef(b.name)?logErr(`Package '${a[0]}' not found`):(log("Adding to central"),addRemoteDB(b,d))}
function add(a){checkOpenAFinDB();var b=getPackage(a[0]);isUnDef(b.name)?logErr(`Package '${a[0]}' not found.`):b.__filelocation!=="local"?logErr("Can't add non unpacked packs."):(delete b.__filelocation,log("Adding to the local OpenPack DB: "+b.name+"("+b.version+") ["+a[0]+"]"),addLocalDB(b,a[0]))}
function __opack_search(a){var b=[],d=!1,c=!1;for(var f in a)d&&(__opackCentral.indexOf(a[f])<0&&__opackCentral.unshift(a[f]),d=!1),a[f]=="-repo"&&(d=!0);if(typeof a[0]=="undefined"||a[0].trim()=="")c=!0;d=getRemoteDB();f=Object.keys(d).sort();for(let e in f){var g=f[e];if(c)b.push({name:d[g].name,version:d[g].version,description:d[g].description});else{(d[g].name.match(new RegExp(a[0],"i"))||d[g].description.match(new RegExp(a[0],"i")))&&b.push({name:d[g].name,version:d[g].version,description:d[g].description});
for(let k in d[g].keywords)k.match(new RegExp(a[0],"i"))&&b.push({name:d[g].name,version:d[g].version,description:d[g].description})}}$from(b).sort("name").select(e=>{ansiStart();print(ansiColor("bold","["+e.name+"]")+" (version "+ansiColor("green",String(e.version))+"):");print(e.description+"\n");ansiStop()})}
function pack(a){genpack(a);var b={};try{b=getPackage(a[0])}catch(p){}var d=new ZIP,c=b.name+"-"+b.version+".opack";io.rm(c);var f=0,g=0,e=ow.format.string.updateLine(lognl);for(let p in b.files){f++;file=b.files[p];var k="Packing ("+ow.format.round(f*100/b.files.length)+"%) "+ow.format.addNumberSeparator(f)+" files";e.line(k);k.length>g&&(g=k.length);k=io.readFileStream(a[0]+"/"+file);d.streamPutFileStream(c,file,k);k.close()}f>0&&(e.end(),log("All files packed."));log("Writing "+c)}
function genpack(a){var b={},d=[".svn",".git"];try{b=getPackage(a[0])}catch(f){}for(var c in a)a[c]=="--includeSCM"&&(d=[]);for(let f in a)a[f]=="--exclude"&&(log("Excluding '"+a[Number(f)+1]+"'..."),d.push(a[Number(f)+1]));c={};c.author=typeof b.author!=="undefined"?b.author:"The author(s) name(s)";c.scripts=typeof b.scripts!=="undefined"?b.scripts:{preerase:"",posterase:"",preinstall:"",postinstall:""};typeof b.scripts!=="undefined"&&(c.scripts.preerase=typeof b.scripts.preerase!=="undefined"?b.scripts.preerase:
"",c.scripts.posterase=typeof b.scripts.posterase!=="undefined"?b.scripts.posterase:"",c.scripts.preinstall=typeof b.scripts.preinstall!=="undefined"?b.scripts.preinstall:"",c.scripts.postinstall=typeof b.scripts.postinstall!=="undefined"?b.scripts.postinstall:"");c.keywords=typeof b.keywords!=="undefined"?b.keywords:["Keyword1","keyword2"];c.bugs=typeof b.bugs!=="undefined"?b.bugs:{url:"URL to track bugs"};c.repository=typeof b.repository!=="undefined"?b.repository:{type:"http",url:"URL to main repository"};
c.description=typeof b.description!=="undefined"?b.description:"A nice description";c.name=typeof b.name!=="undefined"?b.name:"A_nice_name";c.main=isString(b.main)?b.main:"";c.mainJob=typeof b.mainJob!=="undefined"?b.mainJob:"";c.license=typeof b.license!=="undefined"?b.license:"The licence description";c.version=typeof b.version!=="undefined"?b.version:"20010101";c.dependencies=isMap(b.dependencies)?b.dependencies:{packa:">=20100101",packb:"<20120101"};if(isDef(b.odoc)&&isObject(b.odoc)){for(let f in b.odoc)log("Generating help for key "+
f+" from "+b.odoc[f]+"..."),saveHelp(a[0],b.odoc[f]);c.odoc=b.odoc}c.files=listFiles(a[0],void 0,d);c.files.indexOf(PACKAGEJSON)<0&&c.files.indexOf(PACKAGEYAML)<0&&(a.indexOf("-injson")<0?c.files.push(PACKAGEYAML):c.files.push(PACKAGEJSON));c.filesHash=Object(listFilesWithHash(a[0],d));(a.indexOf("-injson")>=0||c.files.indexOf(PACKAGEJSON)>=0)&&a.indexOf("-inyaml")<0?(log("Writing "+a[0]+"/"+PACKAGEJSON),io.writeFileString(a[0]+"/"+PACKAGEJSON,stringify(c))):(log("Writing "+a[0]+"/"+PACKAGEYAML),
io.writeFileString(a[0]+"/"+PACKAGEYAML,af.toYAML(c)))}var showhelp=isUnDef(__opackParams)?1:0,verbfound=0,params=isUnDef(__opackParams)?processExpr(" "):processExpr(" ",__,__opackParams),__adaptParams=a=>{var b=[];traverse(a,(d,c,f,g)=>{isUnDef(c)||c==""?b.push(d):b.push(d+"="+stringify(c,__,""))});return b};
for(let a in verbs)if(!verbfound&&Object.keys(params)[0]==a){delete params[a];verb=a;var fnDone=()=>log("Done.");switch(verb){case "info":__opack_info(__adaptParams(params));break;case "install":log(af.toCSLON(install(__adaptParams(params)),!0));fnDone();break;case "erase":log(af.toCSLON(erase(__adaptParams(params)),!0));fnDone();break;case "list":__opack_list(__adaptParams(params));break;case "genpack":genpack(__adaptParams(params));fnDone();break;case "pack":pack(__adaptParams(params));fnDone();
break;case "add2db":add(__adaptParams(params));fnDone();break;case "remove4db":remove(__adaptParams(params));fnDone();break;case "add2remotedb":addCentral(__adaptParams(params));fnDone();break;case "remove4remotedb":removeCentral(__adaptParams(params));fnDone();break;case "script":__opack_script(__adaptParams(params));break;case "daemon":__opack_script(__adaptParams(params),!0);break;case "ojob":__opack_script(__adaptParams(params),!1,!0);break;case "search":__opack_search(__adaptParams(params));
break;case "update":log(af.toCSLON(update(__adaptParams(params)),!0));fnDone();break;case "exec":__opack_exec(__adaptParams(params));break;case "help":showhelp=1,showHelp()}showhelp=0}showhelp&&showHelp();isDef(__opackParams)&&(__opackParams=void 0);
