// @generated by Peggy 4.2.0.
//
// https://peggyjs.org/

"use strict";


function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
      ? this.location.source.offset(s)
      : s;
    var loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = (last - s.column) || 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + offset_s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1, ' ')
          + peg$padEnd("", hatLen, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { nLinq_text: peg$parsenLinq_text };
  var peg$startRuleFunction = peg$parsenLinq_text;

  var peg$c0 = "(";
  var peg$c1 = ")";
  var peg$c2 = ",";
  var peg$c3 = ".";
  var peg$c4 = "andNotGreaterEquals";
  var peg$c5 = "andNotBetweenEquals";
  var peg$c6 = "orNotBetweenEquals";
  var peg$c7 = "orNotGreaterEquals";
  var peg$c8 = "notGreaterEquals";
  var peg$c9 = "andNotLessEquals";
  var peg$c10 = "andBetweenEquals";
  var peg$c11 = "andGreaterEquals";
  var peg$c12 = "notBetweenEquals";
  var peg$c13 = "orBetweenEquals";
  var peg$c14 = "orNotLessEquals";
  var peg$c15 = "orGreaterEquals";
  var peg$c16 = "andNotContains";
  var peg$c17 = "greaterEquals";
  var peg$c18 = "notLessEquals";
  var peg$c19 = "andNotGreater";
  var peg$c20 = "orNotContains";
  var peg$c21 = "betweenEquals";
  var peg$c22 = "andNotBetween";
  var peg$c23 = "andLessEquals";
  var peg$c24 = "orLessEquals";
  var peg$c25 = "andNotStarts";
  var peg$c26 = "orNotBetween";
  var peg$c27 = "orNotGreater";
  var peg$c28 = "andNotEquals";
  var peg$c29 = "orNotEquals";
  var peg$c30 = "notContains";
  var peg$c31 = "andContains";
  var peg$c32 = "andNotMatch";
  var peg$c33 = "andNotEmpty";
  var peg$c34 = "orNotStarts";
  var peg$c35 = "orNotMatch";
  var peg$c36 = "notBetween";
  var peg$c37 = "orNotEmpty";
  var peg$c38 = "andNotLess";
  var peg$c39 = "andBetween";
  var peg$c40 = "notGreater";
  var peg$c41 = "andNotEnds";
  var peg$c42 = "andNotType";
  var peg$c43 = "orContains";
  var peg$c44 = "andGreater";
  var peg$c45 = "lessEquals";
  var peg$c46 = "andEquals";
  var peg$c47 = "notEquals";
  var peg$c48 = "andBegin";
  var peg$c49 = "orNotLess";
  var peg$c50 = "orGreater";
  var peg$c51 = "notStarts";
  var peg$c52 = "orNotEnds";
  var peg$c53 = "orNotType";
  var peg$c54 = "andStarts";
  var peg$c55 = "orBetween";
  var peg$c56 = "orStarts";
  var peg$c57 = "notMatch";
  var peg$c58 = "notEmpty";
  var peg$c59 = "andNotIs";
  var peg$c60 = "contains";
  var peg$c61 = "orEquals";
  var peg$c62 = "andMatch";
  var peg$c63 = "andEmpty";
  var peg$c64 = "orNotIs";
  var peg$c65 = "orMatch";
  var peg$c66 = "orBegin";
  var peg$c67 = "notType";
  var peg$c68 = "greater";
  var peg$c69 = "notLess";
  var peg$c70 = "notEnds";
  var peg$c71 = "between";
  var peg$c72 = "andEnds";
  var peg$c73 = "andType";
  var peg$c74 = "andLess";
  var peg$c75 = "orEmpty";
  var peg$c76 = "equals";
  var peg$c77 = "orType";
  var peg$c78 = "andNot";
  var peg$c79 = "orLess";
  var peg$c80 = "starts";
  var peg$c81 = "orEnds";
  var peg$c82 = "andIs";
  var peg$c83 = "notIs";
  var peg$c84 = "orNot";
  var peg$c85 = "match";
  var peg$c86 = "empty";
  var peg$c87 = "begin";
  var peg$c88 = "orIs";
  var peg$c89 = "ends";
  var peg$c90 = "less";
  var peg$c91 = "type";
  var peg$c92 = "not";
  var peg$c93 = "end";
  var peg$c94 = "and";
  var peg$c95 = "is";
  var peg$c96 = "or";
  var peg$c97 = "mselect";
  var peg$c98 = "removed";
  var peg$c99 = "select";
  var peg$c100 = "define";
  var peg$c101 = "ignoreCase";
  var peg$c102 = "skipTake";
  var peg$c103 = "useCase";
  var peg$c104 = "toDate";
  var peg$c105 = "limit";
  var peg$c106 = "tail";
  var peg$c107 = "head";
  var peg$c108 = "take";
  var peg$c109 = "skip";
  var peg$c110 = "attachBy";
  var peg$c111 = "attachNotBy";
  var peg$c112 = "attachByEmpty";
  var peg$c113 = "sort";
  var peg$c114 = "detach";
  var peg$c115 = "averageBy";
  var peg$c116 = "distinct";
  var peg$c117 = "average";
  var peg$c118 = "groupBy";
  var peg$c119 = "countBy";
  var peg$c120 = "reverse";
  var peg$c121 = "group";
  var peg$c122 = "first";
  var peg$c123 = "maxBy";
  var peg$c124 = "sumBy";
  var peg$c125 = "minBy";
  var peg$c126 = "count";
  var peg$c127 = "last";
  var peg$c128 = "none";
  var peg$c129 = "all";
  var peg$c130 = "any";
  var peg$c131 = "min";
  var peg$c132 = "max";
  var peg$c133 = "sum";
  var peg$c134 = "at";
  var peg$c135 = "false";
  var peg$c136 = "null";
  var peg$c137 = "true";
  var peg$c138 = "-";
  var peg$c139 = "+";
  var peg$c140 = "0";
  var peg$c141 = "b";
  var peg$c142 = "f";
  var peg$c143 = "n";
  var peg$c144 = "r";
  var peg$c145 = "t";
  var peg$c146 = "u";
  var peg$c147 = "\\";
  var peg$c148 = "\"";
  var peg$c149 = "'";

  var peg$r0 = /^[ \t\n\r]/;
  var peg$r1 = /^[1-9]/;
  var peg$r2 = /^[eE]/;
  var peg$r3 = /^[+\-]/;
  var peg$r4 = /^[^(),]/;
  var peg$r5 = /^["'\/\\]/;
  var peg$r6 = /^[^\0-\x1F"'\\]/;
  var peg$r7 = /^[0-9]/;
  var peg$r8 = /^[0-9a-f]/i;

  var peg$e0 = peg$literalExpectation("(", false);
  var peg$e1 = peg$literalExpectation(")", false);
  var peg$e2 = peg$literalExpectation(",", false);
  var peg$e3 = peg$otherExpectation("whitespace");
  var peg$e4 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false);
  var peg$e5 = peg$literalExpectation(".", false);
  var peg$e6 = peg$literalExpectation("andNotGreaterEquals", false);
  var peg$e7 = peg$literalExpectation("andNotBetweenEquals", false);
  var peg$e8 = peg$literalExpectation("orNotBetweenEquals", false);
  var peg$e9 = peg$literalExpectation("orNotGreaterEquals", false);
  var peg$e10 = peg$literalExpectation("notGreaterEquals", false);
  var peg$e11 = peg$literalExpectation("andNotLessEquals", false);
  var peg$e12 = peg$literalExpectation("andBetweenEquals", false);
  var peg$e13 = peg$literalExpectation("andGreaterEquals", false);
  var peg$e14 = peg$literalExpectation("notBetweenEquals", false);
  var peg$e15 = peg$literalExpectation("orBetweenEquals", false);
  var peg$e16 = peg$literalExpectation("orNotLessEquals", false);
  var peg$e17 = peg$literalExpectation("orGreaterEquals", false);
  var peg$e18 = peg$literalExpectation("andNotContains", false);
  var peg$e19 = peg$literalExpectation("greaterEquals", false);
  var peg$e20 = peg$literalExpectation("notLessEquals", false);
  var peg$e21 = peg$literalExpectation("andNotGreater", false);
  var peg$e22 = peg$literalExpectation("orNotContains", false);
  var peg$e23 = peg$literalExpectation("betweenEquals", false);
  var peg$e24 = peg$literalExpectation("andNotBetween", false);
  var peg$e25 = peg$literalExpectation("andLessEquals", false);
  var peg$e26 = peg$literalExpectation("orLessEquals", false);
  var peg$e27 = peg$literalExpectation("andNotStarts", false);
  var peg$e28 = peg$literalExpectation("orNotBetween", false);
  var peg$e29 = peg$literalExpectation("orNotGreater", false);
  var peg$e30 = peg$literalExpectation("andNotEquals", false);
  var peg$e31 = peg$literalExpectation("orNotEquals", false);
  var peg$e32 = peg$literalExpectation("notContains", false);
  var peg$e33 = peg$literalExpectation("andContains", false);
  var peg$e34 = peg$literalExpectation("andNotMatch", false);
  var peg$e35 = peg$literalExpectation("andNotEmpty", false);
  var peg$e36 = peg$literalExpectation("orNotStarts", false);
  var peg$e37 = peg$literalExpectation("orNotMatch", false);
  var peg$e38 = peg$literalExpectation("notBetween", false);
  var peg$e39 = peg$literalExpectation("orNotEmpty", false);
  var peg$e40 = peg$literalExpectation("andNotLess", false);
  var peg$e41 = peg$literalExpectation("andBetween", false);
  var peg$e42 = peg$literalExpectation("notGreater", false);
  var peg$e43 = peg$literalExpectation("andNotEnds", false);
  var peg$e44 = peg$literalExpectation("andNotType", false);
  var peg$e45 = peg$literalExpectation("orContains", false);
  var peg$e46 = peg$literalExpectation("andGreater", false);
  var peg$e47 = peg$literalExpectation("lessEquals", false);
  var peg$e48 = peg$literalExpectation("andEquals", false);
  var peg$e49 = peg$literalExpectation("notEquals", false);
  var peg$e50 = peg$literalExpectation("andBegin", false);
  var peg$e51 = peg$literalExpectation("orNotLess", false);
  var peg$e52 = peg$literalExpectation("orGreater", false);
  var peg$e53 = peg$literalExpectation("notStarts", false);
  var peg$e54 = peg$literalExpectation("orNotEnds", false);
  var peg$e55 = peg$literalExpectation("orNotType", false);
  var peg$e56 = peg$literalExpectation("andStarts", false);
  var peg$e57 = peg$literalExpectation("orBetween", false);
  var peg$e58 = peg$literalExpectation("orStarts", false);
  var peg$e59 = peg$literalExpectation("notMatch", false);
  var peg$e60 = peg$literalExpectation("notEmpty", false);
  var peg$e61 = peg$literalExpectation("andNotIs", false);
  var peg$e62 = peg$literalExpectation("contains", false);
  var peg$e63 = peg$literalExpectation("orEquals", false);
  var peg$e64 = peg$literalExpectation("andMatch", false);
  var peg$e65 = peg$literalExpectation("andEmpty", false);
  var peg$e66 = peg$literalExpectation("orNotIs", false);
  var peg$e67 = peg$literalExpectation("orMatch", false);
  var peg$e68 = peg$literalExpectation("orBegin", false);
  var peg$e69 = peg$literalExpectation("notType", false);
  var peg$e70 = peg$literalExpectation("greater", false);
  var peg$e71 = peg$literalExpectation("notLess", false);
  var peg$e72 = peg$literalExpectation("notEnds", false);
  var peg$e73 = peg$literalExpectation("between", false);
  var peg$e74 = peg$literalExpectation("andEnds", false);
  var peg$e75 = peg$literalExpectation("andType", false);
  var peg$e76 = peg$literalExpectation("andLess", false);
  var peg$e77 = peg$literalExpectation("orEmpty", false);
  var peg$e78 = peg$literalExpectation("equals", false);
  var peg$e79 = peg$literalExpectation("orType", false);
  var peg$e80 = peg$literalExpectation("andNot", false);
  var peg$e81 = peg$literalExpectation("orLess", false);
  var peg$e82 = peg$literalExpectation("starts", false);
  var peg$e83 = peg$literalExpectation("orEnds", false);
  var peg$e84 = peg$literalExpectation("andIs", false);
  var peg$e85 = peg$literalExpectation("notIs", false);
  var peg$e86 = peg$literalExpectation("orNot", false);
  var peg$e87 = peg$literalExpectation("match", false);
  var peg$e88 = peg$literalExpectation("empty", false);
  var peg$e89 = peg$literalExpectation("begin", false);
  var peg$e90 = peg$literalExpectation("orIs", false);
  var peg$e91 = peg$literalExpectation("ends", false);
  var peg$e92 = peg$literalExpectation("less", false);
  var peg$e93 = peg$literalExpectation("type", false);
  var peg$e94 = peg$literalExpectation("not", false);
  var peg$e95 = peg$literalExpectation("end", false);
  var peg$e96 = peg$literalExpectation("and", false);
  var peg$e97 = peg$literalExpectation("is", false);
  var peg$e98 = peg$literalExpectation("or", false);
  var peg$e99 = peg$literalExpectation("mselect", false);
  var peg$e100 = peg$literalExpectation("removed", false);
  var peg$e101 = peg$literalExpectation("select", false);
  var peg$e102 = peg$literalExpectation("define", false);
  var peg$e103 = peg$literalExpectation("ignoreCase", false);
  var peg$e104 = peg$literalExpectation("skipTake", false);
  var peg$e105 = peg$literalExpectation("useCase", false);
  var peg$e106 = peg$literalExpectation("toDate", false);
  var peg$e107 = peg$literalExpectation("limit", false);
  var peg$e108 = peg$literalExpectation("tail", false);
  var peg$e109 = peg$literalExpectation("head", false);
  var peg$e110 = peg$literalExpectation("take", false);
  var peg$e111 = peg$literalExpectation("skip", false);
  var peg$e112 = peg$literalExpectation("attachBy", false);
  var peg$e113 = peg$literalExpectation("attachNotBy", false);
  var peg$e114 = peg$literalExpectation("attachByEmpty", false);
  var peg$e115 = peg$literalExpectation("sort", false);
  var peg$e116 = peg$literalExpectation("detach", false);
  var peg$e117 = peg$literalExpectation("averageBy", false);
  var peg$e118 = peg$literalExpectation("distinct", false);
  var peg$e119 = peg$literalExpectation("average", false);
  var peg$e120 = peg$literalExpectation("groupBy", false);
  var peg$e121 = peg$literalExpectation("countBy", false);
  var peg$e122 = peg$literalExpectation("reverse", false);
  var peg$e123 = peg$literalExpectation("group", false);
  var peg$e124 = peg$literalExpectation("first", false);
  var peg$e125 = peg$literalExpectation("maxBy", false);
  var peg$e126 = peg$literalExpectation("sumBy", false);
  var peg$e127 = peg$literalExpectation("minBy", false);
  var peg$e128 = peg$literalExpectation("count", false);
  var peg$e129 = peg$literalExpectation("last", false);
  var peg$e130 = peg$literalExpectation("none", false);
  var peg$e131 = peg$literalExpectation("all", false);
  var peg$e132 = peg$literalExpectation("any", false);
  var peg$e133 = peg$literalExpectation("min", false);
  var peg$e134 = peg$literalExpectation("max", false);
  var peg$e135 = peg$literalExpectation("sum", false);
  var peg$e136 = peg$literalExpectation("at", false);
  var peg$e137 = peg$literalExpectation("false", false);
  var peg$e138 = peg$literalExpectation("null", false);
  var peg$e139 = peg$literalExpectation("true", false);
  var peg$e140 = peg$otherExpectation("number");
  var peg$e141 = peg$classExpectation([["1", "9"]], false, false);
  var peg$e142 = peg$classExpectation(["e", "E"], false, false);
  var peg$e143 = peg$classExpectation(["+", "-"], false, false);
  var peg$e144 = peg$literalExpectation("-", false);
  var peg$e145 = peg$literalExpectation("+", false);
  var peg$e146 = peg$literalExpectation("0", false);
  var peg$e147 = peg$otherExpectation("string");
  var peg$e148 = peg$classExpectation(["(", ")", ","], true, false);
  var peg$e149 = peg$classExpectation(["\"", "'", "/", "\\"], false, false);
  var peg$e150 = peg$literalExpectation("b", false);
  var peg$e151 = peg$literalExpectation("f", false);
  var peg$e152 = peg$literalExpectation("n", false);
  var peg$e153 = peg$literalExpectation("r", false);
  var peg$e154 = peg$literalExpectation("t", false);
  var peg$e155 = peg$literalExpectation("u", false);
  var peg$e156 = peg$literalExpectation("\\", false);
  var peg$e157 = peg$literalExpectation("\"", false);
  var peg$e158 = peg$literalExpectation("'", false);
  var peg$e159 = peg$classExpectation([["\0", "\x1F"], "\"", "'", "\\"], true, false);
  var peg$e160 = peg$classExpectation([["0", "9"]], false, false);
  var peg$e161 = peg$classExpectation([["0", "9"], ["a", "f"]], false, true);

  var peg$f0 = function(head, tail) { if (isNull(tail)) tail = {}
      if (isUnDef(tail.transform)) tail.transform = []
      tail.transform.unshift(head)
      return tail };
  var peg$f1 = function(head, tail) { if (isNull(tail)) tail = {}
      if (isUnDef(tail.where)) tail.where = []
      tail.where.unshift(head)
      return tail };
  var peg$f2 = function(head, tail) { if (isNull(tail)) tail = {}
      if (isUnDef(tail.selector)) tail.selector = {}
      tail.selector = head
      return tail };
  var peg$f3 = function(head, tail) { if (isNull(tail)) tail = {}
      if (isUnDef(tail.select)) tail.select = {}
      tail.select = head
      return tail };
  var peg$f4 = function(head) { return head };
  var peg$f5 = function(head) { return head };
  var peg$f6 = function(head) { return head };
  var peg$f7 = function(head) { return head };
  var peg$f8 = function(fn, args) {
    return { cond: fn, args: args }
  };
  var peg$f9 = function(fn) {
    return { cond: fn, args: [] }
  };
  var peg$f10 = function(fn, args) {
    return { func: fn, args: args }
  };
  var peg$f11 = function(fn, args) {
    return { func: fn, args: args }
  };
  var peg$f12 = function(fn, args) {
    return jsonParse(args, true)
  };
  var peg$f13 = function(head, tail) { return [head].concat(tail) };
  var peg$f14 = function() { return false };
  var peg$f15 = function() { return null  };
  var peg$f16 = function() { return true  };
  var peg$f17 = function() { return parseFloat(text()) };
  var peg$f18 = function(chars) { return chars.join("") };
  var peg$f19 = function(chars) { return chars.join("") };
  var peg$f20 = function(chars) { return chars.join("") };
  var peg$f21 = function() { return "\b" };
  var peg$f22 = function() { return "\f" };
  var peg$f23 = function() { return "\n" };
  var peg$f24 = function() { return "\r" };
  var peg$f25 = function() { return "\t" };
  var peg$f26 = function(digits) {
          return String.fromCharCode(parseInt(digits, 16))
        };
  var peg$f27 = function(sequence) { return sequence };
  var peg$currPos = options.peg$currPos | 0;
  var peg$savedPos = peg$currPos;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = peg$currPos;
  var peg$maxFailExpected = options.peg$maxFailExpected || [];
  var peg$silentFails = options.peg$silentFails | 0;

  var peg$result;

  if (options.startRule) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      if (pos >= peg$posDetailsCache.length) {
        p = peg$posDetailsCache.length - 1;
      } else {
        p = pos;
        while (!peg$posDetailsCache[--p]) {}
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parsenLinq_text() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsews();
    s2 = peg$parseexpression();
    if (s2 !== peg$FAILED) {
      s3 = peg$parsews();
      s0 = s2;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebegin_function() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsews();
    if (input.charCodeAt(peg$currPos) === 40) {
      s2 = peg$c0;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parsews();
      s1 = [s1, s2, s3];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseend_function() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsews();
    if (input.charCodeAt(peg$currPos) === 41) {
      s2 = peg$c1;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parsews();
      s1 = [s1, s2, s3];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsearg_separator() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsews();
    if (input.charCodeAt(peg$currPos) === 44) {
      s2 = peg$c2;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e2); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parsews();
      s1 = [s1, s2, s3];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsews() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    s1 = input.charAt(peg$currPos);
    if (peg$r0.test(s1)) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = input.charAt(peg$currPos);
      if (peg$r0.test(s1)) {
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e4); }
      }
    }
    peg$silentFails--;
    s1 = peg$FAILED;
    if (peg$silentFails === 0) { peg$fail(peg$e3); }

    return s0;
  }

  function peg$parseexpression() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsetransform();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 46) {
        s3 = peg$c3;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e5); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parseexpression();
        if (s4 !== peg$FAILED) {
          s2 = s4;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f0(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsewhere();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s3 = peg$c3;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e5); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseexpression();
          if (s4 !== peg$FAILED) {
            s2 = s4;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f1(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseselector();
        if (s1 !== peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c3;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e5); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseexpression();
            if (s4 !== peg$FAILED) {
              s2 = s4;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f2(s1, s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseselect();
          if (s1 !== peg$FAILED) {
            s2 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 46) {
              s3 = peg$c3;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e5); }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parseexpression();
              if (s4 !== peg$FAILED) {
                s2 = s4;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f3(s1, s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetransform() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsetransformFn();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f4(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsewhere() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsewhereFn();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f5(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseselector() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseselectorFn();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f6(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseselect() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseselectFn();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f7(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsevalue() {
    var s0;

    s0 = peg$parsefalse();
    if (s0 === peg$FAILED) {
      s0 = peg$parsenull();
      if (s0 === peg$FAILED) {
        s0 = peg$parsetrue();
        if (s0 === peg$FAILED) {
          s0 = peg$parsenumber();
          if (s0 === peg$FAILED) {
            s0 = peg$parsestring();
          }
        }
      }
    }

    return s0;
  }

  function peg$parsewhereFn() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsecharwhen();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebegin_function();
      if (s2 !== peg$FAILED) {
        s3 = peg$parselist_arguments();
        s4 = peg$parseend_function();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f8(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecharwhen();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f9(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsetransformFn() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsechartransform();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebegin_function();
      if (s2 !== peg$FAILED) {
        s3 = peg$parselist_arguments();
        s4 = peg$parseend_function();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f10(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseselectorFn() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsecharselector();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebegin_function();
      if (s2 !== peg$FAILED) {
        s3 = peg$parselist_arguments();
        s4 = peg$parseend_function();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f11(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseselectFn() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsecharpart();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsecharpart();
    }
    s2 = peg$parsebegin_function();
    if (s2 !== peg$FAILED) {
      s3 = peg$parselist_arguments();
      s4 = peg$parseend_function();
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f12(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecharwhen() {
    var s0;

    if (input.substr(peg$currPos, 19) === peg$c4) {
      s0 = peg$c4;
      peg$currPos += 19;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 19) === peg$c5) {
        s0 = peg$c5;
        peg$currPos += 19;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e7); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 18) === peg$c6) {
          s0 = peg$c6;
          peg$currPos += 18;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e8); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 18) === peg$c7) {
            s0 = peg$c7;
            peg$currPos += 18;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e9); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 16) === peg$c8) {
              s0 = peg$c8;
              peg$currPos += 16;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e10); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 16) === peg$c9) {
                s0 = peg$c9;
                peg$currPos += 16;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e11); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 16) === peg$c10) {
                  s0 = peg$c10;
                  peg$currPos += 16;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e12); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 16) === peg$c11) {
                    s0 = peg$c11;
                    peg$currPos += 16;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e13); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 16) === peg$c12) {
                      s0 = peg$c12;
                      peg$currPos += 16;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e14); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 15) === peg$c13) {
                        s0 = peg$c13;
                        peg$currPos += 15;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e15); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 15) === peg$c14) {
                          s0 = peg$c14;
                          peg$currPos += 15;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e16); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 15) === peg$c15) {
                            s0 = peg$c15;
                            peg$currPos += 15;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e17); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 14) === peg$c16) {
                              s0 = peg$c16;
                              peg$currPos += 14;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e18); }
                            }
                            if (s0 === peg$FAILED) {
                              if (input.substr(peg$currPos, 13) === peg$c17) {
                                s0 = peg$c17;
                                peg$currPos += 13;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e19); }
                              }
                              if (s0 === peg$FAILED) {
                                if (input.substr(peg$currPos, 13) === peg$c18) {
                                  s0 = peg$c18;
                                  peg$currPos += 13;
                                } else {
                                  s0 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$e20); }
                                }
                                if (s0 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 13) === peg$c19) {
                                    s0 = peg$c19;
                                    peg$currPos += 13;
                                  } else {
                                    s0 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$e21); }
                                  }
                                  if (s0 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 13) === peg$c20) {
                                      s0 = peg$c20;
                                      peg$currPos += 13;
                                    } else {
                                      s0 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$e22); }
                                    }
                                    if (s0 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 13) === peg$c21) {
                                        s0 = peg$c21;
                                        peg$currPos += 13;
                                      } else {
                                        s0 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$e23); }
                                      }
                                      if (s0 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 13) === peg$c22) {
                                          s0 = peg$c22;
                                          peg$currPos += 13;
                                        } else {
                                          s0 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$e24); }
                                        }
                                        if (s0 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 13) === peg$c23) {
                                            s0 = peg$c23;
                                            peg$currPos += 13;
                                          } else {
                                            s0 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$e25); }
                                          }
                                          if (s0 === peg$FAILED) {
                                            if (input.substr(peg$currPos, 12) === peg$c24) {
                                              s0 = peg$c24;
                                              peg$currPos += 12;
                                            } else {
                                              s0 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$e26); }
                                            }
                                            if (s0 === peg$FAILED) {
                                              if (input.substr(peg$currPos, 12) === peg$c25) {
                                                s0 = peg$c25;
                                                peg$currPos += 12;
                                              } else {
                                                s0 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$e27); }
                                              }
                                              if (s0 === peg$FAILED) {
                                                if (input.substr(peg$currPos, 12) === peg$c26) {
                                                  s0 = peg$c26;
                                                  peg$currPos += 12;
                                                } else {
                                                  s0 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$e28); }
                                                }
                                                if (s0 === peg$FAILED) {
                                                  if (input.substr(peg$currPos, 12) === peg$c27) {
                                                    s0 = peg$c27;
                                                    peg$currPos += 12;
                                                  } else {
                                                    s0 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$e29); }
                                                  }
                                                  if (s0 === peg$FAILED) {
                                                    if (input.substr(peg$currPos, 12) === peg$c28) {
                                                      s0 = peg$c28;
                                                      peg$currPos += 12;
                                                    } else {
                                                      s0 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$e30); }
                                                    }
                                                    if (s0 === peg$FAILED) {
                                                      if (input.substr(peg$currPos, 11) === peg$c29) {
                                                        s0 = peg$c29;
                                                        peg$currPos += 11;
                                                      } else {
                                                        s0 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$e31); }
                                                      }
                                                      if (s0 === peg$FAILED) {
                                                        if (input.substr(peg$currPos, 11) === peg$c30) {
                                                          s0 = peg$c30;
                                                          peg$currPos += 11;
                                                        } else {
                                                          s0 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$e32); }
                                                        }
                                                        if (s0 === peg$FAILED) {
                                                          if (input.substr(peg$currPos, 11) === peg$c31) {
                                                            s0 = peg$c31;
                                                            peg$currPos += 11;
                                                          } else {
                                                            s0 = peg$FAILED;
                                                            if (peg$silentFails === 0) { peg$fail(peg$e33); }
                                                          }
                                                          if (s0 === peg$FAILED) {
                                                            if (input.substr(peg$currPos, 11) === peg$c32) {
                                                              s0 = peg$c32;
                                                              peg$currPos += 11;
                                                            } else {
                                                              s0 = peg$FAILED;
                                                              if (peg$silentFails === 0) { peg$fail(peg$e34); }
                                                            }
                                                            if (s0 === peg$FAILED) {
                                                              if (input.substr(peg$currPos, 11) === peg$c33) {
                                                                s0 = peg$c33;
                                                                peg$currPos += 11;
                                                              } else {
                                                                s0 = peg$FAILED;
                                                                if (peg$silentFails === 0) { peg$fail(peg$e35); }
                                                              }
                                                              if (s0 === peg$FAILED) {
                                                                if (input.substr(peg$currPos, 11) === peg$c34) {
                                                                  s0 = peg$c34;
                                                                  peg$currPos += 11;
                                                                } else {
                                                                  s0 = peg$FAILED;
                                                                  if (peg$silentFails === 0) { peg$fail(peg$e36); }
                                                                }
                                                                if (s0 === peg$FAILED) {
                                                                  if (input.substr(peg$currPos, 10) === peg$c35) {
                                                                    s0 = peg$c35;
                                                                    peg$currPos += 10;
                                                                  } else {
                                                                    s0 = peg$FAILED;
                                                                    if (peg$silentFails === 0) { peg$fail(peg$e37); }
                                                                  }
                                                                  if (s0 === peg$FAILED) {
                                                                    if (input.substr(peg$currPos, 10) === peg$c36) {
                                                                      s0 = peg$c36;
                                                                      peg$currPos += 10;
                                                                    } else {
                                                                      s0 = peg$FAILED;
                                                                      if (peg$silentFails === 0) { peg$fail(peg$e38); }
                                                                    }
                                                                    if (s0 === peg$FAILED) {
                                                                      if (input.substr(peg$currPos, 10) === peg$c37) {
                                                                        s0 = peg$c37;
                                                                        peg$currPos += 10;
                                                                      } else {
                                                                        s0 = peg$FAILED;
                                                                        if (peg$silentFails === 0) { peg$fail(peg$e39); }
                                                                      }
                                                                      if (s0 === peg$FAILED) {
                                                                        if (input.substr(peg$currPos, 10) === peg$c38) {
                                                                          s0 = peg$c38;
                                                                          peg$currPos += 10;
                                                                        } else {
                                                                          s0 = peg$FAILED;
                                                                          if (peg$silentFails === 0) { peg$fail(peg$e40); }
                                                                        }
                                                                        if (s0 === peg$FAILED) {
                                                                          if (input.substr(peg$currPos, 10) === peg$c39) {
                                                                            s0 = peg$c39;
                                                                            peg$currPos += 10;
                                                                          } else {
                                                                            s0 = peg$FAILED;
                                                                            if (peg$silentFails === 0) { peg$fail(peg$e41); }
                                                                          }
                                                                          if (s0 === peg$FAILED) {
                                                                            if (input.substr(peg$currPos, 10) === peg$c40) {
                                                                              s0 = peg$c40;
                                                                              peg$currPos += 10;
                                                                            } else {
                                                                              s0 = peg$FAILED;
                                                                              if (peg$silentFails === 0) { peg$fail(peg$e42); }
                                                                            }
                                                                            if (s0 === peg$FAILED) {
                                                                              if (input.substr(peg$currPos, 10) === peg$c41) {
                                                                                s0 = peg$c41;
                                                                                peg$currPos += 10;
                                                                              } else {
                                                                                s0 = peg$FAILED;
                                                                                if (peg$silentFails === 0) { peg$fail(peg$e43); }
                                                                              }
                                                                              if (s0 === peg$FAILED) {
                                                                                if (input.substr(peg$currPos, 10) === peg$c42) {
                                                                                  s0 = peg$c42;
                                                                                  peg$currPos += 10;
                                                                                } else {
                                                                                  s0 = peg$FAILED;
                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e44); }
                                                                                }
                                                                                if (s0 === peg$FAILED) {
                                                                                  if (input.substr(peg$currPos, 10) === peg$c43) {
                                                                                    s0 = peg$c43;
                                                                                    peg$currPos += 10;
                                                                                  } else {
                                                                                    s0 = peg$FAILED;
                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e45); }
                                                                                  }
                                                                                  if (s0 === peg$FAILED) {
                                                                                    if (input.substr(peg$currPos, 10) === peg$c44) {
                                                                                      s0 = peg$c44;
                                                                                      peg$currPos += 10;
                                                                                    } else {
                                                                                      s0 = peg$FAILED;
                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e46); }
                                                                                    }
                                                                                    if (s0 === peg$FAILED) {
                                                                                      if (input.substr(peg$currPos, 10) === peg$c45) {
                                                                                        s0 = peg$c45;
                                                                                        peg$currPos += 10;
                                                                                      } else {
                                                                                        s0 = peg$FAILED;
                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e47); }
                                                                                      }
                                                                                      if (s0 === peg$FAILED) {
                                                                                        if (input.substr(peg$currPos, 9) === peg$c46) {
                                                                                          s0 = peg$c46;
                                                                                          peg$currPos += 9;
                                                                                        } else {
                                                                                          s0 = peg$FAILED;
                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e48); }
                                                                                        }
                                                                                        if (s0 === peg$FAILED) {
                                                                                          if (input.substr(peg$currPos, 9) === peg$c47) {
                                                                                            s0 = peg$c47;
                                                                                            peg$currPos += 9;
                                                                                          } else {
                                                                                            s0 = peg$FAILED;
                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e49); }
                                                                                          }
                                                                                          if (s0 === peg$FAILED) {
                                                                                            if (input.substr(peg$currPos, 8) === peg$c48) {
                                                                                              s0 = peg$c48;
                                                                                              peg$currPos += 8;
                                                                                            } else {
                                                                                              s0 = peg$FAILED;
                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e50); }
                                                                                            }
                                                                                            if (s0 === peg$FAILED) {
                                                                                              if (input.substr(peg$currPos, 9) === peg$c49) {
                                                                                                s0 = peg$c49;
                                                                                                peg$currPos += 9;
                                                                                              } else {
                                                                                                s0 = peg$FAILED;
                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e51); }
                                                                                              }
                                                                                              if (s0 === peg$FAILED) {
                                                                                                if (input.substr(peg$currPos, 9) === peg$c50) {
                                                                                                  s0 = peg$c50;
                                                                                                  peg$currPos += 9;
                                                                                                } else {
                                                                                                  s0 = peg$FAILED;
                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e52); }
                                                                                                }
                                                                                                if (s0 === peg$FAILED) {
                                                                                                  if (input.substr(peg$currPos, 9) === peg$c51) {
                                                                                                    s0 = peg$c51;
                                                                                                    peg$currPos += 9;
                                                                                                  } else {
                                                                                                    s0 = peg$FAILED;
                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e53); }
                                                                                                  }
                                                                                                  if (s0 === peg$FAILED) {
                                                                                                    if (input.substr(peg$currPos, 9) === peg$c52) {
                                                                                                      s0 = peg$c52;
                                                                                                      peg$currPos += 9;
                                                                                                    } else {
                                                                                                      s0 = peg$FAILED;
                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e54); }
                                                                                                    }
                                                                                                    if (s0 === peg$FAILED) {
                                                                                                      if (input.substr(peg$currPos, 9) === peg$c53) {
                                                                                                        s0 = peg$c53;
                                                                                                        peg$currPos += 9;
                                                                                                      } else {
                                                                                                        s0 = peg$FAILED;
                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e55); }
                                                                                                      }
                                                                                                      if (s0 === peg$FAILED) {
                                                                                                        if (input.substr(peg$currPos, 9) === peg$c54) {
                                                                                                          s0 = peg$c54;
                                                                                                          peg$currPos += 9;
                                                                                                        } else {
                                                                                                          s0 = peg$FAILED;
                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e56); }
                                                                                                        }
                                                                                                        if (s0 === peg$FAILED) {
                                                                                                          if (input.substr(peg$currPos, 9) === peg$c55) {
                                                                                                            s0 = peg$c55;
                                                                                                            peg$currPos += 9;
                                                                                                          } else {
                                                                                                            s0 = peg$FAILED;
                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e57); }
                                                                                                          }
                                                                                                          if (s0 === peg$FAILED) {
                                                                                                            if (input.substr(peg$currPos, 8) === peg$c56) {
                                                                                                              s0 = peg$c56;
                                                                                                              peg$currPos += 8;
                                                                                                            } else {
                                                                                                              s0 = peg$FAILED;
                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e58); }
                                                                                                            }
                                                                                                            if (s0 === peg$FAILED) {
                                                                                                              if (input.substr(peg$currPos, 8) === peg$c57) {
                                                                                                                s0 = peg$c57;
                                                                                                                peg$currPos += 8;
                                                                                                              } else {
                                                                                                                s0 = peg$FAILED;
                                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e59); }
                                                                                                              }
                                                                                                              if (s0 === peg$FAILED) {
                                                                                                                if (input.substr(peg$currPos, 8) === peg$c58) {
                                                                                                                  s0 = peg$c58;
                                                                                                                  peg$currPos += 8;
                                                                                                                } else {
                                                                                                                  s0 = peg$FAILED;
                                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e60); }
                                                                                                                }
                                                                                                                if (s0 === peg$FAILED) {
                                                                                                                  if (input.substr(peg$currPos, 8) === peg$c59) {
                                                                                                                    s0 = peg$c59;
                                                                                                                    peg$currPos += 8;
                                                                                                                  } else {
                                                                                                                    s0 = peg$FAILED;
                                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e61); }
                                                                                                                  }
                                                                                                                  if (s0 === peg$FAILED) {
                                                                                                                    if (input.substr(peg$currPos, 8) === peg$c60) {
                                                                                                                      s0 = peg$c60;
                                                                                                                      peg$currPos += 8;
                                                                                                                    } else {
                                                                                                                      s0 = peg$FAILED;
                                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e62); }
                                                                                                                    }
                                                                                                                    if (s0 === peg$FAILED) {
                                                                                                                      if (input.substr(peg$currPos, 8) === peg$c61) {
                                                                                                                        s0 = peg$c61;
                                                                                                                        peg$currPos += 8;
                                                                                                                      } else {
                                                                                                                        s0 = peg$FAILED;
                                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e63); }
                                                                                                                      }
                                                                                                                      if (s0 === peg$FAILED) {
                                                                                                                        if (input.substr(peg$currPos, 8) === peg$c62) {
                                                                                                                          s0 = peg$c62;
                                                                                                                          peg$currPos += 8;
                                                                                                                        } else {
                                                                                                                          s0 = peg$FAILED;
                                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e64); }
                                                                                                                        }
                                                                                                                        if (s0 === peg$FAILED) {
                                                                                                                          if (input.substr(peg$currPos, 8) === peg$c63) {
                                                                                                                            s0 = peg$c63;
                                                                                                                            peg$currPos += 8;
                                                                                                                          } else {
                                                                                                                            s0 = peg$FAILED;
                                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e65); }
                                                                                                                          }
                                                                                                                          if (s0 === peg$FAILED) {
                                                                                                                            if (input.substr(peg$currPos, 7) === peg$c64) {
                                                                                                                              s0 = peg$c64;
                                                                                                                              peg$currPos += 7;
                                                                                                                            } else {
                                                                                                                              s0 = peg$FAILED;
                                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e66); }
                                                                                                                            }
                                                                                                                            if (s0 === peg$FAILED) {
                                                                                                                              if (input.substr(peg$currPos, 7) === peg$c65) {
                                                                                                                                s0 = peg$c65;
                                                                                                                                peg$currPos += 7;
                                                                                                                              } else {
                                                                                                                                s0 = peg$FAILED;
                                                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e67); }
                                                                                                                              }
                                                                                                                              if (s0 === peg$FAILED) {
                                                                                                                                if (input.substr(peg$currPos, 7) === peg$c66) {
                                                                                                                                  s0 = peg$c66;
                                                                                                                                  peg$currPos += 7;
                                                                                                                                } else {
                                                                                                                                  s0 = peg$FAILED;
                                                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e68); }
                                                                                                                                }
                                                                                                                                if (s0 === peg$FAILED) {
                                                                                                                                  if (input.substr(peg$currPos, 7) === peg$c67) {
                                                                                                                                    s0 = peg$c67;
                                                                                                                                    peg$currPos += 7;
                                                                                                                                  } else {
                                                                                                                                    s0 = peg$FAILED;
                                                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e69); }
                                                                                                                                  }
                                                                                                                                  if (s0 === peg$FAILED) {
                                                                                                                                    if (input.substr(peg$currPos, 7) === peg$c68) {
                                                                                                                                      s0 = peg$c68;
                                                                                                                                      peg$currPos += 7;
                                                                                                                                    } else {
                                                                                                                                      s0 = peg$FAILED;
                                                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e70); }
                                                                                                                                    }
                                                                                                                                    if (s0 === peg$FAILED) {
                                                                                                                                      if (input.substr(peg$currPos, 7) === peg$c69) {
                                                                                                                                        s0 = peg$c69;
                                                                                                                                        peg$currPos += 7;
                                                                                                                                      } else {
                                                                                                                                        s0 = peg$FAILED;
                                                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e71); }
                                                                                                                                      }
                                                                                                                                      if (s0 === peg$FAILED) {
                                                                                                                                        if (input.substr(peg$currPos, 7) === peg$c70) {
                                                                                                                                          s0 = peg$c70;
                                                                                                                                          peg$currPos += 7;
                                                                                                                                        } else {
                                                                                                                                          s0 = peg$FAILED;
                                                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e72); }
                                                                                                                                        }
                                                                                                                                        if (s0 === peg$FAILED) {
                                                                                                                                          if (input.substr(peg$currPos, 7) === peg$c71) {
                                                                                                                                            s0 = peg$c71;
                                                                                                                                            peg$currPos += 7;
                                                                                                                                          } else {
                                                                                                                                            s0 = peg$FAILED;
                                                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e73); }
                                                                                                                                          }
                                                                                                                                          if (s0 === peg$FAILED) {
                                                                                                                                            if (input.substr(peg$currPos, 7) === peg$c72) {
                                                                                                                                              s0 = peg$c72;
                                                                                                                                              peg$currPos += 7;
                                                                                                                                            } else {
                                                                                                                                              s0 = peg$FAILED;
                                                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e74); }
                                                                                                                                            }
                                                                                                                                            if (s0 === peg$FAILED) {
                                                                                                                                              if (input.substr(peg$currPos, 7) === peg$c73) {
                                                                                                                                                s0 = peg$c73;
                                                                                                                                                peg$currPos += 7;
                                                                                                                                              } else {
                                                                                                                                                s0 = peg$FAILED;
                                                                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e75); }
                                                                                                                                              }
                                                                                                                                              if (s0 === peg$FAILED) {
                                                                                                                                                if (input.substr(peg$currPos, 7) === peg$c74) {
                                                                                                                                                  s0 = peg$c74;
                                                                                                                                                  peg$currPos += 7;
                                                                                                                                                } else {
                                                                                                                                                  s0 = peg$FAILED;
                                                                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e76); }
                                                                                                                                                }
                                                                                                                                                if (s0 === peg$FAILED) {
                                                                                                                                                  if (input.substr(peg$currPos, 7) === peg$c75) {
                                                                                                                                                    s0 = peg$c75;
                                                                                                                                                    peg$currPos += 7;
                                                                                                                                                  } else {
                                                                                                                                                    s0 = peg$FAILED;
                                                                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e77); }
                                                                                                                                                  }
                                                                                                                                                  if (s0 === peg$FAILED) {
                                                                                                                                                    if (input.substr(peg$currPos, 6) === peg$c76) {
                                                                                                                                                      s0 = peg$c76;
                                                                                                                                                      peg$currPos += 6;
                                                                                                                                                    } else {
                                                                                                                                                      s0 = peg$FAILED;
                                                                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e78); }
                                                                                                                                                    }
                                                                                                                                                    if (s0 === peg$FAILED) {
                                                                                                                                                      if (input.substr(peg$currPos, 6) === peg$c77) {
                                                                                                                                                        s0 = peg$c77;
                                                                                                                                                        peg$currPos += 6;
                                                                                                                                                      } else {
                                                                                                                                                        s0 = peg$FAILED;
                                                                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e79); }
                                                                                                                                                      }
                                                                                                                                                      if (s0 === peg$FAILED) {
                                                                                                                                                        if (input.substr(peg$currPos, 6) === peg$c78) {
                                                                                                                                                          s0 = peg$c78;
                                                                                                                                                          peg$currPos += 6;
                                                                                                                                                        } else {
                                                                                                                                                          s0 = peg$FAILED;
                                                                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e80); }
                                                                                                                                                        }
                                                                                                                                                        if (s0 === peg$FAILED) {
                                                                                                                                                          if (input.substr(peg$currPos, 6) === peg$c79) {
                                                                                                                                                            s0 = peg$c79;
                                                                                                                                                            peg$currPos += 6;
                                                                                                                                                          } else {
                                                                                                                                                            s0 = peg$FAILED;
                                                                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e81); }
                                                                                                                                                          }
                                                                                                                                                          if (s0 === peg$FAILED) {
                                                                                                                                                            if (input.substr(peg$currPos, 6) === peg$c80) {
                                                                                                                                                              s0 = peg$c80;
                                                                                                                                                              peg$currPos += 6;
                                                                                                                                                            } else {
                                                                                                                                                              s0 = peg$FAILED;
                                                                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e82); }
                                                                                                                                                            }
                                                                                                                                                            if (s0 === peg$FAILED) {
                                                                                                                                                              if (input.substr(peg$currPos, 6) === peg$c81) {
                                                                                                                                                                s0 = peg$c81;
                                                                                                                                                                peg$currPos += 6;
                                                                                                                                                              } else {
                                                                                                                                                                s0 = peg$FAILED;
                                                                                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e83); }
                                                                                                                                                              }
                                                                                                                                                              if (s0 === peg$FAILED) {
                                                                                                                                                                if (input.substr(peg$currPos, 5) === peg$c82) {
                                                                                                                                                                  s0 = peg$c82;
                                                                                                                                                                  peg$currPos += 5;
                                                                                                                                                                } else {
                                                                                                                                                                  s0 = peg$FAILED;
                                                                                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e84); }
                                                                                                                                                                }
                                                                                                                                                                if (s0 === peg$FAILED) {
                                                                                                                                                                  if (input.substr(peg$currPos, 5) === peg$c83) {
                                                                                                                                                                    s0 = peg$c83;
                                                                                                                                                                    peg$currPos += 5;
                                                                                                                                                                  } else {
                                                                                                                                                                    s0 = peg$FAILED;
                                                                                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e85); }
                                                                                                                                                                  }
                                                                                                                                                                  if (s0 === peg$FAILED) {
                                                                                                                                                                    if (input.substr(peg$currPos, 5) === peg$c84) {
                                                                                                                                                                      s0 = peg$c84;
                                                                                                                                                                      peg$currPos += 5;
                                                                                                                                                                    } else {
                                                                                                                                                                      s0 = peg$FAILED;
                                                                                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e86); }
                                                                                                                                                                    }
                                                                                                                                                                    if (s0 === peg$FAILED) {
                                                                                                                                                                      if (input.substr(peg$currPos, 5) === peg$c85) {
                                                                                                                                                                        s0 = peg$c85;
                                                                                                                                                                        peg$currPos += 5;
                                                                                                                                                                      } else {
                                                                                                                                                                        s0 = peg$FAILED;
                                                                                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e87); }
                                                                                                                                                                      }
                                                                                                                                                                      if (s0 === peg$FAILED) {
                                                                                                                                                                        if (input.substr(peg$currPos, 5) === peg$c86) {
                                                                                                                                                                          s0 = peg$c86;
                                                                                                                                                                          peg$currPos += 5;
                                                                                                                                                                        } else {
                                                                                                                                                                          s0 = peg$FAILED;
                                                                                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e88); }
                                                                                                                                                                        }
                                                                                                                                                                        if (s0 === peg$FAILED) {
                                                                                                                                                                          if (input.substr(peg$currPos, 5) === peg$c87) {
                                                                                                                                                                            s0 = peg$c87;
                                                                                                                                                                            peg$currPos += 5;
                                                                                                                                                                          } else {
                                                                                                                                                                            s0 = peg$FAILED;
                                                                                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e89); }
                                                                                                                                                                          }
                                                                                                                                                                          if (s0 === peg$FAILED) {
                                                                                                                                                                            if (input.substr(peg$currPos, 4) === peg$c88) {
                                                                                                                                                                              s0 = peg$c88;
                                                                                                                                                                              peg$currPos += 4;
                                                                                                                                                                            } else {
                                                                                                                                                                              s0 = peg$FAILED;
                                                                                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e90); }
                                                                                                                                                                            }
                                                                                                                                                                            if (s0 === peg$FAILED) {
                                                                                                                                                                              if (input.substr(peg$currPos, 4) === peg$c89) {
                                                                                                                                                                                s0 = peg$c89;
                                                                                                                                                                                peg$currPos += 4;
                                                                                                                                                                              } else {
                                                                                                                                                                                s0 = peg$FAILED;
                                                                                                                                                                                if (peg$silentFails === 0) { peg$fail(peg$e91); }
                                                                                                                                                                              }
                                                                                                                                                                              if (s0 === peg$FAILED) {
                                                                                                                                                                                if (input.substr(peg$currPos, 4) === peg$c90) {
                                                                                                                                                                                  s0 = peg$c90;
                                                                                                                                                                                  peg$currPos += 4;
                                                                                                                                                                                } else {
                                                                                                                                                                                  s0 = peg$FAILED;
                                                                                                                                                                                  if (peg$silentFails === 0) { peg$fail(peg$e92); }
                                                                                                                                                                                }
                                                                                                                                                                                if (s0 === peg$FAILED) {
                                                                                                                                                                                  if (input.substr(peg$currPos, 4) === peg$c91) {
                                                                                                                                                                                    s0 = peg$c91;
                                                                                                                                                                                    peg$currPos += 4;
                                                                                                                                                                                  } else {
                                                                                                                                                                                    s0 = peg$FAILED;
                                                                                                                                                                                    if (peg$silentFails === 0) { peg$fail(peg$e93); }
                                                                                                                                                                                  }
                                                                                                                                                                                  if (s0 === peg$FAILED) {
                                                                                                                                                                                    if (input.substr(peg$currPos, 3) === peg$c92) {
                                                                                                                                                                                      s0 = peg$c92;
                                                                                                                                                                                      peg$currPos += 3;
                                                                                                                                                                                    } else {
                                                                                                                                                                                      s0 = peg$FAILED;
                                                                                                                                                                                      if (peg$silentFails === 0) { peg$fail(peg$e94); }
                                                                                                                                                                                    }
                                                                                                                                                                                    if (s0 === peg$FAILED) {
                                                                                                                                                                                      if (input.substr(peg$currPos, 3) === peg$c93) {
                                                                                                                                                                                        s0 = peg$c93;
                                                                                                                                                                                        peg$currPos += 3;
                                                                                                                                                                                      } else {
                                                                                                                                                                                        s0 = peg$FAILED;
                                                                                                                                                                                        if (peg$silentFails === 0) { peg$fail(peg$e95); }
                                                                                                                                                                                      }
                                                                                                                                                                                      if (s0 === peg$FAILED) {
                                                                                                                                                                                        if (input.substr(peg$currPos, 3) === peg$c94) {
                                                                                                                                                                                          s0 = peg$c94;
                                                                                                                                                                                          peg$currPos += 3;
                                                                                                                                                                                        } else {
                                                                                                                                                                                          s0 = peg$FAILED;
                                                                                                                                                                                          if (peg$silentFails === 0) { peg$fail(peg$e96); }
                                                                                                                                                                                        }
                                                                                                                                                                                        if (s0 === peg$FAILED) {
                                                                                                                                                                                          if (input.substr(peg$currPos, 2) === peg$c95) {
                                                                                                                                                                                            s0 = peg$c95;
                                                                                                                                                                                            peg$currPos += 2;
                                                                                                                                                                                          } else {
                                                                                                                                                                                            s0 = peg$FAILED;
                                                                                                                                                                                            if (peg$silentFails === 0) { peg$fail(peg$e97); }
                                                                                                                                                                                          }
                                                                                                                                                                                          if (s0 === peg$FAILED) {
                                                                                                                                                                                            if (input.substr(peg$currPos, 2) === peg$c96) {
                                                                                                                                                                                              s0 = peg$c96;
                                                                                                                                                                                              peg$currPos += 2;
                                                                                                                                                                                            } else {
                                                                                                                                                                                              s0 = peg$FAILED;
                                                                                                                                                                                              if (peg$silentFails === 0) { peg$fail(peg$e98); }
                                                                                                                                                                                            }
                                                                                                                                                                                          }
                                                                                                                                                                                        }
                                                                                                                                                                                      }
                                                                                                                                                                                    }
                                                                                                                                                                                  }
                                                                                                                                                                                }
                                                                                                                                                                              }
                                                                                                                                                                            }
                                                                                                                                                                          }
                                                                                                                                                                        }
                                                                                                                                                                      }
                                                                                                                                                                    }
                                                                                                                                                                  }
                                                                                                                                                                }
                                                                                                                                                              }
                                                                                                                                                            }
                                                                                                                                                          }
                                                                                                                                                        }
                                                                                                                                                      }
                                                                                                                                                    }
                                                                                                                                                  }
                                                                                                                                                }
                                                                                                                                              }
                                                                                                                                            }
                                                                                                                                          }
                                                                                                                                        }
                                                                                                                                      }
                                                                                                                                    }
                                                                                                                                  }
                                                                                                                                }
                                                                                                                              }
                                                                                                                            }
                                                                                                                          }
                                                                                                                        }
                                                                                                                      }
                                                                                                                    }
                                                                                                                  }
                                                                                                                }
                                                                                                              }
                                                                                                            }
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    }
                                                                                                  }
                                                                                                }
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecharselect() {
    var s0;

    if (input.substr(peg$currPos, 7) === peg$c97) {
      s0 = peg$c97;
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e99); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 7) === peg$c98) {
        s0 = peg$c98;
        peg$currPos += 7;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e100); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c99) {
          s0 = peg$c99;
          peg$currPos += 6;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e101); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c100) {
            s0 = peg$c100;
            peg$currPos += 6;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e102); }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsechartransform() {
    var s0;

    if (input.substr(peg$currPos, 10) === peg$c101) {
      s0 = peg$c101;
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e103); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 8) === peg$c102) {
        s0 = peg$c102;
        peg$currPos += 8;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e104); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c103) {
          s0 = peg$c103;
          peg$currPos += 7;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e105); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c104) {
            s0 = peg$c104;
            peg$currPos += 6;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e106); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c105) {
              s0 = peg$c105;
              peg$currPos += 5;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e107); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 4) === peg$c106) {
                s0 = peg$c106;
                peg$currPos += 4;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e108); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c107) {
                  s0 = peg$c107;
                  peg$currPos += 4;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e109); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 4) === peg$c108) {
                    s0 = peg$c108;
                    peg$currPos += 4;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e110); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 4) === peg$c109) {
                      s0 = peg$c109;
                      peg$currPos += 4;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e111); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 8) === peg$c110) {
                        s0 = peg$c110;
                        peg$currPos += 8;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e112); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 11) === peg$c111) {
                          s0 = peg$c111;
                          peg$currPos += 11;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e113); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 13) === peg$c112) {
                            s0 = peg$c112;
                            peg$currPos += 13;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e114); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 4) === peg$c113) {
                              s0 = peg$c113;
                              peg$currPos += 4;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e115); }
                            }
                            if (s0 === peg$FAILED) {
                              if (input.substr(peg$currPos, 6) === peg$c114) {
                                s0 = peg$c114;
                                peg$currPos += 6;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e116); }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecharselector() {
    var s0;

    if (input.substr(peg$currPos, 9) === peg$c115) {
      s0 = peg$c115;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e117); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 8) === peg$c116) {
        s0 = peg$c116;
        peg$currPos += 8;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e118); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c117) {
          s0 = peg$c117;
          peg$currPos += 7;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e119); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 7) === peg$c118) {
            s0 = peg$c118;
            peg$currPos += 7;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e120); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 7) === peg$c119) {
              s0 = peg$c119;
              peg$currPos += 7;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e121); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 7) === peg$c120) {
                s0 = peg$c120;
                peg$currPos += 7;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e122); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c121) {
                  s0 = peg$c121;
                  peg$currPos += 5;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e123); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 5) === peg$c122) {
                    s0 = peg$c122;
                    peg$currPos += 5;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e124); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5) === peg$c123) {
                      s0 = peg$c123;
                      peg$currPos += 5;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e125); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 5) === peg$c124) {
                        s0 = peg$c124;
                        peg$currPos += 5;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e126); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 5) === peg$c125) {
                          s0 = peg$c125;
                          peg$currPos += 5;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e127); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 5) === peg$c126) {
                            s0 = peg$c126;
                            peg$currPos += 5;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e128); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 4) === peg$c127) {
                              s0 = peg$c127;
                              peg$currPos += 4;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e129); }
                            }
                            if (s0 === peg$FAILED) {
                              if (input.substr(peg$currPos, 4) === peg$c128) {
                                s0 = peg$c128;
                                peg$currPos += 4;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e130); }
                              }
                              if (s0 === peg$FAILED) {
                                if (input.substr(peg$currPos, 3) === peg$c129) {
                                  s0 = peg$c129;
                                  peg$currPos += 3;
                                } else {
                                  s0 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$e131); }
                                }
                                if (s0 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 3) === peg$c130) {
                                    s0 = peg$c130;
                                    peg$currPos += 3;
                                  } else {
                                    s0 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$e132); }
                                  }
                                  if (s0 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 3) === peg$c131) {
                                      s0 = peg$c131;
                                      peg$currPos += 3;
                                    } else {
                                      s0 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$e133); }
                                    }
                                    if (s0 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 3) === peg$c132) {
                                        s0 = peg$c132;
                                        peg$currPos += 3;
                                      } else {
                                        s0 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$e134); }
                                      }
                                      if (s0 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 3) === peg$c133) {
                                          s0 = peg$c133;
                                          peg$currPos += 3;
                                        } else {
                                          s0 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$e135); }
                                        }
                                        if (s0 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 2) === peg$c134) {
                                            s0 = peg$c134;
                                            peg$currPos += 2;
                                          } else {
                                            s0 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$e136); }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parselist_arguments() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsevalue();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parsearg_separator();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsevalue();
        if (s5 !== peg$FAILED) {
          s3 = s5;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parsearg_separator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsevalue();
          if (s5 !== peg$FAILED) {
            s3 = s5;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f13(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = null;
    }

    return s0;
  }

  function peg$parsefalse() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5) === peg$c135) {
      s1 = peg$c135;
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e137); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f14();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsenull() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c136) {
      s1 = peg$c136;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e138); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f15();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetrue() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c137) {
      s1 = peg$c137;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e139); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f16();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsenumber() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseminus();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parseint();
    if (s2 !== peg$FAILED) {
      s3 = peg$parsefrac();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parseexp();
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f17();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e140); }
    }

    return s0;
  }

  function peg$parsedecimal_point() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 46) {
      s0 = peg$c3;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e5); }
    }

    return s0;
  }

  function peg$parsedigit1_9() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r1.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e141); }
    }

    return s0;
  }

  function peg$parsee() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r2.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e142); }
    }

    return s0;
  }

  function peg$parseexp() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsee();
    if (s1 !== peg$FAILED) {
      s2 = input.charAt(peg$currPos);
      if (peg$r3.test(s2)) {
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e143); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = [];
      s4 = peg$parseDIGIT();
      if (s4 !== peg$FAILED) {
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseDIGIT();
        }
      } else {
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefrac() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedecimal_point();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDIGIT();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseint() {
    var s0, s1, s2, s3;

    s0 = peg$parsezero();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedigit1_9();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseDIGIT();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDIGIT();
        }
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseminus() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c138;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e144); }
    }

    return s0;
  }

  function peg$parseplus() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 43) {
      s0 = peg$c139;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e145); }
    }

    return s0;
  }

  function peg$parsezero() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 48) {
      s0 = peg$c140;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e146); }
    }

    return s0;
  }

  function peg$parsestring() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsechar();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsechar();
      }
      s3 = peg$parsequotation_mark();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f18(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsequotation_mark_single();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsechar();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsechar();
        }
        s3 = peg$parsequotation_mark_single();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f19(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parsecharpart();
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsecharpart();
        }
        peg$savedPos = s0;
        s1 = peg$f20(s1);
        s0 = s1;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e147); }
    }

    return s0;
  }

  function peg$parsecharpart() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r4.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e148); }
    }

    return s0;
  }

  function peg$parsechar() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$parseunescaped();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseescape();
      if (s1 !== peg$FAILED) {
        s2 = input.charAt(peg$currPos);
        if (peg$r5.test(s2)) {
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e149); }
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 98) {
            s3 = peg$c141;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e150); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$f21();
          }
          s2 = s3;
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 102) {
              s3 = peg$c142;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e151); }
            }
            if (s3 !== peg$FAILED) {
              peg$savedPos = s2;
              s3 = peg$f22();
            }
            s2 = s3;
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 110) {
                s3 = peg$c143;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e152); }
              }
              if (s3 !== peg$FAILED) {
                peg$savedPos = s2;
                s3 = peg$f23();
              }
              s2 = s3;
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 114) {
                  s3 = peg$c144;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e153); }
                }
                if (s3 !== peg$FAILED) {
                  peg$savedPos = s2;
                  s3 = peg$f24();
                }
                s2 = s3;
                if (s2 === peg$FAILED) {
                  s2 = peg$currPos;
                  if (input.charCodeAt(peg$currPos) === 116) {
                    s3 = peg$c145;
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e154); }
                  }
                  if (s3 !== peg$FAILED) {
                    peg$savedPos = s2;
                    s3 = peg$f25();
                  }
                  s2 = s3;
                  if (s2 === peg$FAILED) {
                    s2 = peg$currPos;
                    if (input.charCodeAt(peg$currPos) === 117) {
                      s3 = peg$c146;
                      peg$currPos++;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e155); }
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = peg$currPos;
                      s5 = peg$currPos;
                      s6 = peg$parseHEXDIG();
                      if (s6 !== peg$FAILED) {
                        s7 = peg$parseHEXDIG();
                        if (s7 !== peg$FAILED) {
                          s8 = peg$parseHEXDIG();
                          if (s8 !== peg$FAILED) {
                            s9 = peg$parseHEXDIG();
                            if (s9 !== peg$FAILED) {
                              s6 = [s6, s7, s8, s9];
                              s5 = s6;
                            } else {
                              peg$currPos = s5;
                              s5 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s5;
                            s5 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s5;
                          s5 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                      if (s5 !== peg$FAILED) {
                        s4 = input.substring(s4, peg$currPos);
                      } else {
                        s4 = s5;
                      }
                      if (s4 !== peg$FAILED) {
                        peg$savedPos = s2;
                        s2 = peg$f26(s4);
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f27(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseescape() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 92) {
      s0 = peg$c147;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e156); }
    }

    return s0;
  }

  function peg$parsequotation_mark() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c148;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e157); }
    }

    return s0;
  }

  function peg$parsequotation_mark_single() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 39) {
      s0 = peg$c149;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e158); }
    }

    return s0;
  }

  function peg$parseunescaped() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r6.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e159); }
    }

    return s0;
  }

  function peg$parseDIGIT() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r7.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e160); }
    }

    return s0;
  }

  function peg$parseHEXDIG() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r8.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e161); }
    }

    return s0;
  }

  peg$result = peg$startRuleFunction();

  if (options.peg$library) {
    return /** @type {any} */ ({
      peg$result,
      peg$currPos,
      peg$FAILED,
      peg$maxFailExpected,
      peg$maxFailPos
    });
  }
  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  StartRules: ["nLinq_text"],
  SyntaxError: peg$SyntaxError,
  parse: peg$parse
};