/*
 * Decompiled with CFR 0.152.
 */
package openaf.rhino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import openaf.AFCmdBase;
import openaf.JSEngine;
import openaf.OAFdCL;
import openaf.OpenRhinoErrorReporter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoEngine
implements JSEngine {
    protected static Context cx;
    protected static ScriptableObject globalscope;
    protected static boolean getSerializeDefined;
    protected boolean ready = false;
    protected long numberOfLines = 0L;

    private void setOAFdCLClassLoader(Context context) {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader instanceof OAFdCL) {
                context.setApplicationClassLoader(classLoader);
                Thread.currentThread().setContextClassLoader(classLoader);
            } else {
                OAFdCL oAFdCL = OAFdCL.getInstance(classLoader);
                if (oAFdCL != null) {
                    context.setApplicationClassLoader((ClassLoader)oAFdCL);
                    Thread.currentThread().setContextClassLoader(oAFdCL);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public Context getNotSafeContext() {
        return cx;
    }

    @Override
    public Object getGlobalscope() {
        return globalscope;
    }

    @Override
    public void defineSerialize() {
        if (!getSerializeDefined) {
            Object object = "function getSerialize (fn, decycle) { function getPath (value, seen, keys) { var index = seen.indexOf(value); var path = [ keys[index] ]; for (index--; index >= 0; index--) { if (seen[index][ path[0] ] === value) { value = seen[index]; path.unshift(keys[index]); }} return '~' + path.join('.'); }";
            object = (String)object + " var seen = [], keys = []; decycle = decycle || function(key, value) {return '[Circular ' + getPath(value, seen, keys) + ']'}; return function(key, value) {var ret = value;if (typeof value === 'object' && value) {if (seen.indexOf(value) !== -1) ret = decycle(key, value); else { seen.push(value); keys.push(key); }} if (fn) ret = fn(key, ret);  return ret;}}";
            Context context = Context.enter();
            this.setOAFdCLClassLoader(context);
            context.evaluateString((Scriptable)AFCmdBase.jse.getGlobalscope(), (String)object, "internal_getSerialize", 1, null);
            Context.exit();
        }
        getSerializeDefined = true;
    }

    @Override
    public void start(int n) {
        cx = Context.enter();
        cx.setLanguageVersion(200);
        cx.setErrorReporter((ErrorReporter)new OpenRhinoErrorReporter());
        this.setOAFdCLClassLoader(cx);
        globalscope = cx.initStandardObjects();
        this.ready = true;
    }

    @Override
    public void stop() {
        Context.exit();
    }

    @Override
    public Object createObject() {
        return cx.newObject((Scriptable)globalscope);
    }

    @Override
    public Object newObject(Object object) {
        return cx.newObject((Scriptable)object);
    }

    @Override
    public Object newArray(Object object, Object[] objectArray) {
        return cx.newArray((Scriptable)object, objectArray);
    }

    @Override
    public Object stringify(Object object) {
        return NativeJSON.stringify((Context)cx, (Scriptable)globalscope, (Object)object, null, null);
    }

    @Override
    public Object stringify(Object object, Object object2, Object object3) {
        return NativeJSON.stringify((Context)cx, (Scriptable)globalscope, (Object)object, (Object)object2, (Object)object3);
    }

    @Override
    public Object newObject(Object object, String string) {
        return cx.newObject((Scriptable)object, string);
    }

    @Override
    public Object newObject(Object object, String string, Object[] objectArray) {
        return cx.newObject((Scriptable)object, string, objectArray);
    }

    @Override
    public Object enterContext() {
        Context context = Context.enter();
        this.setOAFdCLClassLoader(context);
        return context;
    }

    @Override
    public void exitContext() {
        Context.exit();
    }

    @Override
    public long getCurrentNumberOfLines() {
        return this.numberOfLines;
    }

    @Override
    public void addNumberOfLines(String string) {
        long l = string.split("\r\n|\r|\n").length;
        this.numberOfLines += l;
    }

    @Override
    public Object convertObject(Object object) {
        return Context.javaToJS((Object)object, (Scriptable)((Scriptable)this.getGlobalscope()));
    }

    @Override
    public JSEngine.JSList getNewList(Object object) {
        if (object == null) {
            return new JSList(this);
        }
        return new JSList(this, (Scriptable)object);
    }

    @Override
    public JSEngine.JSMap getNewMap(Object object) {
        if (object == null) {
            return new JSMap(this);
        }
        return new JSMap(this, (Scriptable)object);
    }

    static {
        getSerializeDefined = false;
    }

    public class JSList
    extends JSEngine.JSList {
        Scriptable parentNo;
        ArrayList<Object> alist = new ArrayList();

        public JSList(RhinoEngine rhinoEngine) {
            this.parentNo = (Scriptable)AFCmdBase.jse.getGlobalscope();
        }

        public JSList(RhinoEngine rhinoEngine, Scriptable scriptable) {
            this.parentNo = scriptable;
        }

        @Override
        public void add(Object object) {
            this.alist.add(object);
        }

        @Override
        public Object getList() {
            return AFCmdBase.jse.newArray(this.parentNo, this.alist.toArray());
        }

        @Override
        public void addAll(Collection<?> collection) {
            this.alist.addAll(collection);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.alist.iterator();
        }

        @Override
        public long size() {
            return this.alist.size();
        }
    }

    public class JSMap
    implements JSEngine.JSMap {
        Scriptable no;
        Scriptable parentNo;

        public JSMap(RhinoEngine rhinoEngine) {
            this.parentNo = (Scriptable)AFCmdBase.jse.getGlobalscope();
            this.no = (Scriptable)AFCmdBase.jse.newObject(this.parentNo);
        }

        public JSMap(RhinoEngine rhinoEngine, Scriptable scriptable) {
            this.parentNo = scriptable;
            this.no = (Scriptable)AFCmdBase.jse.newObject(this.parentNo);
        }

        @Override
        public void put(String string, Object object) {
            this.no.put(string, this.no, object);
        }

        @Override
        public Object get(String string) {
            return this.no.get(string, this.parentNo);
        }

        @Override
        public boolean contains(String string) {
            return this.no.has(string, this.parentNo);
        }

        @Override
        public Object getMap() {
            return this.no;
        }
    }
}

