/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class ZIP
extends ScriptableObject {
    private static final long serialVersionUID = -411758788276719694L;
    protected ZipFile zipFile;
    protected Map<String, ZipEntry> zipEntries = new ConcurrentHashMap<String, ZipEntry>();
    protected Map<String, byte[]> zipData = new ConcurrentHashMap<String, byte[]>();
    static final ConcurrentHashMap<URI, FileSystem> fileSystems = new ConcurrentHashMap();
    static final ReentrantLock lock = new ReentrantLock();

    public String getClassName() {
        return "ZIP";
    }

    protected void waitForFileSystem(URI uRI) {
        while (fileSystems.containsKey(uRI)) {
            lock.unlock();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lock.lock();
        }
    }

    @JSConstructor
    public void newZIP(Object object) throws IOException {
        if (object != null && !object.equals("undefined") && !(object instanceof Undefined)) {
            this.load(object);
        }
    }

    @JSFunction
    public static Object gzip(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        IOUtils.write((byte[])((byte[])object), (OutputStream)gZIPOutputStream);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @JSFunction
    public static Object gunzip(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
        IOUtils.copy((InputStream)gZIPInputStream, (OutputStream)byteArrayOutputStream);
        gZIPInputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected void clean() {
        this.zipData = new ConcurrentHashMap<String, byte[]>();
        this.zipEntries = new ConcurrentHashMap<String, ZipEntry>();
    }

    @JSFunction
    public void close() throws IOException {
        this.clean();
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    @JSFunction
    public Object getFile(String string) throws IOException {
        byte[] byArray = this.zipData.get(string);
        if (byArray != null) {
            return byArray;
        }
        try (InputStream inputStream = this.zipFile.getInputStream(this.zipEntries.get(string));){
            byte[] byArray2 = IOUtils.toByteArray((InputStream)inputStream);
            return byArray2;
        }
    }

    @JSFunction
    public void putFile(String string, Object object) {
        SimpleLog.log(SimpleLog.logtype.DEBUG, "put file with data of type " + object.getClass().getName(), null);
        byte[] byArray = object instanceof byte[] ? (byte[])object : object.toString().getBytes();
        ZipEntry zipEntry = new ZipEntry(string);
        this.zipEntries.put(string, zipEntry);
        this.zipData.put(string, byArray);
    }

    @JSFunction
    public ZIP remove(String string) {
        this.zipEntries.remove(string);
        this.zipData.remove(string);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JSFunction
    public Object streamGetFile(String string, String string2) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));){
            ZipEntry zipEntry;
            do {
                if (!(zipEntry = zipInputStream.getNextEntry()).getName().equals(string2)) continue;
                if (this.zipFile != null) {
                    this.zipFile.close();
                }
                this.zipFile = new ZipFile(string);
                try {
                    byte[] byArray;
                    byte[] byArray2 = byArray = IOUtils.toByteArray((InputStream)this.zipFile.getInputStream(zipEntry));
                    return byArray2;
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    this.zipFile.close();
                }
            } while (zipEntry != null);
            return null;
        }
    }

    @JSFunction
    public Object streamGetFileStream(String string, String string2) throws Exception {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));){
            ZipEntry zipEntry;
            do {
                if (!(zipEntry = zipInputStream.getNextEntry()).getName().equals(string2)) continue;
                if (this.zipFile != null) {
                    this.zipFile.close();
                }
                this.zipFile = new ZipFile(string);
                InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                return inputStream;
            } while (zipEntry != null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void streamPutFile(String string, String string2, Object object, boolean bl) throws IOException {
        Path path = Paths.get(string, new String[0]);
        URI uRI = URI.create("jar:" + String.valueOf(path.toUri()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        if (bl) {
            hashMap.put("useTempFile", "true");
        }
        lock.lock();
        this.waitForFileSystem(uRI);
        try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
            fileSystems.put(uRI, fileSystem);
            SimpleLog.log(SimpleLog.logtype.DEBUG, "put file with data of type " + object.getClass().getName(), null);
            Path path2 = fileSystem.getPath(string2, new String[0]);
            try {
                if (path2.getParent() != null && Files.notExists(path2.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                }
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    Files.write(path2, (byte[])object, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                } else if (Files.notExists(path2, new LinkOption[0])) {
                    Files.createDirectory(path2, new FileAttribute[0]);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        finally {
            fileSystems.remove(uRI);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void streamPutFileStream(String string, String string2, Object object, boolean bl) throws IOException {
        Path path = Paths.get(string, new String[0]);
        URI uRI = URI.create("jar:" + String.valueOf(path.toUri()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        if (bl) {
            hashMap.put("useTempFile", "true");
        }
        lock.lock();
        this.waitForFileSystem(uRI);
        try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
            fileSystems.put(uRI, fileSystem);
            SimpleLog.log(SimpleLog.logtype.DEBUG, "put file with data of type " + object.getClass().getName(), null);
            if (object instanceof NativeArray) {
                NativeArray nativeArray = (NativeArray)object;
                for (Object e : nativeArray) {
                    NativeObject nativeObject;
                    if (!(e instanceof NativeObject) || !(nativeObject = (NativeObject)e).has("s", (Scriptable)nativeArray) || !nativeObject.has("n", (Scriptable)nativeArray)) continue;
                    Path path2 = fileSystem.getPath((String)nativeObject.get((Object)"n"), new String[0]);
                    if (path2.getParent() != null && !Files.exists(path2.getParent(), new LinkOption[0])) {
                        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    }
                    Files.copy((InputStream)nativeObject.get((Object)"s"), path2, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Path path3 = fileSystem.getPath(string2, new String[0]);
                if (path3.getParent() != null && !Files.exists(path3.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path3.getParent(), new FileAttribute[0]);
                }
                if (object instanceof InputStream) {
                    Files.copy((InputStream)object, path3, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.write(path3, (byte[])object, new OpenOption[0]);
                }
            }
        }
        finally {
            fileSystems.remove(uRI);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void streamRemoveFile(String string, String string2, boolean bl) throws IOException {
        Path path = Paths.get(string, new String[0]);
        URI uRI = URI.create("jar:" + String.valueOf(path.toUri()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        if (bl) {
            hashMap.put("useTempFile", "true");
        }
        lock.lock();
        this.waitForFileSystem(uRI);
        try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
            fileSystems.put(uRI, fileSystem);
            Path path2 = fileSystem.getPath(string2, new String[0]);
            Files.deleteIfExists(path2);
        }
        finally {
            fileSystems.remove(uRI);
            lock.unlock();
        }
    }

    @JSFunction
    public void streamCreate(String string) throws IOException {
        ZIP zIP = new ZIP();
        zIP.generate2File(string, null, true);
        zIP.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public boolean streamCreateFolder(String string, String string2) throws IOException {
        URI uRI = URI.create("jar:" + String.valueOf(Paths.get(string, new String[0]).toUri()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        FileSystem fileSystem = null;
        lock.lock();
        this.waitForFileSystem(uRI);
        try {
            fileSystem = FileSystems.newFileSystem(uRI, hashMap);
            fileSystems.put(uRI, fileSystem);
            Path path = fileSystem.getPath(string2, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
            fileSystems.remove(uRI);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public Object generate(Object object, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        if (zipOutputStream != null) {
            try {
                if (object != null && object.equals("undefined") && !(object instanceof Undefined)) {
                    String string = (String)((NativeObject)object).get((Object)"compressionLevel");
                    zipOutputStream.setMethod(8);
                    if (string != null) {
                        zipOutputStream.setLevel(Integer.parseInt(string));
                    }
                }
                SimpleLog.log(SimpleLog.logtype.DEBUG, "number of entries " + this.zipEntries.size(), null);
                for (Object e : this.zipEntries.keySet()) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "generating " + this.zipEntries.get(e).getName(), null);
                    ZipEntry zipEntry = new ZipEntry(this.zipEntries.get(e).getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    if (this.zipData.containsKey(zipEntry.getName())) {
                        IOUtils.write((byte[])this.zipData.get(this.zipEntries.get(e).getName()), (OutputStream)zipOutputStream);
                    } else if (!zipEntry.isDirectory()) {
                        IOUtils.copy((InputStream)this.zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
            }
            finally {
                zipOutputStream.flush();
                zipOutputStream.finish();
                zipOutputStream.close();
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        SimpleLog.log(SimpleLog.logtype.DEBUG, "generated " + byteArrayOutputStream.size(), null);
        if (!bl) {
            this.load(byteArrayOutputStream.toByteArray());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @JSFunction
    public void generate2File(String string, Object object, boolean bl) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                if (object != null && object.equals("undefined") && !(object instanceof Undefined)) {
                    String string2 = (String)((NativeObject)object).get((Object)"compressionLevel");
                    zipOutputStream.setMethod(8);
                    if (string2 != null) {
                        zipOutputStream.setLevel(Integer.parseInt(string2));
                    }
                }
                SimpleLog.log(SimpleLog.logtype.DEBUG, "number of entries " + this.zipEntries.size(), null);
                for (Object e : this.zipEntries.keySet()) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "generating " + this.zipEntries.get(e).getName(), null);
                    ZipEntry zipEntry = new ZipEntry(this.zipEntries.get(e).getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    if (this.zipData.containsKey(zipEntry.getName())) {
                        IOUtils.write((byte[])this.zipData.get(this.zipEntries.get(e).getName()), (OutputStream)zipOutputStream);
                    } else if (!zipEntry.isDirectory()) {
                        IOUtils.copy((InputStream)this.zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.flush();
                zipOutputStream.finish();
            }
            fileOutputStream.flush();
        }
        if (!bl) {
            this.load(FileUtils.readFileToByteArray((File)new File(string)));
        }
    }

    @JSFunction
    public ZIP load(Object object) throws IOException {
        ZipEntry zipEntry;
        this.clean();
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.zipEntries.put(zipEntry.getName(), zipEntry);
            this.zipData.put(zipEntry.getName(), IOUtils.toByteArray((InputStream)zipInputStream));
            SimpleLog.log(SimpleLog.logtype.DEBUG, "loading " + zipEntry.getName(), null);
        }
        return this;
    }

    @JSFunction
    public Object list(Object object) throws IOException {
        Object object222;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        if (object != null && !(object instanceof Undefined) && object instanceof String) {
            object3 = new ZipInputStream(new FileInputStream((String)object));
            object222 = null;
            do {
                if ((object222 = ((ZipInputStream)object3).getNextEntry()) == null) continue;
                map.put(((ZipEntry)object222).getName(), object222);
            } while (object222 != null);
            ((ZipInputStream)object3).close();
        } else {
            map = this.zipEntries;
        }
        for (Object object222 : map.keySet()) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("name", ((ZipEntry)map.get(object222)).getName());
            hashMap2.put("size", (String)((Object)Long.valueOf(((ZipEntry)map.get(object222)).getSize())));
            hashMap2.put("compressedSize", (String)((Object)Long.valueOf(((ZipEntry)map.get(object222)).getCompressedSize())));
            hashMap2.put("comment", ((ZipEntry)map.get(object222)).getComment());
            hashMap2.put("crc", (String)((Object)Long.valueOf(((ZipEntry)map.get(object222)).getCrc())));
            hashMap2.put("time", (String)((Object)Long.valueOf(((ZipEntry)map.get(object222)).getTime())));
            hashMap.put(((ZipEntry)map.get(object222)).getName(), hashMap2);
        }
        object3 = (Context)AFCmdBase.jse.enterContext();
        object222 = object3.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        for (Map.Entry entry : hashMap.entrySet()) {
            Scriptable scriptable = object3.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                scriptable.put((String)entry2.getKey(), scriptable, entry2.getValue());
            }
            object222.put((String)entry.getKey(), (Scriptable)object222, (Object)scriptable);
        }
        AFCmdBase.jse.exitContext();
        return object222;
    }

    @JSFunction
    public ZIP loadFile(String string) throws IOException {
        this.clean();
        this.zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            SimpleLog.log(SimpleLog.logtype.DEBUG, "loading " + zipEntry.getName(), null);
            this.zipEntries.put(zipEntry.getName(), zipEntry);
        }
        return this;
    }

    @JSFunction
    public Object getCompressOutputStream(Object object, String string) throws CompressorException {
        return new CompressorStreamFactory().createCompressorOutputStream(string, (OutputStream)object);
    }

    @JSFunction
    public Object getArchiveInputStream(Object object) throws ArchiveException {
        return new ArchiveStreamFactory().createArchiveInputStream((InputStream)object);
    }

    @JSFunction
    public Object getCompressInputStream(Object object) throws CompressorException {
        return new CompressorStreamFactory().createCompressorInputStream((InputStream)object);
    }
}

