/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class Threads
extends ScriptableObject {
    private static final long serialVersionUID = -7619794920784767023L;
    protected ExecutorService executor;
    protected List<ScriptFunction> threads;
    protected HashMap<String, Object> sessions = new HashMap();

    public String getClassName() {
        return "Threads";
    }

    @JSFunction
    public Object getThreads() {
        return this.threads;
    }

    @JSFunction
    public Object getExecutorService() {
        return this.executor;
    }

    @JSConstructor
    public void newThread() {
        this.threads = Collections.synchronizedList(new ArrayList(new ArrayList()));
    }

    @JSFunction
    public int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    @JSFunction
    public void addOpenAFShutdownHook(final NativeFunction nativeFunction) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Context context = (Context)AFCmdBase.jse.enterContext();
                    nativeFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[0]);
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    AFCmdBase.jse.exitContext();
                }
            }
        }));
    }

    @JSFunction
    public String addThread(NativeFunction nativeFunction) {
        UUID uUID = UUID.randomUUID();
        this.threads.add(new ScriptFunction(this, uUID, nativeFunction));
        return uUID.toString();
    }

    @JSFunction
    public void start() throws InterruptedException {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
            this.executor.invokeAll(this.threads);
        }
    }

    @JSFunction
    public void startNoWait() throws InterruptedException, ExecutionException {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
            for (Runnable runnable : this.threads) {
                this.executor.execute(runnable);
            }
        }
    }

    @JSFunction
    public void startAtFixedRate(double d) {
        if (this.executor == null) {
            this.executor = Executors.newScheduledThreadPool(this.threads.size());
            for (Runnable runnable : this.threads) {
                ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(runnable, 0L, Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @JSFunction
    public void startWithFixedRate(double d) {
        if (this.executor == null) {
            this.executor = Executors.newScheduledThreadPool(this.threads.size());
            for (Runnable runnable : this.threads) {
                ((ScheduledExecutorService)this.executor).scheduleWithFixedDelay(runnable, 0L, Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @JSFunction
    public void initCachedThreadPool() {
        this.executor = Executors.newCachedThreadPool();
    }

    @JSFunction
    public void initScheduledThreadPool(int n) {
        if (this.executor == null) {
            if (n < 1) {
                n = this.getNumberOfCores();
            }
            this.executor = Executors.newScheduledThreadPool(n);
        }
    }

    @JSFunction
    public void initFixedThreadPool(int n) {
        if (this.executor == null) {
            if (n < 1) {
                n = this.getNumberOfCores();
            }
            this.executor = Executors.newFixedThreadPool(n);
        }
    }

    @JSFunction
    public void initSingleThreadPool() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    @JSFunction
    public void initVirtualThreadPerTaskExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newVirtualThreadPerTaskExecutor();
        }
    }

    @JSFunction
    public String addVirtualThread(NativeFunction nativeFunction) {
        if (this.executor == null) {
            this.initVirtualThreadPerTaskExecutor();
        }
        UUID uUID = UUID.randomUUID();
        this.executor.execute(new ScriptFunction(this, uUID, nativeFunction));
        return uUID.toString();
    }

    @JSFunction
    public String addScheduleThread(NativeFunction nativeFunction, double d) {
        if (this.executor == null) {
            this.initScheduledThreadPool(this.getNumberOfCores());
        }
        UUID uUID = UUID.randomUUID();
        ((ScheduledExecutorService)this.executor).schedule(new ScriptFunction(this, uUID, nativeFunction), Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
        return uUID.toString();
    }

    @JSFunction
    public String addCachedThread(NativeFunction nativeFunction) {
        if (this.executor == null) {
            this.initCachedThreadPool();
        }
        UUID uUID = UUID.randomUUID();
        this.executor.execute(new ScriptFunction(this, uUID, nativeFunction));
        return uUID.toString();
    }

    @JSFunction
    public String addFixedThread(NativeFunction nativeFunction) throws Exception {
        if (this.executor == null) {
            throw new Exception("Please use initFixedThreadPool first.");
        }
        UUID uUID = UUID.randomUUID();
        this.executor.execute(new ScriptFunction(this, uUID, nativeFunction));
        return uUID.toString();
    }

    @JSFunction
    public String addSingleThread(NativeFunction nativeFunction) {
        if (this.executor == null) {
            this.initSingleThreadPool();
        }
        UUID uUID = UUID.randomUUID();
        this.executor.execute(new ScriptFunction(this, uUID, nativeFunction));
        return uUID.toString();
    }

    @JSFunction
    public String addScheduleThreadAtFixedRate(NativeFunction nativeFunction, double d) {
        if (this.executor == null) {
            this.initScheduledThreadPool(this.getNumberOfCores());
        }
        UUID uUID = UUID.randomUUID();
        ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(new ScriptFunction(this, uUID, nativeFunction), 0L, Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
        return uUID.toString();
    }

    @JSFunction
    public String addScheduleThreadWithFixedDelay(NativeFunction nativeFunction, double d) {
        if (this.executor == null) {
            this.initScheduledThreadPool(this.getNumberOfCores());
        }
        UUID uUID = UUID.randomUUID();
        ((ScheduledExecutorService)this.executor).scheduleWithFixedDelay(new ScriptFunction(this, uUID, nativeFunction), 0L, Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
        return uUID.toString();
    }

    @JSFunction
    public void stop(boolean bl) {
        if (this.executor != null) {
            if (bl) {
                this.executor.shutdownNow();
            } else {
                this.executor.shutdown();
            }
        }
    }

    @JSFunction
    public boolean waitForThreads(double d) throws InterruptedException {
        if (this.executor != null) {
            return this.executor.awaitTermination(Double.valueOf(d).longValue(), TimeUnit.MILLISECONDS);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void sync(NativeFunction nativeFunction) {
        if (this.executor == null) {
            return;
        }
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            Context context = (Context)AFCmdBase.jse.enterContext();
            try {
                nativeFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[0]);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }
    }

    public class ScriptFunction
    implements Callable<Boolean>,
    Runnable {
        protected NativeFunction aFunction;
        protected UUID uuid;

        public ScriptFunction(Threads threads, UUID uUID, NativeFunction nativeFunction) {
            this.aFunction = nativeFunction;
            this.uuid = uUID;
        }

        @Override
        public Boolean call() throws Exception {
            Context context = (Context)AFCmdBase.jse.enterContext();
            try {
                this.aFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{this.uuid.toString()});
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
            return true;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception exception) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Thread exception: " + exception.getMessage(), exception);
            }
        }
    }
}

