/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.SftpStatVFS;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Vector;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class SSH
extends ScriptableObject {
    private static final long serialVersionUID = 6884178680852808569L;
    protected String login;
    protected String host;
    protected String password;
    protected int port;
    protected Session session;
    protected String identity = null;
    protected boolean compression = false;
    public boolean strictHostKeyChecking = true;
    protected JSch jsch;
    protected int timeout = -1;
    protected Channel sftpChannel;
    protected Channel execChannel;

    public String getClassName() {
        return "SSH";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JSConstructor
    public void newSSH(String string, int n, String string2, String string3, Object object, boolean bl, int n2, boolean bl2) throws Exception {
        if (string.toLowerCase().startsWith("ssh:")) {
            URI uRI = new URI(string);
            if (!uRI.getScheme().toLowerCase().equals("ssh")) throw new Exception("Host or SSH url not correct.");
            this.port = uRI.getPort();
            if (uRI.getUserInfo().indexOf(":") >= 0) {
                this.login = AFCmdBase.afc.dIP(uRI.getUserInfo().split(":")[0]);
                this.password = AFCmdBase.afc.dIP(uRI.getUserInfo().split(":")[1]);
            } else {
                this.login = AFCmdBase.afc.dIP(uRI.getUserInfo());
                this.password = "";
            }
            this.identity = uRI.getPath();
            if (uRI.getQuery() != null) {
                String[] stringArray;
                block8: for (String string4 : stringArray = uRI.getQuery().split("&")) {
                    switch (string4.toLowerCase().split("=")[0]) {
                        case "timeout": {
                            this.setTimeout(Integer.valueOf(string4.toLowerCase().split("=")[1]));
                            continue block8;
                        }
                        case "compression": {
                            this.compression = Boolean.getBoolean(string4.toLowerCase().split("=")[1]);
                        }
                    }
                }
            }
            this.host = uRI.getHost();
            if (this.port <= 0) {
                this.port = 22;
            }
        } else {
            this.login = AFCmdBase.afc.dIP(string2);
            this.host = string;
            this.password = AFCmdBase.afc.dIP(string3);
            this.port = n;
            this.identity = null;
            if (object instanceof String && ((String)object).length() > 0) {
                this.identity = (String)object;
            }
            this.compression = bl;
            if (n2 > 0) {
                this.setTimeout(n2);
            }
        }
        this.strictHostKeyChecking = !bl2;
        this.connectSSH();
    }

    @JSFunction
    public Object exec(String string, String string2, boolean bl, boolean bl2, boolean bl3, Object object) throws JSchException, IOException {
        return this.executeSSH(string, string2, bl, bl2, bl3, object);
    }

    @JSFunction
    public Object execSudo(String string, Object object, String string2, boolean bl, boolean bl2, boolean bl3, Object object2) throws JSchException, IOException {
        String string3 = "";
        if (object != null && object instanceof Undefined) {
            string3 = AFCmdBase.afc.dIP((String)object);
        }
        if (this.identity == null) {
            return this.executeSSH("echo " + AFCmdBase.afc.dIP(this.password) + " | sudo -i -u " + String.valueOf(object) + " -S /bin/sh -c '" + string + "'", string2, bl, bl2, bl3, object2);
        }
        return this.executeSSH("sudo -i -u " + String.valueOf(object) + " -S /bin/sh -c '" + string + "'", string2, bl, bl2, bl3, object2);
    }

    @JSFunction
    public void close() {
        if (this.sftpChannel != null && this.sftpChannel.isConnected()) {
            this.sftpChannel.disconnect();
        }
        if (this.execChannel != null && this.execChannel.isConnected()) {
            this.execChannel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @JSFunction
    public void setTimeout(int n) throws JSchException {
        this.timeout = n;
        if (this.session != null) {
            this.session.setTimeout(n);
        }
    }

    protected void connectSSH() throws JSchException, IOException {
        if (SimpleLog.getCurrentLogLevel() == SimpleLog.logtype.DEBUG) {
            JSch.setLogger((Logger)new SSHLogger());
        }
        this.jsch = new JSch();
        if (this.identity != null && this.identity.length() > 0) {
            this.jsch.addIdentity(this.identity);
        }
        this.session = this.jsch.getSession(this.login, this.host, this.port);
        this.session.setUserInfo((UserInfo)new SUserInfo(this.password));
        if (this.timeout > 0) {
            this.session.setTimeout(this.timeout);
        }
        if (this.compression) {
            this.session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
            this.session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
            this.session.setConfig("compression_level", "9");
        }
        if (!this.strictHostKeyChecking) {
            this.session.setConfig("StrictHostKeyChecking", "no");
        }
        this.session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        this.session.connect();
        this.execChannel = null;
        this.sftpChannel = null;
    }

    @JSFunction
    public Object getJsch() {
        return this.jsch;
    }

    @JSFunction
    public Object getSession() {
        return this.session;
    }

    @JSFunction
    public boolean isConnected() throws Exception {
        if (this.session == null) {
            return false;
        }
        return this.session.isConnected();
    }

    @JSFunction
    public void sendKeepAlive() throws Exception {
        if (this.session != null) {
            this.session.sendKeepAliveMsg();
        }
    }

    @JSFunction
    public void tunnelLocal(int n, String string, int n2) throws JSchException {
        this.session.setPortForwardingL(n, string, n2);
    }

    @JSFunction
    public void delTunnelLocal(String string, int n) throws JSchException {
        this.session.delPortForwardingL(string, n);
    }

    @JSFunction
    public void tunnelLocalBind(String string, int n, String string2, int n2) throws JSchException {
        this.session.setPortForwardingL(string, n, string2, n2);
    }

    @JSFunction
    public void tunnelRemote(int n, String string, int n2) throws JSchException {
        this.session.setPortForwardingR(n, string, n2);
    }

    @JSFunction
    public void delTunnelRemote(String string, int n) throws JSchException {
        this.session.delPortForwardingR(string, n);
    }

    @JSFunction
    public void tunnelRemoteBind(String string, int n, String string2, int n2) throws JSchException {
        this.session.setPortForwardingR(string, n, string2, n2);
    }

    @JSFunction
    public Object getSftpChannel() throws JSchException {
        if (this.sftpChannel == null) {
            this.sftpChannel = this.session.openChannel("sftp");
            this.sftpChannel.connect();
        }
        return this.sftpChannel;
    }

    @JSFunction
    public Object getExecChannel() throws JSchException {
        if (this.execChannel == null) {
            this.execChannel = this.session.openChannel("exec");
            this.execChannel.connect();
        }
        return this.execChannel;
    }

    @JSFunction
    public void rename(String string, String string2) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null) {
            channelSftp.rename(string, string2);
        }
    }

    @JSFunction
    public void rm(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null) {
            channelSftp.rm(string);
        }
    }

    @JSFunction
    public void rmdir(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null) {
            channelSftp.rmdir(string);
        }
    }

    @JSFunction
    public String pwd() throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        String string = null;
        if (channelSftp != null) {
            string = channelSftp.pwd();
        }
        return string;
    }

    @JSFunction
    public String get(String string, String string2, Object object) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        String string3 = null;
        if (string2 == null) {
            string2 = string;
        }
        if (channelSftp != null) {
            if (object != null && !(object instanceof Undefined)) {
                channelSftp.get(string, string2, (SftpProgressMonitor)((NativeJavaObject)object).unwrap());
            } else {
                channelSftp.get(string, string2);
            }
        }
        return string3;
    }

    @JSFunction
    public Object getBytes(String string, Object object) throws JSchException, IOException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        byte[] byArray = null;
        if (channelSftp != null) {
            if (object != null && !(object instanceof Undefined)) {
                try (InputStream inputStream = channelSftp.get(string, (SftpProgressMonitor)((NativeJavaObject)object).unwrap());){
                    byArray = IOUtils.toByteArray((InputStream)inputStream);
                }
            }
            try (InputStream inputStream = channelSftp.get(string);){
                byArray = IOUtils.toByteArray((InputStream)inputStream);
            }
        }
        return byArray;
    }

    @JSFunction
    public void putBytes(String string, Object object, Object object2) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null && object instanceof byte[]) {
            if (object2 != null && !(object2 instanceof Undefined)) {
                channelSftp.put((InputStream)new ByteArrayInputStream((byte[])object), string, (SftpProgressMonitor)((NativeJavaObject)object2).unwrap());
            } else {
                channelSftp.put((InputStream)new ByteArrayInputStream((byte[])object), string);
            }
        }
    }

    @JSFunction
    public void put(String string, String string2, Object object) throws JSchException, IOException, FileNotFoundException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        Object var5_5 = null;
        if (string2 == null) {
            string2 = string;
        }
        if (channelSftp != null) {
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                if (object != null && !(object instanceof Undefined)) {
                    channelSftp.put((InputStream)fileInputStream, string2, (SftpProgressMonitor)((NativeJavaObject)object).unwrap());
                } else {
                    channelSftp.put((InputStream)fileInputStream, string2);
                }
            }
        }
    }

    @JSFunction
    public void cd(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null) {
            channelSftp.cd(string);
        }
    }

    @JSFunction
    public Object df(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        Scriptable scriptable = (Scriptable)AFCmdBase.jse.newObject(AFCmdBase.jse.getGlobalscope());
        string = string == null || string.length() < 1 ? "." : string.replaceAll("/+", "/");
        if (channelSftp != null) {
            SftpStatVFS sftpStatVFS = channelSftp.statVFS(string);
            scriptable.put("size", scriptable, (Object)sftpStatVFS.getSize());
            scriptable.put("used", scriptable, (Object)sftpStatVFS.getUsed());
            scriptable.put("available", scriptable, (Object)sftpStatVFS.getAvailForNonRoot());
            scriptable.put("availableForRoot", scriptable, (Object)sftpStatVFS.getAvail());
            scriptable.put("capacityPerc", scriptable, (Object)sftpStatVFS.getCapacity());
        }
        return scriptable;
    }

    @JSFunction
    public void mkdir(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (channelSftp != null) {
            channelSftp.mkdir(string);
        }
    }

    @JSFunction
    public Object listFiles(Object object) throws SftpException, JSchException {
        Vector vector;
        ChannelSftp channelSftp = null;
        Scriptable scriptable = (Scriptable)AFCmdBase.jse.newObject(AFCmdBase.jse.getGlobalscope());
        ArrayList<Scriptable> arrayList = new ArrayList<Scriptable>();
        channelSftp = (ChannelSftp)this.getSftpChannel();
        String string = object == null || !(object instanceof String) ? "." : ((String)object).replaceAll("/+", "/");
        if (channelSftp != null && (vector = channelSftp.ls(string)) != null) {
            for (Object e : vector) {
                if (!(e instanceof ChannelSftp.LsEntry)) continue;
                Scriptable scriptable2 = (Scriptable)AFCmdBase.jse.newObject(scriptable);
                ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)e;
                if (lsEntry.getFilename().equals(".") || lsEntry.getFilename().equals("..")) continue;
                scriptable2.put("filename", scriptable2, (Object)lsEntry.getFilename());
                scriptable2.put("longname", scriptable2, (Object)lsEntry.getLongname());
                scriptable2.put("filepath", scriptable2, (Object)(string + "/" + lsEntry.getFilename()));
                scriptable2.put("size", scriptable2, (Object)lsEntry.getAttrs().getSize());
                scriptable2.put("permissions", scriptable2, (Object)lsEntry.getAttrs().getPermissionsString());
                scriptable2.put("lastModified", scriptable2, (Object)lsEntry.getAttrs().getMTime());
                scriptable2.put("createTime", scriptable2, (Object)lsEntry.getAttrs().getATime());
                scriptable2.put("isDirectory", scriptable2, (Object)lsEntry.getAttrs().isDir());
                scriptable2.put("isFile", scriptable2, (Object)(!lsEntry.getAttrs().isDir() ? 1 : 0));
                arrayList.add(scriptable2);
            }
            scriptable.put("files", scriptable, AFCmdBase.jse.newArray(scriptable, arrayList.toArray()));
        }
        return scriptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeSSH(String string, String string2, boolean bl, boolean bl2, boolean bl3, Object object) throws JSchException, IOException {
        Channel channel = null;
        String string3 = null;
        String string4 = "";
        Object object2 = null;
        channel = this.session.openChannel("exec");
        if (channel != null) {
            Object object3;
            ChannelExec channelExec = (ChannelExec)channel;
            channelExec.setCommand(string);
            channelExec.connect();
            channelExec.setPty(bl2);
            if (string2 != null && !string2.equals("undefined")) {
                object3 = channelExec.getOutputStream();
                ((OutputStream)object3).write(string2.getBytes());
                ((OutputStream)object3).close();
            }
            if (channel.isConnected()) {
                object3 = new StringBuilder();
                if (object != null && object instanceof Function) {
                    Context context = (Context)AFCmdBase.jse.enterContext();
                    try {
                        ((Function)object).call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{channelExec.getInputStream(), channelExec.getErrStream(), channelExec.getOutputStream()});
                    }
                    finally {
                        if (object != null) {
                            AFCmdBase.jse.exitContext();
                        }
                    }
                } else {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(channelExec.getInputStream()));
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(channelExec.getErrStream()));
                    String string5 = bufferedReader.readLine();
                    while (string5 != null) {
                        ((StringBuilder)object3).append(string5);
                        ((StringBuilder)object3).append("\n");
                        if (bl) {
                            System.out.println(string5);
                        }
                        string5 = bufferedReader.readLine();
                    }
                    string3 = ((StringBuilder)object3).toString();
                    object3 = new StringBuilder();
                    string5 = bufferedReader2.readLine();
                    while (string5 != null) {
                        ((StringBuilder)object3).append(string5);
                        ((StringBuilder)object3).append("\n");
                        if (bl) {
                            System.err.println(string5);
                        }
                        string5 = bufferedReader2.readLine();
                    }
                    string4 = ((StringBuilder)object3).toString();
                    bufferedReader.close();
                }
            }
            if (bl3) {
                object3 = AFCmdBase.jse.getNewMap(null);
                object3.put("stdout", string3);
                object3.put("stderr", string4);
                object3.put("exitcode", channelExec.getExitStatus());
                object2 = object3.getMap();
            } else {
                object3 = (Context)AFCmdBase.jse.enterContext();
                object3.evaluateString((Scriptable)AFCmdBase.jse.getGlobalscope(), "__exitcode = " + channelExec.getExitStatus() + ";", "af", 1, null);
                ScriptableObject.putProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__stderr", (Object)string4);
                AFCmdBase.jse.exitContext();
                object2 = string3;
            }
        }
        return object2;
    }

    static int checkAck(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            do {
                n2 = inputStream.read();
                stringBuilder.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                System.out.print(stringBuilder.toString());
            }
            if (n == 2) {
                System.out.print(stringBuilder.toString());
            }
        }
        return n;
    }

    @JSFunction
    public void sendFile(String string, String string2) throws JSchException, IOException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        try {
            int n;
            String string3 = "scp " + (bl ? "-p" : "") + " -t " + string2;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(string3);
            OutputStream outputStream = channel.getOutputStream();
            InputStream inputStream = channel.getInputStream();
            if (SSH.checkAck(inputStream) != 0) {
                return;
            }
            File file = new File(string);
            if (bl) {
                string3 = "T " + file.lastModified() / 1000L + " 0";
                string3 = string3 + " " + file.lastModified() / 1000L + " 0\n";
                outputStream.write(string3.getBytes());
                outputStream.flush();
                if (SSH.checkAck(inputStream) != 0) {
                    return;
                }
            }
            long l = file.length();
            string3 = "C0644 " + l + " ";
            string3 = string.lastIndexOf(47) > 0 ? string3 + string.substring(string.lastIndexOf(47) + 1) : string3 + string;
            string3 = string3 + "\n";
            outputStream.write(string3.getBytes());
            outputStream.flush();
            if (SSH.checkAck(inputStream) != 0) {
                return;
            }
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileInputStream = null;
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            if (SSH.checkAck(inputStream) != 0) {
                return;
            }
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JSFunction
    public Object sftpGet(String string, String string2, Object object) throws SftpException, JSchException, IOException {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (string2 == null) {
            string2 = string;
        }
        if (object != null && !(object instanceof Undefined)) {
            if (string2 != null && !string2.equals("") && !string2.endsWith("undefined")) {
                channelSftp.get(string, string2, (SftpProgressMonitor)((NativeJavaObject)object).unwrap());
                return string;
            }
            try (InputStream inputStream = channelSftp.get(string, (SftpProgressMonitor)((NativeJavaObject)object).unwrap());){
                InputStream inputStream2 = IOUtils.toBufferedInputStream((InputStream)inputStream);
                return inputStream2;
            }
        }
        if (string2 != null && !string2.equals("") && !string2.endsWith("undefined")) {
            channelSftp.get(string, string2);
            return string;
        }
        try (InputStream inputStream = channelSftp.get(string);){
            InputStream inputStream3 = IOUtils.toBufferedInputStream((InputStream)inputStream);
            return inputStream3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JSFunction
    public void sftpPut(Object object, String string, Object object2) throws Exception {
        ChannelSftp channelSftp = (ChannelSftp)this.getSftpChannel();
        if (object2 != null && !(object2 instanceof Undefined)) {
            if (object instanceof String) {
                channelSftp.put((String)object, string, (SftpProgressMonitor)((NativeJavaObject)object2).unwrap());
                return;
            } else {
                if (object instanceof NativeJavaObject) {
                    object = ((NativeJavaObject)object).unwrap();
                }
                if (!(object instanceof InputStream)) throw new Exception("Expecting a string source file name or a Java Input stream as source");
                try (OutputStream outputStream = channelSftp.put(string, (SftpProgressMonitor)((NativeJavaObject)object2).unwrap(), 0);){
                    IOUtils.copyLarge((InputStream)((InputStream)object), (OutputStream)outputStream);
                    return;
                }
            }
        }
        if (object instanceof String) {
            channelSftp.put((String)object, string);
            return;
        }
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        if (!(object instanceof InputStream)) throw new Exception("Expecting a string source file name or a Java Input stream as source");
        try (OutputStream outputStream = channelSftp.put(string);){
            IOUtils.copyLarge((InputStream)((InputStream)object), (OutputStream)outputStream);
            return;
        }
    }

    @JSFunction
    public byte[] getFile(String string, String string2) throws JSchException, IOException {
        if (string2 != null && !string2.equals("") && !string2.endsWith("undefined")) {
            return this.getSSHFile(string, string2, true);
        }
        return this.getSSHFile(string, string2, false);
    }

    public byte[] getSSHFile(String string, String string2, boolean bl) throws JSchException, IOException {
        OutputStream outputStream = null;
        byte[] byArray = null;
        try {
            int n;
            String string3 = null;
            if (bl && new File(string2).isDirectory()) {
                string3 = string2 + File.separator;
            }
            String string4 = "scp -f " + string;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(string4);
            OutputStream outputStream2 = channel.getOutputStream();
            InputStream inputStream = channel.getInputStream();
            if (!channel.isConnected()) {
                channel.connect();
            }
            byte[] byArray2 = new byte[1024];
            byArray2[0] = 0;
            outputStream2.write(byArray2, 0, 1);
            outputStream2.flush();
            while ((n = SSH.checkAck(inputStream)) == 67) {
                inputStream.read(byArray2, 0, 5);
                long l = 0L;
                while (inputStream.read(byArray2, 0, 1) >= 0 && byArray2[0] != 32) {
                    l = l * 10L + (long)(byArray2[0] - 48);
                }
                String string5 = null;
                int n2 = 0;
                while (true) {
                    inputStream.read(byArray2, n2, 1);
                    if (byArray2[n2] == 10) break;
                    ++n2;
                }
                string5 = new String(byArray2, 0, n2);
                byArray2[0] = 0;
                outputStream2.write(byArray2, 0, 1);
                outputStream2.flush();
                outputStream = bl ? new FileOutputStream((String)(string3 == null ? string2 : string3 + string5)) : new ByteArrayOutputStream();
                do {
                    n2 = (long)byArray2.length < l ? byArray2.length : (int)l;
                    if ((n2 = inputStream.read(byArray2, 0, n2)) < 0) break;
                    outputStream.write(byArray2, 0, n2);
                } while ((l -= (long)n2) != 0L);
                outputStream.flush();
                if (!bl) {
                    byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                }
                outputStream.close();
                outputStream = null;
                if (SSH.checkAck(inputStream) != 0) {
                    return byArray;
                }
                byArray2[0] = 0;
                outputStream2.write(byArray2, 0, 1);
                outputStream2.flush();
            }
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        return byArray;
    }

    public static class SSHLogger
    implements Logger {
        public boolean isEnabled(int n) {
            return true;
        }

        public void log(int n, String string) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "SSH: " + string, null);
        }
    }

    public static class SUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        protected String passwd;

        public SUserInfo(String string) {
            this.passwd = string;
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            return null;
        }

        public String getPassphrase() {
            return this.passwd;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public void showMessage(String string) {
        }
    }
}

