/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.TransportMappings;

public class SNMPServer
extends ScriptableObject {
    private static final long serialVersionUID = -3002319922538972994L;
    protected Snmp snmp;
    protected String address;
    protected OctetString community;
    protected SNMPAgent agent;
    public static Map<String, NativeFunction> callbacks = new ConcurrentHashMap<String, NativeFunction>();

    public static MOColumn[] getMOColumns() {
        ArrayList<MOColumn> arrayList = new ArrayList<MOColumn>();
        for (int i = 1; i <= 9; ++i) {
            MOColumn mOColumn = new MOColumn(i, 4);
            arrayList.add(mOColumn);
        }
        return (MOColumn[])arrayList.toArray();
    }

    public static Variable execFunc(String string) {
        NativeFunction nativeFunction = callbacks.get(string);
        Object object = null;
        if (nativeFunction != null) {
            Context context = (Context)AFCmdBase.jse.enterContext();
            try {
                object = nativeFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{string});
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }
        if (object == null || object instanceof Undefined) {
            object = new String("");
        }
        return new OctetString(object.toString());
    }

    public String getClassName() {
        return "SNMPd";
    }

    @JSConstructor
    public void newSNMPd(String string, Object object) {
        this.address = string;
        this.agent = new SNMPAgent(this, string);
        if (object != null && !(object instanceof Undefined)) {
            this.agent.setSysDescr(new OctetString(object.toString()));
        } else {
            this.agent.setSysDescr(new OctetString("OpenAF SNMP server"));
        }
    }

    @JSFunction
    public void start(Object object) throws IOException {
        String string = object == null || object instanceof Undefined ? "public" : object.toString();
        this.agent.start(string);
    }

    @JSFunction
    public void stop() {
        this.agent.stop();
    }

    @JSFunction
    public void addOID(String string, NativeFunction nativeFunction) throws DuplicateRegistrationException {
        if (string != null) {
            this.agent.registerManagedObjects((ManagedObject)new MOJSFunction(this, new OID(string)));
            this.setOID(string, nativeFunction);
        }
    }

    @JSFunction
    public void setOID(String string, NativeFunction nativeFunction) {
        callbacks.put(string, nativeFunction);
    }

    public class SNMPAgent
    extends BaseAgent {
        protected String address;

        protected SNMPAgent(SNMPServer sNMPServer, String string) {
            super(new File("bootCounter.agent"), new File("conf.agent"), new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
            this.address = string;
        }

        protected void addCommunities(SnmpCommunityMIB snmpCommunityMIB) {
            Variable[] variableArray = new Variable[]{new OctetString("public"), new OctetString("cpublic"), this.getAgent().getContextEngineID(), new OctetString("public"), new OctetString(), new Integer32(3), new Integer32(1)};
            MOTableRow mOTableRow = snmpCommunityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), variableArray);
            snmpCommunityMIB.getSnmpCommunityEntry().addRow((MOTableRow)((SnmpCommunityMIB.SnmpCommunityEntryRow)mOTableRow));
        }

        protected void addNotificationTargets(SnmpTargetMIB snmpTargetMIB, SnmpNotificationMIB snmpNotificationMIB) {
        }

        protected void addUsmUser(USM uSM) {
        }

        protected void addViews(VacmMIB vacmMIB) {
            vacmMIB.addGroup(2, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
            vacmMIB.addAccess(new OctetString("v1v2group"), new OctetString("public"), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
            vacmMIB.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        }

        protected void registerManagedObjects() {
        }

        public void registerManagedObjects(ManagedObject managedObject) throws DuplicateRegistrationException {
            this.server.register(managedObject, null);
        }

        public void unregisterManagedObject(MOGroup mOGroup) {
            mOGroup.unregisterMOs((MOServer)this.server, this.getContext(mOGroup));
        }

        protected void unregisterManagedObjects() {
        }

        protected void initTransportMappings() throws IOException {
            TransportMapping transportMapping;
            SimpleLog.log(SimpleLog.logtype.DEBUG, "SNMPd: Starting server at " + this.address, null);
            this.transportMappings = new TransportMapping[1];
            Address address = GenericAddress.parse((String)this.address);
            this.transportMappings[0] = transportMapping = TransportMappings.getInstance().createTransportMapping(address);
        }

        public void start(String string) throws IOException {
            this.init();
            if (string == null) {
                string = new String("public");
            }
            this.addShutdownHook();
            this.getServer().addContext(new OctetString(string));
            this.finishInit();
            this.run();
            this.sendColdStartNotification();
        }
    }

    public class MOJSFunction
    extends MOScalar {
        OID oid;
        protected MOColumn[] values;

        public MOJSFunction(SNMPServer sNMPServer, OID oID) {
            super(oID, MOAccessImpl.ACCESS_READ_ONLY, SNMPServer.execFunc(oID.toString()));
            this.oid = oID;
        }

        public Variable getValue() {
            return SNMPServer.execFunc(this.oid.toString());
        }
    }
}

