/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMP
extends ScriptableObject {
    private static final long serialVersionUID = 9163133329817783828L;
    protected Snmp snmp;
    protected String address;
    protected long timeout;
    protected int retries;
    protected OctetString community;
    protected String securityName;
    protected OID authProtocol = AuthSHA.ID;
    protected String authPassphrase;
    protected OID privProtocol = PrivDES.ID;
    protected String privPassphrase;
    protected int version;
    protected byte[] engineID;
    protected TransportMapping<?> transport;

    public String getClassName() {
        return "SNMP";
    }

    @JSConstructor
    public void newSNMP(String string, String string2, int n, int n2, int n3, Object object) throws Exception {
        NativeObject nativeObject;
        if (string == null) {
            throw new Exception("No address was provided.");
        }
        this.address = string;
        this.timeout = n <= 0 ? 1500L : (long)n;
        this.retries = n2 <= 0 ? 2 : n2;
        this.community = string2 != null ? new OctetString(string2) : new OctetString("public");
        this.version = n3 <= 1 ? 2 : n3;
        if (n3 >= 2 && object instanceof NativeObject) {
            nativeObject = (NativeObject)object;
            if (nativeObject.containsKey((Object)"securityName")) {
                this.securityName = (String)nativeObject.get((Object)"securityName");
            }
            if (nativeObject.containsKey((Object)"engineId")) {
                Object object2 = new BigInteger((String)nativeObject.get((Object)"engineId"), 16).toByteArray();
                object2 = Arrays.copyOfRange((byte[])object2, 1, ((Object)object2).length);
                this.engineID = (byte[])object2;
            }
        }
        if (n3 >= 3 && object instanceof NativeObject) {
            nativeObject = (NativeObject)object;
            if (nativeObject.containsKey((Object)"authProtocol")) {
                switch ((String)nativeObject.get((Object)"authProtocol")) {
                    case "HMAC128SHA224": {
                        this.authProtocol = AuthHMAC128SHA224.ID;
                        break;
                    }
                    case "HMAC192SHA256": {
                        this.authProtocol = AuthHMAC192SHA256.ID;
                        break;
                    }
                    case "HMAC256SHA384": {
                        this.authProtocol = AuthHMAC256SHA384.ID;
                        break;
                    }
                    case "HMAC384SHA512": {
                        this.authProtocol = AuthHMAC384SHA512.ID;
                        break;
                    }
                    case "MD5": {
                        this.authProtocol = AuthMD5.ID;
                        break;
                    }
                    case "SHA": {
                        this.authProtocol = AuthSHA.ID;
                        break;
                    }
                    default: {
                        throw new Exception("SNMP Auth protocol '" + (String)nativeObject.get((Object)"authProtocol") + "' not supported (supported: HMAC128SHA224, HMAC192SHA256, HMAC256SHA384, HMAC384SHA51, MD5, SHA)");
                    }
                }
            }
            if (nativeObject.containsKey((Object)"privProtocol")) {
                switch ((String)nativeObject.get((Object)"privProtocol")) {
                    case "3DES": {
                        this.privProtocol = Priv3DES.ID;
                        break;
                    }
                    case "AES128": {
                        this.privProtocol = PrivAES128.ID;
                        break;
                    }
                    case "AES192": {
                        this.privProtocol = PrivAES192.ID;
                        break;
                    }
                    case "AES256": {
                        this.privProtocol = PrivAES256.ID;
                        break;
                    }
                    case "DES": {
                        this.privProtocol = PrivDES.ID;
                        break;
                    }
                    default: {
                        throw new Exception("SNMP Priv protocol '" + (String)nativeObject.get((Object)"privProtocol") + "' not supported (supported: 3DES, AES128, AES192, AES256, DES)");
                    }
                }
            }
            if (nativeObject.containsKey((Object)"authPassphrase")) {
                this.authPassphrase = AFCmdBase.afc.dIP((String)nativeObject.get((Object)"authPassphrase"));
            }
            if (nativeObject.containsKey((Object)"privPassphrase")) {
                this.privPassphrase = AFCmdBase.afc.dIP((String)nativeObject.get((Object)"privPassphrase"));
            }
        }
        this.start();
    }

    @JSFunction
    public void start() throws IOException {
        if (this.snmp != null) {
            this.snmp.close();
        }
        if (this.transport != null) {
            this.transport.close();
        }
        this.transport = this.address.startsWith("tcp") ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        if (this.version >= 3) {
            if (this.engineID == null) {
                this.engineID = MPv3.createLocalEngineID();
            }
            USM uSM = new USM(SecurityProtocols.getInstance(), new OctetString(this.engineID), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)uSM);
            UsmUser usmUser = new UsmUser(new OctetString(this.securityName), this.authProtocol, new OctetString(this.authPassphrase), this.privProtocol, new OctetString(this.privPassphrase));
            this.snmp.getUSM().addUser(usmUser);
            this.snmp.setLocalEngine(new OctetString(this.engineID).getValue(), 0, 0);
        }
        this.transport.listen();
    }

    @JSFunction
    public void close() {
        try {
            this.snmp.close();
            this.transport.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @JSFunction
    public Object getJavaObject() {
        return this.snmp;
    }

    protected Target getTarget() {
        UserTarget userTarget;
        Address address = GenericAddress.parse((String)this.address);
        if (this.authPassphrase != null || this.privPassphrase != null) {
            userTarget = new UserTarget();
        } else {
            userTarget = new CommunityTarget();
            ((CommunityTarget)userTarget).setCommunity(this.community);
        }
        userTarget.setAddress(address);
        userTarget.setRetries(this.retries);
        userTarget.setTimeout(this.timeout);
        if (this.version == 2) {
            userTarget.setVersion(1);
        }
        if (this.version == 3) {
            userTarget.setVersion(3);
        }
        if (this.securityName != null) {
            userTarget.setSecurityName(new OctetString(this.securityName));
        }
        if (this.authPassphrase != null && this.privPassphrase == null) {
            userTarget.setSecurityLevel(2);
        }
        if (this.authPassphrase != null && this.privPassphrase != null) {
            userTarget.setSecurityLevel(3);
        }
        if (this.authPassphrase == null && this.privPassphrase == null) {
            userTarget.setSecurityLevel(1);
        }
        return userTarget;
    }

    public ResponseEvent getOIDs(OID[] responseEvent) throws IOException {
        Object object = this.version == 3 ? new ScopedPDU() : new PDU();
        for (OID oID : responseEvent) {
            object.add(new VariableBinding(oID));
        }
        object.setType(-96);
        ResponseEvent responseEvent2 = this.snmp.send((PDU)object, this.getTarget(), null);
        if (responseEvent2 != null) {
            return responseEvent2;
        }
        throw new RuntimeException("GET timed out");
    }

    public VariableBinding[] getAsPDU(OID oID) throws Exception {
        ResponseEvent responseEvent = this.getOIDs(new OID[]{oID});
        if (responseEvent != null) {
            if (responseEvent.getError() != null) {
                throw responseEvent.getError();
            }
            SimpleLog.log(SimpleLog.logtype.DEBUG, "SNMP Event " + responseEvent.toString(), null);
            if (responseEvent.getResponse() != null) {
                return responseEvent.getResponse().toArray();
            }
            throw new Exception("SNMP Request timeout");
        }
        SimpleLog.log(SimpleLog.logtype.DEBUG, "SNMP Event null", null);
        return null;
    }

    public OID newOID(String string) {
        return new OID(string);
    }

    @JSFunction
    public Object get(String string) throws Exception {
        VariableBinding[] variableBindingArray = this.getAsPDU(this.newOID(string));
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        if (variableBindingArray != null) {
            for (VariableBinding variableBinding : variableBindingArray) {
                scriptable.put(variableBinding.getOid().toString(), scriptable, (Object)variableBinding.getVariable().toString());
            }
        }
        return scriptable;
    }

    @JSFunction
    public Object trap(String string, double d, Object object, boolean bl) throws IOException {
        Object object2 = this.version >= 3 ? new ScopedPDU() : new PDU();
        if (!bl) {
            object2.setType(-89);
        } else {
            object2.setType(-90);
        }
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        object2.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks((long)d)));
        OID oID = new OID(string);
        object2.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)oID));
        if (object instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)object;
            for (Object e : nativeArray) {
                if (e instanceof NativeObject) {
                    NativeObject nativeObject = (NativeObject)e;
                    if (nativeObject.containsKey((Object)"type") && nativeObject.containsKey((Object)"value") && nativeObject.containsKey((Object)"OID")) {
                        OID oID2 = nativeObject.get((Object)"OID") instanceof String ? new OID((String)nativeObject.get((Object)"OID")) : new OID(((ConsString)nativeObject.get((Object)"OID")).toString());
                        switch ((String)nativeObject.get((Object)"type")) {
                            case "i": {
                                if (nativeObject.get((Object)"value") instanceof Double) {
                                    object2.add(new VariableBinding(oID2, (Variable)new Integer32(((Double)nativeObject.get((Object)"value")).intValue())));
                                    break;
                                }
                                object2.add(new VariableBinding(oID2, (Variable)new Integer32(((Integer)nativeObject.get((Object)"value")).intValue())));
                                break;
                            }
                            case "u": {
                                if (nativeObject.get((Object)"value") instanceof Double) {
                                    object2.add(new VariableBinding(oID2, (Variable)new UnsignedInteger32(((Double)nativeObject.get((Object)"value")).intValue())));
                                    break;
                                }
                                object2.add(new VariableBinding(oID2, (Variable)new UnsignedInteger32(((Integer)nativeObject.get((Object)"value")).intValue())));
                                break;
                            }
                            case "c": {
                                object2.add(new VariableBinding(oID2, (Variable)new Counter32((long)((Integer)nativeObject.get((Object)"value")).intValue())));
                                break;
                            }
                            case "n": {
                                object2.add(new VariableBinding(oID2, (Variable)new Null()));
                                break;
                            }
                            case "o": {
                                object2.add(new VariableBinding(oID2, (Variable)new OID((String)nativeObject.get((Object)"value"))));
                                break;
                            }
                            case "t": {
                                object2.add(new VariableBinding(oID2, (Variable)new TimeTicks((long)((Integer)nativeObject.get((Object)"value")).intValue())));
                                break;
                            }
                            case "a": {
                                object2.add(new VariableBinding(oID2, (Variable)new TimeTicks((long)((Integer)nativeObject.get((Object)"value")).intValue())));
                                break;
                            }
                            case "b": {
                                break;
                            }
                            default: {
                                object2.add(new VariableBinding(oID2, (Variable)new OctetString(nativeObject.get((Object)"value").toString())));
                                break;
                            }
                        }
                        continue;
                    }
                    System.out.println("ERR: doesn't have type, value and OID");
                    continue;
                }
                System.out.println("ERR: Not a native object");
            }
        } else {
            System.out.println("ERR: Not a native array");
        }
        return this.snmp.send((PDU)object2, this.getTarget());
    }

    @JSFunction
    public Object inform(String string, Object object) throws IOException {
        return this.trap(string, 0.0, object, true);
    }
}

