/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.SimpleType;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class JMXServer
extends ScriptableObject {
    private static final long serialVersionUID = 2249818633847061216L;
    protected MXServer mxs;
    protected String name;

    public String getClassName() {
        return "JMXServer";
    }

    @JSConstructor
    public void newJMX(Object object) {
        if (object == null || object instanceof Undefined) {
            object = "com.openaf:type=Values";
        } else {
            this.name = object.toString();
        }
    }

    @JSFunction
    public void start(int n, boolean bl) throws IOException {
        this.mxs = new MXServer(this, n, bl);
    }

    @JSFunction
    public void stop() throws IOException {
        this.mxs.stop();
    }

    @JSFunction
    public long addBean(NativeObject nativeObject, NativeFunction nativeFunction, NativeFunction nativeFunction2, NativeFunction nativeFunction3) throws JMException {
        if (this.mxs != null) {
            DynaMXBean dynaMXBean = new DynaMXBean(this, nativeObject, nativeFunction, nativeFunction2, nativeFunction3);
            this.mxs.addDynaBean(this.name, dynaMXBean);
            return nativeObject.size();
        }
        return 0L;
    }

    @JSFunction
    public long addObjectBean(String string, NativeObject nativeObject, NativeFunction nativeFunction, NativeFunction nativeFunction2, NativeFunction nativeFunction3) throws JMException {
        if (this.mxs != null) {
            DynaMXBean dynaMXBean = new DynaMXBean(this, nativeObject, nativeFunction, nativeFunction2, nativeFunction3);
            this.mxs.addDynaBean(string, dynaMXBean);
            return nativeObject.size();
        }
        return 0L;
    }

    public class MXServer {
        protected MBeanServer mbs;
        protected ConcurrentHashMap<String, ObjectName> objs;
        protected JMXConnectorServer cs;

        public MXServer(JMXServer jMXServer, int n, boolean bl) throws IOException {
            block7: {
                this.objs = new ConcurrentHashMap();
                try {
                    System.setProperty("java.rmi.server.randomIDs", "true");
                    if (n > 0) {
                        if (bl) {
                            LocateRegistry.createRegistry(n, RMISocketFactory.getDefaultSocketFactory(), new RestrictedRMIRegistry(this));
                        } else {
                            LocateRegistry.createRegistry(n);
                        }
                    }
                    this.mbs = ManagementFactory.getPlatformMBeanServer();
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                    if (n <= 0) break block7;
                    try {
                        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + n + "/jmxrmi");
                        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, concurrentHashMap, this.mbs);
                        this.cs.start();
                    }
                    catch (IOException iOException) {
                        SimpleLog.log(SimpleLog.logtype.DEBUG, "Malformed or IO problem with URL service:jmx:rmi:///jndi/rmi://:" + n + "/jmxrmi", iOException);
                        throw iOException;
                    }
                }
                catch (RemoteException remoteException) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem starting JMX", remoteException);
                    throw remoteException;
                }
            }
        }

        public void stop() throws IOException {
            try {
                if (this.cs != null) {
                    this.cs.stop();
                }
            }
            catch (IOException iOException) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem stopping JMX", iOException);
                throw iOException;
            }
        }

        public void registerMBean(Object object, ObjectName objectName) throws JMException {
            try {
                this.mbs.registerMBean(object, objectName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException jMException) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem registering mbean", jMException);
                throw jMException;
            }
        }

        public void registerDynaMBean(DynaMXBean dynaMXBean, ObjectName objectName) throws JMException {
            this.registerMBean(dynaMXBean, objectName);
        }

        public void addBean(String string, Object object) throws JMException {
            ObjectName objectName = null;
            if (this.objs.containsKey(string)) {
                objectName = this.objs.get(string);
            } else {
                try {
                    objectName = new ObjectName(string);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    SimpleLog.log(SimpleLog.logtype.ERROR, "Malformed Object name " + string, malformedObjectNameException);
                }
            }
            if (objectName != null) {
                this.registerMBean(object, objectName);
            }
        }

        public void addDynaBean(String string, DynaMXBean dynaMXBean) throws JMException {
            ObjectName objectName = null;
            if (this.objs.containsKey(string)) {
                objectName = this.objs.get(string);
            } else {
                try {
                    objectName = new ObjectName(string);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    SimpleLog.log(SimpleLog.logtype.ERROR, "Malformed object " + string, malformedObjectNameException);
                }
            }
            if (objectName != null) {
                this.registerDynaMBean(dynaMXBean, objectName);
            }
        }

        public class RestrictedRMIRegistry
        implements RMIServerSocketFactory {
            public RestrictedRMIRegistry(MXServer mXServer) {
            }

            @Override
            public ServerSocket createServerSocket(int n) throws IOException {
                return new ServerSocket(n, 0, InetAddress.getLocalHost());
            }
        }
    }

    public class DynaMXBean
    implements DynamicMBean {
        NativeFunction getFunction;
        NativeFunction setFunction;
        NativeFunction opsFunction;
        protected OpenMBeanAttributeInfo[] attrInfo;
        protected OpenMBeanConstructorInfo[] attrCons;
        protected OpenMBeanOperationInfo[] attrOps;
        protected MBeanNotificationInfo[] attrNoti;

        public DynaMXBean(JMXServer jMXServer) {
            this.attrInfo = new OpenMBeanAttributeInfo[0];
            this.attrCons = new OpenMBeanConstructorInfo[0];
            this.attrOps = new OpenMBeanOperationInfo[0];
            this.attrNoti = new MBeanNotificationInfo[0];
            this.getFunction = null;
            this.setFunction = null;
            this.opsFunction = null;
        }

        public DynaMXBean(JMXServer jMXServer, NativeObject nativeObject, NativeFunction nativeFunction, NativeFunction nativeFunction2, NativeFunction nativeFunction3) {
            ArrayList<OpenMBeanAttributeInfoSupport> arrayList = new ArrayList<OpenMBeanAttributeInfoSupport>();
            ArrayList<OpenMBeanOperationInfoSupport> arrayList2 = new ArrayList<OpenMBeanOperationInfoSupport>();
            this.getFunction = nativeFunction;
            this.setFunction = nativeFunction2;
            this.opsFunction = nativeFunction3;
            for (Object e : nativeObject.keySet()) {
                SimpleType<Object> simpleType = null;
                boolean bl = false;
                String string = (String)nativeObject.get(e);
                boolean bl2 = string.contains("writable");
                if ((string = string.replaceAll("\\s*writable\\s*", "")).equals("double")) {
                    simpleType = SimpleType.DOUBLE;
                }
                if (string.equals("long")) {
                    simpleType = SimpleType.LONG;
                }
                if (string.equals("operation")) {
                    bl = true;
                }
                if (simpleType == null) {
                    simpleType = SimpleType.STRING;
                }
                if (!bl) {
                    arrayList.add(new OpenMBeanAttributeInfoSupport((String)e, (String)e, simpleType, true, bl2, false));
                    continue;
                }
                arrayList2.add(new OpenMBeanOperationInfoSupport((String)e, (String)e, null, SimpleType.STRING, 3));
            }
            this.attrCons = new OpenMBeanConstructorInfo[0];
            this.attrNoti = new MBeanNotificationInfo[0];
            this.attrInfo = (OpenMBeanAttributeInfo[])Arrays.copyOf(arrayList.toArray(), arrayList.size(), OpenMBeanAttributeInfo[].class);
            this.attrOps = (OpenMBeanOperationInfo[])Arrays.copyOf(arrayList2.toArray(), arrayList2.size(), OpenMBeanOperationInfo[].class);
        }

        @Override
        public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (this.getFunction == null) {
                return null;
            }
            Context context = (Context)AFCmdBase.jse.enterContext();
            Object object = null;
            try {
                object = this.getFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{string});
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
            return object;
        }

        @Override
        public AttributeList getAttributes(String[] stringArray) {
            AttributeList attributeList = new AttributeList();
            for (String string : stringArray) {
                try {
                    attributeList.add(this.getAttribute(string));
                }
                catch (AttributeNotFoundException | MBeanException | ReflectionException jMException) {
                    SimpleLog.log(SimpleLog.logtype.ERROR, "Attribute problem for " + string, jMException);
                }
            }
            return attributeList;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            ImmutableDescriptor immutableDescriptor = new ImmutableDescriptor(new String[]{"immutableInfo", "mxbean"}, (Object[])new String[]{"true", "true"});
            OpenMBeanInfoSupport openMBeanInfoSupport = new OpenMBeanInfoSupport(this.getClass().getName(), "OpenAF dynamic MX Bean", this.attrInfo, this.attrCons, this.attrOps, this.attrNoti, (Descriptor)immutableDescriptor);
            return openMBeanInfoSupport;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
            Context context = (Context)AFCmdBase.jse.enterContext();
            Object object = new Object();
            try {
                void var9_13;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object[] object3 = objectArray;
                int arrayList2 = object3.length;
                boolean object4 = false;
                while (var9_13 < arrayList2) {
                    Object object2 = object3[var9_13];
                    arrayList.add(object2.toString());
                    ++var9_13;
                }
                Object object5 = AFCmdBase.jse.newArray(AFCmdBase.jse.getGlobalscope(), arrayList.toArray());
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (String string2 : stringArray) {
                    arrayList3.add(string2.toString());
                }
                Object object6 = AFCmdBase.jse.newArray(AFCmdBase.jse.getGlobalscope(), arrayList3.toArray());
                object = this.opsFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{string, object5, object6});
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
            return object;
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            Context context = (Context)AFCmdBase.jse.enterContext();
            try {
                this.setFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{attribute.getName(), attribute.getValue()});
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }

        @Override
        public AttributeList setAttributes(AttributeList attributeList) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : attributeList) {
                try {
                    this.setAttribute((Attribute)e);
                }
                catch (AttributeNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException jMException) {
                    SimpleLog.log(SimpleLog.logtype.ERROR, "Attribute problem for " + String.valueOf(e), jMException);
                }
                arrayList.add(((Attribute)e).getName());
            }
            return this.getAttributes((String[])arrayList.toArray());
        }
    }
}

