/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import openaf.AFCmdBase;
import openaf.JSEngine;
import openaf.SimpleLog;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class JMX
extends ScriptableObject {
    public static final String CREDENTIALS_LOGIN_KEY = "login";
    public static final String CREDENTIALS_PASSWORD_KEY = "password";
    private static final long serialVersionUID = 2794123619715765456L;
    protected JMXServiceURL serviceUrl = null;
    protected JMXConnector jmxCon = null;
    protected MBeanServerConnection mbeanCon = null;
    protected String provider = null;

    public String getClassName() {
        return "JMX";
    }

    @JSConstructor
    public void newJMX(Object object, Object object2, Object object3, Object object4) throws IOException, InstantiationException, IllegalAccessException {
        if (object != null && object instanceof String) {
            this.serviceUrl = new JMXServiceURL((String)object);
            ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
            if (object2 != null && object2 instanceof String && object3 != null && object3 instanceof String) {
                concurrentHashMap.put("jmx.remote.credentials", new String[]{AFCmdBase.afc.dIP((String)object2), AFCmdBase.afc.dIP((String)object3)});
            }
            if (object4 != null && object4 instanceof String) {
                this.provider = (String)object4;
                concurrentHashMap.put("jmx.remote.protocol.provider.pkgs", this.provider);
            }
            this.jmxCon = JMXConnectorFactory.connect(this.serviceUrl, concurrentHashMap);
            this.mbeanCon = this.jmxCon.getMBeanServerConnection();
        }
    }

    @JSFunction
    public Object getObject(String string) throws MalformedObjectNameException {
        return new JMXObject(string);
    }

    @JSFunction
    public Object getJavaServerConnection() {
        return this.mbeanCon;
    }

    @JSFunction
    public static Object getLocals() throws IOException {
        List<VirtualMachineDescriptor> list = VirtualMachine.list();
        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
        JSEngine.JSList jSList = AFCmdBase.jse.getNewList(jSMap.getMap());
        for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
            JSEngine.JSMap jSMap2 = AFCmdBase.jse.getNewMap(jSList.getList());
            jSMap2.put("id", virtualMachineDescriptor.id());
            jSMap2.put("name", virtualMachineDescriptor.displayName());
            jSList.add(jSMap2.getMap());
        }
        jSMap.put("Locals", jSList.getList());
        return jSMap.getMap();
    }

    @JSFunction
    public static Object attach2Local(String string) throws IOException, AgentLoadException, AgentInitializationException, AttachNotSupportedException {
        Object object;
        VirtualMachine virtualMachine = VirtualMachine.attach(string);
        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
        Properties properties = virtualMachine.getSystemProperties();
        String string2 = virtualMachine.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
        if (string2 != null) {
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string2.toString());
        } else {
            object = new ServerSocket(0);
            try {
                properties.put("com.sun.management.jmxremote", (Object)((ServerSocket)object).getLocalPort());
            }
            finally {
                ((ServerSocket)object).close();
            }
            virtualMachine.startLocalManagementAgent();
            string2 = virtualMachine.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
        }
        object = AFCmdBase.jse.getNewMap(jSMap.getMap());
        jSMap.put("URL", string2);
        for (String string3 : virtualMachine.getSystemProperties().stringPropertyNames()) {
            object.put(string3, virtualMachine.getSystemProperties().getProperty(string3));
        }
        jSMap.put("System", object);
        object = AFCmdBase.jse.getNewMap(jSMap.getMap());
        for (String string3 : virtualMachine.getAgentProperties().stringPropertyNames()) {
            object.put(string3, virtualMachine.getAgentProperties().getProperty(string3));
        }
        jSMap.put("Agent", object);
        return jSMap.getMap();
    }

    public class JMXObject {
        protected ObjectName obj;

        public JMXObject(String string) throws MalformedObjectNameException {
            this.obj = new ObjectName(string);
        }

        public ObjectName getObjectName() {
            return this.obj;
        }

        public Object getAttributes() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
            if (JMX.this.mbeanCon != null) {
                MBeanInfo mBeanInfo = JMX.this.mbeanCon.getMBeanInfo(this.obj);
                JSEngine.JSList jSList = AFCmdBase.jse.getNewList(jSMap.getMap());
                JSEngine.JSList jSList2 = AFCmdBase.jse.getNewList(jSMap.getMap());
                jSList.addAll(Arrays.asList(mBeanInfo.getOperations()));
                jSList2.addAll(Arrays.asList(mBeanInfo.getAttributes()));
                jSMap.put("operations", jSList.getList());
                jSMap.put("attributes", jSList2.getList());
            }
            return jSMap.getMap();
        }

        public Object get(String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, IOException {
            return this.get(string, false);
        }

        public Object get(String string, boolean bl) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Object object = new String("");
            if (JMX.this.mbeanCon != null) {
                if (JMX.this.provider != null && JMX.this.provider.startsWith("weblogic.management")) {
                    try {
                        object = JMX.this.mbeanCon.getAttribute(this.obj, string);
                    }
                    catch (IllegalStateException illegalStateException) {
                        object = JMX.this.mbeanCon.getAttribute(this.obj, string);
                        SimpleLog.log(SimpleLog.logtype.DEBUG, "WebLogic Bug 13339111 Workaround", illegalStateException);
                    }
                } else {
                    object = JMX.this.mbeanCon.getAttribute(this.obj, string);
                }
                if (object != null) {
                    if (bl) {
                        String[] stringArray;
                        for (String string2 : stringArray = string.split("::")) {
                            if (object.getClass().equals(CompositeDataSupport.class)) {
                                object = ((CompositeDataSupport)object).get(string2);
                                continue;
                            }
                            Class<?>[] classArray = null;
                            Object var10_11 = null;
                            object = object.getClass().getMethod(string2, classArray).invoke(object, var10_11);
                        }
                        if (object != null) {
                            return object;
                        }
                        return null;
                    }
                } else {
                    return object;
                }
            }
            return object;
        }

        public void set(String string, Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            if (JMX.this.mbeanCon != null) {
                JMX.this.mbeanCon.setAttribute(this.obj, new Attribute(string, object));
            }
        }

        public Object exec(String string, String[] stringArray, String[] stringArray2) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return JMX.this.mbeanCon.invoke(this.obj, string, stringArray, stringArray2);
        }
    }
}

