/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import com.nwu.httpd.HTTPd;
import com.nwu.httpd.IHTTPd;
import com.nwu.httpd.IWebSock;
import com.nwu.httpd.NanoHTTPD;
import com.nwu.httpd.responses.EchoResponse;
import com.nwu.log.Log;
import com.nwu2.httpd.HTTPWSd;
import com.nwu2.httpd.NanoHTTPD;
import com.nwu2.httpd.responses.FileResponse;
import com.nwu2.httpd.responses.StatusResponse;
import com.nwu2.log.Log;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import openaf.plugins.HTTPd.JSResponse;
import openaf.plugins.HTTPd.JSResponse2;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class HTTPServer
extends ScriptableObject {
    private static final long serialVersionUID = -8638106468713717782L;
    public static String DEFAULT_HTTP_SERVER = "nwu2";
    protected boolean USE_JAVA_HTTP_SERVER = DEFAULT_HTTP_SERVER.equals("java");
    protected boolean USE_NWU2 = DEFAULT_HTTP_SERVER.equals("nwu2");
    protected IHTTPd httpd;
    protected com.nwu2.httpd.IHTTPd httpd2;
    protected HttpServer javaHttpServer;
    protected HttpsServer javaHttpsServer;
    protected String impl;
    protected boolean isSecure = false;
    protected Map<String, HttpHandler> javaHandlers = new ConcurrentHashMap<String, HttpHandler>();
    protected String defaultHandler = null;
    protected static HashMap<String, Object> sessions = new HashMap();
    protected String id;
    protected int serverport;
    public static Map<String, NativeFunction> callbacks = new ConcurrentHashMap<String, NativeFunction>();

    public String getClassName() {
        return "HTTPd";
    }

    @JSConstructor
    public void newHTTPd(int n, Object object, String string, Object object2, Object object3, Object object4, int n2, String string2) throws IOException {
        if (n <= 0) {
            n = this.findRandomOpenPortOnAllLocalInterfaces();
        }
        if (string != null && !string.equals("undefined") && object2 != null && !(object2 instanceof Undefined)) {
            this.USE_JAVA_HTTP_SERVER = false;
            this.USE_NWU2 = true;
            this.impl = "nwu2";
        } else {
            String string3 = DEFAULT_HTTP_SERVER;
            if (string2 != null && string2 instanceof String) {
                string3 = string2;
            }
            switch (string3) {
                case "java": {
                    this.impl = "java";
                    this.USE_JAVA_HTTP_SERVER = true;
                    this.USE_NWU2 = false;
                    break;
                }
                case "nwu": {
                    this.impl = "nwu";
                    this.USE_JAVA_HTTP_SERVER = false;
                    this.USE_NWU2 = false;
                    break;
                }
                case "nwu2": {
                    this.impl = "nwu2";
                    this.USE_JAVA_HTTP_SERVER = false;
                    this.USE_NWU2 = true;
                    break;
                }
                default: {
                    this.impl = "nwu2";
                    this.USE_JAVA_HTTP_SERVER = false;
                    this.USE_NWU2 = false;
                }
            }
        }
        this.serverport = n;
        if (this.USE_JAVA_HTTP_SERVER) {
            this.initializeJavaHttpServer(n, object, string, object2, object3);
        } else {
            this.initializeNWUHttpServer(n, object, string, object2, object3, object4, n2);
        }
        this.id = Integer.toString(n) + ((Object)((Object)this)).hashCode();
    }

    private void initializeJavaHttpServer(int n, Object object, String string, Object object2, Object object3) throws IOException {
        InetSocketAddress inetSocketAddress = object == null || object instanceof Undefined ? new InetSocketAddress(n) : new InetSocketAddress((String)object, n);
        if (string != null && !string.equals("undefined") && object2 != null && !(object2 instanceof Undefined)) {
            this.javaHttpsServer = HttpsServer.create(inetSocketAddress, 0);
            try {
                Object object4;
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                char[] cArray = AFCmdBase.afc.dIP((String)object2).toCharArray();
                if (new File(string).exists()) {
                    object4 = new FileInputStream(string);
                    try {
                        keyStore.load((InputStream)object4, cArray);
                    }
                    finally {
                        ((FileInputStream)object4).close();
                    }
                }
                object4 = HTTPServer.class.getResourceAsStream(string);
                try {
                    keyStore.load((InputStream)object4, cArray);
                }
                finally {
                    if (object4 != null) {
                        ((InputStream)object4).close();
                    }
                }
                object4 = KeyManagerFactory.getInstance("SunX509");
                ((KeyManagerFactory)object4).init(keyStore, cArray);
                sSLContext.init(((KeyManagerFactory)object4).getKeyManagers(), null, null);
                this.javaHttpsServer.setHttpsConfigurator(new HttpsConfigurator(sSLContext));
                this.javaHttpsServer.setExecutor(Executors.newCachedThreadPool());
                this.javaHttpsServer.start();
                this.isSecure = true;
            }
            catch (Exception exception) {
                throw new IOException("Failed to configure HTTPS", exception);
            }
        }
        this.javaHttpServer = HttpServer.create(inetSocketAddress, 0);
        this.javaHttpServer.setExecutor(Executors.newCachedThreadPool());
        this.javaHttpServer.start();
        this.isSecure = false;
    }

    private void initializeNWUHttpServer(int n, Object object, String string, Object object2, Object object3, Object object4, int n2) throws IOException {
        if (object4 instanceof NativeJavaObject) {
            object4 = ((NativeJavaObject)object4).unwrap();
        }
        if (this.USE_NWU2) {
            this.httpd2 = object == null || object instanceof Undefined ? (object4 == null || object4 instanceof Undefined ? new com.nwu2.httpd.HTTPd(new HLog2(this, n, object3), n) : new HTTPWSd(new HLog2(this, n, object3), n, (com.nwu2.httpd.IWebSock)object4, n2)) : (object4 == null || object4 instanceof Undefined ? new com.nwu2.httpd.HTTPd(new HLog2(this, n, object3), (String)object, n) : new HTTPWSd(new HLog2(this, n, object3), (String)object, n, (com.nwu2.httpd.IWebSock)object4, n2));
            if (string != null && !string.equals("undefined") && object2 != null && !(object2 instanceof Undefined)) {
                this.httpd2.stop();
                this.httpd2.setAsyncRunner(new NanoHTTPD.DefaultAsyncRunner());
                if (new File(string).exists()) {
                    this.httpd2.makeSecure(com.nwu2.httpd.HTTPd.makeLocalSSLSocketFactory(string, AFCmdBase.afc.dIP((String)object2).toCharArray()), null);
                } else {
                    this.httpd2.makeSecure(com.nwu2.httpd.HTTPd.makeSSLSocketFactory(string, AFCmdBase.afc.dIP((String)object2).toCharArray()), null);
                }
                this.httpd2.start();
            }
            this.httpd2.addToGzipAccept("text/plain");
            this.httpd2.addToGzipAccept("application/javascript");
            this.httpd2.addToGzipAccept("text/css");
            this.httpd2.addToGzipAccept("application/json");
            this.httpd2.addToGzipAccept("application/xml");
            this.httpd2.addToGzipAccept("text/richtext");
            this.httpd2.addToGzipAccept("text/html");
        } else {
            this.httpd = object == null || object instanceof Undefined ? (object4 == null || object4 instanceof Undefined ? new HTTPd(new HLog(this, n, object3), n) : new com.nwu.httpd.HTTPWSd(new HLog(this, n, object3), n, (IWebSock)object4, n2)) : (object4 == null || object4 instanceof Undefined ? new HTTPd(new HLog(this, n, object3), (String)object, n) : new com.nwu.httpd.HTTPWSd(new HLog(this, n, object3), (String)object, n, (IWebSock)object4, n2));
            if (string != null && !string.equals("undefined") && object2 != null && !(object2 instanceof Undefined)) {
                this.httpd.stop();
                if (new File(string).exists()) {
                    this.httpd.makeSecure(HTTPd.makeLocalSSLSocketFactory(string, AFCmdBase.afc.dIP((String)object2).toCharArray()), null);
                } else {
                    this.httpd.makeSecure(HTTPd.makeSSLSocketFactory(string, AFCmdBase.afc.dIP((String)object2).toCharArray()), null);
                }
                this.httpd.start();
            }
            this.httpd.addToGzipAccept("text/plain");
            this.httpd.addToGzipAccept("application/javascript");
            this.httpd.addToGzipAccept("text/css");
            this.httpd.addToGzipAccept("application/json");
            this.httpd.addToGzipAccept("application/xml");
            this.httpd.addToGzipAccept("text/richtext");
            this.httpd.addToGzipAccept("text/html");
        }
    }

    private Integer findRandomOpenPortOnAllLocalInterfaces() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            Integer n = serverSocket.getLocalPort();
            return n;
        }
    }

    @JSFunction
    public String getImpl() {
        if (this.USE_JAVA_HTTP_SERVER) {
            return "java";
        }
        if (this.USE_NWU2) {
            return "nwu2";
        }
        return "nwu";
    }

    @JSFunction
    public int getPort() {
        return this.serverport;
    }

    @JSFunction
    public void stop() {
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.javaHttpServer != null) {
                this.javaHttpServer.stop(0);
            }
            if (this.javaHttpsServer != null) {
                this.javaHttpsServer.stop(0);
            }
        } else if (this.USE_NWU2) {
            if (this.httpd2 != null) {
                this.httpd2.stop();
            }
        } else if (this.httpd != null) {
            this.httpd.stop();
        }
    }

    @JSFunction
    public boolean isAlive() {
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.isSecure && this.javaHttpsServer != null) {
                return this.javaHttpsServer.getAddress() != null;
            }
            if (this.javaHttpServer != null) {
                return this.javaHttpServer.getAddress() != null;
            }
            return false;
        }
        if (this.USE_NWU2) {
            return this.httpd2 != null && this.httpd2.isAlive();
        }
        return this.httpd != null && this.httpd.isAlive();
    }

    @JSFunction
    public void addWS(String string) {
        if (this.USE_JAVA_HTTP_SERVER) {
            SimpleLog.log(SimpleLog.logtype.ERROR, "WebSocket support is not implemented for the Java HTTP server. This operation will be ignored.", null);
        } else if (this.USE_NWU2) {
            if (this.httpd2 != null) {
                this.httpd2.addToWsAccept(string);
            }
        } else if (this.httpd != null) {
            this.httpd.addToWsAccept(string);
        }
    }

    @JSFunction
    public IHTTPd getHTTPObj() {
        if (this.USE_JAVA_HTTP_SERVER) {
            throw new UnsupportedOperationException("getHTTPObj() not available for Java HTTP server implementation");
        }
        return this.httpd;
    }

    @JSFunction
    public com.nwu2.httpd.IHTTPd getHTTPObj2() {
        if (this.USE_JAVA_HTTP_SERVER) {
            throw new UnsupportedOperationException("getHTTPObj2() not available for Java HTTP server implementation");
        }
        return this.httpd2;
    }

    @JSFunction
    public void addEcho(String object) {
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.javaHandlers.containsKey(object)) {
                if (this.isSecure && this.javaHttpsServer != null) {
                    this.javaHttpsServer.removeContext((String)object);
                } else if (this.javaHttpServer != null) {
                    this.javaHttpServer.removeContext((String)object);
                }
                this.javaHandlers.remove(object);
            }
            HttpHandler httpHandler = new HttpHandler(this){

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    Object object;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Method: ").append(httpExchange.getRequestMethod()).append("\n");
                    stringBuilder.append("URI: ").append(httpExchange.getRequestURI()).append("\n");
                    stringBuilder.append("Headers:\n");
                    httpExchange.getRequestHeaders().forEach((string, list) -> stringBuilder.append("  ").append((String)string).append(": ").append(String.join((CharSequence)", ", list)).append("\n"));
                    try (Object object2 = httpExchange.getRequestBody();){
                        object = ((InputStream)object2).readAllBytes();
                        if (((byte[])object).length > 0) {
                            stringBuilder.append("Body:\n").append(new String((byte[])object, StandardCharsets.UTF_8));
                        }
                    }
                    object2 = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, ((Object)object2).length);
                    object = httpExchange.getResponseBody();
                    try {
                        ((OutputStream)object).write((byte[])object2);
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                }
            };
            if (this.isSecure && this.javaHttpsServer != null) {
                this.javaHttpsServer.createContext((String)object, httpHandler);
            } else if (this.javaHttpServer != null) {
                this.javaHttpServer.createContext((String)object, httpHandler);
            }
        } else if (this.USE_NWU2) {
            this.httpd2.registerURIResponse((String)object, com.nwu2.httpd.responses.EchoResponse.class, null);
        } else {
            this.httpd.registerURIResponse((String)object, EchoResponse.class, null);
        }
    }

    @JSFunction
    public void addStatus(String object) {
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.javaHandlers.containsKey(object)) {
                if (this.isSecure && this.javaHttpsServer != null) {
                    this.javaHttpsServer.removeContext((String)object);
                } else if (this.javaHttpServer != null) {
                    this.javaHttpServer.removeContext((String)object);
                }
                this.javaHandlers.remove(object);
            }
            HttpHandler httpHandler = new HttpHandler(){

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    String string = "Server Status: OK\nPort: " + HTTPServer.this.serverport + "\nTimestamp: " + String.valueOf(new Date());
                    byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, byArray.length);
                    try (OutputStream outputStream = httpExchange.getResponseBody();){
                        outputStream.write(byArray);
                    }
                }
            };
            if (this.isSecure && this.javaHttpsServer != null) {
                this.javaHttpsServer.createContext((String)object, httpHandler);
            } else if (this.javaHttpServer != null) {
                this.javaHttpServer.createContext((String)object, httpHandler);
            }
        } else if (this.USE_NWU2) {
            this.httpd2.registerURIResponse((String)object, StatusResponse.class, null);
        } else {
            this.httpd.registerURIResponse((String)object, com.nwu.httpd.responses.StatusResponse.class, null);
        }
    }

    @JSFunction
    public void add(String string, NativeFunction nativeFunction) {
        Object object = !string.startsWith("/") ? "/" + string : string;
        callbacks.put(this.serverport + ":" + (String)object, nativeFunction);
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.javaHandlers.containsKey(object)) {
                if (this.isSecure && this.javaHttpsServer != null) {
                    this.javaHttpsServer.removeContext((String)object);
                } else if (this.javaHttpServer != null) {
                    this.javaHttpServer.removeContext((String)object);
                }
                this.javaHandlers.remove(object);
            }
            JavaHttpHandler javaHttpHandler = new JavaHttpHandler(this, (String)object, nativeFunction, this.serverport);
            this.javaHandlers.put((String)object, javaHttpHandler);
            if (this.isSecure && this.javaHttpsServer != null) {
                this.javaHttpsServer.createContext((String)object, javaHttpHandler);
            } else if (this.javaHttpServer != null) {
                this.javaHttpServer.createContext((String)object, javaHttpHandler);
            }
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uri", (String)object);
            if (this.USE_NWU2) {
                this.httpd2.registerURIResponse((String)object, JSResponse2.class, hashMap);
            } else {
                this.httpd.registerURIResponse((String)object, JSResponse.class, hashMap);
            }
        }
    }

    @JSFunction
    public void setDefault(String string) {
        Object object;
        Object object2 = object = !string.startsWith("/") ? "/" + string : string;
        if (this.USE_JAVA_HTTP_SERVER) {
            this.defaultHandler = object;
            HttpHandler httpHandler = new HttpHandler(){
                final /* synthetic */ String val$uri;
                {
                    this.val$uri = string;
                }

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    String string = this.val$uri;
                    httpExchange.getResponseHeaders().set("Location", string);
                    httpExchange.sendResponseHeaders(302, -1L);
                }
            };
            if (this.javaHandlers.containsKey("/")) {
                if (this.isSecure && this.javaHttpsServer != null) {
                    this.javaHttpsServer.removeContext("/");
                } else if (this.javaHttpServer != null) {
                    this.javaHttpServer.removeContext("/");
                }
                this.javaHandlers.remove("/");
            }
            if (this.javaHandlers.containsKey(object)) {
                httpHandler = this.javaHandlers.get(object);
            }
            this.javaHandlers.put("/", httpHandler);
            if (this.isSecure && this.javaHttpsServer != null) {
                this.javaHttpsServer.createContext("/", httpHandler);
            } else if (this.javaHttpServer != null) {
                this.javaHttpServer.createContext("/", httpHandler);
            }
        } else if (this.USE_NWU2) {
            this.httpd2.setDefaultResponse(string);
        } else {
            this.httpd.setDefaultResponse(string);
        }
    }

    @JSFunction
    public void addFileBrowse(String string, String string2) {
        Object object;
        Object object2 = object = !string.startsWith("/") ? "/" + string : string;
        if (this.USE_JAVA_HTTP_SERVER) {
            if (this.javaHandlers.containsKey(object)) {
                if (this.isSecure && this.javaHttpsServer != null) {
                    this.javaHttpsServer.removeContext((String)object);
                } else if (this.javaHttpServer != null) {
                    this.javaHttpServer.removeContext((String)object);
                }
                this.javaHandlers.remove(object);
            }
            HttpHandler httpHandler = new HttpHandler(){
                final /* synthetic */ String val$uri;
                final /* synthetic */ String val$filepath;
                {
                    this.val$uri = string;
                    this.val$filepath = string2;
                }

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    File file;
                    String string = httpExchange.getRequestURI().getPath();
                    String string2 = string.substring(this.val$uri.length());
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    if (!(file = new File(this.val$filepath, string2)).exists()) {
                        String string3 = "File not found";
                        httpExchange.sendResponseHeaders(404, string3.length());
                        try (OutputStream outputStream = httpExchange.getResponseBody();){
                            outputStream.write(string3.getBytes(StandardCharsets.UTF_8));
                        }
                        return;
                    }
                    if (file.isDirectory()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("<html><body><h2>Directory: ").append(string2).append("</h2><ul>");
                        File[] fileArray = file.listFiles();
                        if (fileArray != null) {
                            for (File file2 : fileArray) {
                                Object object = file2.getName();
                                if (file2.isDirectory()) {
                                    object = (String)object + "/";
                                }
                                stringBuilder.append("<li><a href=\"").append((String)object).append("\">").append((String)object).append("</a></li>");
                            }
                        }
                        stringBuilder.append("</ul></body></html>");
                        byte[] fileInputStream = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
                        httpExchange.getResponseHeaders().set("Content-Type", "text/html");
                        httpExchange.sendResponseHeaders(200, fileInputStream.length);
                        try (OutputStream byArray = httpExchange.getResponseBody();){
                            byArray.write(fileInputStream);
                        }
                    }
                    String string4 = URLConnection.guessContentTypeFromName(file.getName());
                    if (string4 == null) {
                        string4 = "application/octet-stream";
                    }
                    httpExchange.getResponseHeaders().set("Content-Type", string4);
                    httpExchange.sendResponseHeaders(200, file.length());
                    try (OutputStream outputStream = httpExchange.getResponseBody();
                         FileInputStream fileInputStream = new FileInputStream(file);){
                        int n;
                        byte[] byArray = new byte[8192];
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n);
                        }
                    }
                }
            };
            if (this.isSecure && this.javaHttpsServer != null) {
                this.javaHttpsServer.createContext((String)object, httpHandler);
            } else if (this.javaHttpServer != null) {
                this.javaHttpServer.createContext((String)object, httpHandler);
            }
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("publichtml", string2);
            if (this.USE_NWU2) {
                this.httpd2.registerURIResponse((String)object, FileResponse.class, hashMap);
            } else {
                this.httpd.registerURIResponse((String)object, com.nwu.httpd.responses.FileResponse.class, hashMap);
            }
        }
    }

    @JSFunction
    public void addXDTServer(String string, NativeFunction nativeFunction, NativeFunction nativeFunction2) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (this.USE_JAVA_HTTP_SERVER) {
            throw new UnsupportedOperationException("XDT Server not implemented for Java HTTP server");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uri", string);
        if (AFCmdBase.afcmd.equals("AFCmdWeDo")) {
            Class<?> clazz = Class.forName("openaf.plugins.HTTPd.XDTServerResponse");
            clazz.getDeclaredMethod("setAuthfunction", NativeFunction.class).invoke((Object)this, nativeFunction);
            clazz.getDeclaredMethod("setOpsfunction", NativeFunction.class).invoke((Object)this, nativeFunction2);
            if (this.USE_NWU2) {
                this.httpd2.registerURIResponse(string, clazz, hashMap);
            } else {
                this.httpd.registerURIResponse(string, clazz, hashMap);
            }
        }
    }

    @JSFunction
    public Object replyOKText(String string, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        scriptable.put("status", scriptable, (Object)200);
        scriptable.put("mimetype", scriptable, (Object)"text/plain");
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object replyOKXML(String string, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        scriptable.put("status", scriptable, (Object)200);
        scriptable.put("mimetype", scriptable, (Object)"text/xml");
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object replyOKHTML(String string, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        scriptable.put("status", scriptable, (Object)200);
        scriptable.put("mimetype", scriptable, (Object)"text/html");
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object replyOKJSON(String string, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        scriptable.put("status", scriptable, (Object)200);
        scriptable.put("mimetype", scriptable, (Object)"application/json");
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object replyOKBin(String string, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        scriptable.put("status", scriptable, (Object)200);
        scriptable.put("mimetype", scriptable, (Object)"application/octet-stream");
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object reply(String string, String string2, int n, Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        if (string2 == null || string2.equals("undefined")) {
            string2 = "application/octet-stream";
        }
        if (n <= 0) {
            n = 200;
        }
        scriptable.put("status", scriptable, (Object)n);
        scriptable.put("mimetype", scriptable, (Object)string2);
        scriptable.put("data", scriptable, (Object)string);
        scriptable.put("header", scriptable, object);
        return scriptable;
    }

    @JSFunction
    public Object replyBytes(Object object, String string, int n, Object object2) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        if (string == null || string.equals("undefined")) {
            string = "application/octet-stream";
        }
        if (n <= 0) {
            n = 200;
        }
        scriptable.put("status", scriptable, (Object)n);
        scriptable.put("mimetype", scriptable, (Object)string);
        scriptable.put("data", scriptable, (Object)((byte[])object));
        scriptable.put("header", scriptable, object2);
        return scriptable;
    }

    @JSFunction
    public Object replyStream(Object object, String string, int n, Object object2) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        if (string == null || string.equals("undefined")) {
            string = "application/octet-stream";
        }
        if (n <= 0) {
            n = 200;
        }
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        scriptable.put("status", scriptable, (Object)n);
        scriptable.put("mimetype", scriptable, (Object)string);
        scriptable.put("stream", scriptable, object);
        scriptable.put("header", scriptable, object2);
        return scriptable;
    }

    @JSFunction
    public static void addSession(String string) {
        HTTPServer.setSession(string, null);
    }

    @JSFunction
    public static Object getSession(String string) {
        return sessions.get(string);
    }

    @JSFunction
    public static void setSession(String string, Object object) {
        sessions.put(string, object);
    }

    @JSFunction
    public static void delSession(String string) {
        sessions.remove(string);
    }

    @JSFunction
    public static boolean hasSession(String string) {
        return sessions.containsKey(string);
    }

    public static NanoHTTPD.Response.IStatus translateToNanoHTTPD(int n) {
        return NanoHTTPD.Response.Status.lookup(n);
    }

    public static NanoHTTPD.Response.IStatus translateToNanoHTTPD2(int n) {
        return NanoHTTPD.Response.Status.lookup(n);
    }

    public class HLog2
    extends Log {
        protected int port;
        protected NativeFunction callback = null;

        public HLog2(HTTPServer hTTPServer, int n, Object object) {
            super(false);
            this.port = n;
            if (object != null && object instanceof NativeFunction) {
                this.callback = (NativeFunction)object;
            }
        }

        protected void SimpleLoglog(SimpleLog.logtype logtype2, String string, Exception exception) {
            if (this.callback == null) {
                switch (logtype2) {
                    case DEBUG: {
                        SimpleLog.log(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                    case ERROR: {
                        SimpleLog.log(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                    case INFO: {
                        SimpleLog.log(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                }
            } else {
                Context context = (Context)AFCmdBase.jse.enterContext();
                try {
                    this.callback.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{logtype2, string, exception});
                }
                catch (Exception exception2) {
                    throw exception2;
                }
                finally {
                    AFCmdBase.jse.exitContext();
                }
            }
        }

        @Override
        public void log(Log.Type type, String string) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }

        @Override
        public void log(Log.Type type, String string, Exception exception) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }

        @Override
        public void log(Level level, String string, Exception exception) {
            if (level == Level.WARNING) {
                this.log(Log.Type.DEBUG, string, exception);
            }
            if (level == Level.SEVERE) {
                this.log(Log.Type.ERROR, string, exception);
            }
            if (level == Level.INFO) {
                this.log(Log.Type.INFO, string, exception);
            }
        }

        @Override
        public void log(Log.Type type, long l, String string) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }
    }

    public class HLog
    extends com.nwu.log.Log {
        protected int port;
        protected NativeFunction callback = null;

        public HLog(HTTPServer hTTPServer, int n, Object object) {
            super(false);
            this.port = n;
            if (object != null && object instanceof NativeFunction) {
                this.callback = (NativeFunction)object;
            }
        }

        protected void SimpleLoglog(SimpleLog.logtype logtype2, String string, Exception exception) {
            if (this.callback == null) {
                switch (logtype2) {
                    case DEBUG: {
                        SimpleLog.log(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                    case ERROR: {
                        SimpleLog.log(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                    case INFO: {
                        SimpleLog.log(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, exception);
                        break;
                    }
                }
            } else {
                Context context = (Context)AFCmdBase.jse.enterContext();
                try {
                    this.callback.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{logtype2, string, exception});
                }
                catch (Exception exception2) {
                    throw exception2;
                }
                finally {
                    AFCmdBase.jse.exitContext();
                }
            }
        }

        @Override
        public void log(Log.Type type, String string) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, null);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }

        @Override
        public void log(Log.Type type, String string, Exception exception) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]" + string, exception);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }

        @Override
        public void log(Level level, String string, Exception exception) {
            if (level == Level.WARNING) {
                this.log(Log.Type.DEBUG, string, exception);
            }
            if (level == Level.SEVERE) {
                this.log(Log.Type.ERROR, string, exception);
            }
            if (level == Level.INFO) {
                this.log(Log.Type.INFO, string, exception);
            }
        }

        @Override
        public void log(Log.Type type, long l, String string) {
            switch (type) {
                case DEBUG: {
                    this.SimpleLoglog(SimpleLog.logtype.DEBUG, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case ERROR: {
                    this.SimpleLoglog(SimpleLog.logtype.ERROR, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case INFO: {
                    this.SimpleLoglog(SimpleLog.logtype.INFO, "[HTTPD " + this.port + "]|" + l + "|" + string, null);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }
    }

    public class JavaHttpHandler
    implements HttpHandler {
        private final NativeFunction callback;

        public JavaHttpHandler(HTTPServer hTTPServer, String string, NativeFunction nativeFunction, int n) {
            this.callback = nativeFunction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            try {
                Object object = this.convertHttpExchangeToRequest(httpExchange);
                Context context = (Context)AFCmdBase.jse.enterContext();
                Object object2 = null;
                try {
                    object2 = this.callback.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{object});
                }
                finally {
                    AFCmdBase.jse.exitContext();
                }
                this.sendResponse(httpExchange, object2);
            }
            catch (Exception exception) {
                String string = "Internal Server Error: " + exception.getMessage();
                httpExchange.sendResponseHeaders(500, string.length());
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    outputStream.write(string.getBytes(StandardCharsets.UTF_8));
                }
                SimpleLog.log(SimpleLog.logtype.ERROR, "Error handling request: " + exception.getMessage(), exception);
            }
        }

        private Object convertHttpExchangeToRequest(HttpExchange httpExchange) {
            Context context = (Context)AFCmdBase.jse.enterContext();
            Scriptable scriptable = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
            AFCmdBase.jse.exitContext();
            scriptable.put("method", scriptable, (Object)httpExchange.getRequestMethod());
            scriptable.put("uri", scriptable, (Object)httpExchange.getRequestURI().toString());
            scriptable.put("path", scriptable, (Object)httpExchange.getRequestURI().getPath());
            scriptable.put("query", scriptable, (Object)httpExchange.getRequestURI().getQuery());
            Scriptable scriptable2 = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
            httpExchange.getRequestHeaders().forEach((string, list) -> {
                if (list.size() == 1) {
                    scriptable2.put(string.toLowerCase(), scriptable2, list.get(0));
                } else {
                    scriptable2.put(string.toLowerCase(), scriptable2, (Object)list.toArray(new String[0]));
                }
            });
            scriptable.put("header", scriptable, (Object)scriptable2);
            try (InputStream inputStream = httpExchange.getRequestBody();){
                byte[] byArray = inputStream.readAllBytes();
                if (byArray.length > 0) {
                    scriptable.put("data", scriptable, (Object)new String(byArray, StandardCharsets.UTF_8));
                    scriptable.put("bytes", scriptable, (Object)byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return scriptable;
        }

        private void sendResponse(HttpExchange httpExchange, Object object) throws IOException {
            if (object instanceof Scriptable) {
                Object object2;
                Scriptable scriptable = (Scriptable)object;
                int n = 200;
                Object object3 = scriptable.get("status", scriptable);
                if (object3 instanceof Number) {
                    n = ((Number)object3).intValue();
                }
                String string = "text/plain";
                Object object4 = scriptable.get("mimetype", scriptable);
                if (object4 instanceof String) {
                    string = (String)object4;
                }
                httpExchange.getResponseHeaders().set("Content-Type", string);
                Object object5 = scriptable.get("header", scriptable);
                if (object5 instanceof Scriptable) {
                    object2 = (Scriptable)object5;
                    for (Object object6 : object2.getIds()) {
                        if (!(object6 instanceof String)) continue;
                        String string2 = (String)object6;
                        Object object7 = object2.get(string2, (Scriptable)object2);
                        httpExchange.getResponseHeaders().set(string2, object7.toString());
                    }
                }
                object2 = null;
                Object object8 = scriptable.get("data", scriptable);
                Object object9 = scriptable.get("stream", scriptable);
                if (object9 != null && !(object9 instanceof Undefined) && !(object9 instanceof UniqueTag)) {
                    if (object9 instanceof InputStream) {
                        try (InputStream inputStream = (InputStream)object9;){
                            object2 = inputStream.readAllBytes();
                        }
                    }
                } else if (object8 != null && !(object8 instanceof Undefined) && !(object8 instanceof UniqueTag)) {
                    object2 = object8 instanceof byte[] ? (Object)((byte[])object8) : (Object)object8.toString().getBytes(StandardCharsets.UTF_8);
                }
                if (object2 == null) {
                    object2 = new byte[0];
                }
                httpExchange.sendResponseHeaders(n, ((Scriptable)object2).length);
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    outputStream.write((byte[])object2);
                }
            }
            String string = object != null ? object.toString() : "";
            httpExchange.sendResponseHeaders(200, string.length());
            try (OutputStream outputStream = httpExchange.getResponseBody();){
                outputStream.write(string.getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

