/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import openaf.plugins.HTTPws.WebSockets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class HTTP
extends ScriptableObject {
    protected static CookieManager ckman = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
    protected HTTPResponse output = new HTTPResponse("", -1, null, "");
    protected Object outputObj = null;
    protected Object errorObj = null;
    protected Authenticator authenticator = null;
    protected boolean forceBasic = false;
    protected String l = null;
    protected String p = null;
    protected String lpsID = null;
    protected static ConcurrentHashMap<String, LPs> lps = new ConcurrentHashMap();
    private static final long serialVersionUID = -2025553185688930581L;

    public String getClassName() {
        return "HTTP";
    }

    @JSConstructor
    public void newHTTP(String string, String string2, Object object, NativeObject nativeObject, boolean bl, int n, boolean bl2) throws IOException {
        this.exec(string, string2, object, nativeObject, bl, n, bl2);
    }

    @JSFunction
    public void login(String string, String string2, boolean bl, String string3) {
        if (string3 == null || string3.equals("undefined") || string3.equals("")) {
            string3 = "default";
        }
        if (!bl) {
            lps.put(string3, new LPs(this, string, string2));
            if (this.authenticator == null) {
                this.authenticator = new Authenticator(this){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        URL uRL = this.getRequestingURL();
                        String string = null;
                        for (String string2 : lps.keySet()) {
                            if (string2.equals("default") || !uRL.toString().startsWith(string2)) continue;
                            string = string2;
                        }
                        if (string == null) {
                            return new PasswordAuthentication(AFCmdBase.afc.dIP(HTTP.lps.get((Object)"default").l), AFCmdBase.afc.dIP(HTTP.lps.get((Object)"default").p).toCharArray());
                        }
                        return new PasswordAuthentication(AFCmdBase.afc.dIP(HTTP.lps.get(string).l), AFCmdBase.afc.dIP(HTTP.lps.get((Object)string).p).toCharArray());
                    }
                };
                Authenticator.setDefault(this.authenticator);
            }
        }
        this.l = string;
        this.p = string2;
        if (bl) {
            this.forceBasic = true;
        }
        SimpleLog.log(SimpleLog.logtype.DEBUG, "HTTP connection with authentication for " + string, null);
    }

    @JSFunction
    public Object exec(String string, String string2, Object object, NativeObject nativeObject, boolean bl, int n, boolean bl2) throws IOException {
        Object object22;
        Properties properties = new Properties();
        if (string2.equals("undefined") || string2 == null) {
            string2 = "GET";
        }
        if (string.equals("undefined") || string == null) {
            return new HTTPResponse("No URL", -1, null, "");
        }
        if (object.equals("undefined") || object == null) {
            object = "";
        }
        if (nativeObject != null) {
            for (Object object22 : nativeObject.keySet()) {
                properties.put(object22, nativeObject.get(object22));
            }
        }
        this.output = this.request(string, string2, object, properties, bl, bl2, n);
        Context context = (Context)AFCmdBase.jse.enterContext();
        object22 = context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        object22.put("responseCode", object22, (Object)this.output.responseCode);
        object22.put("contentType", object22, (Object)this.output.contentType);
        if (bl2) {
            return this.output.responseStream;
        }
        if (bl) {
            object22.put("responseBytes", object22, (Object)this.output.responseBytes);
        } else {
            object22.put("response", object22, (Object)this.output.response);
        }
        this.outputObj = object22;
        return this.outputObj;
    }

    @JSFunction
    public Object get(String string, Object object, NativeObject nativeObject, boolean bl, int n, boolean bl2) throws IOException {
        return this.exec(string, "GET", object, nativeObject, bl, n, bl2);
    }

    @JSFunction
    public Object getBytes(String string, Object object, NativeObject nativeObject, int n) throws IOException {
        return this.exec(string, "GET", object, nativeObject, true, n, false);
    }

    @JSFunction
    public Object getStream(String string, Object object, NativeObject nativeObject, int n) throws IOException {
        return this.exec(string, "GET", object, nativeObject, false, n, true);
    }

    @JSFunction
    public Object post(String string, Object object, NativeObject nativeObject, boolean bl, int n, boolean bl2) throws IOException {
        return this.exec(string, "POST", object, nativeObject, bl, n, bl2);
    }

    @JSFunction
    public Object getResponse() {
        return this.outputObj;
    }

    @JSFunction
    public Object getErrorResponse() {
        return this.errorObj;
    }

    @JSFunction
    public long responseCode() {
        return this.output.responseCode;
    }

    @JSFunction
    public Map<String, List<String>> responseHeaders() {
        return this.output.responseHeaders;
    }

    @JSFunction
    public String responseType() {
        return this.output.contentType;
    }

    @JSFunction
    public Object responseStream() {
        return this.output.responseStream;
    }

    @JSFunction
    public Object responseBytes() {
        return this.output.responseBytes;
    }

    @JSFunction
    public String response() {
        return this.output.response;
    }

    @JSFunction
    public Object wsConnect(String string, NativeFunction nativeFunction, NativeFunction nativeFunction2, NativeFunction nativeFunction3, NativeFunction nativeFunction4, Object object, boolean bl) throws Exception {
        return WebSockets.wsConnect(this.authenticator, this.l, this.p, string, nativeFunction, nativeFunction2, nativeFunction3, nativeFunction4, object, bl);
    }

    @JSFunction
    public Object wsClient(String string, NativeFunction nativeFunction, NativeFunction nativeFunction2, NativeFunction nativeFunction3, NativeFunction nativeFunction4, Object object, boolean bl) throws Exception {
        return WebSockets.wsClient(this.authenticator, this.l, this.p, string, nativeFunction, nativeFunction2, nativeFunction3, nativeFunction4, object, bl);
    }

    protected HTTPResponse request(String string, String string2, Object object, Properties properties, boolean bl, boolean bl2, int n) throws IOException {
        Object object22;
        CookieHandler.setDefault(ckman);
        URL uRL = URI.create(string).toURL();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod(string2);
        httpURLConnection.addRequestProperty("host", uRL.getHost());
        httpURLConnection.addRequestProperty("Accept", "*/*");
        if (properties != null) {
            for (Object object22 : properties.keySet()) {
                httpURLConnection.addRequestProperty((String)object22, (String)properties.get(object22));
            }
        }
        if (this.forceBasic) {
            httpURLConnection.addRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])new String(this.l + ":" + this.p).getBytes())));
        }
        if (n > 0) {
            httpURLConnection.setConnectTimeout(n);
        }
        if (n > 0) {
            httpURLConnection.setReadTimeout(n);
        }
        Object object3 = null;
        if (!(object instanceof Undefined)) {
            if (object instanceof String) {
                if (!object.equals("")) {
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.addRequestProperty("content-length", String.valueOf(((String)object).length()));
                    object22 = httpURLConnection.getOutputStream();
                    IOUtils.write((String)((String)object), (OutputStream)object22, (Charset)Charset.defaultCharset());
                    ((OutputStream)object22).flush();
                    ((OutputStream)object22).close();
                    object3 = httpURLConnection.getInputStream();
                }
            } else {
                httpURLConnection.setDoOutput(true);
                httpURLConnection.addRequestProperty("content-length", String.valueOf(((byte[])object).length));
                object22 = httpURLConnection.getOutputStream();
                IOUtils.write((byte[])((byte[])object), (OutputStream)object22);
                ((OutputStream)object22).flush();
                ((OutputStream)object22).close();
                object3 = httpURLConnection.getInputStream();
            }
        }
        if (object3 == null) {
            httpURLConnection.setDoInput(true);
            object3 = httpURLConnection.getInputStream();
        }
        try {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "URL = " + string + "; method = " + string2 + "; cookiesize = " + ckman.getCookieStore().getCookies().size(), null);
            int n2 = httpURLConnection.getResponseCode();
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            String string3 = httpURLConnection.getContentType();
            object22 = bl ? (bl2 ? new HTTPResponse((InputStream)object3, n2, map, string3) : new HTTPResponse(IOUtils.toByteArray((InputStream)object3), n2, map, string3)) : (bl2 ? new HTTPResponse((InputStream)object3, n2, map, string3) : new HTTPResponse(IOUtils.toString((InputStream)object3, (Charset)Charset.defaultCharset()), n2, map, string3));
            return object22;
        }
        catch (Exception exception) {
            if (httpURLConnection.getErrorStream() != null) {
                this.errorObj = IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)Charset.defaultCharset());
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Response = " + IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)Charset.defaultCharset()), exception);
            } else {
                this.errorObj = IOUtils.toString((InputStream)httpURLConnection.getInputStream(), (Charset)Charset.defaultCharset());
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Response = " + IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)Charset.defaultCharset()), exception);
            }
            throw exception;
        }
    }

    public static class HTTPResponse {
        public String response;
        public byte[] responseBytes;
        public int responseCode;
        public String contentType;
        public Map<String, List<String>> responseHeaders;
        public InputStream responseStream;

        public HTTPResponse(String string, int n, Map<String, List<String>> map, String string2) {
            this.response = string;
            this.responseCode = n;
            this.responseHeaders = map;
            this.contentType = string2;
        }

        public HTTPResponse(byte[] byArray, int n, Map<String, List<String>> map, String string) {
            this.responseBytes = byArray;
            this.responseCode = n;
            this.responseHeaders = map;
            this.contentType = string;
        }

        public HTTPResponse(InputStream inputStream, int n, Map<String, List<String>> map, String string) {
            this.responseStream = inputStream;
            this.responseCode = n;
            this.responseHeaders = map;
            this.contentType = string;
        }
    }

    protected class LPs {
        String l;
        String p;

        public LPs(HTTP hTTP, String string, String string2) {
            this.l = string;
            this.p = string2;
        }
    }
}

