/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Authenticator;
import openaf.AFCmdBase;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.resolver.DataSourceFileResolver;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class Email
extends ScriptableObject {
    private static final long serialVersionUID = -8942152353941864969L;
    protected String server;
    protected String sender = "openaf@openaf.io";
    protected boolean secureProto;
    protected String alogin;
    protected String pass;
    protected int port = -1;
    protected MultiPartEmail email;
    protected String contentType = null;
    protected AuthenticatingSMTPClient.AUTH_METHOD credMethod;
    protected Map<String, String> headers = new ConcurrentHashMap<String, String>();
    protected boolean tlssecure;
    protected boolean isHtml;

    public String getClassName() {
        return "Email";
    }

    @JSConstructor
    public void newEmail(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.secureProto = bl;
        this.sender = string2;
        this.server = string;
        this.tlssecure = bl2;
        this.isHtml = bl3;
        this.newEmailObj(bl3);
    }

    protected void newEmailObj(boolean bl) {
        this.email = bl ? new ImageHtmlEmail() : new MultiPartEmail();
        if (this.secureProto) {
            this.setSecure(true, this.tlssecure);
        }
        this.email.setHostName(this.server);
        this.contentType = null;
    }

    @JSFunction
    public Email setPort(int n) {
        this.port = n;
        this.email.setSmtpPort(n);
        return this;
    }

    @JSFunction
    public Email setCredentials(String string, String string2) {
        this.alogin = AFCmdBase.afc.dIP(string);
        this.pass = AFCmdBase.afc.dIP(string2);
        return this;
    }

    @JSFunction
    public Email login(String string, String string2) {
        return this.setCredentials(string, string2);
    }

    protected String hashMap2String(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            stringBuilder.append(string + ": " + map.get(string) + "\n");
        }
        return stringBuilder.toString();
    }

    @JSFunction
    public Email addHeader(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    @JSFunction
    public Email addHTMLHeader() throws Exception {
        throw new Exception("Please use the option in the constructor");
    }

    @JSFunction
    public Email addTo(Object object) throws EmailException {
        if (object instanceof NativeArray) {
            for (Object e : (NativeArray)object) {
                this.email.addTo((String)e);
            }
        } else {
            this.email.addTo((String)object);
        }
        return this;
    }

    @JSFunction
    public Email addCc(Object object) throws EmailException {
        if (object instanceof NativeArray) {
            for (Object e : (NativeArray)object) {
                this.email.addCc((String)e);
            }
        } else {
            this.email.addCc((String)object);
        }
        return this;
    }

    @JSFunction
    public Email addBcc(Object object) throws EmailException {
        if (object instanceof NativeArray) {
            for (Object e : (NativeArray)object) {
                this.email.addBcc((String)e);
            }
        } else {
            this.email.addBcc((String)object);
        }
        return this;
    }

    @JSFunction
    public Email setFrom(String string) throws EmailException {
        this.email.setFrom(string);
        return this;
    }

    @JSFunction
    public Email setCharset(String string) {
        this.email.setCharset(string);
        return this;
    }

    @JSFunction
    public Object getEmailObj() {
        return this.email;
    }

    @JSFunction
    public Email setMessage(String string) throws EmailException {
        if (this.contentType == null) {
            if (this.isHtml) {
                ((ImageHtmlEmail)this.email).setTextMsg(string);
            } else {
                this.email.setMsg(string);
            }
        } else {
            this.setContent(string, this.contentType);
        }
        return this;
    }

    public Email setContent(String string, String string2) {
        this.email.setContent((Object)string, string2);
        return this;
    }

    @JSFunction
    public Email addAttachment(String string, boolean bl, boolean bl2, Object object) throws EmailException {
        EmailAttachment emailAttachment = new EmailAttachment();
        emailAttachment.setPath(string);
        if (object != null && object instanceof String) {
            emailAttachment.setName((String)object);
        }
        if (bl) {
            emailAttachment.setDisposition("inline");
        } else {
            emailAttachment.setDisposition("attachment");
        }
        this.email.attach(emailAttachment);
        return this;
    }

    @JSFunction
    public Email setHTML(String string) throws Exception {
        if (!this.isHtml) {
            throw new Exception("Not created as a HTML email.");
        }
        ((ImageHtmlEmail)this.email).setHtmlMsg(string);
        return this;
    }

    @JSFunction
    public Email addExternalImage(String string) throws Exception {
        if (!this.isHtml) {
            throw new Exception("Not created as a HTML email.");
        }
        URL uRL = URI.create(string).toURL();
        ((ImageHtmlEmail)this.email).setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(uRL));
        return this;
    }

    @JSFunction
    public String embedURL(String string, String string2) throws Exception {
        if (this.isHtml) {
            ((ImageHtmlEmail)this.email).setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(URI.create(string).toURL()));
            return ((ImageHtmlEmail)this.email).embed(string, string2);
        }
        throw new Exception("Not created as a HTML email.");
    }

    @JSFunction
    public String embedFile(String string, String string2) throws Exception {
        if (this.isHtml) {
            File file = new File(string);
            ((ImageHtmlEmail)this.email).setDataSourceResolver((DataSourceResolver)new DataSourceFileResolver(file));
            return ((ImageHtmlEmail)this.email).embed(file, string2);
        }
        throw new Exception("Not created as a HTML email.");
    }

    public Email setSecure(boolean bl, boolean bl2) {
        this.secureProto = true;
        if (!bl2) {
            this.email.setSSLOnConnect(bl);
        } else {
            this.email.setStartTLSEnabled(bl);
        }
        return this;
    }

    @JSFunction
    public Email setSubject(String string) {
        this.email.setSubject(string);
        return this;
    }

    @JSFunction
    public String send(Object object, String string, NativeArray nativeArray, NativeArray nativeArray2, NativeArray nativeArray3, String string2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, EmailException {
        Object object2;
        if (object != null && !(object instanceof Undefined)) {
            if (string == null || string.length() == 0) {
                string = " ";
            }
            this.setSubject((String)object).addTo(nativeArray).addCc(nativeArray2).addBcc(nativeArray3).setMessage(string);
            object2 = string2 != null && !string2.equals("undefined") ? string2 : this.sender;
            this.setFrom((String)object2);
        }
        for (String string3 : this.headers.keySet()) {
            this.email.addHeader(string3, this.headers.get(string3));
        }
        if (this.port <= 0) {
            this.port = this.email.isSSLOnConnect() ? 465 : (this.email.isStartTLSEnabled() ? 587 : 25);
        }
        this.email.setSslSmtpPort(String.valueOf(this.port));
        this.email.setSmtpPort(this.port);
        if (this.alogin != null) {
            this.email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.alogin, this.pass));
        }
        object2 = this.email.send();
        this.newEmailObj(this.isHtml);
        return object2;
    }
}

