/*
 * Decompiled with CFR 0.152.
 */
package openaf.plugins;

import biz.source_code.utils.RawConsoleInput;
import java.io.IOException;
import jline.console.ConsoleReader;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class Console
extends ScriptableObject {
    private static final long serialVersionUID = 2822583540432845379L;
    protected ConsoleReader cr;

    public String getClassName() {
        return "Console";
    }

    @JSConstructor
    public void newConsole() throws IOException {
        try {
            this.cr = new ConsoleReader();
        }
        catch (Exception exception) {
            this.cr = null;
        }
    }

    @JSFunction
    public String readLinePrompt(String string, String string2) throws IOException {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.equals("undefined") || string2.length() <= 0) {
            return this.cr.readLine(string);
        }
        Character c = Character.valueOf(string2.charAt(0));
        return this.cr.readLine(string, c);
    }

    @JSFunction
    public String readLine(String string) throws IOException {
        if (string == null || string.equals("undefined") || string.length() <= 0) {
            return this.cr.readLine();
        }
        Character c = Character.valueOf(string.charAt(0));
        return this.cr.readLine(c);
    }

    @JSFunction
    public char readChar(String string) throws IOException {
        char[] cArray = null;
        if (string == null || string.length() <= 0) {
            return (char)this.cr.readCharacter();
        }
        cArray = string.toCharArray();
        return (char)this.cr.readCharacter(cArray);
    }

    @JSFunction
    public int readCharNB() throws IOException {
        RawConsoleInput.resetConsoleMode();
        return RawConsoleInput.read(false);
    }

    @JSFunction
    public int readCharB() throws IOException {
        RawConsoleInput.resetConsoleMode();
        return RawConsoleInput.read(true);
    }

    @JSFunction
    public ConsoleReader getConsoleReader() {
        return this.cr;
    }

    @JSFunction
    public boolean isAnsiSupported() {
        try {
            if (this.getConsoleReader() != null) {
                return this.getConsoleReader().getTerminal().isAnsiSupported();
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

