/*
 * Decompiled with CFR 0.152.
 */
package openaf.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import openaf.AFBase;
import openaf.AFCmdBase;
import openaf.JSEngine;
import openaf.SimpleLog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.universalchardet.UniversalDetector;

public class IO
extends ScriptableObject {
    protected static PosixFilePermission[] permissionBits = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public static String getFileEncoding(String string) throws IOException {
        byte[] byArray = new byte[4096];
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            UniversalDetector universalDetector = new UniversalDetector(null);
            if (fileInputStream != null) {
                int n;
                String string2 = null;
                while ((n = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
                    universalDetector.handleData(byArray, 0, n);
                }
                universalDetector.dataEnd();
                string2 = universalDetector.getDetectedCharset();
                universalDetector.reset();
                String string3 = string2;
                return string3;
            }
            String string4 = null;
            return string4;
        }
    }

    @JSFunction
    public static String getDefaultEncoding() {
        return System.getProperty("file.encoding");
    }

    @JSFunction
    public static void convertFileToEncoding(String string, String string2, String string3) throws IOException {
        if (string3 == null || string3.equals("undefined")) {
            string3 = System.getProperty("file.encoding");
        }
        FileUtils.writeStringToFile((File)new File(string2), (String)FileUtils.readFileToString((File)new File(string), (String)IO.getFileEncoding(string)), (String)string3);
    }

    @JSFunction
    public static Object listFiles(String string, boolean bl) throws IOException {
        File[] fileArray;
        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
        JSEngine.JSList jSList = AFCmdBase.jse.getNewList(null);
        File file = new File(string);
        if (file != null && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2 == null) continue;
                BasicFileAttributes basicFileAttributes = null;
                try {
                    if (bl) {
                        try {
                            basicFileAttributes = Files.readAttributes(file2.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                        }
                        catch (Exception exception) {
                            bl = false;
                            basicFileAttributes = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                        }
                    } else {
                        basicFileAttributes = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JSEngine.JSMap jSMap2 = AFCmdBase.jse.getNewMap(jSMap.getMap());
                StringBuilder stringBuilder = new StringBuilder();
                jSMap2.put("isDirectory", file2.isDirectory());
                jSMap2.put("isFile", file2.isFile());
                jSMap2.put("filename", file2.getName());
                jSMap2.put("filepath", file2.getPath().replaceAll("\\\\", "/"));
                try {
                    jSMap2.put("canonicalPath", file2.getCanonicalPath().replaceAll("\\\\", "/"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                jSMap2.put("lastModified", file2.lastModified());
                if (basicFileAttributes != null) {
                    jSMap2.put("createTime", basicFileAttributes.creationTime().toMillis());
                }
                if (basicFileAttributes != null) {
                    jSMap2.put("lastAccess", basicFileAttributes.lastAccessTime().toMillis());
                }
                jSMap2.put("size", file2.length());
                if (file2.canExecute()) {
                    stringBuilder.append("x");
                }
                if (file2.canRead()) {
                    stringBuilder.append("r");
                }
                if (file2.canWrite()) {
                    stringBuilder.append("w");
                }
                jSMap2.put("permissions", stringBuilder.toString());
                if (bl && basicFileAttributes != null) {
                    jSMap2.put("group", ((PosixFileAttributes)basicFileAttributes).group().getName());
                    jSMap2.put("user", ((PosixFileAttributes)basicFileAttributes).owner().getName());
                    jSMap2.put("gid", ((PosixFileAttributes)basicFileAttributes).group().hashCode());
                    jSMap2.put("uid", ((PosixFileAttributes)basicFileAttributes).owner().hashCode());
                    String string2 = PosixFilePermissions.toString(((PosixFileAttributes)basicFileAttributes).permissions());
                    jSMap2.put("posixPermissions", string2);
                    int n = 0;
                    Set<PosixFilePermission> set = PosixFilePermissions.fromString(string2);
                    for (int i = 0; i < permissionBits.length; ++i) {
                        if (!set.contains((Object)permissionBits[i])) continue;
                        n += 1 << i;
                    }
                    jSMap2.put("mode", n);
                }
                jSList.add(jSMap2.getMap());
            }
            jSMap.put("files", jSList.getList());
        }
        return jSMap.getMap();
    }

    @JSFunction
    public static Object fileInfo(String string, boolean bl) throws IOException {
        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
        File file = new File(string);
        if (file != null) {
            BasicFileAttributes basicFileAttributes = null;
            try {
                if (bl) {
                    try {
                        basicFileAttributes = Files.readAttributes(file.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    }
                    catch (Exception exception) {
                        bl = false;
                        basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    }
                } else {
                    basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder stringBuilder = new StringBuilder();
            jSMap.put("isDirectory", file.isDirectory());
            jSMap.put("isFile", file.isFile());
            jSMap.put("filename", file.getName());
            jSMap.put("filepath", file.getPath().replaceAll("\\\\", "/"));
            try {
                jSMap.put("canonicalPath", file.getCanonicalPath().replaceAll("\\\\", "/"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            jSMap.put("lastModified", file.lastModified());
            if (basicFileAttributes != null) {
                jSMap.put("createTime", basicFileAttributes.creationTime().toMillis());
            }
            if (basicFileAttributes != null) {
                jSMap.put("lastAccess", basicFileAttributes.lastAccessTime().toMillis());
            }
            jSMap.put("size", file.length());
            if (file.canExecute()) {
                stringBuilder.append("x");
            }
            if (file.canRead()) {
                stringBuilder.append("r");
            }
            if (file.canWrite()) {
                stringBuilder.append("w");
            }
            jSMap.put("permissions", stringBuilder.toString());
            if (bl && basicFileAttributes != null) {
                jSMap.put("group", ((PosixFileAttributes)basicFileAttributes).group().getName());
                jSMap.put("user", ((PosixFileAttributes)basicFileAttributes).owner().getName());
                jSMap.put("gid", ((PosixFileAttributes)basicFileAttributes).group().hashCode());
                jSMap.put("uid", ((PosixFileAttributes)basicFileAttributes).owner().hashCode());
                String string2 = PosixFilePermissions.toString(((PosixFileAttributes)basicFileAttributes).permissions());
                jSMap.put("posixPermissions", string2);
                int n = 0;
                Set<PosixFilePermission> set = PosixFilePermissions.fromString(string2);
                for (int i = 0; i < permissionBits.length; ++i) {
                    if (!set.contains((Object)permissionBits[i])) continue;
                    n += 1 << i;
                }
                jSMap.put("mode", n);
            }
        }
        return jSMap.getMap();
    }

    @JSFunction
    public static Object listFilenames(String string, boolean bl) throws IOException {
        DirectoryStream<Path> directoryStream;
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        if (path != null && (directoryStream = Files.newDirectoryStream(path)) != null) {
            for (Path path2 : directoryStream) {
                if (path2 == null) continue;
                if (bl) {
                    arrayList.add(path2.getFileName().toString());
                    continue;
                }
                arrayList.add(path2.toAbsolutePath().toString());
            }
            directoryStream.close();
        }
        return AFCmdBase.jse.newArray(AFCmdBase.jse.getGlobalscope(), arrayList.toArray());
    }

    @JSFunction
    public static Object readFileAsArray(String string, String string2) throws IOException {
        JSEngine.JSList jSList = AFCmdBase.jse.getNewList(null);
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            jSList.addAll(FileUtils.readLines((File)new File(string), (String)string2));
        }
        catch (IOException iOException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + string + "; " + iOException.getMessage(), iOException);
            throw iOException;
        }
        return jSList.getList();
    }

    @JSFunction
    public static String readFileString(String string, String string2) throws IOException {
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            return IO.__readFileToString(string, string2);
        }
        catch (IOException iOException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + string + "; " + iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] __readFileToBytes(String string) throws IOException {
        if (string.indexOf("::") > -1) {
            byte[] byArray;
            block9: {
                String[] stringArray = string.split("::");
                ZipFile zipFile = new ZipFile(stringArray[0]);
                byArray = null;
                if (zipFile != null) {
                    try {
                        ZipEntry zipEntry = zipFile.getEntry(stringArray[1]);
                        if (zipEntry != null) {
                            InputStream inputStream = zipFile.getInputStream(zipEntry);
                            if (inputStream == null) break block9;
                            try {
                                byArray = IOUtils.toByteArray((InputStream)inputStream);
                                break block9;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        throw new IOException("file '" + stringArray[1] + "' not found in '" + stringArray[0] + "'");
                    }
                    finally {
                        zipFile.close();
                    }
                }
            }
            return byArray;
        }
        return FileUtils.readFileToByteArray((File)new File(string));
    }

    protected static String __readFileToString(String string, String string2) throws UnsupportedEncodingException, IOException {
        return new String(IO.__readFileToBytes(string), string2);
    }

    protected static String removeLines(String string, long l) {
        for (long i = 0L; i < l; ++i) {
            string = string.substring(string.indexOf("\n"));
        }
        return string;
    }

    @JSFunction
    public static Object readFileXML(String string, int n, String string2) throws IOException {
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            return AFCmdBase.jse.newObject(AFCmdBase.jse.getGlobalscope(), "XMLList", new Object[]{IO.removeLines(IO.__readFileToString(string, string2), n)});
        }
        catch (IOException iOException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + string + "; " + iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    @JSFunction
    public static Object readFileBytes(String string) throws IOException {
        try {
            return IO.__readFileToBytes(string);
        }
        catch (IOException iOException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + string + "; " + iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    @JSFunction
    public static void writeFile(String string, Object object, String string2, boolean bl) throws Exception {
        Object object2 = AFCmdBase.jse.stringify(object);
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            FileUtils.writeStringToFile((File)new File(string), (String)object2.toString(), (String)string2, (boolean)bl);
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error writing file: " + exception.getMessage(), exception);
            throw exception;
        }
    }

    @JSFunction
    public static void writeFileString(String string, String string2, String string3, boolean bl) throws IOException {
        try {
            if (string3 == null || string3.equals("undefined")) {
                string3 = "UTF-8";
            }
            FileUtils.writeStringToFile((File)new File(string), (String)string2, (String)string3, (boolean)bl);
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error writing file: " + exception.getMessage(), exception);
            throw exception;
        }
    }

    @JSFunction
    public static void writeFileXML(String string, Object object, String string2, boolean bl) throws IOException {
        if (string2 == null || string2.equals("undefined")) {
            string2 = "UTF-8";
        }
        String string3 = "";
        if (object != null) {
            string3 = AFBase.fromXML(object);
        }
        FileUtils.writeStringToFile((File)new File(string), (String)string3, (String)string2, (boolean)bl);
    }

    @JSFunction
    public static void writeFileBytes(String string, Object object) throws Exception {
        try {
            FileUtils.writeByteArrayToFile((File)new File(string), (byte[])((byte[])object));
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error writing file: " + exception.getMessage(), exception);
            throw exception;
        }
    }

    @JSFunction
    public static void writeFileAsArray(String string, Object object, String string2) throws Exception {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object instanceof NativeArray) {
            if (string2 != null && string2.equals("undefined")) {
                string2 = null;
            }
            object2 = (NativeArray)object;
            arrayList = new ArrayList();
            Object[] objectArray = object2.iterator();
            while (objectArray.hasNext()) {
                Object e = objectArray.next();
                arrayList.add(Context.toString(e));
            }
        }
        AFCmdBase.jse.enterContext();
        try {
            object2 = string2 != null && string2.length() > 0 ? new PrintWriter(string, string2) : new PrintWriter(string);
            for (Object object3 : arrayList.toArray()) {
                ((PrintWriter)object2).println(object3);
            }
            ((PrintWriter)object2).close();
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error writing file: " + exception.getMessage(), exception);
            throw exception;
        }
        finally {
            AFCmdBase.jse.exitContext();
        }
    }

    @JSFunction
    public static Object readFile(String string, String string2) throws Exception {
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            String string3 = IO.__readFileToString(string, string2);
            return string3;
        }
        catch (IOException iOException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + string + "; " + iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    @JSFunction
    public static Object gzip(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        IOUtils.write((byte[])((byte[])object), (OutputStream)gZIPOutputStream);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @JSFunction
    public static Object gunzip(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
        IOUtils.copy((InputStream)gZIPInputStream, (OutputStream)byteArrayOutputStream);
        gZIPInputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @JSFunction
    public static Object randomAccessFile(String string, String string2) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, string2);
        return randomAccessFile;
    }

    @JSFunction
    public static Object writeFileGzipStream(String string, boolean bl) throws IOException {
        return new GZIPOutputStream(FileUtils.openOutputStream((File)new File(string), (boolean)bl));
    }

    @JSFunction
    public static Object readFileGzipStream(String string) throws IOException {
        return new GZIPInputStream(FileUtils.openInputStream((File)new File(string)));
    }

    @JSFunction
    public static Object writeFileStream(String string, boolean bl) throws IOException {
        return FileUtils.openOutputStream((File)new File(string), (boolean)bl);
    }

    @JSFunction
    public static Object readFileStream(String string) throws IOException {
        return FileUtils.openInputStream((File)new File(string));
    }

    public String getClassName() {
        return "IO";
    }

    @JSFunction
    public static boolean fileExists(String string) {
        return new File(string).exists();
    }

    @JSFunction
    public static String getCanonicalPath(String string) throws IOException {
        return new File(string).getCanonicalFile().toString();
    }

    @JSFunction
    public boolean mkdir(String string) throws IOException {
        return new File(string).mkdirs();
    }

    @JSFunction
    public boolean rm(String string) throws IOException {
        File file = new File(string);
        if (!file.isDirectory()) {
            return Files.deleteIfExists(Paths.get(string, new String[0]));
        }
        FileUtils.deleteDirectory((File)new File(string));
        return true;
    }

    @JSFunction
    public boolean rename(String string, String string2) {
        return new File(string).renameTo(new File(string2));
    }

    @JSFunction
    public boolean mv(String string, String string2) throws IOException {
        return Files.move(new File(string).toPath(), new File(string2).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE) != null;
    }

    @JSFunction
    public void cp(String string, String string2) throws IOException {
        Files.copy(new File(string).toPath(), new File(string2).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @JSFunction
    public String createTempFile(String string, String string2, Object object) throws IOException {
        if (string.equals("undefined")) {
            string = "";
        }
        if (string2.equals("undefined")) {
            string2 = "";
        }
        if (object != null && object instanceof String) {
            Path path = Files.createTempFile(new File((String)object).toPath(), string, string2, new FileAttribute[0]);
            path.toFile().deleteOnExit();
            return path.toFile().getAbsolutePath();
        }
        File file = File.createTempFile(string, string2);
        file.deleteOnExit();
        return file.getAbsolutePath();
    }

    @JSFunction
    public String createTempDir(String string, Object object) throws IOException {
        if (string.equals("undefined")) {
            string = "";
        }
        final Path path = object != null && object instanceof String ? Files.createTempDirectory(new File((String)object).toPath(), string, new FileAttribute[0]) : Files.createTempDirectory(string, new FileAttribute[0]);
        final IO iO = this;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    iO.rm(path.toFile().getAbsolutePath());
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }));
        return path.toFile().getAbsolutePath();
    }
}

