/*
 * Decompiled with CFR 0.152.
 */
package openaf.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import openaf.AFCmdBase;
import openaf.DBProxy;
import openaf.JSEngine;
import openaf.OAFdCL;
import openaf.SimpleLog;
import org.apache.commons.io.IOUtils;
import org.h2.tools.Server;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.Scriptable;

public class DB {
    protected static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    protected static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    protected static final String H2_DRIVER = "org.h2.Driver";
    public static HashMap<String, String> drivers = new HashMap();
    protected final Long LIMIT_RESULTS = 100000000L;
    protected Connection con;
    protected Server h2Server;
    protected ConcurrentHashMap<String, PreparedStatement> preparedStatements = new ConcurrentHashMap();
    protected boolean convertDates = false;
    public String url;

    public void newDB(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (string.startsWith("jdbc:")) {
            if (string2 != null) {
                for (String string6 : drivers.keySet()) {
                    if (!string.startsWith(string6)) continue;
                    this.connect(drivers.get(string6), string, string2, string3, string4);
                }
                if (string2.startsWith("jdbc:oracle")) {
                    this.connect(ORACLE_DRIVER, string, string2, string3, string4);
                }
                if (string2.startsWith("jdbc:postgresql")) {
                    this.connect(POSTGRESQL_DRIVER, string, string2, string3, string4);
                }
                if (string2.startsWith("jdbc:h2")) {
                    this.connect(H2_DRIVER, string, string2, string3, string4);
                }
            }
        } else {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "New DB with driver='" + string + "'|url='" + string2 + "'|login='" + string3 + "'|pass='" + string4 + "'|timeout='" + string5 + "'", null);
            this.connect(string, string2, string3, string4, string5);
        }
    }

    public void close() throws SQLException {
        if (this.con != null) {
            this.closeAllStatements();
            this.con.close();
        }
    }

    public Object getStatements() {
        JSEngine.JSList jSList = AFCmdBase.jse.getNewList(null);
        jSList.addAll(this.preparedStatements.keySet());
        return jSList.getList();
    }

    public Object getConnect() {
        return this.con;
    }

    public void closeStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.con != null && (preparedStatement = this.preparedStatements.get(string)) != null) {
            preparedStatement.close();
            this.preparedStatements.remove(string);
        }
    }

    public void closeAllStatements() throws SQLException {
        if (this.con != null) {
            for (PreparedStatement preparedStatement : this.preparedStatements.values()) {
                preparedStatement.close();
            }
        }
    }

    public Object q(String string) throws IOException, SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = resultSet.getMetaData().getColumnCount();
            JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
            JSEngine.JSList jSList = AFCmdBase.jse.getNewList(jSMap.getMap());
            while (resultSet.next()) {
                JSEngine.JSMap jSMap2 = AFCmdBase.jse.getNewMap(jSList.getList());
                for (int i = 1; i <= n; ++i) {
                    InputStream inputStream;
                    if (resultSet.getMetaData().getColumnType(i) == 2 || resultSet.getMetaData().getColumnType(i) == 3 || resultSet.getMetaData().getColumnType(i) == 8 || resultSet.getMetaData().getColumnType(i) == 6 || resultSet.getMetaData().getColumnType(i) == 4) {
                        if (resultSet.getObject(i) != null) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), Double.valueOf(resultSet.getObject(i).toString()));
                            continue;
                        }
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(i) == 2005 || resultSet.getMetaData().getColumnType(i) == -1) {
                        try {
                            inputStream = resultSet.getMetaData().getColumnType(i) == 2005 ? resultSet.getClob(i).getAsciiStream() : resultSet.getAsciiStream(i);
                            StringWriter stringWriter = new StringWriter();
                            IOUtils.copy((InputStream)inputStream, (Writer)stringWriter, (Charset)null);
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), stringWriter.toString());
                        }
                        catch (Exception exception) {
                            SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem getting clob", exception);
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                        }
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(i) == 2004 || resultSet.getMetaData().getColumnType(i) == -2 || resultSet.getMetaData().getColumnType(i) == -4) {
                        try {
                            inputStream = resultSet.getMetaData().getColumnType(i) == 2004 ? resultSet.getBlob(i).getBinaryStream() : resultSet.getBinaryStream(i);
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), IOUtils.toByteArray((InputStream)inputStream));
                        }
                        catch (Exception exception) {
                            SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem getting blob", exception);
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                        }
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(i) == 16) {
                        if (resultSet.getBoolean(i)) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), true);
                            continue;
                        }
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), false);
                        continue;
                    }
                    if (this.convertDates) {
                        if (resultSet.getMetaData().getColumnType(i) == 91) {
                            if (resultSet.getDate(i) != null) {
                                jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getDate(i).getTime()}));
                                continue;
                            }
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                            continue;
                        }
                        if (resultSet.getMetaData().getColumnType(i) == 93 || resultSet.getMetaData().getColumnType(i) == 2014 || resultSet.getMetaData().getColumnTypeName(i).equals("TIMESTAMP WITH TIME ZONE")) {
                            if (resultSet.getTimestamp(i) != null) {
                                jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getTimestamp(i).getTime()}));
                                continue;
                            }
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                            continue;
                        }
                        if (resultSet.getMetaData().getColumnType(i) == 92 || resultSet.getMetaData().getColumnType(i) == 2013) {
                            if (resultSet.getTime(i) != null) {
                                jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getTime(i).getTime()}));
                                continue;
                            }
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                            continue;
                        }
                    }
                    if (resultSet.getObject(i) != null) {
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), resultSet.getObject(i).toString());
                        continue;
                    }
                    jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                }
                jSList.add(jSMap2.getMap());
            }
            resultSet.close();
            preparedStatement.close();
            jSMap.put("results", jSList.getList());
            return jSMap.getMap();
        }
        return null;
    }

    public Object qsRS(String string, JSEngine.JSList jSList) throws IOException, SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = null;
            preparedStatement = this.con.prepareStatement(string);
            int n = 0;
            for (Object object : jSList) {
                preparedStatement.setObject(++n, object);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            return resultSet;
        }
        return null;
    }

    public Object qs(String string, JSEngine.JSList jSList, boolean bl) throws IOException, SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.preparedStatements.get(string);
            if (preparedStatement == null) {
                preparedStatement = this.con.prepareStatement(string);
                if (bl) {
                    this.preparedStatements.putIfAbsent(string, preparedStatement);
                }
            }
            int n = 0;
            for (Object object : jSList) {
                preparedStatement.setObject(++n, object);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = resultSet.getMetaData().getColumnCount();
            JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
            JSEngine.JSList jSList2 = AFCmdBase.jse.getNewList(jSMap.getMap());
            while (resultSet.next()) {
                JSEngine.JSMap jSMap2 = AFCmdBase.jse.getNewMap(jSList2.getList());
                for (int i = 1; i <= n2; ++i) {
                    InputStream inputStream;
                    if (resultSet.getMetaData().getColumnType(i) == 2 || resultSet.getMetaData().getColumnType(i) == 3 || resultSet.getMetaData().getColumnType(i) == 8 || resultSet.getMetaData().getColumnType(i) == 6 || resultSet.getMetaData().getColumnType(i) == 4) {
                        if (resultSet.getObject(i) != null) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), Double.valueOf(resultSet.getObject(i).toString()));
                            continue;
                        }
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(i) == 2005 || resultSet.getMetaData().getColumnType(i) == -1) {
                        inputStream = resultSet.getMetaData().getColumnType(i) == 2005 ? resultSet.getClob(i).getAsciiStream() : resultSet.getAsciiStream(i);
                        StringWriter stringWriter = new StringWriter();
                        IOUtils.copy((InputStream)inputStream, (Writer)stringWriter, (Charset)null);
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), stringWriter.toString());
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(i) == 2004 || resultSet.getMetaData().getColumnType(i) == -2 || resultSet.getMetaData().getColumnType(i) == -4) {
                        inputStream = resultSet.getMetaData().getColumnType(i) == 2004 ? resultSet.getBlob(i).getBinaryStream() : resultSet.getBinaryStream(i);
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), IOUtils.toByteArray((InputStream)inputStream));
                        continue;
                    }
                    if (this.convertDates) {
                        if (resultSet.getMetaData().getColumnType(i) == 91) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getDate(i).getTime()}));
                            continue;
                        }
                        if (resultSet.getMetaData().getColumnType(i) == 93 || resultSet.getMetaData().getColumnType(i) == 2014 || resultSet.getMetaData().getColumnTypeName(i).equals("TIMESTAMP WITH TIME ZONE")) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getTimestamp(i).getTime()}));
                            continue;
                        }
                        if (resultSet.getMetaData().getColumnType(i) == 92 || resultSet.getMetaData().getColumnType(i) == 2013) {
                            jSMap2.put(resultSet.getMetaData().getColumnLabel(i), AFCmdBase.jse.newObject((Scriptable)AFCmdBase.jse.getGlobalscope(), "Date", new Object[]{resultSet.getTime(i).getTime()}));
                            continue;
                        }
                    }
                    if (resultSet.getObject(i) != null) {
                        jSMap2.put(resultSet.getMetaData().getColumnLabel(i), resultSet.getObject(i).toString());
                        continue;
                    }
                    jSMap2.put(resultSet.getMetaData().getColumnLabel(i), null);
                }
                jSList2.add(jSMap2.getMap());
            }
            resultSet.close();
            if (!bl) {
                preparedStatement.close();
            }
            jSMap.put("results", jSList2.getList());
            return jSMap.getMap();
        }
        return null;
    }

    public Object qLob(String string) throws Exception {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            if (resultSet.getMetaData().getColumnType(1) == 2005) {
                StringWriter stringWriter = new StringWriter();
                try {
                    InputStream inputStream = resultSet.getClob(1).getAsciiStream();
                    IOUtils.copy((InputStream)inputStream, (Writer)stringWriter, (Charset)null);
                }
                catch (Exception exception) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem getting clob", exception);
                }
                return stringWriter.toString();
            }
            if (resultSet.getMetaData().getColumnType(1) == 2004) {
                try {
                    InputStream inputStream = resultSet.getBlob(1).getBinaryStream();
                    return IOUtils.toByteArray((InputStream)inputStream);
                }
                catch (Exception exception) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Problem getting blob", exception);
                    return null;
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        return null;
    }

    public int u(String string) throws SQLException {
        if (this.con != null) {
            Statement statement = this.con.createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            return n;
        }
        return -1;
    }

    public int us(String string, JSEngine.JSList jSList, boolean bl) throws SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.preparedStatements.get(string);
            if (preparedStatement != null) {
                bl = true;
            } else {
                preparedStatement = this.con.prepareStatement(string);
                if (bl) {
                    this.preparedStatements.putIfAbsent(string, preparedStatement);
                }
            }
            int n = 0;
            for (Object object : jSList) {
                ++n;
                if (object instanceof IdScriptableObject && ((IdScriptableObject)object).getClassName().equals("Date")) {
                    object = Context.jsToJava((Object)object, Date.class);
                }
                try {
                    preparedStatement.setObject(n, object);
                }
                catch (Exception exception) {
                    System.err.println("ERROR: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            int n2 = preparedStatement.executeUpdate();
            if (!bl) {
                preparedStatement.close();
            }
            return n2;
        }
        return -1;
    }

    public long usArray(String string, JSEngine.JSList jSList, int n, boolean bl) throws SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.preparedStatements.get(string);
            if (preparedStatement != null) {
                bl = true;
            } else {
                preparedStatement = this.con.prepareStatement(string);
                if (bl) {
                    this.preparedStatements.putIfAbsent(string, preparedStatement);
                }
            }
            int n2 = 0;
            long l = 0L;
            if (n <= 0) {
                n = 1000;
            }
            Object object = jSList.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                JSEngine.JSList jSList2 = (JSEngine.JSList)object2;
                int n3 = 1;
                Object object3 = jSList2.iterator();
                while (object3.hasNext()) {
                    Object object4 = object3.next();
                    preparedStatement.setObject(n3++, object4);
                }
                preparedStatement.addBatch();
                if (++n2 % n != 0) continue;
                for (Object object5 : object3 = (Object)preparedStatement.executeBatch()) {
                    if (object5 <= 0) continue;
                    l += (long)object5;
                }
                preparedStatement.clearBatch();
            }
            if (n2 % n != 0) {
                for (Object object6 : object = (Object)preparedStatement.executeBatch()) {
                    if (object6 <= 0) continue;
                    l += (long)object6;
                }
                preparedStatement.clearBatch();
            }
            if (!bl) {
                preparedStatement.close();
            }
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (long)((int)l);
        }
        return -1L;
    }

    public int uLob(String string, Object object) throws SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            if (object instanceof NativeJavaArray) {
                object = ((NativeJavaArray)object).unwrap();
            }
            if (object instanceof byte[]) {
                preparedStatement.setBlob(1, new ByteArrayInputStream((byte[])object));
            } else {
                StringReader stringReader = new StringReader((String)object);
                preparedStatement.setCharacterStream(1, (Reader)stringReader, ((String)object).length());
            }
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
            return n;
        }
        return -1;
    }

    public int uLobs(String string, JSEngine.JSList jSList) throws SQLException {
        if (this.con != null) {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            int n = 0;
            for (Object object : jSList) {
                ++n;
                if (object instanceof NativeJavaArray) {
                    object = ((NativeJavaArray)object).unwrap();
                }
                if (object instanceof byte[]) {
                    preparedStatement.setBlob(n, new ByteArrayInputStream((byte[])object));
                    continue;
                }
                StringReader stringReader = new StringReader((String)object);
                preparedStatement.setCharacterStream(n, (Reader)stringReader, ((String)object).length());
            }
            int n2 = preparedStatement.executeUpdate();
            preparedStatement.close();
            return n2;
        }
        return -1;
    }

    public void commit() throws SQLException {
        if (this.con != null) {
            try {
                this.con.commit();
            }
            catch (SQLException sQLException) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Error while commit on " + this.url + ": " + sQLException.getMessage(), sQLException);
                throw sQLException;
            }
        }
    }

    public void rollback(boolean bl) throws SQLException {
        if (this.con != null) {
            try {
                this.con.rollback();
            }
            catch (SQLException sQLException) {
                if (!bl) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Error while rollback on " + this.url + ": " + sQLException.getMessage(), sQLException);
                }
                SimpleLog.log(SimpleLog.logtype.ERROR, "Error while rollback on " + this.url + ": " + sQLException.getMessage(), sQLException);
                throw sQLException;
            }
        }
    }

    protected void connect(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (OAFdCL.oafdcl != null) {
            Class.forName(string, true, OAFdCL.oafdcl);
        } else {
            Class.forName(string);
        }
        this.url = string2;
        Properties properties = new Properties();
        if (string3 != null) {
            properties.setProperty("user", AFCmdBase.afc.dIP(string3));
        }
        if (string4 != null) {
            properties.setProperty("password", AFCmdBase.afc.dIP(string4));
        }
        try {
            if (string5 != null && Integer.valueOf(string5) > 0) {
                properties.setProperty("connectTimeout", string5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.con = DriverManager.getConnection(string2, properties);
            try {
                this.con.setAutoCommit(false);
            }
            catch (Exception exception) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Error on setAutoCommit: " + exception.getMessage(), exception);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().contains("No suitable driver found")) {
                SimpleLog.log(SimpleLog.logtype.DEBUG, "Using OAFdCL to load '" + string + "': " + sQLException.getMessage(), sQLException);
                Driver driver = (Driver)Class.forName(string, true, OAFdCL.oafdcl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(new DBProxy(driver));
                this.con = DriverManager.getConnection(string2, properties);
                try {
                    this.con.setAutoCommit(false);
                }
                catch (Exception exception) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Error on setAutoCommit: " + exception.getMessage(), exception);
                }
            }
            throw sQLException;
        }
    }

    public String h2StartServer(int n, JSEngine.JSList jSList) throws SQLException {
        if (n >= 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (jSList != null) {
                arrayList.add("-tcpPort");
                arrayList.add("" + n);
                for (Object object : jSList) {
                    arrayList.add(String.valueOf(object));
                }
                this.h2Server = Server.createTcpServer((String[])arrayList.toArray(new String[arrayList.size()])).start();
                return this.h2Server.getURL();
            }
            if (n > 0) {
                arrayList.add("-tcpPort");
                arrayList.add("" + n);
            }
            this.h2Server = Server.createTcpServer((String[])arrayList.toArray(new String[arrayList.size()])).start();
            return this.h2Server.getURL();
        }
        return "";
    }

    public void h2StopServer() {
        this.h2Server.stop();
    }

    public void convertDates(boolean bl) {
        this.convertDates = bl;
    }

    public void setAutoCommit(boolean bl) throws Exception {
        if (this.con == null) {
            throw new Exception("No connection defined.");
        }
        this.con.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws Exception {
        if (this.con != null) {
            return this.con.getAutoCommit();
        }
        throw new Exception("No connection defined.");
    }

    static {
        drivers.put("jdbc:oracle:", ORACLE_DRIVER);
        drivers.put("jdbc:postgresql:", POSTGRESQL_DRIVER);
        drivers.put("jdbc:h2:", H2_DRIVER);
    }
}

