/*
 * Decompiled with CFR 0.152.
 */
package openaf.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CSV {
    protected Map<Long, String> header = new ConcurrentHashMap<Long, String>();
    protected Map<Long, valuetypes> headerType = new ConcurrentHashMap<Long, valuetypes>();
    protected List<Map<String, String>> values = Collections.synchronizedList(new ArrayList());
    protected boolean isDetermineTypesComplete = false;
    protected String separator = ";";
    protected String stringDelimeter = "\"";

    public void clear() {
        this.header.clear();
        this.values.clear();
        this.headerType.clear();
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setStringDelimiter(String string) {
        this.stringDelimeter = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException {
        try (FileReader fileReader = null;){
            fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                this.readHeader(string2);
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                this.readValue(string2);
            }
            bufferedReader.close();
        }
    }

    public CSV(String string) throws IOException {
        if (string.length() > 0) {
            this.readString(string);
        }
    }

    protected void readHeader(String string) {
        int n = 0;
        for (String string2 : string.split(this.separator)) {
            this.header.put(Long.valueOf(n), string2);
            ++n;
        }
    }

    protected void determineTypes(String string) {
        int n = 0;
        for (String string2 : string.split(this.separator)) {
            if (string2.startsWith(this.stringDelimeter) && string2.endsWith(this.stringDelimeter)) {
                this.headerType.put(Long.valueOf(n), valuetypes.STRING);
            } else if (string2.length() > 0) {
                try {
                    Double.valueOf(string2);
                    this.headerType.put(Long.valueOf(n), valuetypes.NUMBER);
                }
                catch (Exception exception) {
                    this.headerType.put(Long.valueOf(n), valuetypes.STRING);
                }
            }
            ++n;
        }
        if (this.headerType.size() == this.header.size()) {
            this.isDetermineTypesComplete = true;
        }
    }

    protected void readValue(String string) {
        long l = 0L;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!this.isDetermineTypesComplete) {
            this.determineTypes(string);
        }
        for (String string2 : string.split(this.separator)) {
            if (this.headerType.get(l) != null && this.headerType.get(l).equals((Object)valuetypes.STRING) && string2 != null) {
                if (string2.equals("\"\"")) {
                    string2 = "";
                } else if (string2.length() > 2) {
                    if (string2.indexOf(this.stringDelimeter) == 0) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    if (string2.indexOf(this.stringDelimeter) == string2.length() - 1) {
                        string2 = string2.substring(0, string2.length() - 2);
                    }
                }
            }
            hashMap.put(this.header.get(l), string2);
            ++l;
        }
        this.values.add(hashMap);
    }

    protected long readString(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        this.clear();
        long l = -1L;
        String string2 = bufferedReader.readLine();
        l = 1L;
        if (string2 != null) {
            this.readHeader(string2);
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            this.readValue(string2);
            ++l;
        }
        bufferedReader.close();
        return l;
    }

    public void fromCSV(String string) throws IOException {
        this.readString(string);
    }

    public void toCsv(ArrayList<HashMap<String, Object>> arrayList, Object[] objectArray) {
        this.clear();
        HashMap<String, String> hashMap = null;
        long l = -1L;
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap<String, Object> hashMap2 = arrayList.get(i);
            if (objectArray == null) {
                objectArray = hashMap2.keySet().toArray();
            }
            l = 0L;
            hashMap = new HashMap<String, String>();
            for (int j = 0; j < objectArray.length; ++j) {
                String string = (String)objectArray[j];
                if (i == 0) {
                    this.header.put(l, string.toString());
                    if (hashMap2.get(string) instanceof Double || hashMap2.get(string) instanceof Integer || hashMap2.get(string) instanceof Long) {
                        this.headerType.put(l, valuetypes.NUMBER);
                    } else {
                        this.headerType.put(l, valuetypes.STRING);
                    }
                }
                if (hashMap2.get(string) != null) {
                    hashMap.put(string.toString(), hashMap2.get(string).toString());
                } else {
                    hashMap.put(string.toString(), null);
                }
                ++l;
            }
            if (hashMap.size() <= 0) continue;
            this.values.add(hashMap);
        }
    }

    public void p(String string) {
        System.out.println(string);
    }

    public long writeFile(String string) throws IOException {
        long l = -1L;
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(string);
            Object object = "";
            for (long i = 0L; i < (long)this.header.keySet().size(); ++i) {
                object = (String)object + this.header.get(i);
                if (i >= (long)(this.header.keySet().size() - 1)) continue;
                object = (String)object + this.separator;
            }
            printWriter.println((String)object);
            l = 1L;
            for (Map<String, String> map : this.values) {
                object = "";
                for (long i = 0L; i < (long)this.header.keySet().size(); ++i) {
                    object = this.headerType.get(i) == valuetypes.NUMBER ? (String)object + map.get(this.header.get(i)) : (String)object + this.stringDelimeter + map.get(this.header.get(i)) + this.stringDelimeter;
                    if (i >= (long)(this.header.keySet().size() - 1)) continue;
                    object = (String)object + this.separator;
                }
                if (l == (long)this.values.size()) {
                    printWriter.print((String)object);
                } else {
                    printWriter.println((String)object);
                }
                ++l;
            }
            printWriter.flush();
        }
        return l;
    }

    public String w() throws IOException {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        stringWriter = new StringWriter();
        printWriter = new PrintWriter(stringWriter);
        Object object = "";
        for (long i = 0L; i < (long)this.header.keySet().size(); ++i) {
            object = (String)object + this.header.get(i);
            if (i >= (long)(this.header.keySet().size() - 1)) continue;
            object = (String)object + this.separator;
        }
        printWriter.println((String)object);
        for (Map<String, String> map : this.values) {
            object = "";
            for (long i = 0L; i < (long)this.header.keySet().size(); ++i) {
                object = this.headerType.get(i) == valuetypes.NUMBER ? (String)object + map.get(this.header.get(i)) : (String)object + this.stringDelimeter + map.get(this.header.get(i)) + this.stringDelimeter;
                if (i >= (long)(this.header.keySet().size() - 1)) continue;
                object = (String)object + this.separator;
            }
            printWriter.println((String)object);
        }
        printWriter.flush();
        stringWriter.flush();
        printWriter.close();
        stringWriter.close();
        return stringWriter.toString().replaceFirst("[\r\n]$", "");
    }

    public long readFile(String string) throws IOException {
        this.clear();
        long l = -1L;
        try (FileReader fileReader = null;){
            fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            l = 1L;
            if (string2 != null) {
                this.readHeader(string2);
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                this.readValue(string2);
                ++l;
            }
            bufferedReader.close();
        }
        return l;
    }

    public ArrayList<HashMap<String, Object>> csv() {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        for (Map<String, String> map : this.values) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (long i = 0L; i < (long)this.header.keySet().size(); ++i) {
                if (this.headerType.get(i) == valuetypes.NUMBER) {
                    try {
                        Long l = Long.getLong(map.get(this.header.get(i)));
                        hashMap.put(this.header.get(i), l);
                    }
                    catch (Exception exception) {
                        try {
                            Double d = Double.valueOf(map.get(this.header.get(i)));
                            hashMap.put(this.header.get(i), d);
                        }
                        catch (Exception exception2) {
                            hashMap.put(this.header.get(i), map.get(this.header.get(i)));
                        }
                    }
                    continue;
                }
                hashMap.put(this.header.get(i), map.get(this.header.get(i)));
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    protected static enum valuetypes {
        STRING,
        NUMBER;

    }
}

