/*
 * Decompiled with CFR 0.152.
 */
package openaf.asciitable.render;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.V2_Row;
import openaf.AFCmdBase;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;

public class WidthAnsiLongestWordTab
implements V2_Width {
    protected int max;
    protected int[] maxAr;
    protected static NativeFunction callback;

    public WidthAnsiLongestWordTab(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Sizeimum column width cannot be smaller than 3");
        }
        this.max = n;
    }

    public WidthAnsiLongestWordTab(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("maximum array cannot be null");
        }
        for (int n : nArray) {
            if (n == -1 || n >= 3) continue;
            throw new IllegalArgumentException("array contains maximum column width smaller than 3");
        }
        this.maxAr = nArray;
    }

    public static void setCallback(NativeFunction nativeFunction) {
        callback = nativeFunction;
    }

    public static int visibleLength(String string) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Object object = null;
        try {
            object = callback.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{string});
        }
        finally {
            AFCmdBase.jse.exitContext();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        return (Integer)object;
    }

    public static int[] longestWord(V2_AsciiTable v2_AsciiTable) {
        if (v2_AsciiTable == null) {
            return null;
        }
        if (v2_AsciiTable.getTable().size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[v2_AsciiTable.getColumnCount()];
        for (V2_Row v2_Row : v2_AsciiTable.getTable()) {
            if (!(v2_Row instanceof ContentRow)) continue;
            ContentRow contentRow = (ContentRow)v2_Row;
            for (int i = 0; i < contentRow.getColumns().length; ++i) {
                if (contentRow.getColumns()[i] == null) continue;
                String string = contentRow.getColumns()[i].toString().replaceAll("\\033\\[[0-9;]*m", "");
                String[] stringArray = StringUtils.split((String)string);
                for (int j = 0; j < stringArray.length; ++j) {
                    int n = WidthAnsiLongestWordTab.visibleLength(stringArray[j]) + contentRow.getPadding()[i] + contentRow.getPadding()[i];
                    if (n <= nArray[i]) continue;
                    nArray[i] = n;
                }
            }
        }
        return nArray;
    }

    public int[] getColumnWidths(V2_AsciiTable v2_AsciiTable) {
        int n;
        int n2;
        int n3;
        int n4;
        if (v2_AsciiTable == null) {
            return null;
        }
        if (this.maxAr != null && this.maxAr.length != v2_AsciiTable.getColumnCount()) {
            throw new IllegalArgumentException("maxAr length is not the same as rows in the table");
        }
        int[] nArray = new int[v2_AsciiTable.getColumnCount()];
        boolean bl = false;
        for (V2_Row v2_Row : v2_AsciiTable.getTable()) {
            if (!(v2_Row instanceof ContentRow)) continue;
            ContentRow contentRow = (ContentRow)v2_Row;
            for (n4 = 0; n4 < contentRow.getColumns().length; ++n4) {
                String string;
                if (contentRow.getColumns()[n4] == null || (n3 = WidthAnsiLongestWordTab.visibleLength(string = contentRow.getColumns()[n4].toString().replaceAll("\\033\\[[0-9;]*m", "")) + contentRow.getPadding()[n4] + contentRow.getPadding()[n4]) <= nArray[n4]) continue;
                nArray[n4] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n5 += nArray[n2] + 2;
        }
        if (n5 <= this.max) {
            return nArray;
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        while (n2 > this.max - nArray.length) {
            n = -1;
            n4 = -1;
            int n6 = -1;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] > n4) {
                    n = n3;
                    n4 = nArray[n3];
                }
                if (nArray[n3] <= n6 || nArray[n3] >= n4) continue;
                n6 = nArray[n3];
            }
            if (n < 0 || n4 <= 9) {
                return nArray;
            }
            n3 = n6 > nArray[n] - (n2 - (this.max - nArray.length)) ? n6 : nArray[n] - (n2 - (this.max - nArray.length));
            nArray[n] = n3 > 9 ? n3 : 10;
            n2 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 += nArray[n3];
            }
        }
        return nArray;
    }
}

