/*
 * Decompiled with CFR 0.152.
 */
package openaf.asciitable.render;

import de.vandermeer.asciitable.v2.RenderedTable;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.BorderPosition;
import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.ProcessedRow;
import de.vandermeer.asciitable.v2.render.RenderUtilities;
import de.vandermeer.asciitable.v2.render.V2_TableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.RuleRowType;
import de.vandermeer.asciitable.v2.row.V2_Row;
import de.vandermeer.asciitable.v2.themes.ThemeValidator;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;
import de.vandermeer.asciitable.v2.themes.V2_TableTheme;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import openaf.asciitable.render.WidthAnsiLongestWordTab;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.fusesource.jansi.Ansi;

public class AnsiAsciiTableRenderer
implements V2_TableRenderer {
    char paddingChar;
    V2_TableTheme theme;
    WidthAnsiLongestWordTab width;
    String[][] colorMap;
    String lineColor;
    List<ProcessedRow> rows;
    int ansi = 0;
    protected HashMap<String, String> __ansiColorCache = new HashMap();
    protected String __reset = "\u001b[m";

    public AnsiAsciiTableRenderer() {
        this.paddingChar = (char)32;
        this.theme = V2_E_TableThemes.PLAIN_7BIT.get();
        this.width = null;
        this.rows = new LinkedList<ProcessedRow>();
    }

    public AnsiAsciiTableRenderer(boolean bl) {
        if (bl) {
            this.ansi = 7;
        }
        this.paddingChar = (char)32;
        this.theme = V2_E_TableThemes.PLAIN_7BIT.get();
        this.width = null;
        this.rows = new LinkedList<ProcessedRow>();
    }

    public AnsiAsciiTableRenderer setWidth(V2_Width v2_Width) {
        if (v2_Width != null) {
            this.width = (WidthAnsiLongestWordTab)v2_Width;
        }
        return this;
    }

    protected String __ansiColorPrep(String string) {
        Object object = "RRR";
        string = string.toUpperCase();
        String[] stringArray = string.split(",");
        Object object2 = "";
        for (String string2 : stringArray) {
            String string3;
            if (string2.startsWith("BG(")) {
                string3 = string2.replaceAll("BG\\((\\d+)\\)", "$1");
                object = "\u001b[48;5;" + string3 + "m" + (String)object;
                continue;
            }
            if (string2.startsWith("FG(")) {
                string3 = string2.replaceAll("FG\\((\\d+)\\)", "$1");
                object = "\u001b[38;5;" + string3 + "m" + (String)object;
                continue;
            }
            object2 = (String)object2 + string2 + ",";
        }
        if (((String)object2).length() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        Object object3 = ((String)object2).length() > 0 ? Ansi.ansi().render("@|" + ((String)object2).toLowerCase() + " " + (String)object + "|@").toString() : object;
        return ((String)object3).substring(0, ((String)object3).indexOf("RRR"));
    }

    private String ansiColor(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.length() > 0) {
            if (this.__ansiColorCache.containsKey(string)) {
                return this.__ansiColorCache.get(string) + string2 + this.__reset;
            }
            this.__ansiColorCache.put(string, this.__ansiColorPrep(string));
            return this.__ansiColorCache.get(string) + string2 + this.__reset;
        }
        return string2;
    }

    public RenderedTable render(V2_AsciiTable v2_AsciiTable, String[][] stringArray, String string) {
        this.colorMap = stringArray;
        this.lineColor = string;
        return this.render(v2_AsciiTable);
    }

    public RenderedTable render(V2_AsciiTable v2_AsciiTable) {
        V2_Row v2_Row;
        Object object;
        this.rows.clear();
        if (v2_AsciiTable == null || v2_AsciiTable.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        if (this.width == null) {
            throw new IllegalArgumentException("wrong table width argument: no width set");
        }
        int[] nArray = this.width.getColumnWidths(v2_AsciiTable);
        for (V2_Row v2_Row2 : v2_AsciiTable.getTable()) {
            object = new ProcessedRow(v2_Row2, nArray, v2_AsciiTable.getColumnCount());
            if (v2_Row2 instanceof ContentRow) {
                ContentRow contentRow = (ContentRow)v2_Row2;
                v2_Row = RenderUtilities.createContentArray((Object[])contentRow.getColumns(), (int[])nArray, (int[])contentRow.getPadding());
                object.setProcessedColumns((String[][])v2_Row);
                object.setBorderTypes(RenderUtilities.getBorderTypes_ContentRow((String[])v2_Row[0], (ContentRow)contentRow, (int)v2_AsciiTable.getColumnCount()));
            }
            this.rows.add((ProcessedRow)object);
        }
        BorderType[] borderTypeArray = RenderUtilities.getBorderTypes_TopRule((ProcessedRow)(this.rows.size() > 1 ? this.rows.get(1) : null), (V2_Row)this.rows.get(0).getOriginalRow(), (int)v2_AsciiTable.getColumnCount());
        this.rows.get(0).setBorderTypes(borderTypeArray);
        borderTypeArray = RenderUtilities.getBorderTypes_BottomRule((ProcessedRow)(this.rows.size() > 1 ? this.rows.get(this.rows.size() - 2) : null), (V2_Row)this.rows.get(this.rows.size() - 1).getOriginalRow(), (int)v2_AsciiTable.getColumnCount());
        this.rows.get(this.rows.size() - 1).setBorderTypes(borderTypeArray);
        if (this.rows.size() > 2) {
            for (int i = 1; i < this.rows.size() - 1; ++i) {
                borderTypeArray = RenderUtilities.getBorderTypes_MidRule((ProcessedRow)this.rows.get(i - 1), (ProcessedRow)(i < this.rows.size() - 2 ? this.rows.get(i + 1) : null), (V2_Row)this.rows.get(i).getOriginalRow(), (int)v2_AsciiTable.getColumnCount());
                this.rows.get(i).setBorderTypes(borderTypeArray);
            }
        }
        boolean bl = false;
        if (this.colorMap != null && this.lineColor != null) {
            bl = true;
        }
        object = new LinkedList();
        for (int i = 0; i < this.rows.size(); ++i) {
            v2_Row = this.rows.get(i).getOriginalRow();
            if (v2_Row instanceof ContentRow) {
                object.add(this.renderContentRow(this.rows.get(i), nArray, i));
                continue;
            }
            if (v2_Row instanceof RuleRow) {
                if (i == 0) {
                    if (bl) {
                        object.add(new StrBuilder(this.ansiColor(this.lineColor, this.renderRuleRow(this.rows.get(i), nArray, RuleRowType.TOP).toString())));
                        continue;
                    }
                    object.add(this.renderRuleRow(this.rows.get(i), nArray, RuleRowType.TOP));
                    continue;
                }
                if (i == this.rows.size() - 1) {
                    if (bl) {
                        object.add(new StrBuilder(this.ansiColor(this.lineColor, this.renderRuleRow(this.rows.get(i), nArray, RuleRowType.BOTTOM).toString())));
                        continue;
                    }
                    object.add(this.renderRuleRow(this.rows.get(i), nArray, RuleRowType.BOTTOM));
                    continue;
                }
                if (bl) {
                    object.add(new StrBuilder(this.ansiColor(this.lineColor, this.renderRuleRow(this.rows.get(i), nArray, RuleRowType.MID).toString())));
                    continue;
                }
                object.add(this.renderRuleRow(this.rows.get(i), nArray, null));
                continue;
            }
            System.err.println("ERROR in renderering");
        }
        return new RenderedTable((List)object);
    }

    protected final StrBuilder renderContentRow(ProcessedRow processedRow, int[] nArray, int n) {
        StrBuilder strBuilder = new StrBuilder(100);
        V2_RowTheme v2_RowTheme = null;
        String[][] stringArray = processedRow.getProcessedColumns();
        BorderType[] borderTypeArray = processedRow.getBorderTypes();
        char[] cArray = ((ContentRow)processedRow.getOriginalRow()).getAlignment();
        int[] nArray2 = ((ContentRow)processedRow.getOriginalRow()).getPadding();
        boolean bl = false;
        if (this.colorMap != null && this.lineColor != null) {
            bl = true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            v2_RowTheme = this.theme.getContent();
            if (i != 0) {
                strBuilder.appendNewLine();
            }
            int n2 = 0;
            for (int j = 0; j < borderTypeArray.length; ++j) {
                int n3;
                String string;
                if (borderTypeArray[j] != BorderType.NONE) {
                    if (j == 0) {
                        if (bl) {
                            strBuilder.append(this.ansiColor(this.lineColor, String.valueOf(RenderUtilities.getChar((BorderPosition)BorderPosition.LEFT, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme))));
                        } else {
                            strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.LEFT, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme));
                        }
                    } else if (j == borderTypeArray.length - 1) {
                        if (bl) {
                            strBuilder.append(this.ansiColor(this.lineColor, String.valueOf(RenderUtilities.getChar((BorderPosition)BorderPosition.RIGHT, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme))));
                        } else {
                            strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.RIGHT, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme));
                        }
                    } else if (bl) {
                        strBuilder.append(this.ansiColor(this.lineColor, String.valueOf(RenderUtilities.getChar((BorderPosition)BorderPosition.MIDDLE, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme))));
                    } else {
                        strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.MIDDLE, (BorderType)borderTypeArray[j], (V2_RowTheme)v2_RowTheme));
                    }
                }
                if (j >= stringArray[i].length) continue;
                if (ArrayUtils.contains((Object[])stringArray[i], null)) {
                    int n4;
                    String string2;
                    int n5;
                    if (stringArray[i][j] == null) {
                        if (j == stringArray[i].length - 1) {
                            int n6 = 0;
                            for (n5 = 0; n5 < n2; ++n5) {
                                n6 += nArray[n5];
                            }
                            n6 += n2;
                            strBuilder.appendFixedWidthPadRight((Object)"", n6 += nArray[j], this.paddingChar);
                            continue;
                        }
                        ++n2;
                        continue;
                    }
                    if ("".equals(stringArray[i][j])) {
                        for (int k = 0; k < n2; ++k) {
                            strBuilder.appendFixedWidthPadRight((Object)"", nArray[k], this.paddingChar);
                        }
                        strBuilder.appendFixedWidthPadRight((Object)"", n2, this.paddingChar);
                        n2 = 0;
                        strBuilder.appendFixedWidthPadRight((Object)stringArray[i][j], nArray[j], this.paddingChar);
                        continue;
                    }
                    int n7 = 0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        n7 += nArray[n5];
                    }
                    n7 += n2;
                    n7 += nArray[j];
                    if (this.colorMap != null && n < this.colorMap.length && j < this.colorMap[n].length && this.colorMap[n][j] instanceof String && !this.colorMap[n][j].equals("")) {
                        String string3 = this.colorMap[n][j];
                        string2 = this.ansiColor(string3.toLowerCase(), stringArray[i][j]);
                        n4 = n7 + (string2.length() - WidthAnsiLongestWordTab.visibleLength(stringArray[i][j]));
                    } else {
                        string2 = stringArray[i][j];
                        n4 = n7;
                    }
                    this.appendWithAlignment(cArray[j], strBuilder, string2, n4, this.paddingChar, nArray2[j], i == stringArray.length);
                    n2 = 0;
                    continue;
                }
                if (this.colorMap != null && n < this.colorMap.length && j < this.colorMap[n].length && this.colorMap[n][j] instanceof String && !this.colorMap[n][j].equals("")) {
                    String string4 = this.colorMap[n][j];
                    string = this.ansiColor(string4.toLowerCase(), stringArray[i][j]);
                    n3 = nArray[j] + (string.length() - WidthAnsiLongestWordTab.visibleLength(stringArray[i][j]));
                } else {
                    string = stringArray[i][j];
                    n3 = nArray[j];
                }
                this.appendWithAlignment(cArray[j], strBuilder, string, n3, this.paddingChar, nArray2[j], i == stringArray.length - 1);
            }
        }
        return strBuilder;
    }

    private void appendWithAlignment(char c, StrBuilder strBuilder, String string, int n, char c2, int n2, boolean bl) {
        int n3;
        if (n2 > 0) {
            n -= n2 * 2;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            strBuilder.append(c2);
        }
        if ('l' == c) {
            strBuilder.appendFixedWidthPadRight((Object)string, n, c2);
        } else if ('r' == c) {
            strBuilder.appendFixedWidthPadLeft((Object)string, n, c2);
        } else if ('c' == c) {
            strBuilder.append(StringUtils.center((String)string, (int)n, (char)c2));
        } else if ('j' == c || 't' == c) {
            if (bl) {
                if ('j' == c) {
                    strBuilder.appendFixedWidthPadRight((Object)string, n, c2);
                } else {
                    strBuilder.appendFixedWidthPadLeft((Object)string, n, c2);
                }
            } else {
                int n4;
                Object[] objectArray = StringUtils.split((String)string);
                int n5 = 0;
                Object[] objectArray2 = objectArray;
                int n6 = objectArray2.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    String string2 = objectArray2[n4];
                    n5 += WidthAnsiLongestWordTab.visibleLength(string2);
                }
                int n7 = (n - n5) / (objectArray.length - 1) * (objectArray.length - 1);
                for (n6 = 0; n6 < objectArray.length - 1; ++n6) {
                    if (n7 == 0) continue;
                    int n8 = n6;
                    objectArray[n8] = objectArray[n8] + " ";
                    --n7;
                }
                n6 = (n - n5) % (objectArray.length - 1);
                for (n4 = 0; n4 < objectArray.length - 1; ++n4) {
                    if (n6 == 0) continue;
                    int n9 = n4;
                    objectArray[n9] = (String)objectArray[n9] + " ";
                    --n6;
                }
                strBuilder.append(StringUtils.join((Object[])objectArray));
            }
        } else {
            System.err.println("ERROR RENDER ALIGNMENT");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            strBuilder.append(c2);
        }
    }

    protected final StrBuilder renderRuleRow(ProcessedRow processedRow, int[] nArray, RuleRowType ruleRowType) {
        StrBuilder strBuilder = new StrBuilder(100);
        V2_RowTheme v2_RowTheme = null;
        BorderType[] borderTypeArray = processedRow.getBorderTypes();
        RuleRow ruleRow = (RuleRow)processedRow.getOriginalRow();
        RuleRowType ruleRowType2 = ruleRowType == null ? ruleRow.getRuleType() : ruleRowType;
        block0 : switch (ruleRowType2) {
            case BOTTOM: {
                switch (ruleRow.getRuleStyle()) {
                    case NORMAL: {
                        v2_RowTheme = this.theme.getBottom();
                        break;
                    }
                    case STRONG: {
                        v2_RowTheme = this.theme.getBottomStrong();
                    }
                }
                break;
            }
            case MID: {
                switch (ruleRow.getRuleStyle()) {
                    case NORMAL: {
                        v2_RowTheme = this.theme.getMid();
                        break;
                    }
                    case STRONG: {
                        v2_RowTheme = this.theme.getMidStrong();
                    }
                }
                break;
            }
            case TOP: {
                switch (ruleRow.getRuleStyle()) {
                    case NORMAL: {
                        v2_RowTheme = this.theme.getTop();
                        break block0;
                    }
                    case STRONG: {
                        v2_RowTheme = this.theme.getTopStrong();
                    }
                }
            }
        }
        for (int i = 0; i < borderTypeArray.length; ++i) {
            if (i == 0) {
                strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.LEFT, (BorderType)borderTypeArray[i], (V2_RowTheme)v2_RowTheme));
            } else if (i == borderTypeArray.length - 1) {
                strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.RIGHT, (BorderType)borderTypeArray[i], (V2_RowTheme)v2_RowTheme));
            } else {
                strBuilder.append(RenderUtilities.getChar((BorderPosition)BorderPosition.MIDDLE, (BorderType)borderTypeArray[i], (V2_RowTheme)v2_RowTheme));
            }
            if (i >= nArray.length) continue;
            strBuilder.appendPadding(nArray[i], v2_RowTheme.getMid());
        }
        return strBuilder;
    }

    public AnsiAsciiTableRenderer setPaddingChar(char c) {
        this.paddingChar = c;
        return this;
    }

    public AnsiAsciiTableRenderer setTheme(V2_TableTheme v2_TableTheme) {
        if (v2_TableTheme != null) {
            ThemeValidator.validateTableTheme((V2_TableTheme)v2_TableTheme);
            this.theme = v2_TableTheme;
        }
        return this;
    }
}

