/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import openaf.AFCmdOS;
import openaf.OAFRepack;
import openaf.SimpleLog;

public class _AFCmdOS {
    public static String[] args;
    protected static boolean checkedRepack;

    public static void repack() {
        if (checkedRepack) {
            return;
        }
        InputStream inputStream = OAFRepack.class.getResourceAsStream("/js.jar");
        if (inputStream != null) {
            File file;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.err.println("Repacking OpenAF...");
            try {
                file = new File(Class.forName("openaf.AFCmdBase").getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (Exception exception) {
                file = new File(System.getProperties().getProperty("java.class.path"));
            }
            try {
                Files.copy(file.toPath(), new File(String.valueOf(file) + ".orig").toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException iOException) {
                SimpleLog.log(SimpleLog.logtype.ERROR, "Error with copying " + String.valueOf(file.toPath()) + " to " + String.valueOf(file.toPath()) + ".orig: " + iOException.getMessage(), null);
                SimpleLog.log(SimpleLog.logtype.DEBUG, "", iOException);
            }
            boolean bl = System.getProperty("os.name").indexOf("Windows") < 0;
            String string = "";
            string = !bl ? "\"" : "'";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + string);
            stringBuffer.append(" -jar ");
            stringBuffer.append(string + file.getPath() + string);
            for (String string2 : args) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
            }
            try {
                OAFRepack.repackAndReplace(file.getPath(), stringBuffer.substring(0, stringBuffer.length()));
            }
            catch (Exception exception) {
                SimpleLog.log(SimpleLog.logtype.ERROR, "Error with the repack: " + exception.getMessage(), null);
                SimpleLog.log(SimpleLog.logtype.DEBUG, "", exception);
            }
        }
        checkedRepack = true;
    }

    public static void main(String[] stringArray) {
        args = stringArray;
        _AFCmdOS.repack();
        AFCmdOS.main(stringArray);
    }

    static {
        checkedRepack = false;
    }
}

