/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import java.lang.management.ManagementFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openaf.OAFdCL;

public final class StartupOptimizer {
    private static volatile boolean optimizationEnabled = true;
    private static volatile ExecutorService virtualThreadExecutor;
    private static final Pattern JAVA_MAJOR_PATTERN;

    public static void optimizeStartup() {
        if (!optimizationEnabled) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            OAFdCL oAFdCL = OAFdCL.getInstance(ClassLoader.getSystemClassLoader());
            if (oAFdCL != null) {
                oAFdCL.preWarmCache();
            }
        }, virtualThreadExecutor);
        CompletableFuture.runAsync(() -> StartupOptimizer.preloadSystemProperties(), virtualThreadExecutor);
        CompletableFuture.runAsync(() -> StartupOptimizer.initializeJITHints(), virtualThreadExecutor);
    }

    private static void preloadSystemProperties() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"java.version", "java.home", "user.dir", "file.separator", "path.separator", "line.separator", "os.name", "os.arch", "java.class.path"}) {
            System.getProperty(string);
        }
    }

    private static void initializeJITHints() {
        try {
            String string = "openaf.test.performance";
            string.contains("test");
            string.startsWith("openaf");
            string.indexOf(".");
            ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
            concurrentHashMap.put("test", "value");
            concurrentHashMap.get("test");
            concurrentHashMap.containsKey("test");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static StartupMetrics getStartupMetrics() {
        return new StartupMetrics();
    }

    public static void disableOptimization() {
        optimizationEnabled = false;
    }

    public static void enableOptimization() {
        optimizationEnabled = true;
    }

    public static void shutdown() {
        if (virtualThreadExecutor != null && !virtualThreadExecutor.isShutdown()) {
            virtualThreadExecutor.shutdown();
        }
    }

    static {
        JAVA_MAJOR_PATTERN = Pattern.compile("^(\\d+)");
        String string = System.getProperty("java.version");
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[0] : string;
        Matcher matcher = JAVA_MAJOR_PATTERN.matcher(string2);
        int n = 0;
        if (matcher.find()) {
            try {
                n = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        virtualThreadExecutor = n >= 21 ? Executors.newVirtualThreadPerTaskExecutor() : Executors.newCachedThreadPool();
    }

    public static class StartupMetrics {
        private final long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        private final long totalMemory;
        private final long freeMemory;
        private final int processorCount;

        public StartupMetrics() {
            Runtime runtime = Runtime.getRuntime();
            this.totalMemory = runtime.totalMemory();
            this.freeMemory = runtime.freeMemory();
            this.processorCount = runtime.availableProcessors();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getUsedMemory() {
            return this.totalMemory - this.freeMemory;
        }

        public int getProcessorCount() {
            return this.processorCount;
        }

        public long getUptime() {
            return ManagementFactory.getRuntimeMXBean().getUptime();
        }

        public String toString() {
            return String.format("StartupMetrics{uptime=%dms, usedMemory=%dMB, processors=%d}", this.getUptime(), this.getUsedMemory() / 0x100000L, this.processorCount);
        }
    }
}

