/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class OAFdCL
extends URLClassLoader {
    public static volatile OAFdCL oafdcl = null;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ConcurrentHashMap<String, Class<?>> classCache = new ConcurrentHashMap(256, 0.75f, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentHashMap<String, URL> urlCache = new ConcurrentHashMap(64, 0.75f, Runtime.getRuntime().availableProcessors());
    private static final AtomicLong cacheHits = new AtomicLong(0L);
    private static final AtomicLong cacheMisses = new AtomicLong(0L);

    public static OAFdCL getInstance(ClassLoader classLoader) {
        if (oafdcl != null) {
            return oafdcl;
        }
        lock.writeLock().lock();
        try {
            if (oafdcl == null) {
                ClassLoader classLoader2 = classLoader;
                while (classLoader2 instanceof OAFdCL) {
                    if (oafdcl != null) {
                        OAFdCL oAFdCL = oafdcl;
                        return oAFdCL;
                    }
                    classLoader2 = classLoader2.getParent();
                }
                oafdcl = new OAFdCL(classLoader2);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return oafdcl;
    }

    public static OAFdCL getCurrentInstance() {
        return oafdcl;
    }

    public OAFdCL(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public final void appendToClassPathForInstrumentation(String string2) throws MalformedURLException {
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        URL uRL = urlCache.computeIfAbsent(string2, string -> {
            try {
                Path path = Paths.get(string, new String[0]);
                return path.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Invalid path: " + string, malformedURLException);
            }
        });
        this.addURL(uRL);
    }

    @Override
    public final void addURL(URL uRL) {
        if (uRL != null) {
            super.addURL(uRL);
            urlCache.putIfAbsent(uRL.toString(), uRL);
            int n = classCache.size();
            if (n > 0) {
                classCache.clear();
            }
        }
    }

    @Override
    public final Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = classCache.get(string);
        if (clazz != null) {
            cacheHits.incrementAndGet();
            return clazz;
        }
        Class<?> clazz2 = super.findClass(string);
        classCache.putIfAbsent(string, clazz2);
        cacheMisses.incrementAndGet();
        return clazz2;
    }

    @Override
    public final Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    @Override
    public final Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this != oafdcl && oafdcl != null) {
            return oafdcl.loadClass(string, bl);
        }
        Class<?> clazz = classCache.get(string);
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            cacheHits.incrementAndGet();
            return clazz;
        }
        try {
            Class<?> clazz2 = this.findClass(string);
            if (bl) {
                this.resolveClass(clazz2);
            }
            classCache.putIfAbsent(string, clazz2);
            cacheMisses.incrementAndGet();
            return clazz2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz3 = super.loadClass(string, bl);
            if (!(string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun."))) {
                classCache.putIfAbsent(string, clazz3);
            }
            cacheMisses.incrementAndGet();
            return clazz3;
        }
    }

    @Override
    public final URL[] getURLs() {
        return super.getURLs();
    }

    public final void clearCache() {
        classCache.clear();
    }

    public final int getCacheSize() {
        return classCache.size();
    }

    public final String[] getCachedClasses() {
        return ((ConcurrentHashMap.CollectionView)((Object)classCache.keySet())).toArray(new String[0]);
    }

    public final long getCacheHits() {
        return cacheHits.get();
    }

    public final long getCacheMisses() {
        return cacheMisses.get();
    }

    public final void preWarmCache() {
        Thread.startVirtualThread(() -> {
            String[] stringArray;
            for (String string : stringArray = new String[]{"org.mozilla.javascript.NativeFunction", "openaf.OAFdCL", "org.mozilla.javascript.Scriptable", "org.mozilla.javascript.optimizer.Bootstrapper", "org.mozilla.javascript.ContextFactory", "org.mozilla.javascript.Script", "org.mozilla.javascript.Undefined", "org.mozilla.javascript.ScriptRuntime", "org.mozilla.javascript.Callable", "org.mozilla.javascript.Context", "org.mozilla.javascript.optimizer.OptRuntime", "openaf.Launcher"}) {
                try {
                    this.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public final URL findResource(String string2) {
        return urlCache.computeIfAbsent("resource:" + string2, string -> {
            String string2 = string.substring("resource:".length());
            return super.findResource(string2);
        });
    }

    public final void addURLs(URL[] uRLArray) {
        if (uRLArray != null && uRLArray.length > 0) {
            for (URL uRL : uRLArray) {
                if (uRL == null) continue;
                this.addURL(uRL);
            }
        }
    }

    public final URL[] getCachedURLs() {
        return urlCache.values().toArray(new URL[0]);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

