/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class OAFRepack {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        int n;
        long l = 0L;
        char[] cArray = new char[4096];
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        try (StringWriter stringWriter = new StringWriter();){
            OAFRepack.copy(inputStreamReader, stringWriter);
            String string2 = stringWriter.toString();
            return string2;
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) throws UnsupportedEncodingException, IOException {
        if (string != null) {
            outputStream.write(string.getBytes(string2));
        }
    }

    public static String javaHome() {
        String string = System.getProperty("java.home");
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(92);
        int n2 = string.lastIndexOf(47);
        if (n2 > n) {
            n = n2;
        }
        return string.substring(0, n);
    }

    public static File findToolsJar() {
        String string = OAFRepack.javaHome();
        if (string == null) {
            return null;
        }
        String string2 = new File(string).getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
        File file = new File(string2);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(String string, String string2, String string3) throws Exception {
        block47: {
            ZipInputStream zipInputStream = null;
            FileInputStream fileInputStream = null;
            String string4 = System.getenv("__OAF_MAINCLASS");
            if (string4 != null) {
                System.out.println("Previous main class: " + string3);
                System.out.println("New main class: " + string4);
                string3 = string4;
            }
            try {
                fileInputStream = new FileInputStream(string);
                if (fileInputStream == null) {
                    throw new Exception("Couldn't read input file " + string);
                }
                zipInputStream = new ZipInputStream(fileInputStream);
                if (zipInputStream == null) {
                    throw new Exception("Couldn't read zip input file " + string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                long l = 0L;
                ZipEntry zipEntry = null;
                try {
                    do {
                        zipEntry = zipInputStream.getNextEntry();
                        ++l;
                    } while (zipEntry != null);
                }
                finally {
                    zipInputStream.close();
                }
                ZipFile zipFile = new ZipFile(string);
                FileInputStream fileInputStream2 = null;
                ZipInputStream zipInputStream2 = null;
                if (zipFile == null) break block47;
                try {
                    ZipEntry zipEntry2 = null;
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    if (fileOutputStream == null) {
                        throw new Exception("Couldn't write output file " + string2);
                    }
                    ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                    if (zipOutputStream == null) {
                        throw new Exception("Couldn't write output zip file " + string2);
                    }
                    try {
                        zipOutputStream.setMethod(8);
                        zipOutputStream.setLevel(9);
                        fileInputStream2 = new FileInputStream(string);
                        if (fileInputStream2 == null) {
                            throw new Exception("Couldn't read internal file " + string);
                        }
                        zipInputStream2 = new ZipInputStream(fileInputStream2);
                        if (zipInputStream2 == null) {
                            throw new Exception("Couldn't read zip internal file " + string);
                        }
                        long l2 = 0L;
                        try {
                            do {
                                Object object;
                                InputStream inputStream;
                                ZipConstants zipConstants;
                                zipEntry2 = zipInputStream2.getNextEntry();
                                ++l2;
                                if (zipEntry2 == null || zipEntry2.getName().endsWith("/")) continue;
                                System.out.print("\rRepack progress " + l2 + "/" + l + " (" + Math.round(l2 * 100L / l) + "%)");
                                if (zipEntry2.getName().toLowerCase().endsWith(".jar")) {
                                    zipConstants = null;
                                    inputStream = null;
                                    try {
                                        if (zipEntry2.getName().toLowerCase().endsWith("tools-attach.jar") && OAFRepack.findToolsJar() != null) {
                                            inputStream = new FileInputStream(OAFRepack.findToolsJar());
                                            zipConstants = new ZipInputStream(inputStream);
                                        } else {
                                            inputStream = zipFile.getInputStream(zipEntry2);
                                            zipConstants = new ZipInputStream(inputStream);
                                        }
                                        while ((object = ((ZipInputStream)zipConstants).getNextEntry()) != null) {
                                            if (arrayList.contains(((ZipEntry)object).getName()) || ((ZipEntry)object).getName().endsWith("MANIFEST.MF") || ((ZipEntry)object).getName().endsWith("ECLIPSE_.RSA") || ((ZipEntry)object).getName().equals("META-INF/services/java.net.spi.InetAddressResolverProvider") || ((ZipEntry)object).getName().equals("META-INF/services/sun.net.spi.nameservice.NameServiceDescriptor")) continue;
                                            ZipEntry zipEntry3 = new ZipEntry(((ZipEntry)object).getName());
                                            zipOutputStream.putNextEntry(zipEntry3);
                                            arrayList.add(zipEntry3.getName());
                                            if (!zipEntry3.isDirectory()) {
                                                OAFRepack.copy((InputStream)((Object)zipConstants), zipOutputStream);
                                            }
                                            zipOutputStream.closeEntry();
                                        }
                                    }
                                    finally {
                                        if (zipConstants != null) {
                                            ((ZipInputStream)zipConstants).close();
                                        }
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                    }
                                }
                                if (!(arrayList.contains(zipEntry2.getName()) || zipEntry2.getName().endsWith("MANIFEST.MF") || zipEntry2.getName().endsWith("ECLIPSE_.RSA"))) {
                                    zipConstants = new ZipEntry(zipEntry2.getName());
                                    zipOutputStream.putNextEntry((ZipEntry)zipConstants);
                                    arrayList.add(((ZipEntry)zipConstants).getName());
                                    if (!((ZipEntry)zipConstants).isDirectory() && (inputStream = zipFile.getInputStream(zipEntry2)) != null) {
                                        try {
                                            OAFRepack.copy(inputStream, zipOutputStream);
                                        }
                                        finally {
                                            inputStream.close();
                                        }
                                    }
                                    zipOutputStream.closeEntry();
                                    continue;
                                }
                                if (arrayList.contains(zipEntry2.getName()) || !zipEntry2.getName().endsWith("MANIFEST.MF")) continue;
                                zipConstants = new ZipEntry(zipEntry2.getName());
                                zipOutputStream.putNextEntry((ZipEntry)zipConstants);
                                inputStream = zipFile.getInputStream(zipEntry2);
                                if (inputStream == null) continue;
                                try {
                                    object = OAFRepack.toString(inputStream, "UTF-8");
                                    object = ((String)object).indexOf("jarinjarloader") >= 0 && ((String)object).indexOf("eclipse") >= 0 ? ((String)object).replaceFirst("org\\.eclipse\\.jdt\\.internal\\.jarinjarloader\\.JarRsrcLoader", string3) : ((String)object).replaceFirst("^Main-Class: .+$", "Main-Class: " + string3);
                                    OAFRepack.write((String)object, zipOutputStream, "UTF-8");
                                    zipOutputStream.closeEntry();
                                }
                                finally {
                                    inputStream.close();
                                }
                            } while (zipEntry2 != null);
                            System.out.println("\rRepack progress " + l2 + "/" + l + " (" + Math.round(l2 * 100L / l) + "%)");
                        }
                        finally {
                            zipInputStream2.close();
                            fileInputStream2.close();
                        }
                    }
                    finally {
                        zipOutputStream.flush();
                        zipOutputStream.finish();
                        zipOutputStream.close();
                        fileOutputStream.close();
                    }
                }
                finally {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        System.out.println("Repack done.");
    }

    public static void repackAndReplace(String string, String string2) throws Exception {
        boolean bl;
        OAFRepack.repack(string, string + ".tmp", "openaf.AFCmdOS");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = bl = System.getProperty("os.name").indexOf("Windows") < 0;
        if (bl) {
            arrayList.add("/bin/sh");
            arrayList.add("-c");
            arrayList.add("sleep 1 && echo Moving '" + string + ".tmp' to '" + string + "'... && mv '" + string + ".tmp' '" + string + "' && echo Moving done. && " + string2);
        } else {
            arrayList.add("cmd");
            arrayList.add("/c");
            arrayList.add("ping -n 1 127.0.0.1 > NUL && move \"" + string + ".tmp\" \"" + string + "\" >NUL && " + string2);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.inheritIO();
        processBuilder.start();
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length >= 1) {
            System.out.println("Repacking " + stringArray[0]);
            String string = "java -jar openaf.jar -h";
            if (stringArray.length > 1) {
                string = stringArray[1];
            }
            OAFRepack.repackAndReplace(stringArray[0], string.replaceAll("--force", ""));
        }
    }
}

