/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import openaf.AFBase;
import openaf.AFCmdBase;
import openaf.SimpleLog;
import openaf.core.IO;
import org.apache.commons.io.FileUtils;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.xml.XMLObject;

public class IOBase
extends IO {
    private static final long serialVersionUID = 2937437659041890404L;

    @JSFunction
    public static boolean fileExists(String string) {
        return IO.fileExists(string);
    }

    @JSFunction
    public static String getFileEncoding(String string) throws IOException {
        return IO.getFileEncoding(string);
    }

    @JSFunction
    public static String getDefaultEncoding() {
        return IO.getDefaultEncoding();
    }

    @JSFunction
    public static void convertFileToEncoding(String string, String string2, String string3) throws IOException {
        IO.convertFileToEncoding(string, string2, string3);
    }

    @JSFunction
    public static Object listFiles(String string, boolean bl) throws IOException {
        return IO.listFiles(string, bl);
    }

    @JSFunction
    public static Object fileInfo(String string, boolean bl) throws IOException {
        return IO.fileInfo(string, bl);
    }

    @JSFunction
    public static Object listFilenames(String string, boolean bl) throws IOException {
        return IO.listFilenames(string, bl);
    }

    @JSFunction
    public static Scriptable readFileAsArray(String string, String string2) throws IOException {
        return (Scriptable)IO.readFileAsArray(string, string2);
    }

    @JSFunction
    public static String readFileString(String string, String string2) throws IOException {
        return IO.readFileString(string, string2);
    }

    @JSFunction
    public static Object readFileXML(String string, int n, String string2) throws IOException {
        return IO.readFileXML(string, n, string2);
    }

    @JSFunction
    public static Object readFileBytes(String string) throws IOException {
        return IO.readFileBytes(string);
    }

    @JSFunction
    public static void writeFile(String string, Object object, String string2, boolean bl) throws Exception {
        Object object2 = AFCmdBase.jse.stringify(object);
        try {
            if (string2 == null || string2.equals("undefined")) {
                string2 = "UTF-8";
            }
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(object2.toString(), JsonObject.class);
            FileUtils.writeStringToFile((File)new File(string), (String)new Gson().toJson((JsonElement)jsonObject), (String)string2, (boolean)bl);
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error writing file: " + exception.getMessage(), exception);
            throw exception;
        }
    }

    @JSFunction
    public static void writeFileString(String string, String string2, String string3, boolean bl) throws IOException {
        IO.writeFileString(string, string2, string3, bl);
    }

    @JSFunction
    public static void writeFileXML(String string, Object object, String string2, boolean bl) throws IOException {
        if (!(object instanceof XMLObject)) {
            object = null;
        }
        IO.writeFileXML(string, object, string2, bl);
    }

    @JSFunction
    public static void writeFileBytes(String string, Object object) throws Exception {
        IO.writeFileBytes(string, object);
    }

    @JSFunction
    public static void writeFileAsArray(String string, Object object, String string2) throws Exception {
        IO.writeFileAsArray(string, object, string2);
    }

    @JSFunction
    public static Object readFile(String string, String string2) throws Exception {
        Object object = IO.readFile(string, string2);
        if (string2 == null || string2.equals("undefined")) {
            string2 = "UTF-8";
        }
        return AFBase.jsonParse((String)object, true);
    }

    @JSFunction
    public static Object gzip(Object object) throws IOException {
        return IO.gzip(object);
    }

    @JSFunction
    public static Object gunzip(Object object) throws IOException {
        return IO.gunzip(object);
    }

    @JSFunction
    public static Object randomAccessFile(String string, String string2) throws FileNotFoundException {
        return IO.randomAccessFile(string, string2);
    }

    @JSFunction
    public static Object writeFileGzipStream(String string, boolean bl) throws IOException {
        return IO.writeFileGzipStream(string, bl);
    }

    @JSFunction
    public static Object readFileGzipStream(String string) throws IOException {
        return IO.readFileGzipStream(string);
    }

    @JSFunction
    public static Object readFileStream(String string) throws IOException {
        return IO.readFileStream(string);
    }

    @JSFunction
    public static Object writeFileStream(String string, boolean bl) throws IOException {
        return IO.writeFileStream(string, bl);
    }
}

