/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import openaf.AFCmdBase;
import openaf.JSEngine;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class CSV
extends ScriptableObject {
    private static final long serialVersionUID = -7745871696050328345L;
    protected openaf.core.CSV csv;
    protected CSVFormat csvFormat = CSVFormat.DEFAULT;
    protected List<String> heads = null;

    public String getClassName() {
        return "CSV";
    }

    @JSFunction
    public void clear() {
        this.csv.clear();
    }

    @JSFunction
    public void setSeparator(String string) {
        this.csv.setSeparator(string);
    }

    @JSFunction
    public void setStringDelimiter(String string) {
        this.csv.setStringDelimiter(string);
    }

    @JSConstructor
    public void newCSV(String string) throws IOException {
        this.csv = new openaf.core.CSV(string);
    }

    @JSFunction
    public void load(String string) throws IOException {
        this.csv.load(string);
    }

    @JSFunction
    public Object getStreamFormat() {
        return this.csvFormat;
    }

    @JSFunction
    public void setStreamFormat(Object object) {
        if (object instanceof NativeJavaObject) {
            this.csvFormat = (CSVFormat)((NativeJavaObject)object).unwrap();
        }
        if (object instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)object;
            CSVFormat.Builder builder = null;
            JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(AFCmdBase.jse.getGlobalscope());
            for (Object object2 : nativeObject.getAllIds()) {
                jSMap.put((String)object2, nativeObject.get(object2));
            }
            if (jSMap.contains("format")) {
                switch (((String)jSMap.get("format")).toUpperCase()) {
                    case "DEFAULT": {
                        this.csvFormat = CSVFormat.DEFAULT;
                        break;
                    }
                    case "EXCEL": {
                        this.csvFormat = CSVFormat.EXCEL;
                        break;
                    }
                    case "INFORMIX_UNLOAD": {
                        this.csvFormat = CSVFormat.INFORMIX_UNLOAD;
                        break;
                    }
                    case "INFORMIX_UNLOAD_CSV": {
                        this.csvFormat = CSVFormat.INFORMIX_UNLOAD_CSV;
                        break;
                    }
                    case "MYSQL": {
                        this.csvFormat = CSVFormat.MYSQL;
                        break;
                    }
                    case "RFC4180": {
                        this.csvFormat = CSVFormat.RFC4180;
                        break;
                    }
                    case "ORACLE": {
                        this.csvFormat = CSVFormat.ORACLE;
                        break;
                    }
                    case "POSTGRESQL_CSV": {
                        this.csvFormat = CSVFormat.POSTGRESQL_CSV;
                        break;
                    }
                    case "POSTGRESQL_TEXT": {
                        this.csvFormat = CSVFormat.POSTGRESQL_TEXT;
                        break;
                    }
                    case "TDF": {
                        this.csvFormat = CSVFormat.TDF;
                        break;
                    }
                    default: {
                        this.csvFormat = CSVFormat.DEFAULT;
                    }
                }
            }
            builder = this.csvFormat.builder();
            if (jSMap.contains("quoteMode")) {
                switch (((String)jSMap.get("quoteMode")).toUpperCase()) {
                    case "ALL": {
                        builder = builder.setQuoteMode(QuoteMode.ALL);
                        break;
                    }
                    case "ALL_NON_NULL": {
                        builder = builder.setQuoteMode(QuoteMode.ALL_NON_NULL);
                        break;
                    }
                    case "MINIMAL": {
                        builder = builder.setQuoteMode(QuoteMode.MINIMAL);
                        break;
                    }
                    case "NON_NUMERIC": {
                        builder = builder.setQuoteMode(QuoteMode.NON_NUMERIC);
                        break;
                    }
                    case "NONE": {
                        builder = builder.setQuoteMode(QuoteMode.NONE);
                        break;
                    }
                    default: {
                        builder = builder.setQuoteMode(QuoteMode.NON_NUMERIC);
                    }
                }
            }
            if (jSMap.contains("withHeader")) {
                builder = builder.setSkipHeaderRecord((Boolean)jSMap.get("withHeader") == false);
            }
            if (jSMap.contains("withHeaders")) {
                int n = 0;
                NativeArray nativeArray = (NativeArray)jSMap.get("withHeaders");
                String[] stringArray = new String[nativeArray.size()];
                this.heads = new ArrayList<String>();
                for (Object e : nativeArray) {
                    stringArray[n] = (String)e;
                    this.heads.add((String)e);
                    ++n;
                }
                builder = builder.setHeader(stringArray);
            }
            if (jSMap.contains("withDelimiter")) {
                builder = builder.setDelimiter(((String)jSMap.get("withDelimiter")).charAt(0));
            }
            if (jSMap.contains("withEscape")) {
                builder = builder.setEscape(((String)jSMap.get("withEscape")).charAt(0));
            }
            if (jSMap.contains("withNullString")) {
                builder = builder.setNullString((String)jSMap.get("withNullString"));
            }
            this.csvFormat = builder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void toStream(Object object, NativeFunction nativeFunction) throws IOException {
        if (object instanceof OutputStream) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
            try {
                Object object2;
                Context context = (Context)AFCmdBase.jse.enterContext();
                CSVPrinter cSVPrinter = new CSVPrinter((Appendable)bufferedWriter, this.csvFormat);
                do {
                    Object[] objectArray = new Object[this.heads.size()];
                    object2 = nativeFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[0]);
                    if (!(object2 instanceof NativeObject)) continue;
                    NativeObject nativeObject = (NativeObject)object2;
                    int n = 0;
                    for (String string : this.heads) {
                        if (!nativeObject.containsKey((Object)string)) continue;
                        objectArray[n++] = nativeObject.get((Object)string);
                    }
                    cSVPrinter.printRecord(objectArray);
                } while (object2 != null && object2 instanceof NativeObject);
                cSVPrinter.flush();
                cSVPrinter.close();
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void fromStream(Object object, NativeFunction nativeFunction) throws IOException {
        if (object instanceof InputStream) {
            CSVParser cSVParser;
            boolean bl = false;
            String[] stringArray = null;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
            if (!this.csvFormat.getSkipHeaderRecord() && this.heads == null) {
                this.csvFormat = this.csvFormat.builder().setHeader(new String[0]).build();
            }
            if ((cSVParser = this.csvFormat.parse((Reader)inputStreamReader)).getHeaderNames() != null || this.heads != null) {
                if (this.heads == null) {
                    this.heads = cSVParser.getHeaderNames();
                }
                bl = true;
                stringArray = new String[this.heads.size()];
                int n = 0;
                for (String object2 : this.heads) {
                    stringArray[n++] = object2;
                }
            }
            try {
                for (Object object3 : cSVParser) {
                    Context context = (Context)AFCmdBase.jse.enterContext();
                    try {
                        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
                        int n = 0;
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (bl && stringArray.length > n) {
                                jSMap.put(stringArray[n], e);
                            } else {
                                jSMap.put("f" + Integer.toString(n), e);
                            }
                            ++n;
                        }
                        nativeFunction.call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{jSMap.getMap()});
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        AFCmdBase.jse.exitContext();
                    }
                }
            }
            finally {
                cSVParser.close();
                ((Reader)inputStreamReader).close();
            }
        }
    }

    @JSFunction
    public void fromCsv(String string) throws IOException {
        this.csv.fromCSV(string);
    }

    @JSFunction
    public void toCsv(NativeArray nativeArray, Object object) {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        for (Object e : nativeArray) {
            if (!(e instanceof NativeObject)) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object e2 : ((NativeObject)e).keySet()) {
                hashMap.put((String)e2, ((NativeObject)e).get(e2));
            }
            arrayList.add(hashMap);
        }
        if (object == null || object instanceof Undefined) {
            this.csv.toCsv(arrayList, null);
        } else {
            this.csv.toCsv(arrayList, ((NativeArray)object).toArray());
        }
    }

    @JSFunction
    public void p(String string) {
        this.csv.p(string);
    }

    @JSFunction
    public long writeFile(String string) throws IOException {
        return this.csv.writeFile(string);
    }

    @JSFunction
    public String w() throws IOException {
        return this.csv.w();
    }

    @JSFunction
    public long readFile(String string) throws IOException {
        return this.csv.readFile(string);
    }

    @JSFunction
    public Object csv() {
        ArrayList<HashMap<String, Object>> arrayList = this.csv.csv();
        ArrayList<Scriptable> arrayList2 = new ArrayList<Scriptable>();
        for (HashMap<String, Object> hashMap : arrayList) {
            Scriptable scriptable = (Scriptable)AFCmdBase.jse.newObject(AFCmdBase.jse.getGlobalscope());
            for (String string : hashMap.keySet()) {
                scriptable.put(string, scriptable, hashMap.get(string));
            }
            arrayList2.add(scriptable);
        }
        return AFCmdBase.jse.newArray(AFCmdBase.jse.getGlobalscope(), arrayList2.toArray());
    }
}

