/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.zip.ZipFile;
import openaf.AFBase;
import openaf.AFCmdBase;
import openaf.CSV;
import openaf.DB;
import openaf.IOBase;
import openaf.SimpleLog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class AFCmdOS
extends AFCmdBase {
    public static final String argHelp = "Usage: openaf [options]\n\nOptions:\n   -e (input)         - provide input directly instead of using stdin\n   -c (input)         - provide javascript code directly\n   -p                 - received streaming input (OS pipe)\n   -o                 - output mode (__pmOut displayed)\n   -f (script file)   - provide a script file directly\n\n   --install          - generates scripts to use openaf on the current directory\n   --check            - checks if this is the current version\n   --update           - updates to the most current version\n   --console          - interactive OpenAF console\n   --repack           - repack OpenAF.jar for faster startup times\n   --daemon           - executes a script/opack as a daemon\n   --script           - executes a script/opack\n   --sb               - generates or pre-appends openaf/ojob shebang to a js script or ojob yaml/json\n   --py               - runs a python script with openaf extensions\n\n   -h                 - show this help information\n   -v                 - show the version\n   -helpscript (term) - show help on a search term on scripting\n\n(version " + VERSION + " (" + DISTRIBUTION + "), " + LICENSE + ")";
    protected static final String OPTION_OUTPUT_MODE = "-o";
    protected static final String OPTION_DEBUG = "-debug";
    protected static final String OPTION_EXPR = "-e";
    protected static final String OPTION_CDEBUG = "-d";
    protected static final String OPTION_SILENT = "-s";
    protected static final String OPTION_HELP = "-h";
    protected static final String OPTION_SCRIPTHELP = "-helpscript";
    protected static final String OPTION_INPUT_TYPE = "-i";
    protected static final String OPTION_INSTALL = "--install";
    protected static final String OPTION_CHECK = "--check";
    protected static final String OPTION_UPDATE = "--update";
    protected static final String OPTION_REPACK = "--repack";
    protected static final String OPTION_OPACK = "--opack";
    protected static final String OPTION_CONSOLE = "--console";
    protected static final String OPTION_OJOB = "--ojob";
    protected static final String OPTION_SCRIPTOPTION = "--script";
    protected static final String OPTION_DAEMON = "--daemon";
    protected static final String OPTION_BASHCOMPLETION = "--bashcompletion";
    protected static final String OPTION_ZSHCOMPLETION = "--zshcompletion";
    protected static final String OPTION_PIPE = "-p";
    protected static final String OPTION_CODE = "-c";
    protected static final String OPTION_SCRIPTFILE = "-f";
    protected static final String OPTION_VERSION = "-v";
    protected static final String OPTION_SB = "--sb";
    protected static final String OPTION_PY = "--py";
    protected static final String OPTION_OAFPY = "--oafpy";
    protected static final String OPTION_INTERPRET = "--i";
    protected static final String PREFIX_SCRIPT = "script:";
    protected static final String OPACK = ".package.json";
    public static ZipFile zip;
    protected inputtype INPUT_TYPE = inputtype.INPUT_AUTO;
    protected String exprInput = "";
    protected String scriptfile = "";
    protected String code = "";
    protected String classfile = "";
    protected String injectscriptfile = "";
    protected String injectclassfile = "";
    protected long numberOfIncludedLines = 0L;
    protected boolean __noSLF4JErrorOnly = true;
    protected boolean silentMode = true;
    protected boolean silenceRepack = false;
    protected boolean pipe = false;
    protected boolean compile = false;
    protected boolean filescript = false;
    protected boolean classscript = false;
    protected boolean opack = false;
    protected boolean console = false;
    protected boolean cdebug = false;
    protected boolean ojob = false;
    protected boolean injectscript = false;
    protected boolean injectclass = false;
    protected boolean daemon = false;
    protected boolean injectcode = false;
    protected JsonObject pmIn;
    protected JsonObject pmOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dIP(Object object) {
        if (object instanceof String) {
            if (!dontDIP && !((String)object).startsWith("$raw$")) {
                return AFBase.decryptIfPossible((String)object);
            }
            if (((String)object).startsWith("$raw$")) {
                return ((String)object).substring(5);
            }
            return (String)object;
        }
        if (object instanceof NativeFunction) {
            try {
                Context context = (Context)AFCmdBase.jse.enterContext();
                String string = (String)((NativeFunction)object).call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[0]);
                return string;
            }
            catch (Exception exception) {
                String string = "";
                return string;
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }
        return null;
    }

    public AFCmdOS() {
        afc = this;
        afcmd = "AFCmdOS";
    }

    public AFCmdOS(boolean bl) {
        afc = this;
        afcmd = "AFCmdOS";
        this.__noSLF4JErrorOnly = !bl;
    }

    public void setNoSLF4JErrorOnly(boolean bl) {
        this.__noSLF4JErrorOnly = bl;
    }

    protected void showHelp() {
        this.showHelp(argHelp);
    }

    protected void showVersion() {
        this.showHelp("version: " + VERSION + "\ndistribution: " + DISTRIBUTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install() {
        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        this.silentMode = true;
        InputStream inputStream = this.getClass().getResourceAsStream("/js/genScripts.js");
        PrintStream printStream = System.out;
        try {
            this.execute(inputStream, printStream, "");
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.ERROR, "Error generating OpenAF scripts: " + exception.getMessage(), exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() {
        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        this.silentMode = true;
        InputStream inputStream = this.getClass().getResourceAsStream("/js/check.js");
        PrintStream printStream = System.out;
        try {
            this.execute(inputStream, printStream, "");
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.ERROR, "Error generating checking version: " + exception.getMessage(), exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        this.silentMode = true;
        InputStream inputStream = this.getClass().getResourceAsStream("/js/update.js");
        PrintStream printStream = System.out;
        try {
            this.execute(inputStream, printStream, "");
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.ERROR, "Error generating updating version: " + exception.getMessage(), exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showHelpScript() throws IOException {
        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        this.silentMode = true;
        PrintStream printStream = System.out;
        try (InputStream inputStream = this.getClass().getResourceAsStream("/js/example.js");){
            this.execute(inputStream, printStream, "");
        }
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    protected void processArgs(String[] var1_1) {
        var2_2 = false;
        var3_3 = "";
        block78: for (String var7_7 : var1_1) {
            if (!var2_2) ** GOTO lbl-1000
            var2_2 = false;
            var8_8 = var3_3;
            var9_9 = -1;
            switch (var8_8.hashCode()) {
                case 1496: {
                    if (!var8_8.equals("-e")) break;
                    var9_9 = 0;
                    break;
                }
                case 1497: {
                    if (!var8_8.equals("-f")) break;
                    var9_9 = 1;
                    break;
                }
                case 1387503: {
                    if (!var8_8.equals("--sb")) break;
                    var9_9 = 2;
                    break;
                }
                case 1387433: {
                    if (!var8_8.equals("--py")) break;
                    var9_9 = 3;
                    break;
                }
                case 439754576: {
                    if (!var8_8.equals("--bashcompletion")) break;
                    var9_9 = 4;
                    break;
                }
                case -76348469: {
                    if (!var8_8.equals("--zshcompletion")) break;
                    var9_9 = 5;
                    break;
                }
                case 1060660260: {
                    if (!var8_8.equals("--daemon")) break;
                    var9_9 = 6;
                    break;
                }
                case 1494: {
                    if (!var8_8.equals("-c")) break;
                    var9_9 = 7;
                }
            }
            switch (var9_9) {
                case 0: {
                    this.exprInput = var7_7;
                    continue block78;
                }
                case 1: {
                    if (this.cdebug) {
                        this.code = "loadDebug('" + var7_7 + "')";
                        continue block78;
                    }
                    this.scriptfile = var7_7;
                    continue block78;
                }
                case 2: {
                    this.exprInput = var7_7;
                    continue block78;
                }
                case 3: {
                    this.exprInput = var7_7;
                    continue block78;
                }
                case 4: {
                    this.exprInput = var7_7;
                    continue block78;
                }
                case 5: {
                    this.exprInput = var7_7;
                    continue block78;
                }
                case 6: {
                    this.scriptfile = var7_7;
                    continue block78;
                }
                case 7: {
                    this.code = var7_7;
                    continue block78;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var8_8 = var7_7;
                    var9_9 = -1;
                    switch (var8_8.hashCode()) {
                        case 1507: {
                            if (!var8_8.equals("-p")) break;
                            var9_9 = 0;
                            break;
                        }
                        case 1510: {
                            if (!var8_8.equals("-s")) break;
                            var9_9 = 1;
                            break;
                        }
                        case 1506: {
                            if (!var8_8.equals("-o")) break;
                            var9_9 = 2;
                            break;
                        }
                        case 1500: {
                            if (!var8_8.equals("-i")) break;
                            var9_9 = 3;
                            break;
                        }
                        case 1496: {
                            if (!var8_8.equals("-e")) break;
                            var9_9 = 4;
                            break;
                        }
                        case 1383770694: {
                            if (!var8_8.equals("-debug")) break;
                            var9_9 = 5;
                            break;
                        }
                        case 1495: {
                            if (!var8_8.equals("-d")) break;
                            var9_9 = 6;
                            break;
                        }
                        case 1497: {
                            if (!var8_8.equals("-f")) break;
                            var9_9 = 7;
                            break;
                        }
                        case 1492328043: {
                            if (!var8_8.equals("--script")) break;
                            var9_9 = 8;
                            break;
                        }
                        case 1060660260: {
                            if (!var8_8.equals("--daemon")) break;
                            var9_9 = 9;
                            break;
                        }
                        case 1499: {
                            if (!var8_8.equals("-h")) break;
                            var9_9 = 10;
                            break;
                        }
                        case 1513: {
                            if (!var8_8.equals("-v")) break;
                            var9_9 = 11;
                            break;
                        }
                        case -951415813: {
                            if (!var8_8.equals("--install")) break;
                            var9_9 = 12;
                            break;
                        }
                        case -1618193347: {
                            if (!var8_8.equals("--oafpy")) break;
                            var9_9 = 13;
                            break;
                        }
                        case 1561167465: {
                            if (!var8_8.equals("--update")) break;
                            var9_9 = 14;
                            break;
                        }
                        case -1617751704: {
                            if (!var8_8.equals("--opack")) break;
                            var9_9 = 15;
                            break;
                        }
                        case 1387503: {
                            if (!var8_8.equals("--sb")) break;
                            var9_9 = 16;
                            break;
                        }
                        case 1387433: {
                            if (!var8_8.equals("--py")) break;
                            var9_9 = 17;
                            break;
                        }
                        case 439754576: {
                            if (!var8_8.equals("--bashcompletion")) break;
                            var9_9 = 18;
                            break;
                        }
                        case -76348469: {
                            if (!var8_8.equals("--zshcompletion")) break;
                            var9_9 = 19;
                            break;
                        }
                        case 1333282446: {
                            if (!var8_8.equals("--ojob")) break;
                            var9_9 = 20;
                            break;
                        }
                        case -1957475401: {
                            if (!var8_8.equals("--console")) break;
                            var9_9 = 21;
                            break;
                        }
                        case 1465478252: {
                            if (!var8_8.equals("--repack")) break;
                            var9_9 = 22;
                            break;
                        }
                        case 44745: {
                            if (!var8_8.equals("--i")) break;
                            var9_9 = 23;
                            break;
                        }
                        case -1629068440: {
                            if (!var8_8.equals("--check")) break;
                            var9_9 = 24;
                            break;
                        }
                        case 1494: {
                            if (!var8_8.equals("-c")) break;
                            var9_9 = 25;
                            break;
                        }
                        case -1431840967: {
                            if (!var8_8.equals("-helpscript")) break;
                            var9_9 = 26;
                        }
                    }
                    switch (var9_9) {
                        case 0: {
                            this.pipe = true;
                            continue block78;
                        }
                        case 1: {
                            this.silentMode = true;
                            continue block78;
                        }
                        case 2: {
                            this.silentMode = false;
                            continue block78;
                        }
                        case 3: {
                            var2_2 = true;
                            var3_3 = "-i";
                            continue block78;
                        }
                        case 4: {
                            var2_2 = true;
                            var3_3 = "-e";
                            continue block78;
                        }
                        case 5: {
                            SimpleLog.currentLogLevel = SimpleLog.logtype.DEBUG;
                            continue block78;
                        }
                        case 6: {
                            this.cdebug = true;
                            this.silentMode = true;
                            var2_2 = true;
                            var3_3 = "-f";
                            this.code = "";
                            this.injectcode = true;
                            continue block78;
                        }
                        case 7: {
                            var2_2 = true;
                            var3_3 = "-f";
                            this.filescript = true;
                            this.silentMode = true;
                            continue block78;
                        }
                        case 8: {
                            var2_2 = true;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            var3_3 = "-f";
                            this.filescript = true;
                            continue block78;
                        }
                        case 9: {
                            var2_2 = true;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            var3_3 = "--daemon";
                            this.filescript = true;
                            this.daemon = true;
                            continue block78;
                        }
                        case 10: {
                            this.showHelp();
                            continue block78;
                        }
                        case 11: {
                            this.showVersion();
                            continue block78;
                        }
                        case 12: {
                            this.silenceRepack = true;
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "genScripts_js";
                            continue block78;
                        }
                        case 13: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "oafpy_js";
                            continue block78;
                        }
                        case 14: {
                            this.silenceRepack = true;
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "update_js";
                            continue block78;
                        }
                        case 15: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.opack = true;
                            this.injectclass = true;
                            this.injectclassfile = "opack_js";
                            continue block78;
                        }
                        case 16: {
                            var2_2 = true;
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            var3_3 = "--sb";
                            this.injectclass = true;
                            this.injectclassfile = "genSB_js";
                            continue block78;
                        }
                        case 17: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "pyoaf_js";
                            continue block78;
                        }
                        case 18: {
                            var2_2 = true;
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            var3_3 = "--bashcompletion";
                            this.injectclass = true;
                            this.injectclassfile = "bashcompletion_js";
                            continue block78;
                        }
                        case 19: {
                            var2_2 = true;
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            var3_3 = "--zshcompletion";
                            this.injectclass = true;
                            this.injectclassfile = "zshcompletion_js";
                            continue block78;
                        }
                        case 20: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.ojob = true;
                            this.injectclass = true;
                            this.injectclassfile = "ojob_js";
                            continue block78;
                        }
                        case 21: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.console = true;
                            this.injectclass = true;
                            this.injectclassfile = "openafconsole_js";
                            continue block78;
                        }
                        case 22: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.silenceRepack = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "repack_js";
                            continue block78;
                        }
                        case 23: {
                            AFCmdBase.optLevel = -1;
                            AFCmdBase.restartEngine();
                            continue block78;
                        }
                        case 24: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "check_js";
                            continue block78;
                        }
                        case 25: {
                            var2_2 = true;
                            this.silentMode = true;
                            var3_3 = "-c";
                            this.code = "";
                            this.injectcode = true;
                            continue block78;
                        }
                        case 26: {
                            this.filescript = false;
                            this.silentMode = true;
                            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                            this.injectclass = true;
                            this.injectclassfile = "example_js";
                            continue block78;
                        }
                    }
                }
            }
        }
    }

    protected void execute(InputStream inputStream, OutputStream outputStream, String string) throws Exception {
        String string2;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        if (this.pipe) {
            string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
        } else if (!(this.filescript || this.ojob || this.injectcode)) {
            while (bufferedReader.ready()) {
                stringBuilder.append(bufferedReader.readLine());
                stringBuilder.append("\n");
            }
        }
        if (this.INPUT_TYPE != inputtype.INPUT_EXPR) {
            stringBuilder2.append((CharSequence)stringBuilder);
        } else {
            stringBuilder2.append((CharSequence)stringBuilder);
            this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        }
        if (stringBuilder2.length() > 0) {
            if (this.INPUT_TYPE == inputtype.INPUT_AUTO) {
                this.INPUT_TYPE = stringBuilder2.toString().startsWith(PREFIX_SCRIPT) || stringBuilder2.toString().startsWith("#!") ? inputtype.INPUT_SCRIPT : inputtype.INPUT_JSON;
            }
            switch (this.INPUT_TYPE.ordinal()) {
                case 1: {
                    try {
                        this.pmIn = (JsonObject)new Gson().fromJson(stringBuilder2.toString(), JsonObject.class);
                        break;
                    }
                    catch (Exception exception) {
                        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
                    }
                }
                case 2: {
                    this.pmIn = new JsonObject();
                    bl = true;
                    break;
                }
                default: {
                    this.pmIn = new JsonObject();
                }
            }
        }
        string2 = this.execute(this.pmIn, string, bl, stringBuilder2, false);
        if (!this.silentMode) {
            String string3 = "";
            string3 = string2.toString();
            outputStream.write(string3.getBytes());
            outputStream.write(10);
            outputStream.flush();
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonObject execute(JsonObject jsonObject, String string, boolean bl, StringBuilder stringBuilder, boolean bl2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        InputStream inputStream;
        this.INPUT_TYPE = inputtype.INPUT_SCRIPT;
        if (!(this.pipe || this.filescript || bl || this.injectcode || this.injectclass || !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE))) {
            this.injectclass = true;
            this.injectclassfile = "openafgui_js";
            this.filescript = false;
            this.silentMode = true;
        }
        if (!bl && !this.filescript && !this.injectcode && !this.injectclass) return this.pmOut;
        Object object6 = "";
        if (this.filescript) {
            if (this.injectscript) {
                inputStream = this.getClass().getResourceAsStream(this.injectscriptfile);
                if (inputStream != null) {
                    try {
                        object6 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    }
                    finally {
                        inputStream.close();
                    }
                }
            } else {
                boolean bl3 = false;
                boolean bl4 = false;
                object5 = null;
                object4 = null;
                if (!this.scriptfile.endsWith(".js")) {
                    object3 = new DataInputStream(new BufferedInputStream(new FileInputStream(this.scriptfile.replaceFirst("::[^:]+$", ""))));
                    int n = 0;
                    if (object3 != null) {
                        try {
                            n = ((DataInputStream)object3).readInt();
                        }
                        finally {
                            ((FilterInputStream)object3).close();
                        }
                    }
                    if (n == 1347093252) {
                        bl3 = true;
                        try {
                            object4 = new ZipFile(this.scriptfile.replaceFirst("::[^:]+$", ""));
                            bl4 = ((ZipFile)object4).getEntry(OPACK) != null;
                            zip = object4;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bl4 && this.scriptfile.indexOf("::") <= 0) {
                            object5 = (JsonObject)new Gson().fromJson(IOUtils.toString((InputStream)zip.getInputStream(zip.getEntry(OPACK)), (Charset)null), JsonObject.class);
                            try {
                                object5.get("main");
                            }
                            catch (Exception exception) {
                                bl3 = false;
                            }
                        }
                    }
                }
                if (bl3) {
                    if (this.scriptfile.indexOf("::") <= 0 && bl4) {
                        if (object5.get("main").getAsString().length() <= 0) throw new Exception("Can't execute main script in " + this.scriptfile);
                        object6 = IOUtils.toString((InputStream)zip.getInputStream(zip.getEntry(object5.get("main").getAsString())), (String)"UTF-8");
                        this.scriptfile = this.scriptfile + "/" + object5.get("main").getAsString();
                    } else {
                        try {
                            object6 = IOUtils.toString((InputStream)zip.getInputStream(zip.getEntry(this.scriptfile.replaceFirst(".+::", ""))), (String)"UTF-8");
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new Exception("Can't find " + this.scriptfile.replaceFirst(".+::", ""));
                        }
                    }
                } else {
                    object6 = FileUtils.readFileToString((File)new File(this.scriptfile), (Charset)null);
                    zip = null;
                }
            }
        } else if (!this.injectclass) {
            object6 = stringBuilder.toString();
        }
        if (object6 != null) {
            if (this.injectcode) {
                object6 = this.code + "\n" + (String)object6;
            }
            if (((String)object6).startsWith("#") || ((String)object6).startsWith(PREFIX_SCRIPT)) {
                object6 = ((String)object6).replaceAll("^#.*", "//");
                object6 = ((String)object6).replaceFirst(PREFIX_SCRIPT, "");
            }
            if (this.daemon) {
                object6 = "ow.loadServer().simpleCheckIn('" + this.scriptfile + "'); " + (String)object6 + "; ow.loadServer().daemon();";
            }
        }
        inputStream = (Context)jse.getNotSafeContext();
        NativeObject nativeObject = new NativeObject();
        object4 = (Scriptable)jse.getGlobalscope();
        object3 = Context.javaToJS((Object)this.__noSLF4JErrorOnly, (Scriptable)object4);
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("java.util.logging.config.file", "");
        }
        object5 = jsonObject != null ? AFBase.jsonParse(jsonObject.toString(), false) : AFCmdBase.jse.newObject(object4);
        Object object7 = this;
        synchronized (object7) {
            Object object8;
            ScriptableObject.putProperty((Scriptable)object4, (String)"__noSLF4JErrorOnly", (Object)object3);
            ScriptableObject.putProperty((Scriptable)object4, (String)"pmIn", (Object)object5);
            ScriptableObject.putProperty((Scriptable)object4, (String)"__pmIn", (Object)object5);
            object2 = Context.javaToJS((Object)nativeObject, (Scriptable)object4);
            ScriptableObject.putProperty((Scriptable)object4, (String)"pmOut", (Object)object2);
            ScriptableObject.putProperty((Scriptable)object4, (String)"__pmOut", (Object)object2);
            object = Context.javaToJS((Object)this.exprInput, (Scriptable)object4);
            ScriptableObject.putProperty((Scriptable)object4, (String)"expr", (Object)object);
            ScriptableObject.putProperty((Scriptable)object4, (String)"__expr", (Object)object);
            ScriptableObject.putProperty((Scriptable)object4, (String)"__args", (Object)args);
            if (this.filescript) {
                object8 = Context.javaToJS((Object)this.scriptfile, (Scriptable)object4);
                ScriptableObject.putProperty((Scriptable)object4, (String)"__scriptfile", (Object)object8);
                ScriptableObject.putProperty((Scriptable)object4, (String)"__iszip", (Object)(zip != null ? 1 : 0));
            }
            ScriptableObject.defineClass((Scriptable)object4, AFBase.class, (boolean)false, (boolean)true);
            ScriptableObject.defineClass((Scriptable)object4, DB.class, (boolean)false, (boolean)true);
            ScriptableObject.defineClass((Scriptable)object4, CSV.class, (boolean)false, (boolean)true);
            ScriptableObject.defineClass((Scriptable)object4, IOBase.class, (boolean)false, (boolean)true);
            object8 = null;
            object8 = (Scriptable)jse.newObject(object4, "AF");
            if (!ScriptableObject.hasProperty((Scriptable)object4, (String)"af")) {
                ((IdScriptableObject)object4).put("af", (Scriptable)object4, object8);
            }
            if (!ScriptableObject.hasProperty((Scriptable)object4, (String)"io")) {
                ((IdScriptableObject)object4).put("io", (Scriptable)object4, jse.newObject(object4, "IO"));
            }
        }
        AFBase.runFromClass(Class.forName("openaf_js").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        if (bl2) {
            object6 = "(function(__pIn) { var __pmOut = {}; var __pmIn = __pIn; " + (String)object6 + "; return __pmOut; })(" + String.valueOf(jsonObject) + ")";
        }
        object6 = "try{" + (String)object6 + "\n;} catch(_e) { $err(_e) }";
        object7 = null;
        if (this.injectscript || this.filescript || this.injectcode || bl) {
            object2 = (Context)jse.enterContext();
            object = object2.compileString((String)object6, this.scriptfile, 1, null);
            object7 = object.exec((Context)object2, (Scriptable)object4);
            jse.exitContext();
        }
        if (this.injectclass) {
            object7 = AFBase.runFromClass(Class.forName(this.injectclassfile).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        nativeObject = bl2 && object7 != null && !(object7 instanceof Undefined) ? (NativeObject)object7 : (NativeObject)((ScriptableObject)jse.getGlobalscope()).get((Object)"__pmOut");
        object2 = NativeJSON.stringify((Context)inputStream, (Scriptable)object4, (Object)nativeObject, null, null);
        try {
            Class.forName("com.google.gson.Gson");
            Class.forName("com.google.gson.internal.Primitives");
            object = new Gson();
            this.pmOut = (JsonObject)object.fromJson(object2.toString(), JsonObject.class);
            return this.pmOut;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.pmOut;
    }

    public static void main(String[] stringArray) {
        AFCmdOS aFCmdOS = new AFCmdOS();
        AFCmdBase.args = stringArray;
        aFCmdOS.processArgs(stringArray);
        try {
            aFCmdOS.execute(System.in, System.out, "");
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.ERROR, "Error while executing operation: " + exception.getMessage(), null);
            SimpleLog.log(SimpleLog.logtype.DEBUG, "", exception);
        }
    }

    public static enum inputtype {
        INPUT_EXPR,
        INPUT_JSON,
        INPUT_SCRIPT,
        INPUT_AUTO;

    }

    public static enum outputtype {
        OUTPUT_JSON;

    }
}

