/*
 * Decompiled with CFR 0.152.
 */
package openaf;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import openaf.AFCmdBase;
import openaf.JSEngine;
import openaf.OAFdCL;
import openaf.SimpleLog;
import openaf.core.IO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.xml.XMLObject;

public class AFBase
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static String K = "openappframework";
    private static Boolean jsonParseOld = null;
    protected static HashMap<URL[], URLClassLoader> loaders = new HashMap();

    public AFBase() {
    }

    @JSConstructor
    public AFBase(Object object) throws Exception {
        if (object != null && !(object instanceof Undefined)) {
            System.out.println("WARNING: You might be trying to use OpenAF without the OpenCli opack or your OpenCli opack doesn't the current OpenAF version.");
        }
    }

    @JSFunction
    public static Object fromJson(String string) throws Exception {
        return AFBase.jsonParse(string, false);
    }

    @JSFunction
    public static void setK(String string) {
        K = string;
    }

    @JSFunction
    public static void restartOpenAF(Object object) throws IOException {
        Object object2;
        File file;
        String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        try {
            file = new File(Class.forName("openaf.AFCmdBase").getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception exception) {
            file = new File(System.getProperties().getProperty("java.class.path"));
        }
        if (!file.getName().endsWith(".jar")) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add("-jar");
        arrayList.add(file.getPath());
        if (object instanceof NativeArray) {
            object2 = new ArrayList();
            for (Object object3 : ((NativeArray)object).toArray()) {
                ((ArrayList)object2).add(object3.toString());
            }
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                arrayList.add(string2);
            }
        } else {
            for (String string3 : AFCmdBase.args) {
                arrayList.add(string3);
            }
        }
        object2 = new ProcessBuilder(arrayList);
        ((ProcessBuilder)object2).inheritIO();
        ((ProcessBuilder)object2).start();
        System.exit(0);
    }

    public static String correctUrlString(String string) {
        try {
            URI uRI = new URI(string);
            Object object = uRI.getPath();
            if (object == null || ((String)object).isEmpty()) {
                object = "/";
            } else if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            return new URI(uRI.getScheme(), uRI.getAuthority(), (String)object, uRI.getQuery(), uRI.getFragment()).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid URL: " + string, uRISyntaxException);
        }
    }

    @JSFunction
    public static Object jsonParse(String string, boolean bl) {
        Object object;
        Context context = (Context)AFCmdBase.jse.enterContext();
        if (string == null || string.length() <= 0) {
            object = AFCmdBase.jse.newObject(AFCmdBase.jse.getGlobalscope());
        } else {
            if (bl) {
                if (jsonParseOld == null) {
                    try {
                        JsonParser.class.getMethod("parseString", new Class[0]);
                        jsonParseOld = false;
                    }
                    catch (Exception exception) {
                        jsonParseOld = true;
                    }
                }
                string = jsonParseOld != false ? JsonParser.parseString((String)string).toString() : JsonParser.parseString((String)string).toString();
            }
            object = NativeJSON.parse((Context)context, (Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)string, (Callable)new Callable(){

                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    return objectArray[1];
                }
            });
        }
        AFCmdBase.jse.exitContext();
        return object;
    }

    @JSFunction
    public static Object toJavaMap(Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        if (object instanceof NativeObject) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Map map = (Map)new Gson().fromJson((String)NativeJSON.stringify((Context)context, (Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (Object)object, null, (Object)"  "), type);
            return map;
        }
        AFCmdBase.jse.exitContext();
        return null;
    }

    @JSFunction
    public static Object fromJavaMap(Object object) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        Object object2 = object;
        try {
            object2 = AFBase.jsonParse(new Gson().toJson(object, type), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public String js2s(Object object) {
        Object object2;
        AFCmdBase.jse.defineSerialize();
        if (object instanceof Undefined) {
            return "undefined";
        }
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap().toString();
        }
        if (object instanceof XMLObject) {
            object = AFBase.fromXML(object);
        }
        Context context = (Context)AFCmdBase.jse.enterContext();
        Object object3 = AFCmdBase.jse.getGlobalscope();
        synchronized (object3) {
            object2 = AFCmdBase.jse.stringify(object, context.evaluateString((Scriptable)AFCmdBase.jse.getGlobalscope(), "getSerialize()", "", 1, null), 2);
        }
        AFCmdBase.jse.exitContext();
        return object2.toString();
    }

    @JSFunction
    public void p(String string) {
        System.out.println(string);
    }

    @JSFunction
    public void pnl(String string) {
        System.out.print(string);
    }

    @JSFunction
    public void e(String string) {
        System.err.println(string);
    }

    @JSFunction
    public void enl(String string) {
        System.err.print(string);
    }

    @JSFunction
    public String fromBytes2String(Object object, Object object2) throws UnsupportedEncodingException {
        byte[] byArray = object instanceof NativeJavaArray ? (byte[])((NativeJavaArray)object).unwrap() : (byte[])object;
        if (object2 != null && !(object2 instanceof Undefined)) {
            return new String(byArray, (String)object2);
        }
        return new String(byArray);
    }

    @JSFunction
    public Object fromString2Bytes(String string, Object object) throws UnsupportedEncodingException {
        if (object != null && !(object instanceof Undefined)) {
            return string.getBytes((String)object);
        }
        return string.getBytes();
    }

    @JSFunction
    public Object toEncoding(String string, Object object, Object object2) throws UnsupportedEncodingException {
        if (string != null) {
            if (object2 != null && !(object2 instanceof Undefined)) {
                if (object != null && !(object instanceof Undefined)) {
                    return new String(string.getBytes((String)object2), (String)object);
                }
                return new String(string.getBytes((String)object2));
            }
            if (object != null && !(object instanceof Undefined)) {
                return new String(string.getBytes(), (String)object);
            }
            return new String(string.getBytes());
        }
        return null;
    }

    @JSFunction
    public static String fromXML(Object object) {
        if (object instanceof XMLObject) {
            return (String)ScriptableObject.callMethod((Scriptable)((XMLObject)object), (String)"toXMLString", (Object[])new Object[0]);
        }
        return null;
    }

    @JSFunction
    public boolean mkdir(String string) throws IOException {
        return new File(string).mkdirs();
    }

    @JSFunction
    public synchronized void sleep(double d) {
        try {
            Thread.sleep((long)d);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public Object sh(Object object, Object object2, Object object3, boolean bl, Object object4, boolean bl2, Object object5, Object object6, boolean bl3, Object object7, Object object8) throws IOException, InterruptedException {
        long l;
        InputStream inputStream;
        String string;
        Object object9;
        Object object102;
        Object object11;
        Map<String, String> map;
        ProcessBuilder processBuilder = null;
        Charset charset = object6 instanceof String ? Charset.forName((String)object6) : Charset.defaultCharset();
        if (object instanceof NativeArray) {
            map = new ArrayList<String>();
            for (Object object12 : ((NativeArray)object).toArray()) {
                ((ArrayList)((Object)map)).add(object12.toString());
            }
            processBuilder = new ProcessBuilder((String[])Arrays.copyOf(((ArrayList)((Object)map)).toArray(), ((ArrayList)((Object)map)).size(), String[].class));
        } else {
            processBuilder = System.getProperty("os.name").startsWith("Windows") ? new ProcessBuilder(((String)object).split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)")) : new ProcessBuilder(((String)object).split(" (?=([^']*'[^']*')*[^']*$)"));
        }
        if (bl) {
            processBuilder.inheritIO();
        }
        if (object4 != null && !(object4 instanceof Undefined)) {
            processBuilder.directory(new File((String)object4));
        }
        if (object7 != null && object7 instanceof NativeObject) {
            map = processBuilder.environment();
            map.clear();
            object11 = (Scriptable)object7;
            for (Object object102 : object11.getIds()) {
                Object object13 = object9 = object102 == null ? null : object102.toString();
                if (object9 == null) continue;
                Object object14 = ScriptableObject.getProperty((Scriptable)object11, (String)object9);
                string = null;
                if (object14 != null && !(object14 instanceof Undefined)) {
                    string = Context.toString((Object)object14);
                }
                map.put((String)object9, string);
            }
        }
        map = processBuilder.start();
        if (object2 instanceof NativeJavaObject) {
            object2 = ((NativeJavaObject)object2).unwrap();
        }
        if (object2 instanceof String) {
            try {
                object11 = ((Process)((Object)map)).getOutputStream();
                ((OutputStream)object11).write(((String)object2).getBytes());
                ((OutputStream)object11).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            object11 = null;
            inputStream = null;
            IOUtils.copy((InputStream)((Process)((Object)map)).getInputStream(), (OutputStream)System.out);
            IOUtils.copy((InputStream)((Process)((Object)map)).getErrorStream(), (OutputStream)System.err);
        } else {
            object11 = ((Process)((Object)map)).getInputStream();
            inputStream = ((Process)((Object)map)).getErrorStream();
        }
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicReference<Object> atomicReference2 = new AtomicReference<Object>(null);
        object102 = null;
        if (((Process)((Object)map)).isAlive() && object8 != null && !(object8 instanceof Undefined) && object8 instanceof Function) {
            object102 = new Thread(this, (Process)((Object)map), object8, (InputStream)object11, atomicReference, charset, inputStream, atomicReference2){
                final /* synthetic */ Process val$p;
                final /* synthetic */ Object val$exitCallback;
                final /* synthetic */ InputStream val$is;
                final /* synthetic */ AtomicReference val$tlines;
                final /* synthetic */ Charset val$Cencoding;
                final /* synthetic */ InputStream val$iserr;
                final /* synthetic */ AtomicReference val$tlinesErr;
                {
                    this.val$p = process;
                    this.val$exitCallback = object;
                    this.val$is = inputStream;
                    this.val$tlines = atomicReference;
                    this.val$Cencoding = charset;
                    this.val$iserr = inputStream2;
                    this.val$tlinesErr = atomicReference2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    var1_1 = false;
                    var2_2 = (Context)AFCmdBase.jse.enterContext();
lbl3:
                    // 10 sources

                    block19: while (this.val$p.isAlive()) {
                        try {
                            if (this.val$p.waitFor(500L, TimeUnit.MILLISECONDS) || !((var3_3 = ((Function)this.val$exitCallback).call(var2_2, (Scriptable)AFCmdBase.jse.getGlobalscope(), var2_2.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{this.val$p})) instanceof String)) continue;
                            var4_7 = ((String)var3_3).toLowerCase();
                            var5_8 = -1;
                            switch (var4_7.hashCode()) {
                                case 97618667: {
                                    if (!var4_7.equals("force")) break;
                                    var5_8 = 0;
                                    break;
                                }
                                case 1557372922: {
                                    if (!var4_7.equals("destroy")) break;
                                    var5_8 = 1;
                                }
                            }
                            switch (var5_8) {
                                case 0: {
                                    this.val$p.destroyForcibly();
                                    var1_1 = true;
                                    ** break;
                                }
                                case 1: {
                                    this.val$p.destroy();
                                    var1_1 = true;
                                    continue block19;
                                }
                                ** default:
lbl27:
                                // 1 sources

                                continue block19;
                            }
                        }
                        catch (Exception var3_5) {
                            var3_5.printStackTrace();
                        }
                        finally {
                            if (!var1_1) continue;
                            try {
                                if (this.val$is != null && !this.val$p.isAlive()) {
                                    this.val$tlines.set(IOUtils.toString((InputStream)this.val$is, (Charset)this.val$Cencoding));
                                }
                                if (this.val$iserr == null || this.val$p.isAlive()) continue;
                                this.val$tlinesErr.set(IOUtils.toString((InputStream)this.val$iserr, (Charset)this.val$Cencoding));
                            }
                            catch (Exception var3_6) {}
                        }
                    }
                    AFCmdBase.jse.exitContext();
                }
            };
            ((Thread)object102).start();
        }
        object9 = null;
        if (((Process)((Object)map)).isAlive() && object3 != null && !(object3 instanceof Undefined) && (l = Double.valueOf(Double.parseDouble(object3.toString())).longValue()) >= 0L) {
            object9 = new Thread(this, (Process)((Object)map), (InputStream)object11, atomicReference, charset, inputStream, atomicReference2){
                final /* synthetic */ Process val$p;
                final /* synthetic */ InputStream val$is;
                final /* synthetic */ AtomicReference val$tlines;
                final /* synthetic */ Charset val$Cencoding;
                final /* synthetic */ InputStream val$iserr;
                final /* synthetic */ AtomicReference val$tlinesErr;
                {
                    this.val$p = process;
                    this.val$is = inputStream;
                    this.val$tlines = atomicReference;
                    this.val$Cencoding = charset;
                    this.val$iserr = inputStream2;
                    this.val$tlinesErr = atomicReference2;
                }

                @Override
                public void run() {
                    try {
                        long l2 = System.currentTimeMillis() + l;
                        while (System.currentTimeMillis() < l2 && this.val$p.isAlive()) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        try {
                            if (this.val$is != null && !this.val$p.isAlive()) {
                                this.val$tlines.set(IOUtils.toString((InputStream)this.val$is, (Charset)this.val$Cencoding));
                            }
                            if (this.val$iserr != null && !this.val$p.isAlive()) {
                                this.val$tlinesErr.set(IOUtils.toString((InputStream)this.val$iserr, (Charset)this.val$Cencoding));
                            }
                        }
                        catch (Exception exception) {}
                        if (this.val$p.isAlive()) {
                            this.val$p.destroy();
                            this.val$p.destroyForcibly();
                            try {
                                if (this.val$is != null) {
                                    this.val$is.close();
                                }
                                if (this.val$iserr != null) {
                                    this.val$iserr.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            };
            ((Thread)object9).start();
        }
        if (((Process)((Object)map)).isAlive() && object11 != null && inputStream != null && object5 != null && object5 instanceof Function) {
            Context context = (Context)AFCmdBase.jse.enterContext();
            try {
                ((Function)object5).call(context, (Scriptable)AFCmdBase.jse.getGlobalscope(), context.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{object11, inputStream, ((Process)((Object)map)).getOutputStream()});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                AFCmdBase.jse.exitContext();
            }
        }
        String string2 = new String();
        string = new String();
        if (!bl3) {
            try {
                if (object11 != null) {
                    string2 = IOUtils.toString((InputStream)object11, (Charset)charset);
                }
                if (inputStream != null) {
                    string = IOUtils.toString((InputStream)inputStream, (Charset)charset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = -1;
        try {
            if (!bl3) {
                n = ((Process)((Object)map)).waitFor();
            }
            try {
                if (object11 != null) {
                    ((InputStream)object11).close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
        ((Process)((Object)map)).getInputStream().close();
        ((Process)((Object)map)).getErrorStream().close();
        if (bl2) {
            JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
            jSMap.put("stdout", atomicReference.get() != null ? atomicReference.get() : string2);
            jSMap.put("stderr", atomicReference2.get() != null ? atomicReference2.get() : string);
            jSMap.put("exitcode", n);
            return jSMap.getMap();
        }
        ((ScriptableObject)AFCmdBase.jse.getGlobalscope()).defineProperty("__exitcode", (Object)n, 4);
        ((ScriptableObject)AFCmdBase.jse.getGlobalscope()).defineProperty("__stderr", atomicReference2.get() != null ? atomicReference2.get() : string, 4);
        return atomicReference.get() != null ? atomicReference.get() : string2;
    }

    @JSFunction
    public boolean rm(String string) throws IOException {
        File file = new File(string);
        if (!file.isDirectory()) {
            return Files.deleteIfExists(Paths.get(string, new String[0]));
        }
        FileUtils.deleteDirectory((File)new File(string));
        return true;
    }

    @JSFunction
    public boolean rename(String string, String string2) {
        return new File(string).renameTo(new File(string2));
    }

    @JSFunction
    public boolean mv(String string, String string2) throws IOException {
        return Files.move(new File(string).toPath(), new File(string2).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE) != null;
    }

    @JSFunction
    public void cp(String string, String string2) throws IOException {
        Files.copy(new File(string).toPath(), new File(string2).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @JSFunction
    public static String encrypt(String string, Object object) throws Exception {
        if (object == null || object instanceof Undefined) {
            object = K;
        }
        if (object instanceof String) {
            object = ((String)object).getBytes();
        }
        if (((byte[])object).length < 16) {
            throw new Exception("Invalid key size. Key should be, at least, 16 bytes.");
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = secureRandom.generateSeed(16);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray2 = cipher.doFinal(string.getBytes());
        return (Hex.encodeHexString((byte[])byArray2) + Hex.encodeHexString((byte[])byArray)).toUpperCase();
    }

    @JSFunction
    public static String decrypt(String string, Object object) throws Exception {
        if (object == null || object instanceof Undefined) {
            object = K;
        }
        if (object instanceof String) {
            object = ((String)object).getBytes();
        }
        if (((byte[])object).length < 16) {
            throw new Exception("Invalid key size. Key should be, at least, 16 bytes.");
        }
        String string2 = string.substring(string.length() - 32);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(Hex.decodeHex((char[])string2.toCharArray()));
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray = cipher.doFinal(Hex.decodeHex((char[])string.substring(0, string.length() - 32).toCharArray()));
        return new String(byArray);
    }

    public static String decryptIfPossible(String string) {
        try {
            String string2 = AFBase.decrypt(string, K);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    @JSFunction
    public void writeFile(String string, Object object, String string2, boolean bl) throws Exception {
        throw new Exception("af.writeFile was deprecated. Please replace with io.writeFile.");
    }

    @JSFunction
    public void writeFileString(String string, String string2, String string3, boolean bl) throws Exception {
        throw new Exception("af.writeFileString was deprecated. Please replace with io.writeFileString.");
    }

    @JSFunction
    public void writeFileXML(String string, Object object, String string2, boolean bl) throws Exception {
        throw new Exception("af.writeFileXML was deprecated. Please replace with io.writeFileXML.");
    }

    @JSFunction
    public void writeFileBytes(String string, Object object) throws Exception {
        throw new Exception("af.writeFileBytes was deprecated. Please replace with io.writeFileBytes.");
    }

    @JSFunction
    public void writeFileAsArray(String string, Object object, String string2) throws Exception {
        throw new Exception("af.writeFileAsArray was deprecated. Please replace with io.writeFileAsArray.");
    }

    @JSFunction
    public Object listFiles(String string) throws Exception {
        throw new Exception("af.listFiles was deprecated. Please replace with io.listFiles.");
    }

    @JSFunction
    public Object readFile(String string, String string2) throws Exception {
        throw new Exception("af.readFile was deprecated. Please replace with io.readFile.");
    }

    @JSFunction
    public Object readFileAsArray(String string, String string2) throws Exception {
        throw new Exception("af.readFileAsArray was deprecated. Please replace with io.readFileAsArray.");
    }

    @JSFunction
    public String readFileString(String string, String string2) throws Exception {
        throw new Exception("af.readFileString was deprecated. Please replace with io.readFileString.");
    }

    @JSFunction
    public Object readFileXML(String string, int n, String string2) throws Exception {
        throw new Exception("af.readFileXML was deprecated. Please replace with io.readFileXML.");
    }

    @JSFunction
    public Object readFileBytes(String string) throws Exception {
        throw new Exception("af.readFileBytes was deprecated. Please replace with io.readFileBytes.");
    }

    @JSFunction
    public void plugin(String string) throws ReflectiveOperationException {
        try {
            Class<?> clazz = Class.forName(string);
            ScriptableObject.defineClass((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), clazz, (boolean)false, (boolean)true);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Cannot find class: " + string + "; " + reflectiveOperationException.getMessage(), reflectiveOperationException);
            throw reflectiveOperationException;
        }
    }

    @JSFunction
    public void externalPlugin(Object object, String string) throws Exception {
        try {
            Object object22;
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (!(object instanceof NativeArray)) {
                return;
            }
            AFCmdBase.jse.enterContext();
            for (Object object22 : (NativeArray)object) {
                arrayList.add(new URI(Context.toString(object22)).toURL());
            }
            AFCmdBase.jse.exitContext();
            URL[] uRLArray = new URL[]{};
            uRLArray = arrayList.toArray(uRLArray);
            if (loaders.containsKey(uRLArray)) {
                object22 = loaders.get(uRLArray);
            } else {
                object22 = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
                loaders.put(uRLArray, (URLClassLoader)object22);
            }
            Class<?> clazz = Class.forName(string, true, object22);
            ScriptableObject.defineClass((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), clazz, (boolean)false, (boolean)true);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | MalformedURLException exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Cannot find class: " + string + "; " + exception.getMessage(), exception);
            throw exception;
        }
    }

    @JSFunction
    public Class<?> externalClass(Object object, String string) throws Exception {
        try (URLClassLoader uRLClassLoader = null;){
            Object object22;
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (!(object instanceof NativeArray)) {
                Class<?> clazz = null;
                return clazz;
            }
            AFCmdBase.jse.enterContext();
            for (Object object22 : (NativeArray)object) {
                arrayList.add(URI.create(Context.toString(object22)).toURL());
            }
            AFCmdBase.jse.exitContext();
            URL[] uRLArray = new URL[]{};
            uRLArray = arrayList.toArray(uRLArray);
            uRLClassLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
            Object object3 = object22 = Class.forName(string, true, uRLClassLoader);
            return object3;
        }
    }

    @JSFunction
    public Object externalClassLoader(Object object) throws MalformedURLException {
        try {
            Object object22;
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (!(object instanceof NativeArray)) {
                return null;
            }
            AFCmdBase.jse.enterContext();
            for (Object object22 : (NativeArray)object) {
                arrayList.add(URI.create(Context.toString(object22)).toURL());
            }
            AFCmdBase.jse.exitContext();
            URL[] uRLArray = new URL[]{};
            uRLArray = arrayList.toArray(uRLArray);
            object22 = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
            return object22;
        }
        catch (MalformedURLException malformedURLException) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Cannot find urls; " + malformedURLException.getMessage(), malformedURLException);
            throw malformedURLException;
        }
    }

    @JSFunction
    public void externalAddClasspath(String string) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        if (string != null) {
            if (ClassLoader.getSystemClassLoader() instanceof OAFdCL) {
                OAFdCL oAFdCL = OAFdCL.getInstance(ClassLoader.getSystemClassLoader());
                oAFdCL.addURL(URI.create(string).toURL());
            } else {
                try {
                    OAFdCL oAFdCL = OAFdCL.getInstance(ClassLoader.getSystemClassLoader());
                    oAFdCL.addURL(URI.create(string).toURL());
                }
                catch (Exception exception) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)classLoader, URI.create(string).toURL());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JSFunction
    public void load(String object, NativeFunction nativeFunction) throws Exception {
        Object object2;
        Object object3;
        String string;
        block30: {
            string = null;
            if (object == null) {
                throw new Exception("No filename provided.");
            }
            if (!((String)object).matches(".+\\.[^\\.]+$")) {
                object = (String)object + ".js";
            }
            if (((String)object).indexOf("::") > 0) {
                if (!IO.fileExists(((String)object).replaceFirst("::.+", ""))) throw new Exception("'" + ((String)object).replaceFirst("::.+", "") + "' not found.");
                object3 = new ZipFile(((String)object).replaceFirst("::.+", ""));
                if (object3 != null) {
                    try {
                        object2 = ((ZipFile)object3).getEntry(((String)object).replaceFirst(".+::", ""));
                        if (object2 == null) throw new Exception("Entry '" + ((String)object).replaceFirst(".+::", "") + "' not found.");
                        InputStreamReader inputStreamReader = new InputStreamReader(((ZipFile)object3).getInputStream((ZipEntry)object2));
                        if (inputStreamReader != null) {
                            string = IOUtils.toString((Reader)inputStreamReader);
                            inputStreamReader.close();
                        }
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        ((ZipFile)object3).close();
                    }
                    ScriptableObject.putProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__loadedfromzip", (Object)((String)object).replaceFirst("::[^:]+$", ""));
                }
            } else {
                try {
                    if (AFCmdBase.zip != null && AFCmdBase.zip.getEntry((String)object) != null) {
                        string = IOUtils.toString((InputStream)AFCmdBase.zip.getInputStream(AFCmdBase.zip.getEntry((String)object)), (Charset)null);
                        break block30;
                    }
                    if (ScriptableObject.getProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__loadedfromzip") != Scriptable.NOT_FOUND) {
                        object3 = ScriptableObject.getProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__loadedfromzip").toString();
                        object2 = null;
                        try {
                            object2 = new ZipFile((String)object3);
                            InputStreamReader inputStreamReader = new InputStreamReader(((ZipFile)object2).getInputStream(((ZipFile)object2).getEntry((String)object)));
                            if (inputStreamReader != null) {
                                string = IOUtils.toString((Reader)inputStreamReader);
                                ScriptableObject.putProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__loadedfromzip", (Object)object3);
                                inputStreamReader.close();
                            }
                        }
                        catch (Exception exception) {
                            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error trying to load from a recurring zip: " + (String)object3 + " for '" + (String)object + "'", exception);
                        }
                        finally {
                            if (object2 != null) {
                                ((ZipFile)object2).close();
                            }
                        }
                    }
                    if (string == null) {
                        string = FileUtils.readFileToString((File)new File((String)object), (Charset)Charset.forName("UTF-8"));
                    }
                }
                catch (IOException iOException) {
                    SimpleLog.log(SimpleLog.logtype.DEBUG, "Error loading file: " + (String)object + "; " + iOException.getMessage(), iOException);
                    throw iOException;
                }
            }
        }
        if (string == null) return;
        object3 = (Context)AFCmdBase.jse.enterContext();
        try {
            ScriptableObject.putProperty((Scriptable)((Scriptable)AFCmdBase.jse.getGlobalscope()), (String)"__loadedfrom", (Object)object);
            string = string.replaceAll("^#[^\n]*\n", "//\n");
            if (nativeFunction != null && (object2 = nativeFunction.call((Context)object3, (Scriptable)AFCmdBase.jse.getGlobalscope(), object3.newObject((Scriptable)AFCmdBase.jse.getGlobalscope()), new Object[]{new String(string)})) != null) {
                string = object2.toString();
            }
            this.compile(string, (String)object);
            return;
        }
        catch (Exception exception) {
            SimpleLog.log(SimpleLog.logtype.DEBUG, "Error reading file: " + (String)object + "; " + exception.getMessage(), exception);
            throw exception;
        }
        finally {
            AFCmdBase.jse.exitContext();
        }
    }

    @JSFunction
    public Object compile(String string, String string2) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        context.setLanguageVersion(200);
        Script script = context.compileString(string, string2, 1, null);
        AFCmdBase.jse.addNumberOfLines(string);
        Object object = script.exec(context, (Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public Object parse(String string, String string2) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        try {
            JSEngine.JSList jSList = AFCmdBase.jse.getNewList(null);
            CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
            compilerEnvirons.setLanguageVersion(200);
            Parser parser = new Parser(compilerEnvirons);
            AstRoot astRoot = parser.parse(string, string2, 1);
            Object object = astRoot.iterator();
            while (object.hasNext()) {
                jSList.add(((ExpressionStatement)object.next()).toSource());
            }
            object = jSList.getList();
            return object;
        }
        finally {
            AFCmdBase.jse.exitContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public void compileToClasses(String string, String string2, String object) throws IOException {
        ClassCompiler classCompiler = new ClassCompiler(new CompilerEnvirons());
        Object[] objectArray = classCompiler.compileToClassFiles(string2, string, 1, string);
        object = object == null || ((String)object).equals("undefined") ? "" : (String)object + "/";
        for (int i = 0; i != objectArray.length; i += 2) {
            String string3 = (String)objectArray[i];
            byte[] byArray = (byte[])objectArray[i + 1];
            File file = new File((String)object + string3 + ".class");
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(byArray);
                continue;
            }
        }
    }

    @JSFunction
    public static Object runFromClass(Object object) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Object object2 = ((Script)object).exec(context, (Scriptable)AFCmdBase.jse.getGlobalscope());
        AFCmdBase.jse.exitContext();
        return object2;
    }

    @JSFunction
    public byte[] fromBase64(Object object) {
        if (object instanceof String) {
            return Base64.decodeBase64((String)((String)object));
        }
        return Base64.decodeBase64((byte[])((byte[])object));
    }

    @JSFunction
    public Object toBase64Bytes(Object object) {
        if (object instanceof String) {
            return Base64.encodeBase64((byte[])((String)object).getBytes());
        }
        if (object instanceof NativeJavaArray) {
            return Base64.encodeBase64((byte[])((byte[])((NativeJavaArray)object).unwrap()));
        }
        return Base64.encodeBase64((byte[])((byte[])object));
    }

    @JSFunction
    public Object fromArray2Bytes(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (object instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)object;
            for (long i = 0L; i < (long)nativeArray.size(); ++i) {
                Double d = Double.parseDouble(nativeArray.get(i).toString());
                byteArrayOutputStream.write(d.intValue());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @JSFunction
    public Object fromBytes2Array(Object object) {
        int n;
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (object instanceof byte[]) {
            object2 = (byte[])object;
            for (n = 0; n < ((byte[])object2).length; ++n) {
                arrayList.add(Integer.valueOf(object2[n]));
            }
        }
        if (object instanceof NativeJavaArray) {
            object2 = (byte[])((NativeJavaArray)object).unwrap();
            for (n = 0; n < ((byte[])object2).length; ++n) {
                arrayList.add(Integer.valueOf(object2[n]));
            }
        }
        object2 = (Scriptable)AFCmdBase.jse.newArray(AFCmdBase.jse.createObject(), arrayList.toArray());
        return object2;
    }

    @JSFunction
    public String ask(String string) {
        Scanner scanner = new Scanner(System.in);
        System.out.println(string);
        String string2 = scanner.nextLine();
        scanner.close();
        return string2;
    }

    @JSFunction
    public String askChar(String string) {
        Scanner scanner = new Scanner(System.in);
        System.out.println(string);
        String string2 = Byte.valueOf(scanner.nextByte()).toString();
        scanner.close();
        return string2;
    }

    @JSFunction
    public Class<?> getClass(String string, Object object) throws ClassNotFoundException {
        if (object != null && object instanceof ClassLoader) {
            return Class.forName(string, true, (ClassLoader)object);
        }
        return Class.forName(string);
    }

    @JSFunction
    public String getVersion() {
        return AFCmdBase.VERSION;
    }

    @JSFunction
    public String getDistribution() {
        return AFCmdBase.DISTRIBUTION;
    }

    @JSFunction
    public static String getOpenAFJar() {
        return AFCmdBase.getJarFilePath(AFCmdBase.class);
    }

    @JSFunction
    public static int visibleLength(String string) {
        string = string.replaceAll("\\033\\[[0-9;]*m", "");
        return string.codePointCount(0, string.length());
    }

    @JSFunction
    public static Object sync(Object object, Object object2) {
        if (object instanceof Function) {
            Object object3 = null;
            if (object2 != Undefined.instance) {
                object3 = object2;
            }
            return new Synchronizer((Scriptable)((Function)object), object3);
        }
        return null;
    }

    @JSFunction
    public static Object loadRequire(Object object, boolean bl) {
        Require require;
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setSandboxed(bl);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (object instanceof Undefined) {
            return null;
        }
        if (object != null) {
            require = new ArrayList();
            if (object instanceof NativeArray) {
                for (Object e : (NativeArray)object) {
                    require.add((String)e);
                }
            } else {
                require.add(object);
            }
            for (Object e : require) {
                try {
                    URI uRI = new URI((String)e);
                    if (!uRI.isAbsolute()) {
                        uRI = new File((String)e).toURI().resolve("");
                    }
                    if (!uRI.toString().endsWith("/")) {
                        uRI = new URI(String.valueOf(uRI) + "/");
                    }
                    arrayList.add(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
            }
        }
        requireBuilder.setModuleScriptProvider((ModuleScriptProvider)new SoftCachingModuleScriptProvider((ModuleSourceProvider)new UrlModuleSourceProvider(arrayList, null)));
        require = requireBuilder.createRequire((Context)AFCmdBase.jse.getNotSafeContext(), (Scriptable)AFCmdBase.jse.getGlobalscope());
        require.install((Scriptable)AFCmdBase.jse.getGlobalscope());
        return require;
    }

    public String getClassName() {
        return "AF";
    }

    @JSFunction
    public Object[] getScopeIds() {
        return ((ScriptableObject)AFCmdBase.jse.getGlobalscope()).getIds();
    }

    @JSFunction
    public static Object eval(String string) {
        Context context = (Context)AFCmdBase.jse.enterContext();
        Object object = context.evaluateString((Scriptable)AFCmdBase.jse.getGlobalscope(), string, "", 1, null);
        AFCmdBase.jse.exitContext();
        return object;
    }

    @JSFunction
    public String crypt(String string, Object object) {
        if (object instanceof Undefined) {
            object = null;
        }
        return Crypt.crypt((String)string, (String)((String)object));
    }

    @JSFunction
    public String randomCryptSalt() {
        String string = ".ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        byte[] byArray = SecureRandom.getSeed(2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.charAt((byArray[0] + 128) % string.length()));
        stringBuilder.append(string.charAt((byArray[1] + 128) % string.length()));
        return stringBuilder.toString();
    }

    @JSFunction
    public Double secureRandom() {
        return new SecureRandom().nextDouble();
    }

    @JSFunction
    public String fromInputStream2String(Object object, Object object2) throws IOException {
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        if (object instanceof InputStream) {
            if (object2 != null && !(object2 instanceof Undefined)) {
                return IOUtils.toString((InputStream)((InputStream)object), (String)((String)object2));
            }
            return IOUtils.toString((InputStream)((InputStream)object), (String)System.getProperty("file.encoding"));
        }
        return null;
    }

    @JSFunction
    public Object fromInputStream2Bytes(Object object) throws IOException {
        if (object instanceof NativeJavaObject) {
            object = ((NativeJavaObject)object).unwrap();
        }
        if (object instanceof InputStream) {
            return IOUtils.toByteArray((InputStream)((InputStream)object));
        }
        return null;
    }

    @JSFunction
    public Object fromBytes2OutputStream(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        if (object != null && !(object instanceof Undefined) && object instanceof byte[]) {
            byteArrayOutputStream.write((byte[])object);
        }
        return byteArrayOutputStream;
    }

    @JSFunction
    public Object fromString2OutputStream(String string, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (string != null) {
            if (object != null && !(object instanceof Undefined)) {
                byteArrayOutputStream.write(string.getBytes((String)object));
            } else {
                byteArrayOutputStream.write(string.getBytes());
            }
        }
        return byteArrayOutputStream;
    }

    @JSFunction
    public Object fromBytes2InputStream(Object object) {
        if (object instanceof NativeJavaArray) {
            object = ((NativeJavaArray)object).unwrap();
        }
        if (object != null && !(object instanceof Undefined) && object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        return new ByteArrayInputStream(new String().getBytes());
    }

    @JSFunction
    public Object fromString2InputStream(String string, Object object) throws UnsupportedEncodingException {
        if (object != null && !(object instanceof Undefined)) {
            if (string != null) {
                return this.fromBytes2InputStream(string.getBytes((String)object));
            }
            return this.fromBytes2InputStream(new String().getBytes());
        }
        if (string != null) {
            return this.fromBytes2InputStream(string.getBytes());
        }
        return this.fromBytes2InputStream(new String().getBytes());
    }

    @JSFunction
    public Object newOutputStream() {
        return new ByteArrayOutputStream();
    }

    @JSFunction
    public Object create2FACredentials(String string, String string2) throws Exception {
        JSEngine.JSMap jSMap = AFCmdBase.jse.getNewMap(null);
        if (string == null) {
            string = "openaf";
        }
        if (string2 == null) {
            string2 = "user@openaf.io";
        }
        GoogleAuthenticator googleAuthenticator = new GoogleAuthenticator();
        GoogleAuthenticatorKey googleAuthenticatorKey = googleAuthenticator.createCredentials();
        JSEngine.JSList jSList = AFCmdBase.jse.getNewList(null);
        jSList.addAll(googleAuthenticatorKey.getScratchCodes());
        jSMap.put("scratchCodes", jSList.getList());
        jSMap.put("verificationCode", String.format("%06d", googleAuthenticatorKey.getVerificationCode()));
        jSMap.put("key", googleAuthenticatorKey.getKey());
        jSMap.put("encryptedKey", AFBase.encrypt(googleAuthenticatorKey.getKey(), null));
        jSMap.put("qrChart", "https://api.qrserver.com/v1/create-qr-code/?data=otpauth%3A%2F%2Ftopt%2F" + string + "%3A" + string2 + "%3Fsecret%3D" + googleAuthenticatorKey.getKey() + "%26issuer%3D" + string + "%26algorithm%3D" + googleAuthenticatorKey.getConfig().getHmacHashFunction().toString().replace("Hmac", "") + "%26digits%3D" + googleAuthenticatorKey.getConfig().getCodeDigits() + "%26period%3D" + googleAuthenticatorKey.getConfig().getTimeStepSizeInMillis() / 1000L + "&size=200x200&ecc=M&margin=0");
        jSMap.put("otpURL", "otpauth://totp/" + string + ":" + string2 + "?secret=" + googleAuthenticatorKey.getKey() + "&issuer=" + string + "&algorithm=" + googleAuthenticatorKey.getConfig().getHmacHashFunction().toString().replace("Hmac", "") + "&digits=" + googleAuthenticatorKey.getConfig().getCodeDigits() + "&period=" + googleAuthenticatorKey.getConfig().getTimeStepSizeInMillis() / 1000L);
        return jSMap.getMap();
    }

    @JSFunction
    public boolean validate2FA(String string, String string2) {
        GoogleAuthenticator googleAuthenticator = new GoogleAuthenticator();
        return googleAuthenticator.authorize(AFCmdBase.afc.dIP(string), Integer.valueOf(string2).intValue());
    }

    @JSFunction
    public String get2FAToken(String string, double d) {
        GoogleAuthenticator googleAuthenticator = new GoogleAuthenticator();
        long l = -1L;
        if (!Double.isNaN(d)) {
            l = (long)d;
        }
        if (l >= 0L) {
            return String.format("%06d", googleAuthenticator.getTotpPassword(AFCmdBase.afc.dIP(string), l));
        }
        return String.format("%06d", googleAuthenticator.getTotpPassword(AFCmdBase.afc.dIP(string)));
    }
}

