/*
 * Decompiled with CFR 0.152.
 */
package com.nwu2.util;

import com.nwu2.util.CacheableObject;
import com.nwu2.util.SimpleCacheConfig;
import java.util.HashMap;

public class SimpleCache {
    protected HashMap<String, CacheableObject> cache = new HashMap();
    protected HashMap<String, Long> cacheAge = new HashMap();
    protected HashMap<String, Long> cacheLimitAge = new HashMap();
    protected SimpleCacheConfig conf;

    public SimpleCache(SimpleCacheConfig simpleCacheConfig) {
        this.conf = simpleCacheConfig;
    }

    public int getNumberOfCurrentCachedObjects() {
        return this.cache.size();
    }

    protected boolean stillYoungEnough(String string) {
        if (this.cacheAge.containsKey(string)) {
            if (this.cacheLimitAge.containsKey(string)) {
                return this.cacheLimitAge.get(string) - (this.conf.getCurrentCounter() - this.cacheAge.get(string)) > 0L;
            }
            if (this.conf.getLimitObjectInCacheAge() < 0L) {
                return true;
            }
            return this.conf.getLimitObjectInCacheAge() - (this.conf.getCurrentCounter() - this.cacheAge.get(string)) > 0L;
        }
        return false;
    }

    public void addObjectToCache(String string, CacheableObject cacheableObject) {
        this.cache.put(string, cacheableObject);
        this.cacheAge.put(string, this.conf.getCurrentCounter());
    }

    public void addObjectToCacheWithTimeLimit(String string, CacheableObject cacheableObject, long l) {
        this.addObjectToCache(string, cacheableObject);
        this.cacheLimitAge.put(string, l);
    }

    public boolean isObjectStillValid(String string) {
        boolean bl = false;
        if (this.cache.containsKey(string)) {
            if (this.stillYoungEnough(string)) {
                bl = true;
            } else {
                this.invalidateObject(string);
            }
        }
        return bl;
    }

    public void invalidateObject(String string) {
        this.cache.remove(string);
        this.cacheAge.remove(string);
        if (this.cacheLimitAge.containsKey(string)) {
            this.cacheLimitAge.remove(string);
        }
    }

    public CacheableObject getCachedObject(String string) {
        if (this.isObjectStillValid(string)) {
            return this.cache.get(string);
        }
        return null;
    }
}

