/*
 * Decompiled with CFR 0.152.
 */
package com.nwu2.log;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    protected static String LOG_DEFAULT_PATTERN = "%d{dd MMM yyyy HH:mm:ss,SSS};[%p]; %m%n";
    protected String logName;
    protected Logger lOG;
    protected boolean useLog4J;

    public Log(String string) {
        this(string, true);
    }

    public Log(String string, boolean bl) {
        this.logName = string;
        this.useLog4J = bl;
        this.lOG = Logger.getLogger(string);
        this.lOG.setLevel(Log.getOutputType2JavaLevel(Type.INFO));
    }

    public Log(String string, Type type) {
        this.logName = string;
        this.lOG = Logger.getLogger(string);
        this.lOG.setLevel(Log.getOutputType2JavaLevel(type));
    }

    public Log() {
        this(true);
    }

    public Log(boolean bl) {
        this.useLog4J = bl;
    }

    public void log(Type type, String string) {
        switch (type.ordinal()) {
            case 3: {
                this.lOG.log(Level.WARNING, string);
                break;
            }
            case 2: {
                this.lOG.severe(string);
                break;
            }
            case 1: {
                this.lOG.info(string);
                break;
            }
            case 0: {
                this.lOG.fine(string);
                break;
            }
        }
    }

    public void log(Type type, String string, Exception exception) {
        this.log(type, string + " | " + exception.getMessage());
        if (type == Type.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(Level level, String string) {
        if (level == Level.WARNING) {
            this.log(Type.DEBUG, string);
        }
        if (level == Level.SEVERE) {
            this.log(Type.ERROR, string);
        }
        if (level == Level.INFO) {
            this.log(Type.INFO, string);
        }
        if (level == Level.FINE) {
            this.log(Type.FINE, string);
        }
    }

    public void log(Level level, String string, Exception exception) {
        this.log(level, string + " | " + exception.getMessage());
        if (level == Level.WARNING) {
            exception.printStackTrace();
        }
    }

    public void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    public void log(Type type, long l, String string) {
        switch (type.ordinal()) {
            case 3: {
                this.lOG.log(Level.WARNING, l + "|" + string);
                break;
            }
            case 2: {
                this.lOG.severe(l + "|" + string);
                break;
            }
            case 1: {
                this.lOG.info(l + "|" + string);
                break;
            }
            case 0: {
                this.lOG.fine(l + "|" + string);
                break;
            }
        }
    }

    public static Level getOutputType2JavaLevel(Type type) {
        switch (type.ordinal()) {
            case 3: {
                return Level.WARNING;
            }
            case 2: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.INFO;
            }
            case 0: {
                return Level.FINE;
            }
            case 4: {
                return Level.OFF;
            }
        }
        return Level.OFF;
    }

    public Logger getLogLogger() {
        return this.lOG;
    }

    public static enum Type {
        FINE,
        INFO,
        ERROR,
        DEBUG,
        OFF;

    }
}

