/*
 * Decompiled with CFR 0.152.
 */
package com.nwu2.httpd.responses;

import com.nwu2.httpd.Codes;
import com.nwu2.httpd.IHTTPd;
import com.nwu2.httpd.Request;
import com.nwu2.httpd.responses.Response;
import com.nwu2.httpd.responses.SimpleResponse;
import com.nwu2.log.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.StringTokenizer;

public class FileResponse
extends Response {
    protected String fileLocation = ".";
    protected String HTML_STYLE = "<style type=\"text/css\"> body {background-color: #ffffff; color: #000000;}body, td, th, h1, h2 {font-family: sans-serif;}pre {margin: 0px; font-family: monospace;}a:link {color: #000099; text-decoration: none; background-color: #ffffff;}a:hover {text-decoration: underline;}table {border-collapse: collapse;}.center {text-align: center;}.center table { margin-left: auto; margin-right: auto; text-align: left;}.center th { text-align: center !important; }td, th { border: 1px solid #000000; font-size: 75%; vertical-align: baseline;}h1 {font-size: 150%;}h2 {font-size: 125%;}.p {text-align: left;}.e {background-color: #ccccff; font-weight: bold; color: #000000;}.h {background-color: #9999cc; font-weight: bold; color: #000000;}.v {background-color: #cccccc; color: #000000;}i {color: #666666; background-color: #cccccc;}img {float: right; border: 0px;}hr {width: 600px; background-color: #cccccc; border: 0px; height: 1px; color: #000000;}</style>";

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String string) {
        this.fileLocation = string;
    }

    public FileResponse(IHTTPd iHTTPd, String string, Map<String, String> map) {
        super(iHTTPd, string, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response serveFile(String object, Map<String, String> map, File file, boolean bl) {
        SimpleResponse simpleResponse;
        block31: {
            object = ((String)object).replaceFirst(this.rURI, "");
            if (!file.isDirectory()) {
                return new SimpleResponse(this.httpd, Codes.HTTP_INTERNALERROR, "text/plain", "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
            }
            if (((String)(object = ((String)object).trim().replace(File.separatorChar, '/'))).indexOf(63) >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf(63));
            }
            if (((String)object).startsWith("..") || ((String)object).endsWith("..") || ((String)object).indexOf("../") >= 0) {
                return new SimpleResponse(this.httpd, Codes.HTTP_FORBIDDEN, "text/plain", "FORBIDDEN: Won't serve ../ for security reasons.");
            }
            File file2 = new File(file, (String)object);
            if (!file2.exists()) {
                return new SimpleResponse(this.httpd, Codes.HTTP_NOTFOUND, "text/plain", "Error 404, file not found.");
            }
            if (file2.isDirectory()) {
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                this.rURI = this.rURI.replaceAll("/+", "/");
                object = ((String)object).replaceAll("/+", "/");
                if (new File(file2, "index.html").exists()) {
                    file2 = new File(file, (String)object + "/index.html");
                } else if (new File(file2, "index.htm").exists()) {
                    file2 = new File(file, (String)object + "/index.htm");
                } else {
                    if (bl) {
                        String string;
                        int n;
                        String[] stringArray = file2.list();
                        String string2 = "<html>" + this.HTML_STYLE + "<body><h1>Directory " + (String)object + "</h1><br/>";
                        if (((String)object).length() > 1 && (n = (string = ((String)object).substring(0, ((String)object).length() - 1)).lastIndexOf(47)) >= 0 && n < string.length()) {
                            string2 = string2 + "<b><a href=\"" + this.encodeUri(((String)object).substring(0, n + 1)) + "\">..</a></b><br/>";
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            File file3 = new File(file2, stringArray[i]);
                            boolean bl2 = file3.isDirectory();
                            if (bl2) {
                                string2 = string2 + "<b>";
                                int n2 = i;
                                stringArray[n2] = stringArray[n2] + "/";
                            }
                            string2 = string2 + "<a href=\"" + this.encodeUri((String)object + stringArray[i]) + "\">" + stringArray[i] + "</a>";
                            if (file3.isFile()) {
                                long l = file3.length();
                                string2 = string2 + " &nbsp;<font size=2>(";
                                string2 = l < 1024L ? string2 + file3.length() + " bytes" : (l < 0x100000L ? string2 + file3.length() / 1024L + "." + file3.length() % 1024L / 10L % 100L + " KB" : string2 + file3.length() / 0x100000L + "." + file3.length() % 0x100000L / 10L % 100L + " MB");
                                string2 = string2 + ")</font>";
                            }
                            string2 = string2 + "<br/>";
                            if (!bl2) continue;
                            string2 = string2 + "</b>";
                        }
                        return new SimpleResponse(this.httpd, Codes.HTTP_OK, "text/html", string2);
                    }
                    return new SimpleResponse(this.httpd, Codes.HTTP_FORBIDDEN, "text/plain", "FORBIDDEN: No directory listing.");
                }
            }
            String string = null;
            int n = file2.getCanonicalPath().lastIndexOf(46);
            if (n >= 0) {
                string = (String)Codes.theMimeTypes.get(file2.getCanonicalPath().substring(n + 1).toLowerCase());
            }
            if (string == null) {
                string = "application/octet-stream";
            }
            long l = 0L;
            String string3 = map.get("range");
            if (string3 != null && string3.startsWith("bytes=")) {
                int n3 = (string3 = string3.substring("bytes=".length())).indexOf(45);
                if (n3 > 0) {
                    string3 = string3.substring(0, n3);
                }
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                fileInputStream.skip(l);
                SimpleResponse simpleResponse2 = new SimpleResponse(this.httpd, Codes.HTTP_OK, string, fileInputStream);
                simpleResponse2.addHeader("Content-length", "" + (file2.length() - l));
                simpleResponse2.addHeader("Content-range", l + "-" + (file2.length() - 1L) + "/" + file2.length());
                simpleResponse = simpleResponse2;
                if (fileInputStream == null) break block31;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new SimpleResponse(this.httpd, Codes.HTTP_FORBIDDEN, "text/plain", "FORBIDDEN: Reading file failed.");
                }
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return simpleResponse;
    }

    private String encodeUri(String string) {
        Object object = this.rURI;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("/")) {
                object = (String)object + "/";
                continue;
            }
            if (string2.equals(" ")) {
                object = (String)object + "%20";
                continue;
            }
            try {
                object = (String)object + URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = (String)object + string2;
            }
        }
        return object;
    }

    @Override
    public void execute(Request request) {
        String string = request.getUri();
        this.log.log(Log.Type.DEBUG, "URI = " + string);
        this.log.log(Log.Type.DEBUG, "Method = " + String.valueOf((Object)request.getMethod()));
        if (this.props.containsKey("publichtml")) {
            this.fileLocation = (String)this.props.get("publichtml");
        }
        this.log.log(Log.Type.DEBUG, "publichtml = " + this.fileLocation);
        Response response = this.serveFile(string, request.getHeader(), new File(this.fileLocation), true);
        this.status = response.status;
        this.mimeType = response.mimeType;
        this.header = response.header;
        this.data = response.data;
    }
}

