/*
 * Decompiled with CFR 0.152.
 */
package com.nwu2.httpd;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;

public abstract class NanoHTTPD {
    public static volatile int BUFSIZE = 8192;
    private static final String CONTENT_DISPOSITION_REGEX = "([ |\t]*Content-Disposition[ |\t]*:)(.*)";
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("([ |\t]*Content-Disposition[ |\t]*:)(.*)", 2);
    private static final String CONTENT_TYPE_REGEX = "([ |\t]*content-type[ |\t]*:)(.*)";
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("([ |\t]*content-type[ |\t]*:)(.*)", 2);
    private static final String CONTENT_DISPOSITION_ATTRIBUTE_REGEX = "[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]";
    private static final Pattern CONTENT_DISPOSITION_ATTRIBUTE_PATTERN = Pattern.compile("[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]");
    public static final int SOCKET_READ_TIMEOUT = 5000;
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    protected static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";
    protected static Logger LOG = Logger.getLogger(NanoHTTPD.class.getName());
    protected static Map<String, String> MIME_TYPES;
    public static int numThreads;
    private final String hostname;
    private final int myPort;
    private volatile ServerSocket myServerSocket;
    private ServerSocketFactory serverSocketFactory = new DefaultServerSocketFactory();
    private Thread myThread;
    protected AsyncRunner asyncRunner;
    private TempFileManagerFactory tempFileManagerFactory;

    public static int getBufSize() {
        return BUFSIZE;
    }

    public static void setBufSize(int n) {
        BUFSIZE = n;
    }

    public static Map<String, String> mimeTypes() {
        if (MIME_TYPES == null) {
            MIME_TYPES = new HashMap<String, String>();
            NanoHTTPD.loadMimeTypes(MIME_TYPES, "META-INF/nanohttpd/default-mimetypes.properties");
            NanoHTTPD.loadMimeTypes(MIME_TYPES, "META-INF/nanohttpd/mimetypes.properties");
            if (MIME_TYPES.isEmpty()) {
                LOG.log(Level.WARNING, "no mime types found in the classpath! please provide mimetypes.properties");
            }
        }
        return MIME_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMimeTypes(Map<String, String> map, String string) {
        try {
            Enumeration<URL> enumeration = NanoHTTPD.class.getClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                Properties properties = new Properties();
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "could not load mimetypes from " + String.valueOf(uRL), iOException);
                }
                finally {
                    NanoHTTPD.safeClose(inputStream);
                }
                map.putAll(properties);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "no mime types available at " + string);
        }
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore keyStore, KeyManager[] keyManagerArray) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, trustManagerFactory.getTrustManagers(), null);
            sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return sSLServerSocketFactory;
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore keyStore, KeyManagerFactory keyManagerFactory) throws IOException {
        try {
            return NanoHTTPD.makeSSLSocketFactory(keyStore, keyManagerFactory.getKeyManagers());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLServerSocketFactory makeSSLSocketFactory(String string, char[] cArray) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream inputStream = ClassLoader.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Unable to load keystore from classpath: " + string);
            }
            try {
                keyStore.load(inputStream, cArray);
            }
            finally {
                NanoHTTPD.safeClose(inputStream);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            return NanoHTTPD.makeSSLSocketFactory(keyStore, keyManagerFactory);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static SSLServerSocketFactory makeLocalSSLSocketFactory(String string, char[] cArray) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory;
        block9: {
            FileInputStream fileInputStream = FileUtils.openInputStream((File)new File(string));
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                if (fileInputStream == null) {
                    throw new IOException("Unable to load keystore from filesystem: " + string);
                }
                keyStore.load(fileInputStream, cArray);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, cArray);
                sSLServerSocketFactory = NanoHTTPD.makeSSLSocketFactory(keyStore, keyManagerFactory);
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            ((InputStream)fileInputStream).close();
        }
        return sSLServerSocketFactory;
    }

    public static String getMimeTypeForFile(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        if (n >= 0) {
            string2 = NanoHTTPD.mimeTypes().get(string.substring(n + 1).toLowerCase());
        }
        return string2 == null ? "application/octet-stream" : string2;
    }

    private static final void safeClose(Object object) {
        block5: {
            try {
                if (object == null) break block5;
                if (object instanceof Closeable) {
                    ((Closeable)object).close();
                    break block5;
                }
                if (object instanceof Socket) {
                    ((Socket)object).close();
                    break block5;
                }
                if (object instanceof ServerSocket) {
                    ((ServerSocket)object).close();
                    break block5;
                }
                throw new IllegalArgumentException("Unknown object to close");
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, "Could not close", iOException);
            }
        }
    }

    public NanoHTTPD(int n) {
        this(null, n);
    }

    public NanoHTTPD(String string, int n) {
        this.hostname = string;
        this.myPort = n;
        this.setTempFileManagerFactory(new DefaultTempFileManagerFactory(this));
        this.setAsyncRunner(new DefaultAsyncRunner());
    }

    public synchronized void closeAllConnections() {
        this.stop();
    }

    protected ClientHandler createClientHandler(Socket socket, InputStream inputStream) {
        return new ClientHandler(inputStream, socket);
    }

    protected ServerRunnable createServerRunnable(int n) {
        return new ServerRunnable(n);
    }

    protected static Map<String, List<String>> decodeParameters(Map<String, String> map) {
        return NanoHTTPD.decodeParameters(map.get(QUERY_STRING_PARAMETER));
    }

    protected static Map<String, List<String>> decodeParameters(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3;
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(61);
                String string5 = string3 = n >= 0 ? NanoHTTPD.decodePercent(string4.substring(0, n)).trim() : NanoHTTPD.decodePercent(string4).trim();
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new ArrayList());
                }
                if ((string2 = n >= 0 ? NanoHTTPD.decodePercent(string4.substring(n + 1)) : null) == null) continue;
                ((List)hashMap.get(string3)).add(string2);
            }
        }
        return hashMap;
    }

    protected static String decodePercent(String string) {
        String string2 = null;
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, "Encoding not supported, ignored", unsupportedEncodingException);
        }
        return string2;
    }

    protected boolean useGzipWhenAccepted(Response response) {
        return response.getMimeType() != null && (response.getMimeType().toLowerCase().contains("text/") || response.getMimeType().toLowerCase().contains("/json"));
    }

    public final int getListeningPort() {
        return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean isAlive() {
        return this.wasStarted() && !this.myServerSocket.isClosed() && this.myThread.isAlive();
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public String getHostname() {
        return this.hostname;
    }

    public TempFileManagerFactory getTempFileManagerFactory() {
        return this.tempFileManagerFactory;
    }

    public void makeSecure(SSLServerSocketFactory sSLServerSocketFactory, String[] stringArray) {
        this.serverSocketFactory = new SecureServerSocketFactory(sSLServerSocketFactory, stringArray);
    }

    public static Response newChunkedResponse(Response.IStatus iStatus, String string, InputStream inputStream) {
        return new Response(iStatus, string, inputStream, -1L);
    }

    public static Response newFixedLengthResponse(Response.IStatus iStatus, String string, InputStream inputStream, long l) {
        return new Response(iStatus, string, inputStream, l);
    }

    public static Response newFixedLengthResponse(Response.IStatus iStatus, String string, String string2) {
        byte[] byArray;
        ContentType contentType = new ContentType(string);
        if (string2 == null) {
            return NanoHTTPD.newFixedLengthResponse(iStatus, string, new ByteArrayInputStream(new byte[0]), 0L);
        }
        try {
            CharsetEncoder charsetEncoder = Charset.forName(contentType.getEncoding()).newEncoder();
            if (!charsetEncoder.canEncode(string2)) {
                contentType = contentType.tryUTF8();
            }
            byArray = string2.getBytes(contentType.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.SEVERE, "encoding problem, responding nothing", unsupportedEncodingException);
            byArray = new byte[]{};
        }
        return NanoHTTPD.newFixedLengthResponse(iStatus, contentType.getContentTypeHeader(), new ByteArrayInputStream(byArray), byArray.length);
    }

    public static Response newFixedLengthResponse(String string) {
        return NanoHTTPD.newFixedLengthResponse(Response.Status.OK, MIME_HTML, string);
    }

    public Response serve(IHTTPSession iHTTPSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Method method = iHTTPSession.getMethod();
        if (Method.PUT.equals((Object)method) || Method.POST.equals((Object)method)) {
            try {
                iHTTPSession.parseBody(hashMap);
            }
            catch (IOException iOException) {
                return NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + iOException.getMessage());
            }
            catch (ResponseException responseException) {
                return NanoHTTPD.newFixedLengthResponse(responseException.getStatus(), MIME_PLAINTEXT, responseException.getMessage());
            }
        }
        Map<String, String> map = iHTTPSession.getParms();
        map.put(QUERY_STRING_PARAMETER, iHTTPSession.getQueryParameterString());
        return this.serve(iHTTPSession.getUri(), method, iHTTPSession.getHeaders(), map, hashMap, iHTTPSession.getOriginalURI());
    }

    @Deprecated
    public Response serve(String string, Method method, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, String string2) {
        return NanoHTTPD.newFixedLengthResponse(Response.Status.NOT_FOUND, MIME_PLAINTEXT, "Not Found");
    }

    public void setAsyncRunner(AsyncRunner asyncRunner) {
        this.asyncRunner = asyncRunner;
    }

    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
        this.tempFileManagerFactory = tempFileManagerFactory;
    }

    public void start() throws IOException {
        this.start(5000);
    }

    public void start(int n) throws IOException {
        this.start(n, true);
    }

    public void start(int n, boolean bl) throws IOException {
        this.myServerSocket = this.getServerSocketFactory().create();
        this.myServerSocket.setReuseAddress(true);
        ServerRunnable serverRunnable = this.createServerRunnable(n);
        this.myThread = new Thread(serverRunnable);
        this.myThread.setDaemon(bl);
        this.myThread.setName("NanoHttpd Main Listener");
        this.myThread.start();
        while (!serverRunnable.hasBinded && serverRunnable.bindException == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
        if (serverRunnable.bindException != null) {
            throw serverRunnable.bindException;
        }
    }

    public void stop() {
        try {
            NanoHTTPD.safeClose(this.myServerSocket);
            this.asyncRunner.closeAll();
            if (this.myThread != null) {
                this.myThread.join();
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Could not stop all connections", exception);
        }
    }

    public final boolean wasStarted() {
        return this.myServerSocket != null && this.myThread != null;
    }

    static {
        numThreads = Math.max(Runtime.getRuntime().availableProcessors() * 2, 15);
    }

    public static class DefaultServerSocketFactory
    implements ServerSocketFactory {
        @Override
        public ServerSocket create() throws IOException {
            return new ServerSocket();
        }
    }

    public static interface ServerSocketFactory {
        public ServerSocket create() throws IOException;
    }

    private class DefaultTempFileManagerFactory
    implements TempFileManagerFactory {
        private DefaultTempFileManagerFactory(NanoHTTPD nanoHTTPD) {
        }

        @Override
        public TempFileManager create() {
            return new DefaultTempFileManager();
        }
    }

    public static interface TempFileManagerFactory {
        public TempFileManager create();
    }

    public static class DefaultAsyncRunner
    implements AsyncRunner {
        private long requestCount;
        private final List<ClientHandler> running = Collections.synchronizedList(new ArrayList());
        private final ExecutorService threadPool = Executors.newVirtualThreadPerTaskExecutor();

        public List<ClientHandler> getRunning() {
            return this.running;
        }

        @Override
        public void closeAll() {
            this.threadPool.shutdownNow();
            for (ClientHandler clientHandler : new ArrayList<ClientHandler>(this.running)) {
                clientHandler.close();
            }
        }

        @Override
        public void closed(ClientHandler clientHandler) {
            this.running.remove(clientHandler);
        }

        @Override
        public void exec(ClientHandler clientHandler) {
            ++this.requestCount;
            this.running.add(clientHandler);
            this.threadPool.execute(clientHandler);
        }
    }

    public static interface AsyncRunner {
        public void closeAll();

        public void closed(ClientHandler var1);

        public void exec(ClientHandler var1);
    }

    public class ClientHandler
    implements Runnable {
        private final InputStream inputStream;
        private final Socket acceptSocket;

        public ClientHandler(InputStream inputStream, Socket socket) {
            this.inputStream = inputStream;
            this.acceptSocket = socket;
        }

        public void close() {
            NanoHTTPD.safeClose(this.inputStream);
            NanoHTTPD.safeClose(this.acceptSocket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream outputStream = null;
            try {
                outputStream = this.acceptSocket.getOutputStream();
                TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
                HTTPSession hTTPSession = new HTTPSession(tempFileManager, this.inputStream, outputStream, this.acceptSocket.getInetAddress());
                while (!this.acceptSocket.isClosed()) {
                    hTTPSession.execute();
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof SocketException && "NanoHttpd Shutdown".equals(exception.getMessage()) || exception instanceof SocketTimeoutException || LOG == null)) {
                    LOG.log(Level.SEVERE, "Communication with the client broken, or an bug in the handler code", exception);
                }
            }
            finally {
                NanoHTTPD.safeClose(outputStream);
                NanoHTTPD.safeClose(this.inputStream);
                NanoHTTPD.safeClose(this.acceptSocket);
                NanoHTTPD.this.asyncRunner.closed(this);
            }
        }
    }

    public class ServerRunnable
    implements Runnable {
        private final int timeout;
        private IOException bindException;
        private boolean hasBinded = false;

        public ServerRunnable(int n) {
            this.timeout = n;
        }

        @Override
        public void run() {
            try {
                NanoHTTPD.this.myServerSocket.bind(NanoHTTPD.this.hostname != null ? new InetSocketAddress(NanoHTTPD.this.hostname, NanoHTTPD.this.myPort) : new InetSocketAddress(NanoHTTPD.this.myPort));
                this.hasBinded = true;
            }
            catch (IOException iOException) {
                this.bindException = iOException;
                return;
            }
            do {
                try {
                    Socket socket = NanoHTTPD.this.myServerSocket.accept();
                    if (this.timeout > 0) {
                        socket.setSoTimeout(this.timeout);
                    }
                    InputStream inputStream = socket.getInputStream();
                    NanoHTTPD.this.asyncRunner.exec(NanoHTTPD.this.createClientHandler(socket, inputStream));
                }
                catch (IOException iOException) {
                    if (LOG == null) continue;
                    LOG.log(Level.FINE, "Communication with the client broken", iOException);
                }
            } while (!NanoHTTPD.this.myServerSocket.isClosed());
        }
    }

    public static class Response
    implements Closeable {
        private IStatus status;
        private String mimeType;
        private InputStream data;
        private long contentLength;
        private final Map<String, String> header = new HashMap<String, String>(){

            @Override
            public String put(String string, String string2) {
                lowerCaseHeader.put(string == null ? string : string.toLowerCase(), string2);
                return super.put(string, string2);
            }
        };
        private final Map<String, String> lowerCaseHeader = new HashMap<String, String>();
        private Method requestMethod;
        private boolean chunkedTransfer;
        private boolean encodeAsGzip;
        private boolean keepAlive;

        public Response(IStatus iStatus, String string, InputStream inputStream, long l) {
            this.status = iStatus;
            this.mimeType = string;
            if (inputStream == null) {
                this.data = new ByteArrayInputStream(new byte[0]);
                this.contentLength = 0L;
            } else {
                this.data = inputStream;
                this.contentLength = l;
            }
            this.chunkedTransfer = this.contentLength < 0L;
            this.keepAlive = true;
        }

        @Override
        public void close() throws IOException {
            if (this.data != null) {
                this.data.close();
            }
        }

        public void addHeader(String string, String string2) {
            this.header.put(string, string2);
        }

        public void closeConnection(boolean bl) {
            if (bl) {
                this.header.put("connection", "close");
            } else {
                this.header.remove("connection");
            }
        }

        public boolean isCloseConnection() {
            return "close".equals(this.getHeader("connection"));
        }

        public InputStream getData() {
            return this.data;
        }

        public String getHeader(String string) {
            return this.lowerCaseHeader.get(string.toLowerCase());
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Method getRequestMethod() {
            return this.requestMethod;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setGzipEncoding(boolean bl) {
            this.encodeAsGzip = bl;
        }

        public void setKeepAlive(boolean bl) {
            this.keepAlive = bl;
        }

        protected void send(OutputStream outputStream) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                long l;
                if (this.status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, new ContentType(this.mimeType).getEncoding())), false);
                printWriter.append("HTTP/1.1 ").append(this.status.getDescription()).append(" \r\n");
                if (this.mimeType != null) {
                    this.printHeader(printWriter, "Content-Type", this.mimeType);
                }
                if (this.getHeader("date") == null) {
                    this.printHeader(printWriter, "Date", simpleDateFormat.format(new Date()));
                }
                for (Map.Entry<String, String> entry : this.header.entrySet()) {
                    this.printHeader(printWriter, entry.getKey(), entry.getValue());
                }
                if (this.getHeader("connection") == null) {
                    this.printHeader(printWriter, "Connection", this.keepAlive ? "keep-alive" : "close");
                }
                if (this.getHeader("content-length") != null) {
                    this.encodeAsGzip = false;
                }
                if (this.encodeAsGzip) {
                    this.printHeader(printWriter, "Content-Encoding", "gzip");
                    this.setChunkedTransfer(true);
                }
                long l2 = l = this.data != null ? this.contentLength : 0L;
                if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                    this.printHeader(printWriter, "Transfer-Encoding", "chunked");
                } else if (!this.encodeAsGzip) {
                    l = this.sendContentLengthHeaderIfNotAlreadyPresent(printWriter, l);
                }
                printWriter.append("\r\n");
                printWriter.flush();
                this.sendBodyWithCorrectTransferAndEncoding(outputStream, l);
                outputStream.flush();
                NanoHTTPD.safeClose(this.data);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, "Could not send response to the client", iOException);
            }
        }

        protected void printHeader(PrintWriter printWriter, String string, String string2) {
            printWriter.append(string).append(": ").append(string2).append("\r\n");
        }

        protected long sendContentLengthHeaderIfNotAlreadyPresent(PrintWriter printWriter, long l) {
            String string = this.getHeader("content-length");
            long l2 = l;
            if (string != null) {
                try {
                    l2 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.severe("content-length was no number " + string);
                }
            }
            printWriter.print("Content-Length: " + l2 + "\r\n");
            return l2;
        }

        private void sendBodyWithCorrectTransferAndEncoding(OutputStream outputStream, long l) throws IOException {
            if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream);
                this.sendBodyWithCorrectEncoding(chunkedOutputStream, -1L);
                chunkedOutputStream.finish();
            } else {
                this.sendBodyWithCorrectEncoding(outputStream, l);
            }
        }

        private void sendBodyWithCorrectEncoding(OutputStream outputStream, long l) throws IOException {
            if (this.encodeAsGzip) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                this.sendBody(gZIPOutputStream, -1L);
                gZIPOutputStream.finish();
            } else {
                this.sendBody(outputStream, l);
            }
        }

        private void sendBody(OutputStream outputStream, long l) throws IOException {
            long l2;
            int n;
            boolean bl;
            long l3 = 16384L;
            byte[] byArray = new byte[(int)l3];
            boolean bl2 = bl = l == -1L;
            while ((l > 0L || bl) && (n = this.data.read(byArray, 0, (int)(l2 = bl ? l3 : Math.min(l, l3)))) > 0) {
                outputStream.write(byArray, 0, n);
                if (bl) continue;
                l -= (long)n;
            }
        }

        public void setChunkedTransfer(boolean bl) {
            this.chunkedTransfer = bl;
        }

        public void setData(InputStream inputStream) {
            this.data = inputStream;
        }

        public void setMimeType(String string) {
            this.mimeType = string;
        }

        public void setRequestMethod(Method method) {
            this.requestMethod = method;
        }

        public void setStatus(IStatus iStatus) {
            this.status = iStatus;
        }

        public static interface IStatus {
            public String getDescription();

            public int getRequestStatus();
        }

        private static class ChunkedOutputStream
        extends FilterOutputStream {
            public ChunkedOutputStream(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) throws IOException {
                byte[] byArray = new byte[]{(byte)n};
                this.write(byArray, 0, 1);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (n2 == 0) {
                    return;
                }
                this.out.write(String.format("%x\r\n", n2).getBytes());
                this.out.write(byArray, n, n2);
                this.out.write("\r\n".getBytes());
            }

            public void finish() throws IOException {
                this.out.write("0\r\n\r\n".getBytes());
            }
        }

        public static enum Status implements IStatus
        {
            SWITCH_PROTOCOL(101, "Switching Protocols"),
            OK(200, "OK"),
            CREATED(201, "Created"),
            ACCEPTED(202, "Accepted"),
            NO_CONTENT(204, "No Content"),
            PARTIAL_CONTENT(206, "Partial Content"),
            MULTI_STATUS(207, "Multi-Status"),
            REDIRECT(301, "Moved Permanently"),
            FOUND(302, "Found"),
            REDIRECT_SEE_OTHER(303, "See Other"),
            NOT_MODIFIED(304, "Not Modified"),
            TEMPORARY_REDIRECT(307, "Temporary Redirect"),
            BAD_REQUEST(400, "Bad Request"),
            UNAUTHORIZED(401, "Unauthorized"),
            FORBIDDEN(403, "Forbidden"),
            NOT_FOUND(404, "Not Found"),
            METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
            NOT_ACCEPTABLE(406, "Not Acceptable"),
            REQUEST_TIMEOUT(408, "Request Timeout"),
            CONFLICT(409, "Conflict"),
            GONE(410, "Gone"),
            LENGTH_REQUIRED(411, "Length Required"),
            PRECONDITION_FAILED(412, "Precondition Failed"),
            PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
            UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
            RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
            EXPECTATION_FAILED(417, "Expectation Failed"),
            TOO_MANY_REQUESTS(429, "Too Many Requests"),
            INTERNAL_ERROR(500, "Internal Server Error"),
            NOT_IMPLEMENTED(501, "Not Implemented"),
            SERVICE_UNAVAILABLE(503, "Service Unavailable"),
            UNSUPPORTED_HTTP_VERSION(505, "HTTP Version Not Supported");

            private final int requestStatus;
            private final String description;

            private Status(int n2, String string2) {
                this.requestStatus = n2;
                this.description = string2;
            }

            public static Status lookup(int n) {
                for (Status status : Status.values()) {
                    if (status.getRequestStatus() != n) continue;
                    return status;
                }
                return null;
            }

            @Override
            public String getDescription() {
                return this.requestStatus + " " + this.description;
            }

            @Override
            public int getRequestStatus() {
                return this.requestStatus;
            }
        }
    }

    public static class SecureServerSocketFactory
    implements ServerSocketFactory {
        private SSLServerSocketFactory sslServerSocketFactory;
        private String[] sslProtocols;

        public SecureServerSocketFactory(SSLServerSocketFactory sSLServerSocketFactory, String[] stringArray) {
            this.sslServerSocketFactory = sSLServerSocketFactory;
            this.sslProtocols = stringArray;
        }

        @Override
        public ServerSocket create() throws IOException {
            SSLServerSocket sSLServerSocket = null;
            sSLServerSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
            if (this.sslProtocols != null) {
                sSLServerSocket.setEnabledProtocols(this.sslProtocols);
            } else {
                sSLServerSocket.setEnabledProtocols(sSLServerSocket.getSupportedProtocols());
            }
            sSLServerSocket.setUseClientMode(false);
            sSLServerSocket.setWantClientAuth(false);
            sSLServerSocket.setNeedClientAuth(false);
            return sSLServerSocket;
        }
    }

    protected static class ContentType {
        private static final String ASCII_ENCODING = "US-ASCII";
        private static final String MULTIPART_FORM_DATA_HEADER = "multipart/form-data";
        private static final String CONTENT_REGEX = "[ |\t]*([^/^ ^;^,]+/[^ ^;^,]+)";
        private static final Pattern MIME_PATTERN = Pattern.compile("[ |\t]*([^/^ ^;^,]+/[^ ^;^,]+)", 2);
        private static final String CHARSET_REGEX = "[ |\t]*(charset)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?";
        private static final Pattern CHARSET_PATTERN = Pattern.compile("[ |\t]*(charset)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?", 2);
        private static final String BOUNDARY_REGEX = "[ |\t]*(boundary)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?";
        private static final Pattern BOUNDARY_PATTERN = Pattern.compile("[ |\t]*(boundary)[ |\t]*=[ |\t]*['|\"]?([^\"^'^;^,]*)['|\"]?", 2);
        private final String contentTypeHeader;
        private final String contentType;
        private final String encoding;
        private final String boundary;

        public ContentType(String string) {
            this.contentTypeHeader = string;
            if (string != null) {
                this.contentType = this.getDetailFromContentHeader(string, MIME_PATTERN, "", 1);
                this.encoding = this.getDetailFromContentHeader(string, CHARSET_PATTERN, null, 2);
            } else {
                this.contentType = "";
                this.encoding = "UTF-8";
            }
            this.boundary = MULTIPART_FORM_DATA_HEADER.equalsIgnoreCase(this.contentType) ? this.getDetailFromContentHeader(string, BOUNDARY_PATTERN, null, 2) : null;
        }

        private String getDetailFromContentHeader(String string, Pattern pattern, String string2, int n) {
            Matcher matcher = pattern.matcher(string);
            return matcher.find() ? matcher.group(n) : string2;
        }

        public String getContentTypeHeader() {
            return this.contentTypeHeader;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getEncoding() {
            return this.encoding == null ? ASCII_ENCODING : this.encoding;
        }

        public String getBoundary() {
            return this.boundary;
        }

        public boolean isMultipart() {
            return MULTIPART_FORM_DATA_HEADER.equalsIgnoreCase(this.contentType);
        }

        public ContentType tryUTF8() {
            if (this.encoding == null) {
                return new ContentType(this.contentTypeHeader + "; charset=UTF-8");
            }
            return this;
        }
    }

    public static interface IHTTPSession {
        public void execute() throws IOException;

        public CookieHandler getCookies();

        public Map<String, String> getHeaders();

        public InputStream getInputStream();

        public Method getMethod();

        @Deprecated
        public Map<String, String> getParms();

        public Map<String, List<String>> getParameters();

        public String getQueryParameterString();

        public String getUri();

        public void parseBody(Map<String, String> var1) throws IOException, ResponseException;

        public String getRemoteIpAddress();

        public String getRemoteHostName();

        public String getOriginalURI();
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        CONNECT,
        PATCH,
        PROPFIND,
        PROPPATCH,
        MKCOL,
        MOVE,
        COPY,
        LOCK,
        UNLOCK;


        static Method lookup(String string) {
            if (string == null) {
                return null;
            }
            try {
                return Method.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static final class ResponseException
    extends Exception {
        private static final long serialVersionUID = 6569838532917408380L;
        private final Response.Status status;

        public ResponseException(Response.Status status, String string) {
            super(string);
            this.status = status;
        }

        public ResponseException(Response.Status status, String string, Exception exception) {
            super(string, exception);
            this.status = status;
        }

        public Response.Status getStatus() {
            return this.status;
        }
    }

    public static interface TempFileManager {
        public void clear();

        public TempFile createTempFile(String var1) throws Exception;
    }

    public static interface TempFile {
        public void delete() throws Exception;

        public String getName();

        public OutputStream open() throws Exception;
    }

    protected class HTTPSession
    implements IHTTPSession {
        private static final int REQUEST_BUFFER_LEN = 512;
        private static final int MEMORY_STORE_LIMIT = 1024;
        public static final int MAX_HEADER_SIZE = 1024;
        private final TempFileManager tempFileManager;
        private final OutputStream outputStream;
        private final BufferedInputStream inputStream;
        private int splitbyte;
        private int rlen;
        private String uri;
        private String originalURI;
        private Method method;
        private Map<String, List<String>> parms;
        private Map<String, String> headers;
        private CookieHandler cookies;
        private String queryParameterString;
        private String remoteIp;
        private String remoteHostname;
        private String protocolVersion;

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new BufferedInputStream(inputStream, NanoHTTPD.getBufSize());
            this.outputStream = outputStream;
        }

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new BufferedInputStream(inputStream, NanoHTTPD.getBufSize());
            this.outputStream = outputStream;
            this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
            this.remoteHostname = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "localhost" : inetAddress.getHostName().toString();
            this.headers = new HashMap<String, String>();
        }

        private void decodeHeader(BufferedReader bufferedReader, Map<String, String> map, Map<String, List<String>> map2, Map<String, String> map3) throws ResponseException {
            try {
                String string = bufferedReader.readLine();
                if (string == null) {
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                map.put("method", stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String string2 = stringTokenizer.nextToken();
                map.put("originalURI", string2);
                int n = string2.indexOf(63);
                if (n >= 0) {
                    this.decodeParms(string2.substring(n + 1), map2);
                    string2 = NanoHTTPD.decodePercent(string2.substring(0, n));
                } else {
                    string2 = NanoHTTPD.decodePercent(string2);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.protocolVersion = stringTokenizer.nextToken();
                } else {
                    this.protocolVersion = "HTTP/1.1";
                    LOG.log(Level.FINE, "no protocol version specified, strange. Assuming HTTP/1.1.");
                }
                String string3 = bufferedReader.readLine();
                while (string3 != null && !string3.trim().isEmpty()) {
                    int n2 = string3.indexOf(58);
                    if (n2 >= 0) {
                        map3.put(string3.substring(0, n2).trim().toLowerCase(Locale.US), string3.substring(n2 + 1).trim());
                    }
                    string3 = bufferedReader.readLine();
                }
                map.put("uri", string2);
            }
            catch (IOException iOException) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + iOException.getMessage(), iOException);
            }
        }

        private void decodeMultipartFormData(ContentType contentType, ByteBuffer byteBuffer, Map<String, List<String>> map, Map<String, String> map2) throws ResponseException {
            int n = 0;
            try {
                int[] nArray = this.getBoundaryPositions(byteBuffer, contentType.getBoundary().getBytes());
                if (nArray.length < 2) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but contains less than two boundary strings.");
                }
                byte[] byArray = new byte[1024];
                for (int i = 0; i < nArray.length - 1; ++i) {
                    Object object;
                    byteBuffer.position(nArray[i]);
                    int n2 = byteBuffer.remaining() < 1024 ? byteBuffer.remaining() : 1024;
                    byteBuffer.get(byArray, 0, n2);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), Charset.forName(contentType.getEncoding())), n2);
                    int n3 = 0;
                    String string = bufferedReader.readLine();
                    ++n3;
                    if (string == null || !string.contains(contentType.getBoundary())) {
                        throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but chunk does not start with boundary.");
                    }
                    Object object2 = null;
                    String string2 = null;
                    String string3 = null;
                    string = bufferedReader.readLine();
                    ++n3;
                    while (string != null && string.trim().length() > 0) {
                        Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(string);
                        if (matcher.matches()) {
                            String string4 = matcher.group(2);
                            matcher = CONTENT_DISPOSITION_ATTRIBUTE_PATTERN.matcher(string4);
                            while (matcher.find()) {
                                String string5 = matcher.group(1);
                                if ("name".equalsIgnoreCase(string5)) {
                                    object2 = matcher.group(2);
                                    continue;
                                }
                                if (!"filename".equalsIgnoreCase(string5) || (string2 = matcher.group(2)).isEmpty()) continue;
                                if (n > 0) {
                                    object2 = (String)object2 + String.valueOf(n++);
                                    continue;
                                }
                                ++n;
                            }
                        }
                        if ((matcher = CONTENT_TYPE_PATTERN.matcher(string)).matches()) {
                            string3 = matcher.group(2).trim();
                        }
                        string = bufferedReader.readLine();
                        ++n3;
                    }
                    int n4 = 0;
                    while (n3-- > 0) {
                        n4 = this.scipOverNewLine(byArray, n4);
                    }
                    if (n4 >= n2 - 4) {
                        throw new ResponseException(Response.Status.INTERNAL_ERROR, "Multipart header size exceeds MAX_HEADER_SIZE.");
                    }
                    int n5 = nArray[i] + n4;
                    int n6 = nArray[i + 1] - 4;
                    byteBuffer.position(n5);
                    List<String> list = map.get(object2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put((String)object2, list);
                    }
                    if (string3 == null) {
                        object = new byte[n6 - n5];
                        byteBuffer.get((byte[])object);
                        list.add(new String((byte[])object, contentType.getEncoding()));
                        continue;
                    }
                    object = this.saveTmpFile(byteBuffer, n5, n6 - n5, string2);
                    if (!map2.containsKey(object2)) {
                        map2.put((String)object2, (String)object);
                    } else {
                        int n7 = 2;
                        while (map2.containsKey((String)object2 + n7)) {
                            ++n7;
                        }
                        map2.put((String)object2 + n7, (String)object);
                    }
                    list.add(string2);
                }
            }
            catch (ResponseException responseException) {
                throw responseException;
            }
            catch (Exception exception) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, exception.toString());
            }
        }

        private int scipOverNewLine(byte[] byArray, int n) {
            while (byArray[n] != 10) {
                ++n;
            }
            return ++n;
        }

        private void decodeParms(String string, Map<String, List<String>> map) {
            if (string == null) {
                this.queryParameterString = "";
                return;
            }
            this.queryParameterString = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                String string3 = null;
                String string4 = null;
                if (n >= 0) {
                    string3 = NanoHTTPD.decodePercent(string2.substring(0, n)).trim();
                    string4 = NanoHTTPD.decodePercent(string2.substring(n + 1));
                } else {
                    string3 = NanoHTTPD.decodePercent(string2).trim();
                    string4 = "";
                }
                List<String> list = map.get(string3);
                if (list == null) {
                    list = new ArrayList<String>();
                    map.put(string3, list);
                }
                list.add(string4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void execute() throws IOException {
            Response response = null;
            try {
                byte[] byArray = new byte[NanoHTTPD.getBufSize()];
                this.splitbyte = 0;
                this.rlen = 0;
                int n = -1;
                this.inputStream.mark(NanoHTTPD.getBufSize());
                try {
                    n = this.inputStream.read(byArray, 0, NanoHTTPD.getBufSize());
                }
                catch (SSLException sSLException) {
                    throw sSLException;
                }
                catch (IOException iOException) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                if (n == -1) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                while (n > 0) {
                    this.rlen += n;
                    this.splitbyte = this.findHeaderEnd(byArray, this.rlen);
                    if (this.splitbyte > 0) break;
                    n = this.inputStream.read(byArray, this.rlen, NanoHTTPD.getBufSize() - this.rlen);
                }
                if (this.splitbyte < this.rlen) {
                    this.inputStream.reset();
                    this.inputStream.skip(this.splitbyte);
                }
                this.parms = new HashMap<String, List<String>>();
                if (null == this.headers) {
                    this.headers = new HashMap<String, String>();
                } else {
                    this.headers.clear();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray, 0, this.rlen)));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.decodeHeader(bufferedReader, hashMap, this.parms, this.headers);
                if (null != this.remoteIp) {
                    this.headers.put("remote-addr", this.remoteIp);
                    this.headers.put("http-client-ip", this.remoteIp);
                }
                this.method = Method.lookup((String)hashMap.get("method"));
                if (this.method == null) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. HTTP verb " + (String)hashMap.get("method") + " unhandled.");
                }
                this.uri = (String)hashMap.get("uri");
                this.originalURI = (String)hashMap.get("originalURI");
                this.cookies = new CookieHandler(NanoHTTPD.this, this.headers);
                String string = this.headers.get("connection");
                boolean bl = "HTTP/1.1".equals(this.protocolVersion) && (string == null || !string.matches("(?i).*close.*"));
                response = NanoHTTPD.this.serve(this);
                if (response == null) {
                    throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                }
                String string2 = this.headers.get("accept-encoding");
                this.cookies.unloadQueue(response);
                response.setRequestMethod(this.method);
                response.setGzipEncoding(NanoHTTPD.this.useGzipWhenAccepted(response) && string2 != null && string2.contains("gzip"));
                response.setKeepAlive(bl);
                response.send(this.outputStream);
                if (!bl) throw new SocketException("NanoHttpd Shutdown");
                if (response.isCloseConnection()) {
                    throw new SocketException("NanoHttpd Shutdown");
                }
                NanoHTTPD.safeClose(response);
                this.tempFileManager.clear();
                return;
            }
            catch (SocketException socketException) {
                throw socketException;
                catch (SocketTimeoutException socketTimeoutException) {
                    throw socketTimeoutException;
                }
                catch (SSLException sSLException) {
                    Response response2 = NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SSL PROTOCOL FAILURE: " + sSLException.getMessage());
                    response2.send(this.outputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    return;
                }
                catch (IOException iOException) {
                    Response response3 = NanoHTTPD.newFixedLengthResponse(Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + iOException.getMessage());
                    response3.send(this.outputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (ResponseException responseException) {
                        Response response4 = NanoHTTPD.newFixedLengthResponse(responseException.getStatus(), NanoHTTPD.MIME_PLAINTEXT, responseException.getMessage());
                        response4.send(this.outputStream);
                        NanoHTTPD.safeClose(this.outputStream);
                        return;
                    }
                }
            }
            finally {
                NanoHTTPD.safeClose(response);
                this.tempFileManager.clear();
            }
        }

        private int findHeaderEnd(byte[] byArray, int n) {
            int n2 = 0;
            while (n2 + 1 < n) {
                if (byArray[n2] == 13 && byArray[n2 + 1] == 10 && n2 + 3 < n && byArray[n2 + 2] == 13 && byArray[n2 + 3] == 10) {
                    return n2 + 4;
                }
                if (byArray[n2] == 10 && byArray[n2 + 1] == 10) {
                    return n2 + 2;
                }
                ++n2;
            }
            return 0;
        }

        private int[] getBoundaryPositions(ByteBuffer byteBuffer, byte[] byArray) {
            int[] nArray = new int[]{};
            if (byteBuffer.remaining() < byArray.length) {
                return nArray;
            }
            int n = 0;
            byte[] byArray2 = new byte[4096 + byArray.length];
            int n2 = byteBuffer.remaining() < byArray2.length ? byteBuffer.remaining() : byArray2.length;
            byteBuffer.get(byArray2, 0, n2);
            int n3 = n2 - byArray.length;
            do {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < byArray.length && byArray2[i + j] == byArray[j]; ++j) {
                        if (j != byArray.length - 1) continue;
                        int[] nArray2 = new int[nArray.length + 1];
                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        nArray2[nArray.length] = n + i;
                        nArray = nArray2;
                    }
                }
                n += n3;
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray2, 0, byArray.length);
                n3 = byArray2.length - byArray.length;
                n3 = byteBuffer.remaining() < n3 ? byteBuffer.remaining() : n3;
                byteBuffer.get(byArray2, byArray.length, n3);
            } while (n3 > 0);
            return nArray;
        }

        @Override
        public CookieHandler getCookies() {
            return this.cookies;
        }

        @Override
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public final Method getMethod() {
            return this.method;
        }

        @Override
        @Deprecated
        public final Map<String, String> getParms() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : this.parms.keySet()) {
                hashMap.put(string, this.parms.get(string).get(0));
            }
            return hashMap;
        }

        @Override
        public final Map<String, List<String>> getParameters() {
            return this.parms;
        }

        @Override
        public String getQueryParameterString() {
            return this.queryParameterString;
        }

        private RandomAccessFile getTmpBucket() {
            try {
                TempFile tempFile = this.tempFileManager.createTempFile(null);
                return new RandomAccessFile(tempFile.getName(), "rw");
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }

        @Override
        public final String getUri() {
            return this.uri;
        }

        @Override
        public final String getOriginalURI() {
            return this.originalURI;
        }

        public long getBodySize() {
            if (this.headers.containsKey("content-length")) {
                return Long.parseLong(this.headers.get("content-length"));
            }
            if (this.splitbyte < this.rlen) {
                return this.rlen - this.splitbyte;
            }
            return 0L;
        }

        @Override
        public void parseBody(Map<String, String> map) throws IOException, ResponseException {
            try (RandomAccessFile randomAccessFile = this.getBodySize() >= 1024L ? this.getTmpBucket() : null;
                 FileChannel fileChannel = randomAccessFile != null ? randomAccessFile.getChannel() : null;
                 ByteArrayOutputStream byteArrayOutputStream = this.getBodySize() < 1024L ? new ByteArrayOutputStream() : null;
                 DataOutputStream dataOutputStream = byteArrayOutputStream != null ? new DataOutputStream(byteArrayOutputStream) : null;){
                ByteBuffer byteBuffer;
                DataOutput dataOutput = byteArrayOutputStream != null ? dataOutputStream : randomAccessFile;
                byte[] byArray = new byte[512];
                for (long i = this.getBodySize(); this.rlen >= 0 && i > 0L; i -= (long)this.rlen) {
                    this.rlen = this.inputStream.read(byArray, 0, (int)Math.min(i, 512L));
                    if (this.rlen <= 0) continue;
                    dataOutput.write(byArray, 0, this.rlen);
                }
                ByteBuffer byteBuffer2 = byteBuffer = byteArrayOutputStream != null ? ByteBuffer.wrap(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size()) : fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
                if (Method.POST.equals((Object)this.method)) {
                    ContentType contentType = new ContentType(this.headers.get("content-type"));
                    if (contentType.isMultipart()) {
                        String string = contentType.getBoundary();
                        if (string == null) {
                            throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                        }
                        this.decodeMultipartFormData(contentType, byteBuffer, this.parms, map);
                    } else {
                        byte[] byArray2 = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray2);
                        String string = new String(byArray2, contentType.getEncoding()).trim();
                        if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType.getContentType())) {
                            this.decodeParms(string, this.parms);
                        } else if (string.length() != 0) {
                            map.put("postData", string);
                        }
                    }
                } else if (Method.PUT.equals((Object)this.method)) {
                    map.put("content", this.saveTmpFile(byteBuffer, 0, byteBuffer.limit(), null));
                }
            }
        }

        private String saveTmpFile(ByteBuffer byteBuffer, int n, int n2, String string) {
            String string2 = "";
            if (n2 > 0) {
                try {
                    string2 = this.tempFileManager.createTempFile(string).getName();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(string2);
                         FileChannel fileChannel = fileOutputStream.getChannel();){
                        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                        byteBuffer2.position(n).limit(n + n2);
                        fileChannel.write(byteBuffer2.slice());
                    }
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            }
            return string2;
        }

        @Override
        public String getRemoteIpAddress() {
            return this.remoteIp;
        }

        @Override
        public String getRemoteHostName() {
            return this.remoteHostname;
        }
    }

    public static class DefaultTempFileManager
    implements TempFileManager {
        private final File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        private final List<TempFile> tempFiles;

        public DefaultTempFileManager() {
            if (!this.tmpdir.exists()) {
                this.tmpdir.mkdirs();
            }
            this.tempFiles = new ArrayList<TempFile>();
        }

        @Override
        public void clear() {
            for (TempFile tempFile : this.tempFiles) {
                try {
                    tempFile.delete();
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "could not delete file ", exception);
                }
            }
            this.tempFiles.clear();
        }

        @Override
        public TempFile createTempFile(String string) throws Exception {
            DefaultTempFile defaultTempFile = new DefaultTempFile(this.tmpdir);
            this.tempFiles.add(defaultTempFile);
            return defaultTempFile;
        }
    }

    public static class DefaultTempFile
    implements TempFile {
        private final File file;
        private final OutputStream fstream;

        public DefaultTempFile(File file) throws IOException {
            this.file = File.createTempFile("NanoHTTPD-", "", file);
            this.fstream = new FileOutputStream(this.file);
        }

        @Override
        public void delete() throws Exception {
            NanoHTTPD.safeClose(this.fstream);
            if (!this.file.delete()) {
                throw new Exception("could not delete temporary file: " + this.file.getAbsolutePath());
            }
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public OutputStream open() throws Exception {
            return this.fstream;
        }
    }

    public class CookieHandler
    implements Iterable<String> {
        private final HashMap<String, String> cookies = new HashMap();
        private final ArrayList<Cookie> queue = new ArrayList();

        public CookieHandler(NanoHTTPD nanoHTTPD, Map<String, String> map) {
            String string = map.get("cookie");
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(";")) {
                    String[] stringArray2 = string2.trim().split("=");
                    if (stringArray2.length != 2) continue;
                    this.cookies.put(stringArray2[0], stringArray2[1]);
                }
            }
        }

        public void delete(String string) {
            this.set(string, "-delete-", -30);
        }

        @Override
        public Iterator<String> iterator() {
            return this.cookies.keySet().iterator();
        }

        public String read(String string) {
            return this.cookies.get(string);
        }

        public void set(Cookie cookie) {
            this.queue.add(cookie);
        }

        public void set(String string, String string2, int n) {
            this.queue.add(new Cookie(string, string2, Cookie.getHTTPTime(n)));
        }

        public void unloadQueue(Response response) {
            for (Cookie cookie : this.queue) {
                response.addHeader("Set-Cookie", cookie.getHTTPHeader());
            }
        }
    }

    public static class Cookie {
        private final String n;
        private final String v;
        private final String e;

        public static String getHTTPTime(int n) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.add(5, n);
            return simpleDateFormat.format(calendar.getTime());
        }

        public Cookie(String string, String string2) {
            this(string, string2, 30);
        }

        public Cookie(String string, String string2, int n) {
            this.n = string;
            this.v = string2;
            this.e = Cookie.getHTTPTime(n);
        }

        public Cookie(String string, String string2, String string3) {
            this.n = string;
            this.v = string2;
            this.e = string3;
        }

        public String getHTTPHeader() {
            String string = "%s=%s; expires=%s";
            return String.format(string, this.n, this.v, this.e);
        }
    }
}

