/*
 * Decompiled with CFR 0.152.
 */
package com.nwu2.httpd;

import com.nwu2.httpd.HTTPSession;
import com.nwu2.httpd.IHTTPd;
import com.nwu2.httpd.NanoHTTPD;
import com.nwu2.httpd.responses.Response;
import com.nwu2.log.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;

public class HTTPd
extends NanoHTTPD
implements IHTTPd {
    protected int myTcpPort;
    protected Thread myThread;
    protected HTTPd httpd;
    protected Log log;
    protected String defaultResponse = null;
    protected HashMap<String, Class> URIresponses = new HashMap();
    protected HashMap<String, Long> URIhits = new HashMap();
    protected HashMap<String, Map<String, String>> URIProps = new HashMap();
    protected ArrayList<String> gzipaccept = new ArrayList();
    File myFileDir;

    @Override
    public String getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public void setDefaultResponse(String string) {
        this.httpd.defaultResponse = string;
    }

    public HTTPd(Log log, int n) throws IOException {
        super(n);
        NanoHTTPD.LOG = log.getLogLogger();
        super.start();
        if (log != null) {
            this.log = log;
        }
        this.httpd = this;
        this.myTcpPort = n;
        this.log.log(Log.Type.DEBUG, "ServerSocket created for TCP port: " + this.myTcpPort);
    }

    public HTTPd(Log log, String string, int n) throws IOException {
        super(string, n);
        NanoHTTPD.LOG = log.getLogLogger();
        super.start();
        if (log != null) {
            this.log = log;
        }
        this.httpd = this;
        this.myTcpPort = n;
        this.log.log(Log.Type.DEBUG, "ServerSocket created for TCP hostname: " + string + "; port: " + this.myTcpPort);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession iHTTPSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NanoHTTPD.Method method = iHTTPSession.getMethod();
        if (NanoHTTPD.Method.PUT.equals((Object)method) || NanoHTTPD.Method.POST.equals((Object)method)) {
            try {
                iHTTPSession.parseBody(hashMap);
            }
            catch (IOException iOException) {
                return new NanoHTTPD.Response(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", new ByteArrayInputStream(("SERVER INTERNAL ERROR: IOException: " + iOException.getMessage()).getBytes(StandardCharsets.UTF_8)), -1L);
            }
            catch (NanoHTTPD.ResponseException responseException) {
                return new NanoHTTPD.Response(responseException.getStatus(), "text/plain", new ByteArrayInputStream(responseException.getMessage().getBytes(StandardCharsets.UTF_8)), responseException.getMessage().length());
            }
        }
        Map<String, String> map = iHTTPSession.getParms();
        map.put("NanoHttpd.QUERY_STRING", iHTTPSession.getQueryParameterString());
        NanoHTTPD.Response response = HTTPSession.serve(this, this.log, iHTTPSession.getUri(), method, iHTTPSession.getHeaders(), map, hashMap, iHTTPSession.getOriginalURI());
        try {
            iHTTPSession.getInputStream().skip(iHTTPSession.getInputStream().available());
        }
        catch (IOException iOException) {
            this.log.log(Log.Type.ERROR, "Error emptying buffer: " + iOException.getMessage());
        }
        return response;
    }

    @Override
    public void registerURIResponse(String string, Class<?> clazz, Map<String, String> map) {
        if (clazz != null && clazz.asSubclass(Response.class) != null) {
            this.URIresponses.put(string, clazz);
            this.URIProps.put(string, map);
            this.URIhits.put(string, 0L);
        }
    }

    @Override
    public HashMap<String, Class> getURIresponses() {
        return this.URIresponses;
    }

    @Override
    public HashMap<String, Map<String, String>> getURIproperties() {
        return this.URIProps;
    }

    @Override
    public Class<?> getURIresponse(String string) {
        string.replaceFirst("/+", "/");
        if (this.getURIresponses().containsKey(string)) {
            this.URIhits.put(string, this.URIhits.get(string) + 1L);
            return this.getURIresponses().get(string);
        }
        return null;
    }

    @Override
    public Map<String, String> getURIProps(String string) {
        if (string.equals("")) {
            string = "/";
        }
        if (this.getURIproperties().containsKey(string)) {
            return this.getURIproperties().get(string);
        }
        return null;
    }

    @Override
    public HashMap<String, Long> getURIhits() {
        return this.URIhits;
    }

    @Override
    public int getMyTcpPort() {
        return this.myTcpPort;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public void addToGzipAccept(String string) {
        this.gzipaccept.add(string.toLowerCase());
    }

    @Override
    public boolean useGzipWhenAccepted(NanoHTTPD.Response response) {
        return response.getMimeType() != null && (response.getMimeType().toLowerCase().contains("text/") || this.gzipaccept.contains(response.getMimeType().toLowerCase()));
    }

    @Override
    public void makeSecure(SSLServerSocketFactory sSLServerSocketFactory, String[] stringArray) {
        super.makeSecure(sSLServerSocketFactory, stringArray);
    }

    @Override
    public void addToWsAccept(String string) {
    }

    @Override
    public void setAsyncRunner(NanoHTTPD.DefaultAsyncRunner defaultAsyncRunner) {
        super.setAsyncRunner(defaultAsyncRunner);
    }
}

