/*
 * Decompiled with CFR 0.152.
 */
package com.nwu.httpd.responses;

import com.nwu.httpd.IHTTPd;
import com.nwu.httpd.responses.JsonResponse;
import java.lang.management.ManagementFactory;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusResponse
extends JsonResponse {
    StringBuffer out;

    public void addHeader(StringBuffer stringBuffer) {
        stringBuffer.append("<html><title>Status</title><body>");
        stringBuffer.append("<table border=1 cellspacing=1>");
    }

    public void addLine(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td>" + string + "</td><td>" + string2 + "</td></tr>");
    }

    public void addFooter(StringBuffer stringBuffer) {
        stringBuffer.append("</table>");
        stringBuffer.append("</body></html>");
    }

    protected JSONObject respond2Properties(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("TCP port", this.httpd.getMyTcpPort());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    protected JSONObject respond2URIResponsesNumber(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("Size", this.httpd.getURIresponses().size());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    protected JSONObject respond2ListOfResponses(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string : this.httpd.getURIresponses().keySet()) {
                jSONObject.put(string, this.httpd.getURIresponses().get(string).getName());
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    protected JSONObject respond2ListOfResponsesHits(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string : this.httpd.getURIhits().keySet()) {
                jSONObject.put(string, this.httpd.getURIhits().get(string));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    protected JSONObject respond2Memory(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("Total memory", Runtime.getRuntime().totalMemory());
            jSONObject.put("Free memory", Runtime.getRuntime().freeMemory());
            jSONObject.put("Maximum memory", Runtime.getRuntime().maxMemory());
            jSONObject.put("Number of threads", Thread.activeCount());
            jSONObject.put("System load", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
            jSONObject.put("Uptime", ManagementFactory.getRuntimeMXBean().getUptime());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public StatusResponse(IHTTPd iHTTPd, String string, Map<String, String> map) {
        super(iHTTPd, string, map);
        this.add("q", "properties", new JsonResponse.JsonAnswer(){

            @Override
            public JSONObject answer(Map<String, String> map) {
                return StatusResponse.this.respond2Properties(map);
            }
        });
        this.add("q", "uriresponsesnumber", new JsonResponse.JsonAnswer(){

            @Override
            public JSONObject answer(Map<String, String> map) {
                return StatusResponse.this.respond2URIResponsesNumber(map);
            }
        });
        this.add("q", "listofresponses", new JsonResponse.JsonAnswer(){

            @Override
            public JSONObject answer(Map<String, String> map) {
                return StatusResponse.this.respond2ListOfResponses(map);
            }
        });
        this.add("q", "listofresponseshits", new JsonResponse.JsonAnswer(){

            @Override
            public JSONObject answer(Map<String, String> map) {
                return StatusResponse.this.respond2ListOfResponsesHits(map);
            }
        });
        this.add("q", "memory", new JsonResponse.JsonAnswer(){

            @Override
            public JSONObject answer(Map<String, String> map) {
                return StatusResponse.this.respond2Memory(map);
            }
        });
    }

    protected String listOfResponses() {
        Object object = "";
        for (String string : this.httpd.getURIresponses().keySet()) {
            object = (String)object + string + "<br>";
        }
        return object;
    }

    protected String listOfResponsesHits() {
        Object object = "";
        for (String string : this.httpd.getURIhits().keySet()) {
            object = (String)object + string + " - " + String.valueOf(this.httpd.getURIhits().get(string)) + "<br>";
        }
        return object;
    }
}

