/*
 * Decompiled with CFR 0.152.
 */
package com.nwu.httpd.responses;

import com.nwu.httpd.Codes;
import com.nwu.httpd.IHTTPd;
import com.nwu.httpd.NanoHTTPD;
import com.nwu.httpd.Request;
import com.nwu.log.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class Response {
    protected IHTTPd httpd;
    protected Log log;
    protected String rURI;
    protected Map<String, String> props;
    protected long size = -1L;
    protected NanoHTTPD.Response.IStatus status = null;
    protected String mimeType = null;
    protected InputStream data = null;
    protected Map<String, String> header = new HashMap<String, String>();

    public Response(IHTTPd iHTTPd, String string) {
        this.httpd = iHTTPd;
        this.log = iHTTPd.getLog();
        this.rURI = string;
    }

    public abstract void execute(Request var1);

    public static void register(IHTTPd iHTTPd, String string, Map<String, String> map) {
        iHTTPd.registerURIResponse(string, Response.class, map);
    }

    public Response(IHTTPd iHTTPd) {
        this.httpd = iHTTPd;
        this.status = Codes.HTTP_OK;
        this.log = iHTTPd.getLog();
    }

    public Response(IHTTPd iHTTPd, NanoHTTPD.Response.IStatus iStatus, String string, InputStream inputStream) {
        this.httpd = iHTTPd;
        this.status = iStatus;
        this.mimeType = string;
        this.data = inputStream;
        this.log = iHTTPd.getLog();
    }

    public Response(IHTTPd iHTTPd, NanoHTTPD.Response.IStatus iStatus, String string, String string2) {
        this.httpd = iHTTPd;
        this.status = iStatus;
        this.mimeType = string;
        this.data = new ByteArrayInputStream(string2.getBytes());
        this.log = iHTTPd.getLog();
        this.size = string2.length();
    }

    public Response(IHTTPd iHTTPd, String string, Map<String, String> map) {
        this.httpd = iHTTPd;
        this.props = map;
        this.rURI = string;
        this.log = iHTTPd.getLog();
    }

    public NanoHTTPD.Response getResponse() {
        NanoHTTPD.Response response = new NanoHTTPD.Response(this.status, this.mimeType, this.data, this.size);
        for (String string : this.header.keySet()) {
            response.addHeader(string, this.header.get(string));
        }
        return response;
    }

    public void addHeader(String string, String string2) {
        this.header.put(string, string2);
    }

    public NanoHTTPD.Response.IStatus getStatus() {
        return this.status;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public InputStream getData() {
        return this.data;
    }
}

