/*
 * Decompiled with CFR 0.152.
 */
package com.nwu.httpd;

import com.nwu.httpd.NanoHTTPD;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NanoWSD
extends NanoHTTPD {
    protected static Logger LOG = Logger.getLogger(NanoWSD.class.getName());
    public static final String HEADER_UPGRADE = "upgrade";
    public static final String HEADER_UPGRADE_VALUE = "websocket";
    public static final String HEADER_CONNECTION = "connection";
    public static final String HEADER_CONNECTION_VALUE = "Upgrade";
    public static final String HEADER_WEBSOCKET_VERSION = "sec-websocket-version";
    public static final String HEADER_WEBSOCKET_VERSION_VALUE = "13";
    public static final String HEADER_WEBSOCKET_KEY = "sec-websocket-key";
    public static final String HEADER_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    public static final String HEADER_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    private static final String WEBSOCKET_KEY_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private static String encodeBase64(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3++];
            byte by2 = n3 < n ? byArray[n3++] : (byte)0;
            byte by3 = n3 < n ? byArray[n3++] : (byte)0;
            int n4 = 63;
            cArray[n2++] = ALPHABET[by >> 2 & n4];
            cArray[n2++] = ALPHABET[(by << 4 | (by2 & 0xFF) >> 4) & n4];
            cArray[n2++] = ALPHABET[(by2 << 2 | (by3 & 0xFF) >> 6) & n4];
            cArray[n2++] = ALPHABET[by3 & n4];
        }
        switch (n % 3) {
            case 1: {
                cArray[--n2] = 61;
            }
            case 2: {
                cArray[--n2] = 61;
            }
        }
        return new String(cArray);
    }

    public static String makeAcceptKey(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string2 = string + WEBSOCKET_KEY_MAGIC;
        messageDigest.update(string2.getBytes(), 0, string2.length());
        byte[] byArray = messageDigest.digest();
        return NanoWSD.encodeBase64(byArray);
    }

    public NanoWSD(int n) {
        super(n);
    }

    public NanoWSD(String string, int n) {
        super(string, n);
    }

    private boolean isWebSocketConnectionHeader(Map<String, String> map) {
        String string = map.get(HEADER_CONNECTION);
        return string != null && string.toLowerCase().contains(HEADER_CONNECTION_VALUE.toLowerCase());
    }

    protected boolean isWebsocketRequested(NanoHTTPD.IHTTPSession iHTTPSession) {
        Map<String, String> map = iHTTPSession.getHeaders();
        String string = map.get(HEADER_UPGRADE);
        boolean bl = this.isWebSocketConnectionHeader(map);
        boolean bl2 = HEADER_UPGRADE_VALUE.equalsIgnoreCase(string);
        return bl2 && bl;
    }

    protected abstract WebSocket openWebSocket(NanoHTTPD.IHTTPSession var1);

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession iHTTPSession) {
        Map<String, String> map = iHTTPSession.getHeaders();
        if (this.isWebsocketRequested(iHTTPSession)) {
            if (!HEADER_WEBSOCKET_VERSION_VALUE.equalsIgnoreCase(map.get(HEADER_WEBSOCKET_VERSION))) {
                return NanoWSD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain", "Invalid Websocket-Version " + map.get(HEADER_WEBSOCKET_VERSION));
            }
            if (!map.containsKey(HEADER_WEBSOCKET_KEY)) {
                return NanoWSD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain", "Missing Websocket-Key");
            }
            WebSocket webSocket = this.openWebSocket(iHTTPSession);
            NanoHTTPD.Response response = webSocket.getHandshakeResponse();
            try {
                response.addHeader(HEADER_WEBSOCKET_ACCEPT, NanoWSD.makeAcceptKey(map.get(HEADER_WEBSOCKET_KEY)));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return NanoWSD.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "The SHA-256 Algorithm required for websockets is not available on the server.");
            }
            if (map.containsKey(HEADER_WEBSOCKET_PROTOCOL)) {
                response.addHeader(HEADER_WEBSOCKET_PROTOCOL, map.get(HEADER_WEBSOCKET_PROTOCOL).split(",")[0]);
            }
            return response;
        }
        return this.serveHttp(iHTTPSession);
    }

    protected NanoHTTPD.Response serveHttp(NanoHTTPD.IHTTPSession iHTTPSession) {
        return super.serve(iHTTPSession);
    }

    @Override
    protected boolean useGzipWhenAccepted(NanoHTTPD.Response response) {
        return false;
    }

    public static abstract class WebSocket {
        private final InputStream in;
        private OutputStream out;
        private WebSocketFrame.OpCode continuousOpCode = null;
        private final List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
        private State state = State.UNCONNECTED;
        private final NanoHTTPD.IHTTPSession handshakeRequest;
        private final NanoHTTPD.Response handshakeResponse = new NanoHTTPD.Response(NanoHTTPD.Response.Status.SWITCH_PROTOCOL, null, null, 0L){

            @Override
            protected void send(OutputStream outputStream) {
                out = outputStream;
                state = State.CONNECTING;
                super.send(outputStream);
                state = State.OPEN;
                this.onOpen();
                this.readWebsocket();
            }
        };

        public WebSocket(NanoHTTPD.IHTTPSession iHTTPSession) {
            this.handshakeRequest = iHTTPSession;
            this.in = iHTTPSession.getInputStream();
            this.handshakeResponse.addHeader(NanoWSD.HEADER_UPGRADE, NanoWSD.HEADER_UPGRADE_VALUE);
            this.handshakeResponse.addHeader(NanoWSD.HEADER_CONNECTION, NanoWSD.HEADER_CONNECTION_VALUE);
        }

        public boolean isOpen() {
            return this.state == State.OPEN;
        }

        protected abstract void onOpen();

        protected abstract void onClose(WebSocketFrame.CloseCode var1, String var2, boolean var3);

        protected abstract void onMessage(WebSocketFrame var1);

        protected abstract void onPong(WebSocketFrame var1);

        protected abstract void onException(IOException var1);

        protected void debugFrameReceived(WebSocketFrame webSocketFrame) {
        }

        protected void debugFrameSent(WebSocketFrame webSocketFrame) {
        }

        public void close(WebSocketFrame.CloseCode closeCode, String string, boolean bl) throws IOException {
            State state = this.state;
            this.state = State.CLOSING;
            if (state == State.OPEN) {
                this.sendFrame(new WebSocketFrame.CloseFrame(closeCode, string));
            } else {
                this.doClose(closeCode, string, bl);
            }
        }

        private void doClose(WebSocketFrame.CloseCode closeCode, String string, boolean bl) {
            if (this.state == State.CLOSED) {
                return;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "close failed", iOException);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "close failed", iOException);
                }
            }
            this.state = State.CLOSED;
            this.onClose(closeCode, string, bl);
        }

        public NanoHTTPD.IHTTPSession getHandshakeRequest() {
            return this.handshakeRequest;
        }

        public NanoHTTPD.Response getHandshakeResponse() {
            return this.handshakeResponse;
        }

        private void handleCloseFrame(WebSocketFrame webSocketFrame) throws IOException {
            WebSocketFrame.CloseCode closeCode = WebSocketFrame.CloseCode.NormalClosure;
            String string = "";
            if (webSocketFrame instanceof WebSocketFrame.CloseFrame) {
                closeCode = ((WebSocketFrame.CloseFrame)webSocketFrame).getCloseCode();
                string = ((WebSocketFrame.CloseFrame)webSocketFrame).getCloseReason();
            }
            if (this.state == State.CLOSING) {
                this.doClose(closeCode, string, false);
            } else {
                this.close(closeCode, string, true);
            }
        }

        private void handleFrameFragment(WebSocketFrame webSocketFrame) throws IOException {
            if (webSocketFrame.getOpCode() != WebSocketFrame.OpCode.Continuation) {
                if (this.continuousOpCode != null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
                }
                this.continuousOpCode = webSocketFrame.getOpCode();
                this.continuousFrames.clear();
                this.continuousFrames.add(webSocketFrame);
            } else if (webSocketFrame.isFin()) {
                if (this.continuousOpCode == null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
                }
                this.continuousFrames.add(webSocketFrame);
                this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
                this.continuousOpCode = null;
                this.continuousFrames.clear();
            } else {
                if (this.continuousOpCode == null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
                }
                this.continuousFrames.add(webSocketFrame);
            }
        }

        private void handleWebsocketFrame(WebSocketFrame webSocketFrame) throws IOException {
            this.debugFrameReceived(webSocketFrame);
            if (webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Close) {
                this.handleCloseFrame(webSocketFrame);
            } else if (webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Ping) {
                this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Pong, true, webSocketFrame.getBinaryPayload()));
            } else if (webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Pong) {
                this.onPong(webSocketFrame);
            } else if (!webSocketFrame.isFin() || webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Continuation) {
                this.handleFrameFragment(webSocketFrame);
            } else {
                if (this.continuousOpCode != null) {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence not completed.");
                }
                if (webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Text || webSocketFrame.getOpCode() == WebSocketFrame.OpCode.Binary) {
                    this.onMessage(webSocketFrame);
                } else {
                    throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Non control or continuous frame expected.");
                }
            }
        }

        public void ping(byte[] byArray) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Ping, true, byArray));
        }

        private void readWebsocket() {
            try {
                while (this.state == State.OPEN) {
                    this.handleWebsocketFrame(WebSocketFrame.read(this.in));
                }
            }
            catch (CharacterCodingException characterCodingException) {
                this.onException(characterCodingException);
                this.doClose(WebSocketFrame.CloseCode.InvalidFramePayloadData, characterCodingException.toString(), false);
            }
            catch (IOException iOException) {
                this.onException(iOException);
                if (iOException instanceof WebSocketException) {
                    this.doClose(((WebSocketException)iOException).getCode(), ((WebSocketException)iOException).getReason(), false);
                }
            }
            finally {
                this.doClose(WebSocketFrame.CloseCode.InternalServerError, "Handler terminated without closing the connection.", false);
            }
        }

        public void send(byte[] byArray) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Binary, true, byArray));
        }

        public void send(String string) throws IOException {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Text, true, string));
        }

        public synchronized void sendFrame(WebSocketFrame webSocketFrame) throws IOException {
            this.debugFrameSent(webSocketFrame);
            webSocketFrame.write(this.out);
        }
    }

    public static class WebSocketFrame {
        public static final Charset TEXT_CHARSET = Charset.forName("UTF-8");
        private OpCode opCode;
        private boolean fin;
        private byte[] maskingKey;
        private byte[] payload;
        private transient int _payloadLength;
        private transient String _payloadString;

        public static String binary2Text(byte[] byArray) throws CharacterCodingException {
            return new String(byArray, TEXT_CHARSET);
        }

        public static String binary2Text(byte[] byArray, int n, int n2) throws CharacterCodingException {
            return new String(byArray, n, n2, TEXT_CHARSET);
        }

        private static int checkedRead(int n) throws IOException {
            if (n < 0) {
                throw new EOFException();
            }
            return n;
        }

        public static WebSocketFrame read(InputStream inputStream) throws IOException {
            byte by = (byte)WebSocketFrame.checkedRead(inputStream.read());
            boolean bl = (by & 0x80) != 0;
            OpCode opCode = OpCode.find((byte)(by & 0xF));
            if ((by & 0x70) != 0) {
                throw new WebSocketException(CloseCode.ProtocolError, "The reserved bits (" + Integer.toBinaryString(by & 0x70) + ") must be 0.");
            }
            if (opCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Received frame with reserved/unknown opcode " + (by & 0xF) + ".");
            }
            if (opCode.isControlFrame() && !bl) {
                throw new WebSocketException(CloseCode.ProtocolError, "Fragmented control frame.");
            }
            WebSocketFrame webSocketFrame = new WebSocketFrame(opCode, bl);
            webSocketFrame.readPayloadInfo(inputStream);
            webSocketFrame.readPayload(inputStream);
            if (webSocketFrame.getOpCode() == OpCode.Close) {
                return new CloseFrame(webSocketFrame);
            }
            return webSocketFrame;
        }

        public static byte[] text2Binary(String string) throws CharacterCodingException {
            return string.getBytes(TEXT_CHARSET);
        }

        private WebSocketFrame(OpCode opCode, boolean bl) {
            this.setOpCode(opCode);
            this.setFin(bl);
        }

        public WebSocketFrame(OpCode opCode, boolean bl, byte[] byArray) {
            this(opCode, bl, byArray, null);
        }

        public WebSocketFrame(OpCode opCode, boolean bl, byte[] byArray, byte[] byArray2) {
            this(opCode, bl);
            this.setMaskingKey(byArray2);
            this.setBinaryPayload(byArray);
        }

        public WebSocketFrame(OpCode opCode, boolean bl, String string) throws CharacterCodingException {
            this(opCode, bl, string, null);
        }

        public WebSocketFrame(OpCode opCode, boolean bl, String string, byte[] byArray) throws CharacterCodingException {
            this(opCode, bl);
            this.setMaskingKey(byArray);
            this.setTextPayload(string);
        }

        public WebSocketFrame(OpCode opCode, List<WebSocketFrame> list) throws WebSocketException {
            this.setOpCode(opCode);
            this.setFin(true);
            long l = 0L;
            for (WebSocketFrame webSocketFrame : list) {
                l += (long)webSocketFrame.getBinaryPayload().length;
            }
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
            }
            this._payloadLength = (int)l;
            Object object = new byte[this._payloadLength];
            int n = 0;
            for (WebSocketFrame webSocketFrame : list) {
                System.arraycopy(webSocketFrame.getBinaryPayload(), 0, object, n, webSocketFrame.getBinaryPayload().length);
                n += webSocketFrame.getBinaryPayload().length;
            }
            this.setBinaryPayload((byte[])object);
        }

        public WebSocketFrame(WebSocketFrame webSocketFrame) {
            this.setOpCode(webSocketFrame.getOpCode());
            this.setFin(webSocketFrame.isFin());
            this.setBinaryPayload(webSocketFrame.getBinaryPayload());
            this.setMaskingKey(webSocketFrame.getMaskingKey());
        }

        public byte[] getBinaryPayload() {
            return this.payload;
        }

        public byte[] getMaskingKey() {
            return this.maskingKey;
        }

        public OpCode getOpCode() {
            return this.opCode;
        }

        public String getTextPayload() {
            if (this._payloadString == null) {
                try {
                    this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
                }
                catch (CharacterCodingException characterCodingException) {
                    throw new RuntimeException("Undetected CharacterCodingException", characterCodingException);
                }
            }
            return this._payloadString;
        }

        public boolean isFin() {
            return this.fin;
        }

        public boolean isMasked() {
            return this.maskingKey != null && this.maskingKey.length == 4;
        }

        private String payloadToString() {
            if (this.payload == null) {
                return "null";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[').append(this.payload.length).append("b] ");
            if (this.getOpCode() == OpCode.Text) {
                String string = this.getTextPayload();
                if (string.length() > 100) {
                    stringBuilder.append(string.substring(0, 100)).append("...");
                } else {
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append("0x");
                for (int i = 0; i < Math.min(this.payload.length, 50); ++i) {
                    stringBuilder.append(Integer.toHexString(this.payload[i] & 0xFF));
                }
                if (this.payload.length > 50) {
                    stringBuilder.append("...");
                }
            }
            return stringBuilder.toString();
        }

        private void readPayload(InputStream inputStream) throws IOException {
            this.payload = new byte[this._payloadLength];
            for (int i = 0; i < this._payloadLength; i += WebSocketFrame.checkedRead(inputStream.read(this.payload, i, this._payloadLength - i))) {
            }
            if (this.isMasked()) {
                for (int i = 0; i < this.payload.length; ++i) {
                    int n = i;
                    this.payload[n] = (byte)(this.payload[n] ^ this.maskingKey[i % 4]);
                }
            }
            if (this.getOpCode() == OpCode.Text) {
                this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
            }
        }

        private void readPayloadInfo(InputStream inputStream) throws IOException {
            byte by = (byte)WebSocketFrame.checkedRead(inputStream.read());
            boolean bl = (by & 0x80) != 0;
            this._payloadLength = (byte)(0x7F & by);
            if (this._payloadLength == 126) {
                this._payloadLength = (WebSocketFrame.checkedRead(inputStream.read()) << 8 | WebSocketFrame.checkedRead(inputStream.read())) & 0xFFFF;
                if (this._payloadLength < 126) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 2byte length. (not using minimal length encoding)");
                }
            } else if (this._payloadLength == 127) {
                long l = (long)WebSocketFrame.checkedRead(inputStream.read()) << 56 | (long)WebSocketFrame.checkedRead(inputStream.read()) << 48 | (long)WebSocketFrame.checkedRead(inputStream.read()) << 40 | (long)WebSocketFrame.checkedRead(inputStream.read()) << 32 | (long)(WebSocketFrame.checkedRead(inputStream.read()) << 24) | (long)(WebSocketFrame.checkedRead(inputStream.read()) << 16) | (long)(WebSocketFrame.checkedRead(inputStream.read()) << 8) | (long)WebSocketFrame.checkedRead(inputStream.read());
                if (l < 65536L) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 4byte length. (not using minimal length encoding)");
                }
                if (l < 0L || l > Integer.MAX_VALUE) {
                    throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
                }
                this._payloadLength = (int)l;
            }
            if (this.opCode.isControlFrame()) {
                if (this._payloadLength > 125) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Control frame with payload length > 125 bytes.");
                }
                if (this.opCode == OpCode.Close && this._payloadLength == 1) {
                    throw new WebSocketException(CloseCode.ProtocolError, "Received close frame with payload len 1.");
                }
            }
            if (bl) {
                this.maskingKey = new byte[4];
                for (int i = 0; i < this.maskingKey.length; i += WebSocketFrame.checkedRead(inputStream.read(this.maskingKey, i, this.maskingKey.length - i))) {
                }
            }
        }

        public void setBinaryPayload(byte[] byArray) {
            this.payload = byArray;
            this._payloadLength = byArray.length;
            this._payloadString = null;
        }

        public void setFin(boolean bl) {
            this.fin = bl;
        }

        public void setMaskingKey(byte[] byArray) {
            if (byArray != null && byArray.length != 4) {
                throw new IllegalArgumentException("MaskingKey " + Arrays.toString(byArray) + " hasn't length 4");
            }
            this.maskingKey = byArray;
        }

        public void setOpCode(OpCode opCode) {
            this.opCode = opCode;
        }

        public void setTextPayload(String string) throws CharacterCodingException {
            this.payload = WebSocketFrame.text2Binary(string);
            this._payloadLength = string.length();
            this._payloadString = string;
        }

        public void setUnmasked() {
            this.setMaskingKey(null);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("WS[");
            stringBuilder.append((Object)this.getOpCode());
            stringBuilder.append(", ").append(this.isFin() ? "fin" : "inter");
            stringBuilder.append(", ").append(this.isMasked() ? "masked" : "unmasked");
            stringBuilder.append(", ").append(this.payloadToString());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public void write(OutputStream outputStream) throws IOException {
            int n = 0;
            if (this.fin) {
                n = (byte)(n | 0x80);
            }
            n = (byte)(n | this.opCode.getValue() & 0xF);
            outputStream.write(n);
            this._payloadLength = this.getBinaryPayload().length;
            if (this._payloadLength <= 125) {
                outputStream.write(this.isMasked() ? (byte)(0x80 | (byte)this._payloadLength) : (byte)this._payloadLength);
            } else if (this._payloadLength <= 65535) {
                outputStream.write(this.isMasked() ? 254 : 126);
                outputStream.write(this._payloadLength >>> 8);
                outputStream.write(this._payloadLength);
            } else {
                outputStream.write(this.isMasked() ? 255 : 127);
                outputStream.write(this._payloadLength >>> 56 & 0);
                outputStream.write(this._payloadLength >>> 48 & 0);
                outputStream.write(this._payloadLength >>> 40 & 0);
                outputStream.write(this._payloadLength >>> 32 & 0);
                outputStream.write(this._payloadLength >>> 24);
                outputStream.write(this._payloadLength >>> 16);
                outputStream.write(this._payloadLength >>> 8);
                outputStream.write(this._payloadLength);
            }
            if (this.isMasked()) {
                outputStream.write(this.maskingKey);
                for (int i = 0; i < this._payloadLength; ++i) {
                    outputStream.write(this.getBinaryPayload()[i] ^ this.maskingKey[i % 4]);
                }
            } else {
                outputStream.write(this.getBinaryPayload());
            }
            outputStream.flush();
        }

        public static enum OpCode {
            Continuation(0),
            Text(1),
            Binary(2),
            Close(8),
            Ping(9),
            Pong(10);

            private final byte code;

            public static OpCode find(byte by) {
                for (OpCode opCode : OpCode.values()) {
                    if (opCode.getValue() != by) continue;
                    return opCode;
                }
                return null;
            }

            private OpCode(int n2) {
                this.code = (byte)n2;
            }

            public byte getValue() {
                return this.code;
            }

            public boolean isControlFrame() {
                return this == Close || this == Ping || this == Pong;
            }
        }

        public static enum CloseCode {
            NormalClosure(1000),
            GoingAway(1001),
            ProtocolError(1002),
            UnsupportedData(1003),
            NoStatusRcvd(1005),
            AbnormalClosure(1006),
            InvalidFramePayloadData(1007),
            PolicyViolation(1008),
            MessageTooBig(1009),
            MandatoryExt(1010),
            InternalServerError(1011),
            TLSHandshake(1015);

            private final int code;

            public static CloseCode find(int n) {
                for (CloseCode closeCode : CloseCode.values()) {
                    if (closeCode.getValue() != n) continue;
                    return closeCode;
                }
                return null;
            }

            private CloseCode(int n2) {
                this.code = n2;
            }

            public int getValue() {
                return this.code;
            }
        }

        public static class CloseFrame
        extends WebSocketFrame {
            private CloseCode _closeCode;
            private String _closeReason;

            private static byte[] generatePayload(CloseCode closeCode, String string) throws CharacterCodingException {
                if (closeCode != null) {
                    byte[] byArray = CloseFrame.text2Binary(string);
                    byte[] byArray2 = new byte[byArray.length + 2];
                    byArray2[0] = (byte)(closeCode.getValue() >> 8 & 0xFF);
                    byArray2[1] = (byte)(closeCode.getValue() & 0xFF);
                    System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
                    return byArray2;
                }
                return new byte[0];
            }

            public CloseFrame(CloseCode closeCode, String string) throws CharacterCodingException {
                super(OpCode.Close, true, CloseFrame.generatePayload(closeCode, string));
            }

            private CloseFrame(WebSocketFrame webSocketFrame) throws CharacterCodingException {
                super(webSocketFrame);
                assert (webSocketFrame.getOpCode() == OpCode.Close);
                if (webSocketFrame.getBinaryPayload().length >= 2) {
                    this._closeCode = CloseCode.find((webSocketFrame.getBinaryPayload()[0] & 0xFF) << 8 | webSocketFrame.getBinaryPayload()[1] & 0xFF);
                    this._closeReason = CloseFrame.binary2Text(this.getBinaryPayload(), 2, this.getBinaryPayload().length - 2);
                }
            }

            public CloseCode getCloseCode() {
                return this._closeCode;
            }

            public String getCloseReason() {
                return this._closeReason;
            }
        }
    }

    public static class WebSocketException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final WebSocketFrame.CloseCode code;
        private final String reason;

        public WebSocketException(WebSocketFrame.CloseCode closeCode, String string) {
            this(closeCode, string, null);
        }

        public WebSocketException(WebSocketFrame.CloseCode closeCode, String string, Exception exception) {
            super(String.valueOf((Object)closeCode) + ": " + string, exception);
            this.code = closeCode;
            this.reason = string;
        }

        public WebSocketException(Exception exception) {
            this(WebSocketFrame.CloseCode.InternalServerError, exception.toString(), exception);
        }

        public WebSocketFrame.CloseCode getCode() {
            return this.code;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static enum State {
        UNCONNECTED,
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

