/*
 * Decompiled with CFR 0.152.
 */
package com.nwu.httpd;

import com.nwu.httpd.HTTPSession;
import com.nwu.httpd.IHTTPd;
import com.nwu.httpd.IWebSock;
import com.nwu.httpd.NanoHTTPD;
import com.nwu.httpd.NanoWSD;
import com.nwu.httpd.responses.Response;
import com.nwu.log.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;

public class HTTPWSd
extends NanoWSD
implements IHTTPd {
    protected int myTcpPort;
    protected Thread myThread;
    protected HTTPWSd httpd;
    protected Log log;
    protected String defaultResponse = null;
    protected HashMap<String, Class> URIresponses = new HashMap();
    protected HashMap<String, Long> URIhits = new HashMap();
    protected HashMap<String, Map<String, String>> URIProps = new HashMap();
    protected ArrayList<String> gzipaccept = new ArrayList();
    protected ArrayList<String> wsaccept = new ArrayList();
    File myFileDir;
    protected IWebSock ws;

    @Override
    public String getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public void setDefaultResponse(String string) {
        this.httpd.defaultResponse = string;
    }

    public HTTPWSd(Log log, int n, IWebSock iWebSock, int n2) throws IOException {
        super(n);
        NanoWSD.LOG = log.getLogLogger();
        this.ws = iWebSock;
        if (n2 > 0) {
            super.start(n2);
        } else {
            super.start();
        }
        if (log != null) {
            this.log = log;
        }
        this.httpd = this;
        this.myTcpPort = n;
        this.log.log(Log.Type.DEBUG, "ServerSocket created for TCP port: " + this.myTcpPort);
    }

    public HTTPWSd(Log log, String string, int n, IWebSock iWebSock, int n2) throws IOException {
        super(string, n);
        NanoWSD.LOG = log.getLogLogger();
        this.ws = iWebSock;
        if (n2 > 0) {
            super.start(n2);
        } else {
            super.start();
        }
        if (log != null) {
            this.log = log;
        }
        this.httpd = this;
        this.myTcpPort = n;
        this.log.log(Log.Type.DEBUG, "ServerSocket created for TCP hostname: " + string + "; port: " + this.myTcpPort);
    }

    @Override
    public void addToWsAccept(String string) {
        this.wsaccept.add(string);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession iHTTPSession) {
        if (this.isWebsocketRequested(iHTTPSession) && this.wsaccept.contains(iHTTPSession.getUri())) {
            return super.serve(iHTTPSession);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NanoHTTPD.Method method = iHTTPSession.getMethod();
        if (NanoHTTPD.Method.PUT.equals((Object)method) || NanoHTTPD.Method.POST.equals((Object)method)) {
            try {
                iHTTPSession.parseBody(hashMap);
            }
            catch (IOException iOException) {
                return new NanoHTTPD.Response(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", new ByteArrayInputStream(("SERVER INTERNAL ERROR: IOException: " + iOException.getMessage()).getBytes(StandardCharsets.UTF_8)), -1L);
            }
            catch (NanoHTTPD.ResponseException responseException) {
                return new NanoHTTPD.Response(responseException.getStatus(), "text/plain", new ByteArrayInputStream(responseException.getMessage().getBytes(StandardCharsets.UTF_8)), responseException.getMessage().length());
            }
        }
        Map<String, String> map = iHTTPSession.getParms();
        map.put("NanoHttpd.QUERY_STRING", iHTTPSession.getQueryParameterString());
        NanoHTTPD.Response response = HTTPSession.serve(this, this.log, iHTTPSession.getUri(), method, iHTTPSession.getHeaders(), map, hashMap, iHTTPSession.getOriginalURI());
        try {
            iHTTPSession.getInputStream().skip(iHTTPSession.getInputStream().available());
        }
        catch (IOException iOException) {
            this.log.log(Log.Type.ERROR, "Error emptying buffer: " + iOException.getMessage());
        }
        return response;
    }

    @Override
    public void registerURIResponse(String string, Class<?> clazz, Map<String, String> map) {
        if (clazz != null && clazz.asSubclass(Response.class) != null) {
            this.URIresponses.put(string, clazz);
            this.URIProps.put(string, map);
            this.URIhits.put(string, 0L);
        }
    }

    @Override
    public HashMap<String, Class> getURIresponses() {
        return this.URIresponses;
    }

    @Override
    public HashMap<String, Map<String, String>> getURIproperties() {
        return this.URIProps;
    }

    @Override
    public Class<?> getURIresponse(String string) {
        string.replaceFirst("/+", "/");
        if (this.getURIresponses().containsKey(string)) {
            this.URIhits.put(string, this.URIhits.get(string) + 1L);
            return this.getURIresponses().get(string);
        }
        return null;
    }

    @Override
    public Map<String, String> getURIProps(String string) {
        if (string.equals("")) {
            string = "/";
        }
        if (this.getURIproperties().containsKey(string)) {
            return this.getURIproperties().get(string);
        }
        return null;
    }

    @Override
    public HashMap<String, Long> getURIhits() {
        return this.URIhits;
    }

    @Override
    public int getMyTcpPort() {
        return this.myTcpPort;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public void addToGzipAccept(String string) {
        this.gzipaccept.add(string.toLowerCase());
    }

    @Override
    public boolean useGzipWhenAccepted(NanoHTTPD.Response response) {
        return response.getMimeType() != null && (response.getMimeType().toLowerCase().contains("text/") || this.gzipaccept.contains(response.getMimeType().toLowerCase()));
    }

    @Override
    protected NanoWSD.WebSocket openWebSocket(NanoHTTPD.IHTTPSession iHTTPSession) {
        return new NanoWSD.WebSocket(iHTTPSession){

            @Override
            protected void onOpen() {
                HTTPWSd.this.ws.oOpen(this);
            }

            @Override
            protected void onClose(NanoWSD.WebSocketFrame.CloseCode closeCode, String string, boolean bl) {
                HTTPWSd.this.ws.oClose(this, closeCode, string, bl);
            }

            @Override
            protected void onException(IOException iOException) {
                HTTPWSd.this.ws.oException(this, iOException);
            }

            @Override
            protected void onMessage(NanoWSD.WebSocketFrame webSocketFrame) {
                HTTPWSd.this.ws.oMessage(this, webSocketFrame);
            }

            @Override
            protected void onPong(NanoWSD.WebSocketFrame webSocketFrame) {
                HTTPWSd.this.ws.oPong(this, webSocketFrame);
            }
        };
    }

    @Override
    public void makeSecure(SSLServerSocketFactory sSLServerSocketFactory, String[] stringArray) {
        super.makeSecure(sSLServerSocketFactory, stringArray);
    }
}

