/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import com.jamesmurty.utils.BaseXMLBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLBuilder
extends BaseXMLBuilder {
    protected XMLBuilder(Document document) {
        super(document);
    }

    protected XMLBuilder(Node node, Node node2) {
        super(node, node2);
    }

    public static XMLBuilder create(String string, String string2, boolean bl) throws ParserConfigurationException, FactoryConfigurationError {
        return new XMLBuilder(XMLBuilder.createDocumentImpl(string, string2, bl));
    }

    public static XMLBuilder create(String string, boolean bl) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create(string, null, bl);
    }

    public static XMLBuilder create(String string, String string2) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create(string, string2, false);
    }

    public static XMLBuilder create(String string) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create(string, null);
    }

    public static XMLBuilder parse(InputSource inputSource, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        return new XMLBuilder(XMLBuilder.parseDocumentImpl(inputSource, bl));
    }

    public static XMLBuilder parse(String string, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(new InputSource(new StringReader(string)), bl);
    }

    public static XMLBuilder parse(File file, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(new InputSource(new FileReader(file)), bl);
    }

    public static XMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(inputSource, false);
    }

    public static XMLBuilder parse(String string) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(string, false);
    }

    public static XMLBuilder parse(File file) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(file, false);
    }

    @Override
    public XMLBuilder stripWhitespaceOnlyTextNodes() throws XPathExpressionException {
        super.stripWhitespaceOnlyTextNodesImpl();
        return this;
    }

    @Override
    public XMLBuilder importXMLBuilder(BaseXMLBuilder baseXMLBuilder) {
        super.importXMLBuilderImpl(baseXMLBuilder);
        return this;
    }

    @Override
    public XMLBuilder root() {
        return new XMLBuilder(this.getDocument());
    }

    @Override
    public XMLBuilder xpathFind(String string, NamespaceContext namespaceContext) throws XPathExpressionException {
        Node node = super.xpathFindImpl(string, namespaceContext);
        return new XMLBuilder(node, null);
    }

    @Override
    public XMLBuilder xpathFind(String string) throws XPathExpressionException {
        return this.xpathFind(string, null);
    }

    @Override
    public XMLBuilder element(String string) {
        String string2 = super.lookupNamespaceURIImpl(string);
        return this.element(string, string2);
    }

    @Override
    public XMLBuilder elem(String string) {
        return this.element(string);
    }

    @Override
    public XMLBuilder e(String string) {
        return this.element(string);
    }

    @Override
    public XMLBuilder element(String string, String string2) {
        Element element = super.elementImpl(string, string2);
        return new XMLBuilder(element, this.getElement());
    }

    @Override
    public XMLBuilder elementBefore(String string) {
        Element element = super.elementBeforeImpl(string);
        return new XMLBuilder(element, null);
    }

    @Override
    public XMLBuilder elementBefore(String string, String string2) {
        Element element = super.elementBeforeImpl(string, string2);
        return new XMLBuilder(element, null);
    }

    @Override
    public XMLBuilder attribute(String string, String string2) {
        super.attributeImpl(string, string2);
        return this;
    }

    @Override
    public XMLBuilder attr(String string, String string2) {
        return this.attribute(string, string2);
    }

    @Override
    public XMLBuilder a(String string, String string2) {
        return this.attribute(string, string2);
    }

    @Override
    public XMLBuilder text(String string, boolean bl) {
        super.textImpl(string, bl);
        return this;
    }

    @Override
    public XMLBuilder text(String string) {
        return this.text(string, false);
    }

    @Override
    public XMLBuilder t(String string) {
        return this.text(string);
    }

    @Override
    public XMLBuilder cdata(String string) {
        super.cdataImpl(string);
        return this;
    }

    @Override
    public XMLBuilder data(String string) {
        return this.cdata(string);
    }

    @Override
    public XMLBuilder d(String string) {
        return this.cdata(string);
    }

    @Override
    public XMLBuilder cdata(byte[] byArray) {
        super.cdataImpl(byArray);
        return this;
    }

    @Override
    public XMLBuilder data(byte[] byArray) {
        return this.cdata(byArray);
    }

    @Override
    public XMLBuilder d(byte[] byArray) {
        return this.cdata(byArray);
    }

    @Override
    public XMLBuilder comment(String string) {
        super.commentImpl(string);
        return this;
    }

    @Override
    public XMLBuilder cmnt(String string) {
        return this.comment(string);
    }

    @Override
    public XMLBuilder c(String string) {
        return this.comment(string);
    }

    @Override
    public XMLBuilder instruction(String string, String string2) {
        super.instructionImpl(string, string2);
        return this;
    }

    @Override
    public XMLBuilder inst(String string, String string2) {
        return this.instruction(string, string2);
    }

    @Override
    public XMLBuilder i(String string, String string2) {
        return this.instruction(string, string2);
    }

    @Override
    public XMLBuilder insertInstruction(String string, String string2) {
        super.insertInstructionImpl(string, string2);
        return this;
    }

    @Override
    public XMLBuilder reference(String string) {
        super.referenceImpl(string);
        return this;
    }

    @Override
    public XMLBuilder ref(String string) {
        return this.reference(string);
    }

    @Override
    public XMLBuilder r(String string) {
        return this.reference(string);
    }

    @Override
    public XMLBuilder namespace(String string, String string2) {
        super.namespaceImpl(string, string2);
        return this;
    }

    @Override
    public XMLBuilder ns(String string, String string2) {
        return this.attribute(string, string2);
    }

    @Override
    public XMLBuilder namespace(String string) {
        this.namespace(null, string);
        return this;
    }

    @Override
    public XMLBuilder ns(String string) {
        return this.namespace(string);
    }

    @Override
    public XMLBuilder up(int n) {
        Node node = super.upImpl(n);
        if (node instanceof Document) {
            return new XMLBuilder((Document)node);
        }
        return new XMLBuilder(node, null);
    }

    @Override
    public XMLBuilder up() {
        return this.up(1);
    }

    @Override
    public XMLBuilder document() {
        return new XMLBuilder(this.getDocument(), null);
    }
}

