/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;

public class NamespaceContextImpl
implements NamespaceContext {
    protected Element element = null;
    protected Map<String, String> prefixToNsUriMap = new HashMap<String, String>();
    protected Map<String, Set<String>> nsUriToPrefixesMap = new HashMap<String, Set<String>>();

    public NamespaceContextImpl() {
    }

    public NamespaceContextImpl(Element element) {
        this.element = element;
    }

    public void addNamespace(String string, String string2) {
        this.prefixToNsUriMap.put(string, string2);
        if (this.nsUriToPrefixesMap.get(string2) == null) {
            this.nsUriToPrefixesMap.put(string2, new HashSet());
        }
        this.nsUriToPrefixesMap.get(string2).add(string);
    }

    @Override
    public String getNamespaceURI(String string) {
        String string2 = this.prefixToNsUriMap.get(string);
        if (string2 == null && this.element != null) {
            if (string != null && string.length() == 0) {
                string = null;
            }
            string2 = this.element.lookupNamespaceURI(string);
        }
        return string2;
    }

    @Override
    public String getPrefix(String string) {
        Set<String> set = this.nsUriToPrefixesMap.get(string);
        if (set != null && set.size() > 0) {
            return set.iterator().next();
        }
        if (this.element != null) {
            return this.element.lookupPrefix(string);
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        return Collections.EMPTY_LIST.iterator();
    }
}

