/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import com.jamesmurty.utils.NamespaceContextImpl;
import com.jamesmurty.utils.XMLBuilderRuntimeException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.iharder.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseXMLBuilder {
    private Document xmlDocument = null;
    private Node xmlNode = null;
    private static boolean isNamespaceAware = true;
    public static boolean failIfExternalEntityParsingCannotBeConfigured = true;

    protected BaseXMLBuilder(Document document) {
        this.xmlDocument = document;
        this.xmlNode = document.getDocumentElement();
    }

    protected BaseXMLBuilder(Node node, Node node2) {
        this.xmlNode = node;
        this.xmlDocument = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (node2 != null) {
            node2.appendChild(node);
        }
    }

    protected static void enableOrDisableExternalEntityParsing(DocumentBuilderFactory documentBuilderFactory, boolean bl) {
        String[] stringArray = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xerces.apache.org/xerces-j/features.html#external-general-entities", "http://xerces.apache.org/xerces2-j/features.html#external-general-entities"};
        boolean bl2 = false;
        for (String string : stringArray) {
            try {
                documentBuilderFactory.setFeature(string, bl);
                bl2 = true;
                break;
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
        }
        if (!bl2 && failIfExternalEntityParsingCannotBeConfigured) {
            throw new XMLBuilderRuntimeException(new ParserConfigurationException("Failed to set 'external-general-entities' feature to " + bl));
        }
        String[] stringArray2 = new String[]{"http://xml.org/sax/features/external-parameter-entities", "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities"};
        bl2 = false;
        for (String string : stringArray2) {
            try {
                documentBuilderFactory.setFeature(string, bl);
                bl2 = true;
                break;
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
        }
        if (!bl2 && failIfExternalEntityParsingCannotBeConfigured) {
            throw new XMLBuilderRuntimeException(new ParserConfigurationException("Failed to set 'external-parameter-entities' feature to " + bl));
        }
    }

    protected static Document createDocumentImpl(String string, String string2, boolean bl) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(isNamespaceAware);
        BaseXMLBuilder.enableOrDisableExternalEntityParsing(documentBuilderFactory, bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = null;
        element = string2 != null && string2.length() > 0 ? document.createElementNS(string2, string) : document.createElement(string);
        document.appendChild(element);
        return document;
    }

    protected static Document parseDocumentImpl(InputSource inputSource, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(isNamespaceAware);
        BaseXMLBuilder.enableOrDisableExternalEntityParsing(documentBuilderFactory, bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    protected void stripWhitespaceOnlyTextNodesImpl() throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPathExpression xPathExpression = xPathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList nodeList = (NodeList)xPathExpression.evaluate(this.getDocument(), XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
    }

    public abstract BaseXMLBuilder stripWhitespaceOnlyTextNodes() throws XPathExpressionException;

    protected void importXMLBuilderImpl(BaseXMLBuilder baseXMLBuilder) {
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(this.xmlNode);
        Node node = this.getDocument().importNode(baseXMLBuilder.getDocument().getDocumentElement(), true);
        this.xmlNode.appendChild(node);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BaseXMLBuilder) {
            BaseXMLBuilder baseXMLBuilder = (BaseXMLBuilder)object;
            return this.xmlDocument.equals(baseXMLBuilder.getDocument()) && this.xmlNode.equals(baseXMLBuilder.getElement());
        }
        return false;
    }

    public Element getElement() {
        if (this.xmlNode instanceof Element) {
            return (Element)this.xmlNode;
        }
        return null;
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public abstract BaseXMLBuilder importXMLBuilder(BaseXMLBuilder var1);

    public abstract BaseXMLBuilder root();

    public Object xpathQuery(String string, QName qName, NamespaceContext namespaceContext) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        XPathExpression xPathExpression = xPath.compile(string);
        try {
            return xPathExpression.evaluate(this.xmlNode, qName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Object xpathQuery(String string, QName qName) throws XPathExpressionException {
        return this.xpathQuery(string, qName, null);
    }

    public abstract BaseXMLBuilder xpathFind(String var1, NamespaceContext var2) throws XPathExpressionException;

    public abstract BaseXMLBuilder xpathFind(String var1) throws XPathExpressionException;

    protected Node xpathFindImpl(String string, NamespaceContext namespaceContext) throws XPathExpressionException {
        Node node = (Node)this.xpathQuery(string, XPathConstants.NODE, namespaceContext);
        if (node == null || node.getNodeType() != 1) {
            throw new XPathExpressionException("XPath expression \"" + string + "\" does not resolve to an Element in context " + String.valueOf(this.xmlNode) + ": " + String.valueOf(node));
        }
        return node;
    }

    protected String lookupNamespaceURIImpl(String string) {
        String string2 = this.getPrefixFromQualifiedName(string);
        String string3 = this.xmlNode.lookupNamespaceURI(string2);
        return string3;
    }

    protected Element elementImpl(String string, String string2) {
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(this.xmlNode);
        if (string2 == null) {
            return this.getDocument().createElement(string);
        }
        return this.getDocument().createElementNS(string2, string);
    }

    public abstract BaseXMLBuilder element(String var1);

    public abstract BaseXMLBuilder elem(String var1);

    public abstract BaseXMLBuilder e(String var1);

    public abstract BaseXMLBuilder element(String var1, String var2);

    public abstract BaseXMLBuilder elementBefore(String var1);

    public abstract BaseXMLBuilder elementBefore(String var1, String var2);

    public abstract BaseXMLBuilder attribute(String var1, String var2);

    public abstract BaseXMLBuilder attr(String var1, String var2);

    public abstract BaseXMLBuilder a(String var1, String var2);

    public abstract BaseXMLBuilder text(String var1, boolean var2);

    public abstract BaseXMLBuilder text(String var1);

    public abstract BaseXMLBuilder t(String var1);

    protected Element elementBeforeImpl(String string) {
        String string2 = this.getPrefixFromQualifiedName(string);
        String string3 = this.xmlNode.lookupNamespaceURI(string2);
        return this.elementBeforeImpl(string, string3);
    }

    protected Element elementBeforeImpl(String string, String string2) {
        Node node = this.xmlNode.getParentNode();
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(node);
        Element element = string2 == null ? this.getDocument().createElement(string) : this.getDocument().createElementNS(string2, string);
        node.insertBefore(element, this.xmlNode);
        return element;
    }

    protected void attributeImpl(String string, String string2) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + String.valueOf(this.xmlNode));
        }
        ((Element)this.xmlNode).setAttribute(string, string2);
    }

    protected void textImpl(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Illegal null text value");
        }
        if (bl) {
            this.xmlNode.setTextContent(string);
        } else {
            this.xmlNode.appendChild(this.getDocument().createTextNode(string));
        }
    }

    protected void cdataImpl(String string) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(string));
    }

    protected void cdataImpl(byte[] byArray) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(Base64.encodeBytes(byArray)));
    }

    protected void commentImpl(String string) {
        this.xmlNode.appendChild(this.getDocument().createComment(string));
    }

    protected void instructionImpl(String string, String string2) {
        this.xmlNode.appendChild(this.getDocument().createProcessingInstruction(string, string2));
    }

    protected void insertInstructionImpl(String string, String string2) {
        this.getDocument().insertBefore(this.getDocument().createProcessingInstruction(string, string2), this.xmlNode);
    }

    protected void referenceImpl(String string) {
        this.xmlNode.appendChild(this.getDocument().createEntityReference(string));
    }

    protected void namespaceImpl(String string, String string2) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + String.valueOf(this.xmlNode));
        }
        if (string != null && string.length() > 0) {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        } else {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
        }
    }

    protected void namespaceImpl(String string) {
        this.namespaceImpl(null, string);
    }

    public abstract BaseXMLBuilder cdata(String var1);

    public abstract BaseXMLBuilder data(String var1);

    public abstract BaseXMLBuilder d(String var1);

    public abstract BaseXMLBuilder cdata(byte[] var1);

    public abstract BaseXMLBuilder data(byte[] var1);

    public abstract BaseXMLBuilder d(byte[] var1);

    public abstract BaseXMLBuilder comment(String var1);

    public abstract BaseXMLBuilder cmnt(String var1);

    public abstract BaseXMLBuilder c(String var1);

    public abstract BaseXMLBuilder instruction(String var1, String var2);

    public abstract BaseXMLBuilder inst(String var1, String var2);

    public abstract BaseXMLBuilder i(String var1, String var2);

    public abstract BaseXMLBuilder insertInstruction(String var1, String var2);

    public abstract BaseXMLBuilder reference(String var1);

    public abstract BaseXMLBuilder ref(String var1);

    public abstract BaseXMLBuilder r(String var1);

    public abstract BaseXMLBuilder namespace(String var1, String var2);

    public abstract BaseXMLBuilder ns(String var1, String var2);

    public abstract BaseXMLBuilder namespace(String var1);

    public abstract BaseXMLBuilder ns(String var1);

    public abstract BaseXMLBuilder up(int var1);

    public abstract BaseXMLBuilder up();

    public abstract BaseXMLBuilder document();

    protected Node upImpl(int n) {
        Node node = this.xmlNode;
        for (int i = 0; node.getParentNode() != null && i < n; ++i) {
            node = node.getParentNode();
        }
        return node;
    }

    protected void assertElementContainsNoOrWhitespaceOnlyTextNodes(Node node) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3;
            String string;
            if (3 != nodeList.item(i).getNodeType() || (string = (node3 = nodeList.item(i)).getTextContent().replaceAll("\\s", "")).length() <= 0) continue;
            node2 = node3;
            break;
        }
        if (node2 != null) {
            throw new IllegalStateException("Cannot add sub-element to element <" + node.getNodeName() + "> that contains a Text node that isn't purely whitespace: " + String.valueOf(node2));
        }
    }

    public void toWriter(boolean bl, Writer writer, Properties properties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource dOMSource = null;
        dOMSource = bl ? new DOMSource(this.getDocument()) : new DOMSource(this.getElement());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                transformer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        transformer.transform(dOMSource, streamResult);
    }

    public void toWriter(Writer writer, Properties properties) throws TransformerException {
        this.toWriter(true, writer, properties);
    }

    public String asString(Properties properties) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        this.toWriter(stringWriter, properties);
        return stringWriter.toString();
    }

    public String elementAsString(Properties properties) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        this.toWriter(false, stringWriter, properties);
        return stringWriter.toString();
    }

    public String asString() throws TransformerException {
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        return this.asString(properties);
    }

    public String elementAsString() throws TransformerException {
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        return this.elementAsString(properties);
    }

    protected NamespaceContextImpl buildDocumentNamespaceContext() {
        return new NamespaceContextImpl(this.xmlDocument.getDocumentElement());
    }

    protected String getPrefixFromQualifiedName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }
}

