/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.List;

public class RawConsoleInput {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final int invalidKey = 65534;
    private static final String invalidKeyStr = String.valueOf('\ufffe');
    private static boolean initDone;
    private static boolean stdinIsConsole;
    private static boolean consoleModeAltered;
    private static Msvcrt msvcrt;
    private static Kernel32 kernel32;
    private static Pointer consoleHandle;
    private static int originalConsoleMode;
    private static final int stdinFd = 0;
    private static Libc libc;
    private static CharsetDecoder charsetDecoder;
    private static Termios originalTermios;
    private static Termios rawTermios;
    private static Termios intermediateTermios;

    public static int read(boolean bl) throws IOException {
        if (isWindows) {
            return RawConsoleInput.readWindows(bl);
        }
        return RawConsoleInput.readUnix(bl);
    }

    public static void resetConsoleMode() throws IOException {
        if (isWindows) {
            RawConsoleInput.resetConsoleModeWindows();
        } else {
            RawConsoleInput.resetConsoleModeUnix();
        }
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RawConsoleInput.shutdownHook();
            }
        });
    }

    private static void shutdownHook() {
        try {
            RawConsoleInput.resetConsoleMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int readWindows(boolean bl) throws IOException {
        RawConsoleInput.initWindows();
        if (!stdinIsConsole) {
            int n = msvcrt.getwchar();
            if (n == 65535) {
                n = -1;
            }
            return n;
        }
        consoleModeAltered = true;
        RawConsoleInput.setConsoleMode(consoleHandle, originalConsoleMode & 0xFFFFFFFE);
        if (!bl && msvcrt._kbhit() == 0) {
            return -2;
        }
        return RawConsoleInput.getwch();
    }

    private static int getwch() {
        int n = msvcrt._getwch();
        if (n == 0 || n == 224) {
            n = msvcrt._getwch();
            if (n >= 0 && n <= 6399) {
                return 57344 + n;
            }
            return 65534;
        }
        if (n < 0 || n > 65535) {
            return 65534;
        }
        return n;
    }

    private static synchronized void initWindows() throws IOException {
        if (initDone) {
            return;
        }
        msvcrt = (Msvcrt)Native.load((String)"msvcrt", Msvcrt.class);
        kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class);
        try {
            consoleHandle = RawConsoleInput.getStdInputHandle();
            originalConsoleMode = RawConsoleInput.getConsoleMode(consoleHandle);
            stdinIsConsole = true;
        }
        catch (IOException iOException) {
            stdinIsConsole = false;
        }
        if (stdinIsConsole) {
            RawConsoleInput.registerShutdownHook();
        }
        initDone = true;
    }

    private static Pointer getStdInputHandle() throws IOException {
        Pointer pointer = kernel32.GetStdHandle(-10);
        if (Pointer.nativeValue((Pointer)pointer) == 0L || Pointer.nativeValue((Pointer)pointer) == Kernel32Defs.INVALID_HANDLE_VALUE) {
            throw new IOException("GetStdHandle(STD_INPUT_HANDLE) failed.");
        }
        return pointer;
    }

    private static int getConsoleMode(Pointer pointer) throws IOException {
        IntByReference intByReference = new IntByReference();
        int n = kernel32.GetConsoleMode(pointer, intByReference);
        if (n == 0) {
            throw new IOException("GetConsoleMode() failed.");
        }
        return intByReference.getValue();
    }

    private static void setConsoleMode(Pointer pointer, int n) throws IOException {
        int n2 = kernel32.SetConsoleMode(pointer, n);
        if (n2 == 0) {
            throw new IOException("SetConsoleMode() failed.");
        }
    }

    private static void resetConsoleModeWindows() throws IOException {
        if (!(initDone && stdinIsConsole && consoleModeAltered)) {
            return;
        }
        RawConsoleInput.setConsoleMode(consoleHandle, originalConsoleMode);
        consoleModeAltered = false;
    }

    private static int readUnix(boolean bl) throws IOException {
        RawConsoleInput.initUnix();
        if (!stdinIsConsole) {
            return RawConsoleInput.readSingleCharFromByteStream(System.in);
        }
        consoleModeAltered = true;
        RawConsoleInput.setTerminalAttrs(0, rawTermios);
        try {
            if (!bl && System.in.available() == 0) {
                int n = -2;
                return n;
            }
            int n = RawConsoleInput.readSingleCharFromByteStream(System.in);
            return n;
        }
        finally {
            RawConsoleInput.setTerminalAttrs(0, intermediateTermios);
        }
    }

    private static Termios getTerminalAttrs(int n) throws IOException {
        Termios termios = new Termios();
        try {
            int n2 = libc.tcgetattr(n, termios);
            if (n2 != 0) {
                throw new RuntimeException("tcgetattr() failed.");
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("tcgetattr() failed.", lastErrorException);
        }
        return termios;
    }

    private static void setTerminalAttrs(int n, Termios termios) throws IOException {
        try {
            int n2 = libc.tcsetattr(n, 0, termios);
            if (n2 != 0) {
                throw new RuntimeException("tcsetattr() failed.");
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("tcsetattr() failed.", lastErrorException);
        }
    }

    private static int readSingleCharFromByteStream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4];
        int n2 = 0;
        do {
            if (n2 >= byArray.length) {
                return 65534;
            }
            int n3 = inputStream.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[n2++] = (byte)n3;
        } while ((n = RawConsoleInput.decodeCharFromBytes(byArray, n2)) == -1);
        return n;
    }

    private static synchronized int decodeCharFromBytes(byte[] byArray, int n) {
        charsetDecoder.reset();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.replaceWith(invalidKeyStr);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charsetDecoder.decode(byteBuffer, charBuffer, false);
        if (charBuffer.position() == 0) {
            return -1;
        }
        return charBuffer.get(0);
    }

    private static synchronized void initUnix() throws IOException {
        if (initDone) {
            return;
        }
        libc = (Libc)Native.load((String)"c", Libc.class);
        stdinIsConsole = libc.isatty(0) == 1;
        charsetDecoder = Charset.defaultCharset().newDecoder();
        if (stdinIsConsole) {
            originalTermios = RawConsoleInput.getTerminalAttrs(0);
            rawTermios = new Termios(originalTermios);
            RawConsoleInput.rawTermios.c_lflag &= 0xFFFFFFB4;
            intermediateTermios = new Termios(rawTermios);
            RawConsoleInput.intermediateTermios.c_lflag |= 2;
            RawConsoleInput.registerShutdownHook();
        }
        initDone = true;
    }

    private static void resetConsoleModeUnix() throws IOException {
        if (!(initDone && stdinIsConsole && consoleModeAltered)) {
            return;
        }
        RawConsoleInput.setTerminalAttrs(0, originalTermios);
        consoleModeAltered = false;
    }

    private static interface Msvcrt
    extends Library {
        public int _kbhit();

        public int _getwch();

        public int getwchar();
    }

    private static class Kernel32Defs {
        static final int STD_INPUT_HANDLE = -10;
        static final long INVALID_HANDLE_VALUE = Native.POINTER_SIZE == 8 ? -1L : 0xFFFFFFFFL;
        static final int ENABLE_PROCESSED_INPUT = 1;
        static final int ENABLE_LINE_INPUT = 2;
        static final int ENABLE_ECHO_INPUT = 4;
        static final int ENABLE_WINDOW_INPUT = 8;

        private Kernel32Defs() {
        }
    }

    private static interface Kernel32
    extends Library {
        public int GetConsoleMode(Pointer var1, IntByReference var2);

        public int SetConsoleMode(Pointer var1, int var2);

        public Pointer GetStdHandle(int var1);
    }

    protected static class Termios
    extends Structure {
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte c_line;
        public byte[] filler = new byte[64];

        protected List<String> getFieldOrder() {
            return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "filler");
        }

        Termios() {
        }

        Termios(Termios termios) {
            this.c_iflag = termios.c_iflag;
            this.c_oflag = termios.c_oflag;
            this.c_cflag = termios.c_cflag;
            this.c_lflag = termios.c_lflag;
            this.c_line = termios.c_line;
            this.filler = (byte[])termios.filler.clone();
        }
    }

    private static interface Libc
    extends Library {
        public int tcgetattr(int var1, Termios var2) throws LastErrorException;

        public int tcsetattr(int var1, int var2, Termios var3) throws LastErrorException;

        public int isatty(int var1);
    }

    private static class LibcDefs {
        static final int ISIG = 1;
        static final int ICANON = 2;
        static final int ECHO = 8;
        static final int ECHONL = 64;
        static final int TCSANOW = 0;

        private LibcDefs() {
        }
    }
}

